/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.interlinear.edit.IGTCalculator;
import mpi.eudico.client.annotator.interlinear.edit.IGTEditProvider;
import mpi.eudico.client.annotator.interlinear.edit.IGTGroupRenderer;
import mpi.eudico.client.annotator.interlinear.edit.SuggestionSetSelector;
import mpi.eudico.client.annotator.interlinear.edit.SuggestionWindow;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTEditAction;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelListener;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSelectionListener;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAbstractDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTTierRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import nl.mpi.lexan.analyzers.helpers.Position;

public class IGTGroupEditor
extends JComponent
implements MouseListener,
KeyListener,
IGTDataModelListener {
    private static final Color EDIT_BG_COLOR = new Color(200, 200, 255);
    private IGTEditProvider editProvider;
    private IGTAbstractDataModel model;
    private IGTViewerRenderInfo vrInfo;
    private IGTAnnotation selectedAnn = null;
    private InlineEditBox editBox;
    private boolean forceOpenControlledVocabulary = false;
    private AbstractViewer viewer;
    private boolean deselectCommits = true;
    private WeakReference<SuggestionWindow> weakSuggestionWindow;

    public IGTGroupEditor(IGTEditProvider editProvider, AbstractViewer viewer) {
        this.editProvider = editProvider;
        this.viewer = viewer;
        this.setLayout(null);
        this.editBox = new InlineEditBox(true);
        this.editBox.addKeyListener(this);
        this.editBox.setFont(this.getFont());
        this.editBox.setVisible(false);
        this.editBox.setBorder(null);
        this.editBox.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.editBox);
        this.setBackground(EDIT_BG_COLOR);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setOpaque(false);
    }

    public void editIGTGroup(IGTDataModel rowModel, IGTViewerRenderInfo viewerRenderInfo) {
        if (this.deselectCommits) {
            this.commitEdit();
        } else {
            this.cancelEdit();
        }
        this.model = (IGTAbstractDataModel)rowModel;
        this.vrInfo = viewerRenderInfo;
        if (this.model != null) {
            this.model.addIGTDataModelListener(this);
        }
        this.repaint();
    }

    public void commitEdit() {
        if (this.model != null) {
            this.model.removeIGTDataModelListener(this);
            if (this.editBox.isVisible()) {
                this.editBox.commitEdit();
            }
        }
    }

    public void cancelEdit() {
        if (this.model != null) {
            this.model.removeIGTDataModelListener(this);
            if (this.editBox.isVisible()) {
                this.editBox.cancelEdit();
            }
        }
    }

    public void setDeselectCommits(boolean deselectCommits) {
        this.deselectCommits = deselectCommits;
    }

    public void suggestionSetDelivered(IGTSuggestionViewerModel svModel, Position pos, SuggestionSelectionListener listener) {
        int row;
        if (pos != null && (row = this.model.getRowIndexForTier(pos.getTierId())) > -1) {
            IGTTier igtTier = this.model.getRowData(row);
            IGTAnnotation igtAnn = null;
            boolean found = false;
            ArrayList<IGTAnnotation> annotations = igtTier.getAnnotations();
            int size = annotations.size();
            for (int i = 0; i < size; ++i) {
                igtAnn = annotations.get(i);
                AbstractAnnotation annotation = igtAnn.getAnnotation();
                if (annotation == null) continue;
                long beginTime = pos.getBeginTime();
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer(String.format("find matching ann: %d-%d in %d-%d?", beginTime, pos.getEndTime(), annotation.getBeginTimeBoundary(), annotation.getEndTimeBoundary()));
                }
                if (annotation.getBeginTimeBoundary() > beginTime || annotation.getEndTimeBoundary() <= beginTime) continue;
                found = true;
                break;
            }
            int annY = 0;
            int annX = 0;
            int annCalcWidth = 0;
            int annHeight = 0;
            if (igtAnn == null || !found) {
                IGTTierRenderInfo tierRenderInfo = igtTier.getRenderInfo();
                annY = tierRenderInfo.y;
                annX = 0;
                annCalcWidth = tierRenderInfo.width;
                annHeight = tierRenderInfo.height;
            } else {
                IGTNodeRenderInfo annRenderInfo = igtAnn.getRenderInfo();
                annY = annRenderInfo.y;
                annX = annRenderInfo.x;
                annCalcWidth = annRenderInfo.calcWidth;
                annHeight = annRenderInfo.height;
            }
            SuggestionSetSelector selector = new SuggestionSetSelector(svModel, this.vrInfo);
            SuggestionWindow window = new SuggestionWindow(SwingUtilities.getWindowAncestor(this), selector);
            window.setSuggestionSelectionListener(listener);
            window.setVisible(true);
            try {
                Point gePos = this.getLocationOnScreen();
                Dimension windowSize = window.getPreferredSize();
                window.setLocation(gePos.x + this.vrInfo.headerWidth + annX + annCalcWidth / 2 - windowSize.width / 2, gePos.y + annY + annHeight + 2 * this.vrInfo.vertLineMargin);
                Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
                Point windowLocation = window.getLocation();
                int availableWidthOnScreen = screenDim.width - screenInsets.right - windowLocation.x;
                int availableHeightOnScreen = screenDim.height - screenInsets.bottom - windowLocation.y;
                window.setMaximumSize(new Dimension(availableWidthOnScreen, availableHeightOnScreen));
            }
            catch (IllegalComponentStateException ex) {
                ex.printStackTrace();
            }
            this.weakSuggestionWindow = new WeakReference<SuggestionWindow>(window);
        }
    }

    public void cancelSuggestionSet() {
        if (this.weakSuggestionWindow != null) {
            SuggestionWindow window = (SuggestionWindow)this.weakSuggestionWindow.get();
            if (window != null) {
                window.setVisible(false);
                window.dispose();
                this.weakSuggestionWindow.clear();
            }
            this.weakSuggestionWindow = null;
        }
    }

    public AbstractAnnotation getActiveAnnotation() {
        if (this.selectedAnn == null) {
            return null;
        }
        return this.selectedAnn.getAnnotation();
    }

    public void updateActiveAnnotation(Annotation activeAnnotation) {
        if (this.model == null) {
            return;
        }
        if (activeAnnotation == null) {
            this.internalSetSelectedAnnotation(null);
        } else {
            String tierName = activeAnnotation.getTier().getName();
            IGTTier tier = this.model.getRowDataForTier(tierName);
            if (tier != null) {
                for (IGTAnnotation ann : tier.getAnnotations()) {
                    if (ann.getAnnotation() != activeAnnotation) continue;
                    this.internalSetSelectedAnnotation(ann);
                    break;
                }
            }
        }
    }

    public void startEditAnnotation(Annotation annotationToEdit) {
        if (this.model == null) {
            return;
        }
        if (this.selectedAnn != null && (this.selectedAnn.getAnnotation() == annotationToEdit || annotationToEdit == null)) {
            this.textEditAnnotation(this.selectedAnn);
        } else if (annotationToEdit != null) {
            this.updateActiveAnnotation(annotationToEdit);
            this.textEditAnnotation(this.selectedAnn);
        } else {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                IGTTier t = this.model.getRowData(i);
                if (t.isSpecial() || t.getAnnotations().isEmpty()) continue;
                IGTAnnotation annToEdit = t.getAnnotations().get(0);
                this.internalSetSelectedAnnotationAndNotify(annToEdit);
                this.textEditAnnotation(this.selectedAnn);
                break;
            }
        }
    }

    private void internalSetSelectedAnnotation(IGTAnnotation newSelectedAnn) {
        IGTAnnotation prev = this.selectedAnn;
        this.selectedAnn = newSelectedAnn;
        this.repaint(this.selectedAnn);
        this.repaint(prev);
    }

    private void internalSetSelectedAnnotationAndNotify(IGTAnnotation newSelectedAnn) {
        this.internalSetSelectedAnnotation(newSelectedAnn);
        this.notifyActiveAnnotation();
    }

    private void notifyActiveAnnotation() {
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine("Notify the outside that the active annotation and selection have changed");
        }
        if (this.viewer != null) {
            AbstractAnnotation ann = this.getActiveAnnotation();
            this.viewer.setActiveAnnotation(ann);
            this.viewer.setSelection(ann);
        }
    }

    private void repaint(IGTAnnotation ann) {
        if (ann != null) {
            IGTNodeRenderInfo annRender = ann.getRenderInfo();
            this.repaint(this.vrInfo.headerWidth + annRender.x, annRender.y, annRender.calcWidth, annRender.height);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Color bg = EDIT_BG_COLOR;
        g.setColor(bg);
        g.fillRect(0, 0, width, height);
        IGTGroupRenderer.renderRow2(g, this.model, this.vrInfo, height, this.selectedAnn);
    }

    private IGTAnnotation getAnnotationAtPoint(Point p) {
        IGTTier igtTier = this.getTierAtY(p.y);
        if (igtTier != null) {
            return igtTier.getAnnotationAtPoint(p);
        }
        return null;
    }

    private IGTTier getTierAtY(int y) {
        if (this.model != null) {
            int rowCount = this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IGTTier igtTier = this.model.getRowData(i);
                if (!igtTier.isAtY(y)) continue;
                return igtTier;
            }
        }
        return null;
    }

    private IGTAnnotation getParentAnnotationOfPoint(Point p, boolean grandParentsToo) {
        IGTTier igtTier = this.getTierAtY(p.y);
        while (igtTier != null) {
            IGTTier parentTier = igtTier.getParentTier();
            if (parentTier != null) {
                int y;
                p.y = y = parentTier.getY(p.y);
                IGTAnnotation parentAnn = parentTier.getAnnotationAtPoint(p);
                if (parentAnn != null || !grandParentsToo) {
                    return parentAnn;
                }
            }
            igtTier = parentTier;
        }
        return null;
    }

    private void editAnnotation(IGTAnnotation igtAnn) {
        if (igtAnn == null) {
            return;
        }
        if (igtAnn.getIGTTier().isSpecial()) {
            return;
        }
        List<IGTEditAction> actions = this.editProvider.actionsForAnnotation(igtAnn);
        if (actions != null) {
            JPopupMenu popup = new JPopupMenu();
            for (IGTEditAction igtAction : actions) {
                popup.add(igtAction);
            }
            popup.show(this, igtAnn.getRenderInfo().x + this.vrInfo.headerWidth, igtAnn.getRenderInfo().y + igtAnn.getRenderInfo().height);
            this.repaint();
        }
    }

    private void editEmptySpace(IGTAnnotation parent, int x, int y) {
        if (parent == null) {
            return;
        }
        List<IGTEditAction> actions = this.editProvider.actionsForEmptySpace(parent);
        if (actions != null) {
            JPopupMenu popup = new JPopupMenu();
            for (IGTEditAction igtAction : actions) {
                popup.add(igtAction);
            }
            popup.show(this, x, y);
            this.repaint();
        }
    }

    private void textEditAnnotation(IGTAnnotation igtAnn) {
        if (igtAnn == null) {
            return;
        }
        if (igtAnn.getIGTTier().isSpecial()) {
            return;
        }
        this.editBox.setAnnotation(igtAnn.getAnnotation(), this.forceOpenControlledVocabulary);
        this.editBox.setFont(this.vrInfo.getFontForTier(igtAnn.getIGTTier().getTierName()));
        IGTNodeRenderInfo renderInfo = igtAnn.getRenderInfo();
        int x = this.vrInfo.headerWidth + renderInfo.x;
        int y = renderInfo.y;
        int w = Math.max(50, renderInfo.calcWidth + 2);
        int h = renderInfo.height;
        int availWidth = this.getWidth() - 1;
        if (x + w > availWidth) {
            w = Math.max(50, availWidth - x);
            x = availWidth - w;
        }
        Dimension dim = new Dimension(w, h);
        this.editBox.setLocation(x, y);
        this.editBox.configureEditor(JPanel.class, null, dim);
        this.editBox.setSizeIgnoreMinimum(dim);
        this.editBox.setVisible(true);
        this.editBox.startEdit();
        this.forceOpenControlledVocabulary = false;
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer("Ann: x=" + (renderInfo.x + this.vrInfo.headerWidth) + " y=" + renderInfo.y + " w=" + (renderInfo.calcWidth + 2) + " h=" + renderInfo.height);
            ClientLogger.LOG.finer("TF: " + this.editBox.getBounds());
        }
    }

    private void selectEditNextAnnotation(IGTAnnotation igtAnn) {
        if (igtAnn == null) {
            return;
        }
        IGTAnnotation nextAnn = igtAnn.getIGTTier().getNextAnnotation(igtAnn);
        if (nextAnn != null) {
            this.internalSetSelectedAnnotationAndNotify(nextAnn);
            this.textEditAnnotation(nextAnn);
        } else {
            block9: {
                IGTTier nextTier;
                int curRow = this.model.getRowIndexForTier(igtAnn.getIGTTier().getTierName());
                int nextRow = curRow + 1;
                while (true) {
                    if (nextRow == this.model.getRowCount()) {
                        nextRow = 0;
                    }
                    if (nextRow == curRow) {
                        nextAnn = igtAnn.getIGTTier().getAnnotations().get(0);
                        break block9;
                    }
                    nextTier = this.model.getRowData(nextRow);
                    if (nextTier.isSpecial()) {
                        ++nextRow;
                        continue;
                    }
                    if (!nextTier.getAnnotations().isEmpty()) break;
                    ++nextRow;
                }
                nextAnn = nextTier.getAnnotations().get(0);
            }
            if (nextAnn == null || nextAnn == igtAnn) {
                this.internalSetSelectedAnnotationAndNotify(null);
            } else {
                this.internalSetSelectedAnnotationAndNotify(nextAnn);
                this.textEditAnnotation(nextAnn);
            }
        }
    }

    private void selectEditPreviousAnnotation(IGTAnnotation igtAnn) {
        if (igtAnn == null) {
            return;
        }
        IGTAnnotation prevAnn = igtAnn.getIGTTier().getPreviousAnnotation(igtAnn);
        if (prevAnn != null) {
            this.internalSetSelectedAnnotationAndNotify(prevAnn);
            this.textEditAnnotation(prevAnn);
        } else {
            block10: {
                IGTTier nextTier;
                int curRow = this.model.getRowIndexForTier(igtAnn.getIGTTier().getTierName());
                int prevRow = curRow - 1;
                while (true) {
                    if (prevRow < 0) {
                        prevRow = this.model.getRowCount() - 1;
                    }
                    if (prevRow == curRow) {
                        int numAnn = igtAnn.getIGTTier().getAnnotations().size();
                        if (numAnn > 1) {
                            prevAnn = igtAnn.getIGTTier().getAnnotations().get(numAnn - 1);
                        }
                        break block10;
                    }
                    nextTier = this.model.getRowData(prevRow);
                    if (nextTier.isSpecial()) {
                        --prevRow;
                        continue;
                    }
                    if (!nextTier.getAnnotations().isEmpty()) break;
                    --prevRow;
                }
                int numAnn = nextTier.getAnnotations().size();
                prevAnn = nextTier.getAnnotations().get(numAnn - 1);
            }
            if (prevAnn == null || prevAnn == igtAnn) {
                this.internalSetSelectedAnnotationAndNotify(null);
            } else {
                this.internalSetSelectedAnnotationAndNotify(prevAnn);
                this.textEditAnnotation(prevAnn);
            }
        }
    }

    void clickedAt(int x, int y, int nclicks) {
        Point p = new Point(x - this.vrInfo.headerWidth, y);
        if (nclicks == 1) {
            IGTAnnotation actAnnotation = this.getAnnotationAtPoint(p);
            if (actAnnotation != null) {
                this.internalSetSelectedAnnotationAndNotify(actAnnotation);
                this.textEditAnnotation(this.selectedAnn);
            } else if (this.editBox.isVisible()) {
                if (this.deselectCommits) {
                    this.editBox.commitEdit();
                } else {
                    this.editBox.cancelEdit();
                }
            } else {
                this.internalSetSelectedAnnotationAndNotify(null);
            }
        }
    }

    void pressedAt(int x, int y) {
        if (this.editBox.isVisible()) {
            if (this.deselectCommits) {
                this.editBox.commitEdit();
            } else {
                this.editBox.cancelEdit();
            }
        }
        Point p = new Point(x - this.vrInfo.headerWidth, y);
        IGTAnnotation actAnnotation = this.getAnnotationAtPoint(p);
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("pressedAt x=%d y=%d ann=%s", x, y, String.valueOf(actAnnotation)));
        }
        this.internalSetSelectedAnnotationAndNotify(actAnnotation);
        if (this.selectedAnn != null) {
            this.editAnnotation(this.selectedAnn);
        } else {
            IGTAnnotation parentAnnotation = this.getParentAnnotationOfPoint(p, true);
            this.editEmptySpace(parentAnnotation, x, y);
        }
    }

    @Override
    public void dataModelChanged(IGTDataModelEvent event) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger()) {
            return;
        }
        int nx = me.getX();
        int ny = me.getY();
        int nclicks = me.getClickCount();
        this.clickedAt(nx, ny, nclicks);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger()) {
            int nx = me.getX();
            int ny = me.getY();
            this.pressedAt(nx, ny);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 9) {
            this.editBox.commitEdit();
            if (ke.isShiftDown()) {
                this.selectEditPreviousAnnotation(this.selectedAnn);
            } else {
                this.selectEditNextAnnotation(this.selectedAnn);
            }
            ke.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 9) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer("Tab release: consuming event");
            }
            ke.consume();
        }
        if (this.selectedAnn == null) {
            return;
        }
        int curWidth = this.editBox.getWidth();
        int textWidth = this.editBox.getCurrentTextWidth();
        int availWidth = this.getWidth() - this.vrInfo.headerWidth;
        if (textWidth != curWidth && textWidth > this.selectedAnn.getRenderInfo().calcWidth) {
            Dimension dim = this.editBox.getSize();
            dim.width = textWidth;
            if (this.editBox.getX() + dim.width < this.getWidth()) {
                this.editBox.setSizeIgnoreMinimum(dim);
                this.editBox.revalidate();
                boolean bl = IGTCalculator.updateLASRecursiveFromNode(this.selectedAnn, textWidth, availWidth);
            }
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

