/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTSuggestionRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTTierRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.util.ClientLogger;

public class IGTGroupRenderer {
    public static void renderRow2(Graphics g, IGTDataModel model, IGTViewerRenderInfo vrInfo, int height, IGTAnnotation selectedAnn) {
        boolean showTierLabels = true;
        boolean showTierIndentation = true;
        int labelWidth = 0;
        int indentPerLevel = 0;
        int leftMargin = 0;
        boolean isSuggestion = model instanceof IGTSuggestionModel;
        if (isSuggestion) {
            IGTSuggestionRenderInfo sugRenderInfo = (IGTSuggestionRenderInfo)((IGTSuggestionModel)model).getRenderInfo();
            showTierLabels = sugRenderInfo.tierLabelsVisible;
            showTierIndentation = sugRenderInfo.visualizeIndentation;
            indentPerLevel = sugRenderInfo.indentPerLevel;
            labelWidth = sugRenderInfo.rowHeaderWidth;
            if (sugRenderInfo.getTextInsets() != null) {
                leftMargin = sugRenderInfo.getTextInsets().left;
            }
        } else {
            labelWidth = vrInfo.headerWidth;
            leftMargin = model.getRowHeaderRenderInfo().leftMargin;
        }
        g.setColor(vrInfo.foregroundColor);
        if (showTierLabels) {
            g.drawLine(labelWidth - 1, 0, labelWidth - 1, height);
        } else {
            labelWidth = 0;
        }
        int defFontBaseline = g.getFontMetrics(vrInfo.defaultFont).getDescent();
        ArrayList<IGTTier> renderedTier = new ArrayList<IGTTier>();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IGTTier tier = model.getRowData(i);
            if (renderedTier.contains(tier) || isSuggestion && tier.getType() == IGTTierType.ROOT) continue;
            IGTTierRenderInfo tierRenderInfo = tier.getRenderInfo();
            ArrayList<IGTAnnotation> annotations = tier.getAnnotations();
            int numAnnos = annotations.size();
            int indent = leftMargin;
            if (showTierIndentation) {
                indent = isSuggestion ? (indent += tier.getLevel() * indentPerLevel) : (indent += tier.getLevel() * tierRenderInfo.indentPerLevel);
            }
            if (tier.isInWordLevelBlock()) {
                int j;
                if (showTierLabels) {
                    g.setFont(vrInfo.defaultFont);
                    g.setColor(vrInfo.getColorForTier(tier));
                    List<Integer> yPositions = tierRenderInfo.getYPositions();
                    if (yPositions != null) {
                        for (j = 0; j < yPositions.size(); ++j) {
                            int botY = yPositions.get(j) + tierRenderInfo.height;
                            if (j != 0) {
                                g.drawLine(leftMargin, botY - defFontBaseline - g.getFont().getSize() / 2, leftMargin, botY - defFontBaseline - g.getFont().getSize() / 4);
                                if (indent > leftMargin) {
                                    g.drawLine(leftMargin, botY - defFontBaseline - g.getFont().getSize() / 4, tierRenderInfo.indentPerLevel, botY - defFontBaseline - g.getFont().getSize() / 4);
                                }
                            }
                            g.drawString(model.getShortTierNameForIndex(i), indent, botY - defFontBaseline);
                            if (!ClientLogger.LOG.isLoggable(Level.FINER)) continue;
                            ClientLogger.LOG.finer(String.format("string 1T: '%s'", model.getShortTierNameForIndex(i)));
                        }
                    } else {
                        int botY = tierRenderInfo.y + tierRenderInfo.height;
                        g.drawString(model.getShortTierNameForIndex(i), indent, botY - defFontBaseline);
                        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                            ClientLogger.LOG.finer(String.format("string 2T: '%s'", model.getShortTierNameForIndex(i)));
                        }
                    }
                }
                g.setFont(vrInfo.getFontForTier(tier.getTierName()));
                g.setColor(vrInfo.foregroundColor);
                int baseline = vrInfo.getBaselineForTier(g, tier.getTierName());
                for (j = 0; j < numAnnos; ++j) {
                    IGTAnnotation igtAnn = annotations.get(j);
                    IGTNodeRenderInfo annRender = igtAnn.getRenderInfo();
                    int botY = annRender.y + annRender.height;
                    IGTGroupRenderer.drawBox(igtAnn == selectedAnn, labelWidth + annRender.x, annRender.y, annRender.calcWidth, annRender.height, g, vrInfo, igtAnn.getTextValue(), labelWidth + annRender.x + vrInfo.annBBoxInsets.left, botY - baseline - vrInfo.annBBoxInsets.bottom);
                }
            } else {
                int botY = tierRenderInfo.y + tierRenderInfo.height;
                if (showTierLabels) {
                    g.setFont(vrInfo.defaultFont);
                    g.setColor(vrInfo.getColorForTier(tier));
                    g.drawString(model.getShortTierNameForIndex(i), indent, botY - defFontBaseline);
                    if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                        ClientLogger.LOG.finer(String.format("string 4T: '%s'", model.getShortTierNameForIndex(i)));
                    }
                }
                if (tierRenderInfo.getNumLines() > 1) {
                    IGTAnnotation igtAnn;
                    IGTNodeRenderInfo annRender;
                    List<String> lines;
                    if (numAnnos >= 1 && (lines = (annRender = (igtAnn = annotations.get(0)).getRenderInfo()).getWrappedLines()) != null) {
                        g.setFont(vrInfo.getFontForTier(tier.getTierName()));
                        g.setColor(vrInfo.foregroundColor);
                        int baseline = vrInfo.getBaselineForTier(g, tier.getTierName());
                        int numLines = lines.size();
                        for (int a = 0; a < numLines; ++a) {
                            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                                ClientLogger.LOG.finer(String.format("string 5L: '%s'", lines.get(a)));
                            }
                            IGTGroupRenderer.drawBox(igtAnn == selectedAnn, labelWidth + annRender.x, botY - tierRenderInfo.height, annRender.calcWidth, tierRenderInfo.height, g, vrInfo, lines.get(a), labelWidth + annRender.x + vrInfo.annBBoxInsets.left, botY - baseline - vrInfo.annBBoxInsets.bottom);
                            botY += vrInfo.vertLineMargin;
                            botY += tierRenderInfo.height;
                        }
                    }
                } else if (numAnnos >= 1) {
                    g.setFont(vrInfo.getFontForTier(tier.getTierName()));
                    g.setColor(vrInfo.foregroundColor);
                    int baseline = vrInfo.getBaselineForTier(g, tier.getTierName());
                    IGTAnnotation igtAnn = annotations.get(0);
                    IGTNodeRenderInfo annRenderInfo = igtAnn.getRenderInfo();
                    if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                        ClientLogger.LOG.finer(String.format("string 6A: '%s'", igtAnn.getTextValue()));
                    }
                    IGTGroupRenderer.drawBox(igtAnn == selectedAnn, labelWidth + annRenderInfo.x, botY - tierRenderInfo.height, annRenderInfo.calcWidth, tierRenderInfo.height, g, vrInfo, igtAnn.getTextValue(), labelWidth + annRenderInfo.x + vrInfo.annBBoxInsets.left, botY - baseline - vrInfo.annBBoxInsets.bottom);
                }
            }
            renderedTier.add(tier);
        }
    }

    private static void drawBox(boolean isSelected, int x, int y, int w, int h, Graphics g, IGTViewerRenderInfo vrInfo, String text, int textX, int textY) {
        Color saveColor = g.getColor();
        if (vrInfo.showAnnoBackground) {
            g.setColor(vrInfo.annoBackgroundColor);
            g.fillRect(x, y, w, h);
        }
        if (isSelected) {
            g.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            g.drawRect(x, y, w - 1, h - 1);
        } else if (vrInfo.showAnnoBorders) {
            g.setColor(vrInfo.annoBorderColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
        g.setColor(saveColor);
        g.drawString(text, textX, textY);
    }

    private static String tierTypeTag(IGTTier tier) {
        String wlb = tier.isInWordLevelBlock() ? " inWLB" : "";
        return " -- " + tier.getType().toString() + wlb;
    }
}

