/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FontSizer;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.ShowHideMoreTiersDlg;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.IGTCalculator;
import mpi.eudico.client.annotator.interlinear.edit.IGTEditProvider;
import mpi.eudico.client.annotator.interlinear.edit.IGTGroupEditor;
import mpi.eudico.client.annotator.interlinear.edit.IGTGroupRenderer;
import mpi.eudico.client.annotator.interlinear.edit.IGTViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.IGTViewerModelImpl;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerLexiconHostContext;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTAddToLexiconAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTCreateDependentAnnotationsAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTDeleteAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTEditAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTInterlinearizeAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTSplitAnnotationAction;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTViewerChangeListener;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTViewerModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTViewerModelListener;
import mpi.eudico.client.annotator.interlinear.edit.event.ModelEventType;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetListener;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetProvider;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDefaultModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTSuggestionRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.util.AnnotationCoreComparator;
import mpi.eudico.util.TimeRelation;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;

public class IGTViewer
extends JComponent
implements MouseListener,
MouseMotionListener,
ComponentListener,
IGTEditProvider,
IGTViewerModelListener,
SuggestionSetListener,
FontSizer {
    private AbstractViewer viewer;
    private IGTViewerModel model;
    private IGTViewerRenderInfo viewerRenderInfo;
    private IGTGroupEditor groupEditor;
    private GroupTableCellRenderer groupCellRenderer;
    private TextAnalyzerHostContext hostContext;
    private TextAnalyzerLexiconHostContext lexHostContext;
    private List<IGTViewerChangeListener> viewerChangeListeners;
    private int previousWidth;
    private int previousRowWithActiveAnnotation = -1;
    private JTable table;
    private JScrollPane tableScrollPane;
    private String tierToolTipPattern;
    private JPopupMenu popupMenu;
    private JMenuItem showHideMoreMI;
    private JCheckBoxMenuItem showHideTimeCodesMI;
    private JCheckBoxMenuItem showHideSpeakerMI;
    private boolean tableSelectionIsUpdating = false;
    private Map<KeyStroke, Object> origKSMaps;

    public IGTViewer(IGTViewerModel model, TextAnalyzerHostContext hostContext, TextAnalyzerLexiconHostContext lexHostContext, AbstractViewer viewer) {
        this.model = model;
        this.hostContext = hostContext;
        this.lexHostContext = lexHostContext;
        this.viewer = viewer;
        this.viewerChangeListeners = new ArrayList<IGTViewerChangeListener>(4);
        this.viewerRenderInfo = new IGTViewerRenderInfo();
        this.viewerRenderInfo.headerWidth = 100;
        this.groupEditor = new IGTGroupEditor(this, viewer);
        model.addIGTViewerModelListener(this);
        if (hostContext instanceof SuggestionSetProvider) {
            hostContext.addSuggestionSetListener(this);
        }
        IGTViewerModelImpl tableModel = (IGTViewerModelImpl)model;
        this.groupCellRenderer = new GroupTableCellRenderer();
        GroupTableCellEditor editor = new GroupTableCellEditor(model);
        this.table = new JTable(tableModel);
        this.table.setDefaultRenderer(IGTDataModel.class, this.groupCellRenderer);
        this.table.setDefaultEditor(IGTDataModel.class, editor);
        this.table.setRowMargin(this.viewerRenderInfo.vertRowMargin);
        this.table.setTableHeader(null);
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        editor.getTableCellEditorComponent().addMouseListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.addComponentListener(this);
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.addMouseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.tableScrollPane, gbc);
        new InitScrollThread().start();
    }

    public void isClosing(Transcription transcription) {
        this.storeGUIPreferences(transcription);
        if (this.hostContext instanceof SuggestionSetProvider) {
            this.hostContext.removeSuggestionSetListener(this);
        }
        this.table.removeMouseListener(this);
        GroupTableCellEditor editor = (GroupTableCellEditor)this.table.getDefaultEditor(IGTDataModel.class);
        editor.getTableCellEditorComponent().removeMouseListener(this);
        this.removeComponentListener(this);
    }

    private void storeGUIPreferences(Transcription transcription) {
        Preferences.set("IGTViewerRenderInfo.headerWidth", (Object)this.viewerRenderInfo.headerWidth, transcription);
    }

    public void readGUIPreferences(Transcription transcription) {
        Integer intPref = Preferences.getInt("IGTViewerRenderInfo.headerWidth", transcription);
        if (intPref != null) {
            this.setHeaderWidth(intPref);
        }
    }

    public IGTViewerRenderInfo getViewerRenderInfo() {
        return this.viewerRenderInfo;
    }

    public void setTierColorMap(Map<String, Color> tierColorMap) {
        this.viewerRenderInfo.setTierColorMap(tierColorMap);
    }

    public void setTierFontMap(Map<String, Font> fontMap) {
        this.viewerRenderInfo.setTierFontMap(fontMap);
    }

    public void setDeselectCommits(boolean deselectCommits) {
        this.groupEditor.setDeselectCommits(deselectCommits);
    }

    @Override
    public void setFontSize(int fontSize) {
        if (fontSize != this.viewerRenderInfo.getFontSize()) {
            this.viewerRenderInfo.setFontSize(fontSize);
            this.recalculateAllRows(true);
        }
    }

    @Override
    public int getFontSize() {
        return this.viewerRenderInfo.getFontSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public int getRowHeight(int row) {
        try {
            return this.model.getRowData((int)row).getRenderInfo().height;
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            return 0;
        }
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int getTotalHeight() {
        return this.table.getHeight();
    }

    public int getHeaderWidth() {
        return this.viewerRenderInfo.headerWidth;
    }

    public void setHeaderWidth(int hWidth) {
        if (hWidth != this.viewerRenderInfo.headerWidth) {
            this.viewerRenderInfo.headerWidth = hWidth;
            this.recalculateAllRows(true);
            this.repaint();
            this.notifyViewChanged();
        }
    }

    public void calculateHeightForRow(int row, boolean notifyForChanges) {
        try {
            int width = this.table.getWidth() - this.viewerRenderInfo.headerWidth - 1;
            if (width > 0) {
                IGTTier curTier;
                IGTDataModel dModel = this.model.getRowData(row);
                Graphics g = this.getGraphics();
                g.setFont(this.viewerRenderInfo.defaultFont);
                IGTCalculator.calculateShortTierLabels(g, dModel, this.viewerRenderInfo.headerWidth);
                IGTTier rootTier = dModel.getRootRow();
                IGTCalculator.calculateTierAndAnnotationsLAS(g, this.viewerRenderInfo, rootTier, true);
                int tierCount = dModel.getRowCount();
                ArrayList<String> procTiers = new ArrayList<String>();
                for (int i = 0; i < tierCount; ++i) {
                    curTier = dModel.getRowData(i);
                    if (procTiers.contains(curTier.getTierName())) continue;
                    IGTCalculator.calculateWrappingInfo(g, this.viewerRenderInfo, curTier, width);
                    procTiers.add(curTier.getTierName());
                    if (!curTier.isInWordLevelBlock()) continue;
                    this.addChildTiers(procTiers, curTier);
                }
                int origHeight = dModel.getRenderInfo().height;
                tierCount = dModel.getRowCount();
                int rowHeight = 0;
                procTiers.clear();
                for (int i = 0; i < tierCount; ++i) {
                    int subHeight;
                    curTier = dModel.getRowData(i);
                    if (procTiers.contains(curTier.getTierName())) continue;
                    if (curTier.isInWordLevelBlock()) {
                        subHeight = IGTCalculator.calculateTierYPositionRecursive(g, this.viewerRenderInfo, curTier, rowHeight);
                        rowHeight += subHeight;
                        this.addChildTiers(procTiers, curTier);
                    } else {
                        subHeight = IGTCalculator.calculateTierYPosition(g, this.viewerRenderInfo, curTier, rowHeight);
                        rowHeight += subHeight;
                    }
                    procTiers.add(curTier.getTierName());
                }
                dModel.getRenderInfo().height = rowHeight;
                if (this.table != null) {
                    this.table.setRowHeight(row, rowHeight + this.viewerRenderInfo.vertRowMargin);
                }
                if (notifyForChanges && origHeight != rowHeight) {
                    this.notifyViewChanged();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void recalculateAllRows(boolean always) {
        int width = this.table.getWidth();
        if (!always && width == this.previousWidth) {
            return;
        }
        this.previousWidth = width;
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.calculateHeightForRow(i, false);
        }
        this.notifyViewChanged();
    }

    public void updateStaleEditor(int row) {
        this.groupEditor.cancelEdit();
        IGTDefaultModel rowModel = (IGTDefaultModel)this.model.getRowData(row);
        this.table.setRowSelectionInterval(row, row);
        this.model.startEditingRow(row);
        this.groupEditor.editIGTGroup(rowModel, this.viewerRenderInfo);
    }

    private void addChildTiers(List<String> children, IGTTier igtTier) {
        List<IGTTier> childTiers = igtTier.getChildTiers();
        if (childTiers != null && !childTiers.isEmpty()) {
            for (int i = 0; i < childTiers.size(); ++i) {
                IGTTier child = childTiers.get(i);
                children.add(child.getTierName());
                this.addChildTiers(children, child);
            }
        }
    }

    private void changeVisibility(IGTTierType tierType, boolean newState) {
        if (this.model.getSpecialTierVisibility(tierType) != newState) {
            this.model.setSpecialTierVisibility(tierType, newState);
            this.recalculateAllRows(true);
        }
    }

    private void updateHiddenTiersInModel(List<String> hiddenTierNames) {
        if (hiddenTierNames == null) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("The list of hidden tiers is null");
            }
            return;
        }
        boolean empty = this.model.removeAllRows();
        if (!empty && ClientLogger.LOG.isLoggable(Level.WARNING)) {
            ClientLogger.LOG.warning("Error: the viewer model is not empty after removing all rows");
        }
        this.model.setHiddenTiers(hiddenTierNames);
        ArrayList<AlignableAnnotation> allAnns = new ArrayList<AlignableAnnotation>();
        for (TierImpl t : ((TranscriptionImpl)this.hostContext.getTranscription()).getTiers()) {
            if (t.hasParentTier() || hiddenTierNames.contains(t.getName())) continue;
            allAnns.addAll(t.getAlignableAnnotations());
        }
        AnnotationCoreComparator comparator = new AnnotationCoreComparator();
        Collections.sort(allAnns, comparator);
        boolean speakerVisible = true;
        Boolean speakVisPref = Preferences.getBool("InterlinearEditor.ShowSpeaker", this.hostContext.getTranscription());
        if (speakVisPref != null) {
            speakerVisible = speakVisPref;
        }
        boolean tcVisible = true;
        Boolean tcVisPref = Preferences.getBool("InterlinearEditor.ShowTimeCode", this.hostContext.getTranscription());
        if (tcVisPref != null) {
            tcVisible = tcVisPref;
        }
        ArrayList<IGTTierType> hiddenSpecTiers = null;
        if (!speakerVisible || tcVisible) {
            hiddenSpecTiers = new ArrayList<IGTTierType>(2);
            if (!speakerVisible) {
                hiddenSpecTiers.add(IGTTierType.SPEAKER_LABEL);
            }
            if (!tcVisible) {
                hiddenSpecTiers.add(IGTTierType.TIME_CODE);
            }
        }
        for (AlignableAnnotation aa : allAnns) {
            IGTDefaultModel rowModel = new IGTDefaultModel(aa, hiddenTierNames, hiddenSpecTiers);
            this.model.addRow(rowModel);
        }
        this.recalculateAllRows(true);
    }

    private List<String> getSetDifference(Transcription transcription, Collection<String> inputSelection) {
        ArrayList<String> setDiff = new ArrayList<String>();
        for (Tier tier : transcription.getTiers()) {
            if (inputSelection.contains(tier.getName())) continue;
            setDiff.add(tier.getName());
        }
        return setDiff;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.getX() < this.viewerRenderInfo.headerWidth) {
            if (SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger()) {
                JPopupMenu popup = this.getPopup();
                popup.show(this.table, me.getX(), me.getY());
            }
        } else if ((SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger()) && me.getSource() == this.table) {
            Component cc;
            int row = this.table.rowAtPoint(me.getPoint());
            this.table.setRowSelectionInterval(row, row);
            this.table.editCellAt(row, 0);
            Rectangle cellRect = this.table.getCellRect(row, 0, true);
            int yInCell = me.getY() - cellRect.y;
            TableCellEditor cellEditor = this.table.getCellEditor(row, 0);
            if (cellEditor instanceof GroupTableCellEditor && (cc = ((GroupTableCellEditor)cellEditor).getTableCellEditorComponent()) instanceof IGTGroupEditor) {
                ((IGTGroupEditor)cc).pressedAt(me.getX(), yInCell);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        int row = this.table.rowAtPoint(me.getPoint());
        if (row == -1) {
            this.table.setToolTipText(null);
            return;
        }
        if (me.getX() < this.viewerRenderInfo.headerWidth) {
            IGTDefaultModel dataModel = (IGTDefaultModel)this.table.getValueAt(row, 0);
            int yInCell = me.getY() - this.table.getCellRect((int)row, (int)0, (boolean)false).y;
            for (int i = 0; i < dataModel.getRowCount(); ++i) {
                IGTTier igtTier = dataModel.getRowData(i);
                if (!igtTier.isAtY(yInCell)) continue;
                if (igtTier.isSpecial()) {
                    this.table.setToolTipText(null);
                    return;
                }
                String tierName = igtTier.getTierName();
                String type = "-";
                String langRef = "-";
                Tier tier = this.hostContext.getTranscription().getTierWithId(tierName);
                if (tier != null) {
                    type = tier.getLinguisticType().getLinguisticTypeName();
                    if (tier.getLangRef() != null) {
                        langRef = tier.getLangRef();
                    }
                }
                this.table.setToolTipText(String.format(this.getTierToolTipPattern(), tierName, type, langRef));
                return;
            }
        } else {
            this.table.setToolTipText(null);
        }
    }

    private JPopupMenu getPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu("");
            PopupMenuListener pmListener = new PopupMenuListener();
            this.showHideMoreMI = new JMenuItem();
            this.showHideMoreMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowHideMore"));
            this.showHideMoreMI.setActionCommand("showHideMore");
            this.showHideMoreMI.addActionListener(pmListener);
            this.popupMenu.add(this.showHideMoreMI);
            this.popupMenu.addSeparator();
            this.showHideSpeakerMI = new JCheckBoxMenuItem(ElanLocale.getString("InterlinearEditor.Menu.ShowHideSpeaker"));
            this.showHideSpeakerMI.setSelected(this.model.getSpecialTierVisibility(IGTTierType.SPEAKER_LABEL));
            this.showHideSpeakerMI.addItemListener(pmListener);
            this.popupMenu.add(this.showHideSpeakerMI);
            this.showHideTimeCodesMI = new JCheckBoxMenuItem(ElanLocale.getString("InterlinearEditor.Menu.ShowHideTimeCode"));
            this.showHideTimeCodesMI.setSelected(this.model.getSpecialTierVisibility(IGTTierType.TIME_CODE));
            this.showHideTimeCodesMI.addItemListener(pmListener);
            this.popupMenu.add(this.showHideTimeCodesMI);
        }
        return this.popupMenu;
    }

    private String getTierToolTipPattern() {
        if (this.tierToolTipPattern == null) {
            StringBuilder tooltip = new StringBuilder("<html><table>");
            tooltip.append("<tr><td><b>");
            tooltip.append(ElanLocale.getString("EditTierDialog.Label.TierName"));
            tooltip.append("</b></td><td>");
            tooltip.append("%s");
            tooltip.append("</td></tr>");
            tooltip.append("<tr><td><b>");
            tooltip.append(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
            tooltip.append("</b></td><td>");
            tooltip.append("%s");
            tooltip.append("</td></tr>");
            tooltip.append("<tr><td><b>");
            tooltip.append(ElanLocale.getString("EditTierDialog.Label.ContentLanguage"));
            tooltip.append("</b></td><td>");
            tooltip.append("%s");
            tooltip.append("</td></tr>");
            tooltip.append("</table></html>");
            this.tierToolTipPattern = tooltip.toString();
        }
        return this.tierToolTipPattern;
    }

    @Override
    public List<IGTEditAction> actionsForAnnotation(IGTAnnotation igtAnnotation) {
        if (igtAnnotation != null) {
            List<? extends Tier> childTiers;
            boolean isInsertionSupported;
            ShortcutsUtil su = ShortcutsUtil.getInstance();
            ArrayList<IGTEditAction> actions = new ArrayList<IGTEditAction>(4);
            IGTEditAction act = null;
            if (this.hostContext.isAnalyzerSource(igtAnnotation.getIGTTier().getTierName())) {
                act = new IGTInterlinearizeAction(igtAnnotation, this.hostContext, ElanLocale.getString("InterlinearEditor.Button.Interlinearize"));
                act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.Analyze", "Menu.Options.InterlinearizationMode"));
                actions.add(act);
            }
            AbstractAnnotation ann = igtAnnotation.getAnnotation();
            Tier tier = ann.getTier();
            LexiconQueryBundle2 lexBundle = tier.getLinguisticType().getLexiconQueryBundle();
            Constraint constraints = tier.getLinguisticType().getConstraints();
            if (lexBundle != null && !igtAnnotation.getAnnotation().getValue().isEmpty()) {
                act = new IGTAddToLexiconAction(igtAnnotation, this.lexHostContext, ElanLocale.getString("InterlinearEditor.Button.AddToLexicon"));
                act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.AddToLexicon", "Menu.Options.InterlinearizationMode"));
                actions.add(act);
            }
            act = new IGTDeleteAction(igtAnnotation, this.hostContext, ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
            act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.InterlinearizationMode"));
            actions.add(act);
            boolean bl = isInsertionSupported = constraints != null && constraints.supportsInsertion();
            if (tier.getParentTier() == null) {
                boolean canSplit = true;
                List<TierImpl> childTiers2 = ((TierImpl)tier).getChildTiers();
                if (!childTiers2.isEmpty()) {
                    for (TierImpl tt : childTiers2) {
                        if (tt.getLinguisticType().getConstraints().getStereoType() == 4 || ann.getChildrenOnTier(tt).isEmpty()) continue;
                        canSplit = false;
                        break;
                    }
                }
                if (canSplit) {
                    act = new IGTSplitAnnotationAction(igtAnnotation, this.hostContext, 0, ElanLocale.getString("Menu.Annotation.SplitAnnotation"));
                    act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.SplitAnnotation", "Menu.Options.InterlinearizationMode"));
                    actions.add(act);
                }
            }
            if (isInsertionSupported) {
                act = new IGTSplitAnnotationAction(igtAnnotation, this.hostContext, 1, ElanLocale.getString("Menu.Annotation.NewAnnotationBefore"));
                act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.NewAnnotationBefore", "Menu.Options.InterlinearizationMode"));
                actions.add(act);
                act = new IGTSplitAnnotationAction(igtAnnotation, this.hostContext, 2, ElanLocale.getString("Menu.Annotation.NewAnnotationAfter"));
                act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.NewAnnotationAfter", "Menu.Options.InterlinearizationMode"));
                actions.add(act);
            }
            if (!(childTiers = tier.getChildTiers()).isEmpty()) {
                act = new IGTCreateDependentAnnotationsAction(igtAnnotation, this.hostContext, ElanLocale.getString("Menu.Annotation.CreateDependingAnnotations"));
                act.putValue("AcceleratorKey", su.getKeyStrokeForAction("Menu.Annotation.CreateDependingAnnotations", "Menu.Options.InterlinearizationMode"));
                actions.add(act);
            }
            return actions;
        }
        return null;
    }

    @Override
    public List<IGTEditAction> actionsForEmptySpace(IGTAnnotation parent) {
        if (parent != null) {
            ArrayList<IGTEditAction> actions = new ArrayList<IGTEditAction>(1);
            IGTCreateDependentAnnotationsAction act = new IGTCreateDependentAnnotationsAction(parent, this.hostContext, ElanLocale.getString("Menu.Annotation.CreateDependingAnnotations"));
            actions.add(act);
            return actions;
        }
        return null;
    }

    @Override
    public void viewerModelChanged(IGTViewerModelEvent event) {
        if (event != null && event.getRow() > -1 && event.getType() == ModelEventType.CHANGE) {
            this.calculateHeightForRow(event.getRow(), true);
        }
    }

    @Override
    public void suggestionSetDelivered(SuggestionSetEvent event) {
        if (event != null && event.getSuggestionSets() != null) {
            List<SuggestionSet> sugSets = event.getSuggestionSets();
            int recursionLevel = event.getRecursionLevel();
            Position sourcePos = null;
            for (SuggestionSet sugSet : sugSets) {
                sourcePos = sugSet.getSource();
                int rowIndex = this.getRowIndexForTierAndTime(sourcePos.getTierId(), (sourcePos.getBeginTime() + sourcePos.getEndTime()) / 2L);
                if (rowIndex <= -1) continue;
                this.scrollToVisible(rowIndex);
                this.table.editCellAt(rowIndex, 0);
                break;
            }
            IGTSuggestionViewerModel svModel = new IGTSuggestionViewerModel(recursionLevel);
            svModel.renderInfo.setHeaderFont(this.viewerRenderInfo.defaultFont);
            svModel.renderInfo.setTextInsets(this.viewerRenderInfo.annBBoxInsets);
            int optRowHeaderWidth = this.viewerRenderInfo.headerWidth;
            boolean rhwCalculated = false;
            for (SuggestionSet sugSet : sugSets) {
                IGTSuggestionModel sugModel = new IGTSuggestionModel(sugSet);
                svModel.addRow(sugModel);
                if (!rhwCalculated) {
                    optRowHeaderWidth = IGTCalculator.calcSuggestionRowHeaderWidth(this.getGraphics(), sugModel, svModel.renderInfo);
                    if (optRowHeaderWidth > 0) {
                        svModel.renderInfo.rowHeaderWidth = optRowHeaderWidth;
                    }
                    rhwCalculated = true;
                }
                IGTSuggestionRenderInfo sugRenderInfo = (IGTSuggestionRenderInfo)sugModel.getRenderInfo();
                sugRenderInfo.rowHeaderWidth = svModel.renderInfo.rowHeaderWidth;
                sugRenderInfo.setTextInsets(svModel.renderInfo.getTextInsets());
            }
            this.groupEditor.suggestionSetDelivered(svModel, sourcePos, this.hostContext);
        }
    }

    @Override
    public void cancelSuggestionSet() {
        this.groupEditor.cancelSuggestionSet();
    }

    void scrollToVisible(int row) {
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
    }

    public int getRowIndexForTierAndTime(String tierName, long time) {
        if (tierName != null) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                IGTDataModel rowModel = this.model.getRowData(i);
                if (rowModel.getBeginTime() > time || rowModel.getEndTime() < time || rowModel.getRowIndexForTier(tierName) <= -1) continue;
                return i;
            }
        }
        return -1;
    }

    public int getRowIndexForTime(long time) {
        if (time > -1L) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                IGTDataModel nextModel;
                IGTDataModel rowModel = this.model.getRowData(i);
                if (rowModel.getBeginTime() > time || rowModel.getEndTime() < time) continue;
                if (rowModel.getEndTime() == time && i < this.model.getRowCount() - 1 && (nextModel = this.model.getRowData(i + 1)).getBeginTime() == time) {
                    return i + 1;
                }
                return i;
            }
        }
        return -1;
    }

    public long[] getTimeIntervalForRow(int row) {
        if (row >= 0 && row < this.model.getRowCount()) {
            IGTDataModel rowModel = this.model.getRowData(row);
            return new long[]{rowModel.getBeginTime(), rowModel.getEndTime()};
        }
        return null;
    }

    public boolean isTierInRow(String tierName, int row) {
        if (row >= 0 && row < this.model.getRowCount()) {
            IGTDataModel rowModel = this.model.getRowData(row);
            return rowModel.getRowIndexForTier(tierName) > -1;
        }
        return false;
    }

    public void updateActiveAnnotation(Annotation newActiveAnnotation) {
        if (newActiveAnnotation != this.groupEditor.getActiveAnnotation()) {
            long time;
            String tierName;
            int rowIndex;
            if (newActiveAnnotation != null && (rowIndex = this.getRowIndexForTierAndTime(tierName = newActiveAnnotation.getTier().getName(), time = (newActiveAnnotation.getBeginTimeBoundary() + newActiveAnnotation.getEndTimeBoundary()) / 2L)) >= 0) {
                this.updateStaleEditor(rowIndex);
                this.scrollToVisible(rowIndex);
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.table.editCellAt(rowIndex, 0);
            }
            this.groupEditor.updateActiveAnnotation(newActiveAnnotation);
        }
        int oldActiveIndex = this.previousRowWithActiveAnnotation;
        this.groupCellRenderer.updateActiveAnnotation(newActiveAnnotation);
        this.previousRowWithActiveAnnotation = this.table.getSelectedRow();
        if (oldActiveIndex != this.previousRowWithActiveAnnotation && oldActiveIndex != -1) {
            Rectangle rowRect = this.table.getCellRect(oldActiveIndex, 0, false);
            if (this.tableScrollPane.getViewport().getViewRect().intersects(rowRect)) {
                this.table.repaint(rowRect);
            }
        }
    }

    public void startEditAnnotation(Annotation annotationToEdit) {
        if (annotationToEdit == null) {
            int row = this.table.getSelectedRow();
            if (row < 0 && this.table.getRowCount() >= 1) {
                row = 0;
            }
            this.table.setRowSelectionInterval(row, row);
            this.groupEditor.startEditAnnotation(null);
        } else {
            int annRow;
            int selRow = this.table.getSelectedRow();
            if (selRow == (annRow = this.getRowIndexForTierAndTime(annotationToEdit.getTier().getName(), (annotationToEdit.getBeginTimeBoundary() + annotationToEdit.getEndTimeBoundary()) / 2L))) {
                this.groupEditor.startEditAnnotation(annotationToEdit);
            } else {
                this.table.setRowSelectionInterval(annRow, annRow);
                this.model.startEditingRow(annRow);
                this.groupEditor.startEditAnnotation(annotationToEdit);
            }
        }
    }

    public void selectRowForTime(long time) {
        if (this.tableSelectionIsUpdating) {
            return;
        }
        int row = this.getRowIndexForTime(time);
        int curRow = this.getSelectedRow();
        if (curRow > -1 && curRow != row) {
            long[] curInterval = this.getTimeIntervalForRow(curRow);
            AbstractAnnotation aa = this.groupEditor.getActiveAnnotation();
            if (curInterval != null && aa != null && curInterval[0] <= time && curInterval[1] >= time && aa.getBeginTimeBoundary() >= curInterval[0] && aa.getEndTimeBoundary() <= curInterval[1]) {
                if (!this.table.getVisibleRect().contains(this.table.getCellRect(curRow, 0, true))) {
                    this.scrollToVisible(curRow);
                }
                return;
            }
            this.table.setRowSelectionInterval(row, row);
            this.scrollToVisible(row);
        }
    }

    public void addViewerChangeListener(IGTViewerChangeListener listener) {
        if (!this.viewerChangeListeners.contains(listener)) {
            this.viewerChangeListeners.add(listener);
        }
    }

    public void removeViewerChangeListener(IGTViewerChangeListener listener) {
        this.viewerChangeListeners.remove(listener);
    }

    private void notifyViewChanged() {
        for (IGTViewerChangeListener listener : this.viewerChangeListeners) {
            listener.viewChanged();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.recalculateAllRows(false);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksNotToBeConsumed) {
        InputMap im;
        if (this.origKSMaps == null) {
            this.origKSMaps = new HashMap<KeyStroke, Object>();
        }
        if (!this.origKSMaps.isEmpty()) {
            for (KeyStroke ks : this.origKSMaps.keySet()) {
                Object command = this.origKSMaps.get(ks);
                im = this.table.getInputMap();
                if (im.get(ks) != null) {
                    im.put(ks, command);
                }
                if ((im = this.table.getInputMap(2)).get(ks) != null) {
                    im.put(ks, command);
                }
                if ((im = this.table.getInputMap(1)).get(ks) == null) continue;
                im.put(ks, command);
            }
            this.origKSMaps.clear();
        }
        String NONE = "none";
        for (KeyStroke ks : ksNotToBeConsumed) {
            im = this.table.getInputMap();
            Object command = im.get(ks);
            if (command != null) {
                this.origKSMaps.put(ks, command);
                im.put(ks, "none");
            }
            if ((im = this.table.getInputMap(2)).get(ks) != null) {
                this.origKSMaps.put(ks, command);
                im.put(ks, "none");
            }
            if ((im = this.table.getInputMap(1)).get(ks) == null) continue;
            this.origKSMaps.put(ks, command);
            im.put(ks, "none");
        }
    }

    private class GroupTableCellRenderer
    implements TableCellRenderer {
        private IGTDataModel rowData;
        private int row;
        private boolean isSelected;
        private Annotation activeAnnotation;
        private IGTAnnotation activeIGTAnnotation = null;
        JComponent component = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                Color bg;
                int thisHeight = this.getHeight();
                int thisWidth = this.getWidth();
                Color color = bg = GroupTableCellRenderer.this.row % 2 == 0 ? ((IGTViewer)IGTViewer.this).viewerRenderInfo.backgroundColor : ((IGTViewer)IGTViewer.this).viewerRenderInfo.backgroundColor2;
                if (GroupTableCellRenderer.this.isSelected) {
                    bg = new Color(bg.getRed(), bg.getGreen(), (int)((double)bg.getBlue() * 0.7));
                }
                g.setColor(bg);
                g.fillRect(0, 0, thisWidth, thisHeight);
                IGTGroupRenderer.renderRow2(g, GroupTableCellRenderer.this.rowData, IGTViewer.this.viewerRenderInfo, thisHeight, GroupTableCellRenderer.this.activeIGTAnnotation);
            }
        };

        private GroupTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.row = row;
            this.rowData = (IGTDataModel)value;
            this.isSelected = isSelected;
            this.updateActiveIGTAnnotation(this.rowData);
            return this.component;
        }

        public void updateActiveAnnotation(Annotation activeAnnotation) {
            this.activeAnnotation = activeAnnotation;
        }

        private void updateActiveIGTAnnotation(IGTDataModel dataModel) {
            if (this.activeAnnotation == null) {
                this.activeIGTAnnotation = null;
            } else {
                IGTTier targetTier = dataModel.getRowDataForTier(this.activeAnnotation.getTier().getName());
                if (targetTier == null) {
                    this.activeIGTAnnotation = null;
                } else if (!TimeRelation.isInside(this.activeAnnotation, dataModel.getBeginTime(), dataModel.getEndTime())) {
                    this.activeIGTAnnotation = null;
                } else {
                    for (IGTAnnotation igta : targetTier.getAnnotations()) {
                        if (igta.getAnnotation() != this.activeAnnotation) continue;
                        this.activeIGTAnnotation = igta;
                        return;
                    }
                }
            }
        }
    }

    private class GroupTableCellEditor
    implements TableCellEditor {
        private final IGTViewerModel model;

        private GroupTableCellEditor(IGTViewerModel model) {
            this.model = model;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            IGTViewer.this.groupEditor.commitEdit();
            this.model.startEditingRow(-1);
            return true;
        }

        @Override
        public void cancelCellEditing() {
            IGTViewer.this.groupEditor.cancelEdit();
            this.model.startEditingRow(-1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            IGTDataModel rowModel = (IGTDataModel)value;
            this.model.startEditingRow(row);
            IGTViewer.this.groupEditor.editIGTGroup(rowModel, IGTViewer.this.viewerRenderInfo);
            return IGTViewer.this.groupEditor;
        }

        public Component getTableCellEditorComponent() {
            return IGTViewer.this.groupEditor;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selectedRow = IGTViewer.this.table.getSelectedRow();
                if (IGTViewer.this.viewer != null) {
                    IGTViewer.this.tableSelectionIsUpdating = true;
                    long[] timeInterval = IGTViewer.this.getTimeIntervalForRow(selectedRow);
                    if (timeInterval != null) {
                        IGTViewer.this.viewer.setSelection(timeInterval[0], timeInterval[1]);
                        IGTViewer.this.viewer.setMediaTime(timeInterval[0]);
                    } else {
                        IGTViewer.this.viewer.setSelection(0L, 0L);
                    }
                    IGTViewer.this.tableSelectionIsUpdating = false;
                }
                if (IGTViewer.this.table.getEditingRow() != selectedRow && selectedRow >= 0) {
                    IGTViewer.this.table.editCellAt(selectedRow, 0);
                }
            }
        }
    }

    private class InitScrollThread
    extends Thread {
        private InitScrollThread() {
        }

        @Override
        public void run() {
            while (!IGTViewer.this.table.isValid()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
            }
            IGTViewer.this.scrollToVisible(IGTViewer.this.table.getSelectedRow());
        }
    }

    private class PopupMenuListener
    implements ActionListener,
    ItemListener {
        private PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("showHideMore")) {
                Collection<String> hiddenTiers = IGTViewer.this.model.getHiddenTiers();
                if (hiddenTiers == null) {
                    hiddenTiers = new ArrayList<String>();
                }
                List visibleTiers = IGTViewer.this.getSetDifference(IGTViewer.this.hostContext.getTranscription(), hiddenTiers);
                ShowHideMoreTiersDlg dialog = new ShowHideMoreTiersDlg(IGTViewer.this.hostContext.getTranscription(), visibleTiers, IGTViewer.this);
                String selectionMode = Preferences.getString("InterlinearEditor.SelectTiersMode", IGTViewer.this.hostContext.getTranscription());
                if (selectionMode != null) {
                    dialog.setSelectionMode(selectionMode, (List)hiddenTiers);
                }
                dialog.setVisible(true);
                if (dialog.isValueChanged()) {
                    List<String> selVisibleTiers = dialog.getVisibleTierNames();
                    List nextHiddenTiers = IGTViewer.this.getSetDifference(IGTViewer.this.hostContext.getTranscription(), selVisibleTiers);
                    IGTViewer.this.updateHiddenTiersInModel(nextHiddenTiers);
                    Preferences.set("InterlinearEditor.SelectTiersMode", dialog.getSelectionMode(), IGTViewer.this.hostContext.getTranscription(), false, false);
                    Preferences.set("InterlinearEditor.HiddenTiers", nextHiddenTiers, IGTViewer.this.hostContext.getTranscription(), false, false);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItem() == IGTViewer.this.showHideTimeCodesMI) {
                boolean newVisibility = e.getStateChange() == 1;
                IGTViewer.this.changeVisibility(IGTTierType.TIME_CODE, newVisibility);
                Preferences.set("InterlinearEditor.ShowTimeCode", newVisibility, IGTViewer.this.hostContext.getTranscription(), false, false);
            } else if (e.getItem() == IGTViewer.this.showHideSpeakerMI) {
                boolean speakerVis = e.getStateChange() == 1;
                IGTViewer.this.changeVisibility(IGTTierType.SPEAKER_LABEL, speakerVis);
                Preferences.set("InterlinearEditor.ShowSpeaker", speakerVis, IGTViewer.this.hostContext.getTranscription(), false, false);
            }
        }
    }
}

