/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FontSizePanel;
import mpi.eudico.client.annotator.interlinear.IGTPlayerControlPanel;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.IGTConstants;
import mpi.eudico.client.annotator.interlinear.edit.IGTViewer;
import mpi.eudico.client.annotator.interlinear.edit.IGTViewerModelImpl;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAbstractDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDefaultModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.RenderingConfigDialog;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.util.AnnotationCoreComparator;
import nl.mpi.lexan.analyzers.helpers.Position;

public class InterlinearEditor
extends AbstractViewer
implements ComponentListener,
ActionListener,
ACMEditListener {
    private InterlinearizationManager manager;
    private TranscriptionImpl transcription = null;
    private Font font;
    private int bpHeight = 40;
    private JPanel buttonPanel;
    private JButton interButton;
    private JButton configureButton;
    private JCheckBox recursiveCB;
    private FontSizePanel fontSizePanel;
    private IGTPlayerControlPanel playerControlPanel;
    private JSplitPane buttonSplitPane;
    private SpringLayout buttonLayout;
    private AnalyzerConfig activeConfig = null;
    private IGTViewer igtViewer = null;
    private IGTViewerModelImpl viewerModel = null;

    public InterlinearEditor(InterlinearizationManager manager) {
        this.manager = manager;
        this.transcription = (TranscriptionImpl)manager.getTranscription();
        this.initViewer();
    }

    public void configsChanged() {
        this.paintBuffer();
    }

    public void setActiveConfiguration(AnalyzerConfig ac) {
        this.activeConfig = ac;
    }

    public AnalyzerConfig getActiveConfiguration() {
        return this.activeConfig;
    }

    public Zoomable getZoomable() {
        return this.fontSizePanel;
    }

    private void initViewer() {
        this.setOpaque(true);
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.setBackground(Color.WHITE);
        this.buttonLayout = new SpringLayout();
        this.buttonPanel = new JPanel(this.buttonLayout);
        this.playerControlPanel = new IGTPlayerControlPanel();
        this.buttonSplitPane = new JSplitPane(1);
        this.buttonSplitPane.setOneTouchExpandable(false);
        this.buttonSplitPane.setLeftComponent(this.playerControlPanel);
        this.buttonSplitPane.setRightComponent(this.buttonPanel);
        this.buttonSplitPane.setContinuousLayout(true);
        this.buttonSplitPane.setBorder(null);
        this.add(this.buttonSplitPane);
        this.interButton = new JButton();
        this.interButton.addActionListener(this);
        this.buttonPanel.add(this.interButton);
        this.recursiveCB = new JCheckBox();
        this.buttonPanel.add(this.recursiveCB);
        this.recursiveCB.addActionListener(this);
        this.viewerModel = new IGTViewerModelImpl();
        this.initModel();
        this.igtViewer = new IGTViewer(this.viewerModel, this.manager.getTextAnalyzerContext(), this.manager.getTextAnalyzerLexiconContext(), this);
        this.igtViewer.readGUIPreferences(this.transcription);
        this.add(this.igtViewer);
        this.configureButton = new JButton();
        this.configureButton.addActionListener(this);
        try {
            ImageIcon confIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Configure16.gif"));
            this.configureButton.setIcon(confIcon);
        }
        catch (Exception ex) {
            this.configureButton.setText("C");
        }
        this.buttonPanel.add(this.configureButton);
        this.fontSizePanel = new FontSizePanel(this.igtViewer);
        this.buttonPanel.add(this.fontSizePanel);
        this.buttonLayout.putConstraint("West", (Component)this.interButton, 6, "West", (Component)this.buttonPanel);
        this.buttonLayout.putConstraint("VerticalCenter", (Component)this.interButton, 0, "VerticalCenter", (Component)this.buttonPanel);
        this.buttonLayout.putConstraint("West", (Component)this.recursiveCB, 6, "East", (Component)this.interButton);
        this.buttonLayout.putConstraint("VerticalCenter", (Component)this.recursiveCB, 0, "VerticalCenter", (Component)this.buttonPanel);
        this.buttonLayout.putConstraint("East", (Component)this.fontSizePanel, -3, "East", (Component)this.buttonPanel);
        this.buttonLayout.putConstraint("VerticalCenter", (Component)this.fontSizePanel, 0, "VerticalCenter", (Component)this.buttonPanel);
        this.buttonLayout.putConstraint("East", (Component)this.configureButton, -12, "West", (Component)this.fontSizePanel);
        this.buttonLayout.putConstraint("VerticalCenter", (Component)this.configureButton, 0, "VerticalCenter", (Component)this.buttonPanel);
        this.bpHeight = this.fontSizePanel.getPreferredSize().height + 4;
        this.buttonSplitPane.setDividerLocation(this.igtViewer.getHeaderWidth() - this.buttonSplitPane.getDividerSize() / 2);
        this.setPreferredFontAndColorSettings();
        this.manager.getViewerManager().connectViewer(this.playerControlPanel, true);
        this.manager.getViewerManager().connectListener(this.playerControlPanel);
        this.addComponentListener(this);
        this.playerControlPanel.addComponentListener(this);
        this.updateLocale();
        this.paintBuffer();
    }

    private void setPreferredFontAndColorSettings() {
        Integer size;
        HashMap<String, Color> tierColorMap = new HashMap<String, Color>();
        Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
        if (colors != null) {
            for (Map.Entry<String, Color> e : colors.entrySet()) {
                String name = e.getKey();
                Color col = e.getValue();
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null) continue;
                tierColorMap.put(name, col);
            }
        }
        this.igtViewer.setTierColorMap(tierColorMap);
        Map<String, Font> fo = Preferences.getMapOfFont("TierFonts", this.transcription);
        if (fo != null) {
            this.igtViewer.setTierFontMap(fo);
        }
        if ((size = Preferences.getInt("InterlinearizationEditor.FontSize", this.transcription)) != null) {
            this.fontSizePanel.setFontSize(size);
        }
    }

    private void initModel() {
        Boolean showSpeakPref;
        List<String> hiddenTiers = Preferences.getListOfString("InterlinearEditor.HiddenTiers", this.transcription);
        if (hiddenTiers == null && (hiddenTiers = Preferences.getListOfString("MultiTierViewer.HiddenTiers", this.transcription)) == null) {
            hiddenTiers = new ArrayList<String>();
        }
        this.viewerModel.setHiddenTiers(hiddenTiers);
        ArrayList<IGTTierType> hiddenSpecialTiers = new ArrayList<IGTTierType>(3);
        Boolean showTCPref = Preferences.getBool("InterlinearEditor.ShowTimeCode", this.transcription);
        if (showTCPref != null && !showTCPref.booleanValue()) {
            hiddenSpecialTiers.add(IGTTierType.TIME_CODE);
            this.viewerModel.setSpecialTierVisibility(IGTTierType.TIME_CODE, showTCPref);
        }
        if ((showSpeakPref = Preferences.getBool("InterlinearEditor.ShowSpeaker", this.transcription)) != null && !showSpeakPref.booleanValue()) {
            hiddenSpecialTiers.add(IGTTierType.SPEAKER_LABEL);
            this.viewerModel.setSpecialTierVisibility(IGTTierType.SPEAKER_LABEL, showSpeakPref);
        }
        ArrayList<AlignableAnnotation> allAnns = new ArrayList<AlignableAnnotation>();
        for (TierImpl t : this.transcription.getTiers()) {
            if (t.hasParentTier() || hiddenTiers.contains(t.getName())) continue;
            allAnns.addAll(t.getAlignableAnnotations());
        }
        AnnotationCoreComparator comparator = new AnnotationCoreComparator();
        Collections.sort(allAnns, comparator);
        for (AlignableAnnotation aa : allAnns) {
            IGTDefaultModel rowModel = new IGTDefaultModel(aa, hiddenTiers, hiddenSpecialTiers);
            this.viewerModel.addRow(rowModel);
        }
    }

    public List<String> getVisibleTiersRow(int row) {
        if (row >= 0 && row < this.viewerModel.getRowCount()) {
            return ((IGTAbstractDataModel)this.viewerModel.getRowData(row)).getVisibleTierOrder();
        }
        return null;
    }

    public IGTAbstractDataModel getModelFromRow(int row) {
        if (row >= 0 && row < this.viewerModel.getRowCount()) {
            return (IGTAbstractDataModel)this.viewerModel.getRowData(row);
        }
        return null;
    }

    public int getRowForAnnotation(AbstractAnnotation annotation) {
        if (annotation != null) {
            return this.findRowIndexForAnnotation(annotation);
        }
        return -1;
    }

    public int getSelectedRow() {
        return this.igtViewer.getSelectedRow();
    }

    public int getRowCount() {
        return this.viewerModel.getRowCount();
    }

    public void startEditAnnotation() {
        this.igtViewer.startEditAnnotation(this.getActiveAnnotation());
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public void isClosing() {
        Preferences.set("InterlinearizationEditor.FontSize", this.igtViewer.getFontSize(), this.transcription, false, false);
        this.manager.getViewerManager().connectViewer(this.playerControlPanel, false);
        this.manager.getViewerManager().disconnectListener(this.playerControlPanel);
        this.igtViewer.isClosing(this.transcription);
    }

    private void paintBuffer() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        this.repaint();
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        int rowCount = this.viewerModel.getRowCount();
        switch (e.getOperation()) {
            case 3: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof AbstractAnnotation)) break;
                AbstractAnnotation newAnn = (AbstractAnnotation)e.getModification();
                TierImpl invTier = (TierImpl)e.getInvalidatedObject();
                assert (invTier == newAnn.getTier());
                IGTDefaultModel rowModel = this.findAnnotationRow(newAnn, invTier);
                if (rowModel == null) break;
                rowModel.annotationAdded(newAnn);
                break;
            }
            case 5: {
                IGTDefaultModel rowModel;
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof AbstractAnnotation)) break;
                AbstractAnnotation newAnn = (AbstractAnnotation)e.getModification();
                TierImpl invTier = (TierImpl)e.getInvalidatedObject();
                assert (invTier == newAnn.getTier());
                AbstractAnnotation annBefore = (AbstractAnnotation)invTier.getAnnotationBefore(newAnn);
                if (annBefore == null || annBefore.getParentAnnotation() != newAnn.getParentAnnotation() || (rowModel = this.findAnnotationRow(newAnn, invTier)) == null) break;
                rowModel.annotationAddedAfter(newAnn, annBefore);
                break;
            }
            case 4: {
                IGTDefaultModel rowModel;
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof AbstractAnnotation)) break;
                AbstractAnnotation newAnn = (AbstractAnnotation)e.getModification();
                TierImpl invTier = (TierImpl)e.getInvalidatedObject();
                assert (invTier == newAnn.getTier());
                AbstractAnnotation annAfter = (AbstractAnnotation)invTier.getAnnotationAfter(newAnn);
                if (annAfter == null || annAfter.getParentAnnotation() != newAnn.getParentAnnotation() || (rowModel = this.findAnnotationRow(newAnn, invTier)) == null) break;
                rowModel.annotationAddedBefore(newAnn, annAfter);
                break;
            }
            case 7: 
            case 8: {
                int row;
                TierImpl invTier;
                if (!(e.getInvalidatedObject() instanceof AbstractAnnotation)) break;
                AbstractAnnotation a = (AbstractAnnotation)e.getInvalidatedObject();
                IGTDefaultModel rowModel = this.findAnnotationRow(a, invTier = (TierImpl)a.getTier());
                if (rowModel != null) {
                    rowModel.annotationValueChanged(a);
                }
                if ((row = this.igtViewer.getSelectedRow()) <= -1 || this.viewerModel.getRowData(row) != rowModel) break;
                this.igtViewer.updateStaleEditor(row);
                break;
            }
            case 6: {
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                if (e.getModification() instanceof AbstractAnnotation) {
                    TierImpl invTier;
                    AbstractAnnotation remAnnotation = (AbstractAnnotation)e.getModification();
                    IGTDefaultModel rowModel = this.findAnnotationRow(remAnnotation, invTier = (TierImpl)remAnnotation.getTier());
                    if (rowModel == null) break;
                    if (rowModel.getRootRow().getTierName().equals(invTier.getName())) {
                        int row = this.findRowIndexForAnnotation(remAnnotation);
                        this.viewerModel.removeRowData(rowModel);
                        if (row >= this.viewerModel.getRowCount() || this.igtViewer.getSelectedRow() != -1) break;
                        this.igtViewer.updateStaleEditor(row);
                        break;
                    }
                    rowModel.annotationRemoved(remAnnotation);
                    break;
                }
                for (int i = 0; i < rowCount; ++i) {
                    IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
                    int tierRowCount = rowModel.getRowCount();
                    for (int j = 0; j < tierRowCount; ++j) {
                        IGTTier tierRowModel = rowModel.getRowData(j);
                        ArrayList<IGTAnnotation> anns = tierRowModel.getAnnotations();
                        for (int k = anns.size() - 1; k >= 0; --k) {
                            IGTAnnotation igtAnn = anns.get(k);
                            AbstractAnnotation annotation = igtAnn.getAnnotation();
                            if (annotation == null || !annotation.isMarkedDeleted()) continue;
                            rowModel.annotationRemoved(annotation);
                            tierRowCount = rowModel.getRowCount();
                        }
                    }
                }
                this.igtViewer.recalculateAllRows(true);
                break;
            }
            case 14: {
                this.eventChangeAnnotations();
                break;
            }
            case 1: {
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl)) break;
                TierImpl invTier = (TierImpl)obj;
                TierImpl rootTier = invTier.getRootTier();
                String rootTierName = rootTier.getName();
                for (int i = 0; i < rowCount; ++i) {
                    IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
                    IGTTier igtTier = rowModel.getRootRow();
                    if (!igtTier.getTierName().equals(rootTierName)) continue;
                    rowModel.tierRemoved(invTier.getName());
                    if (invTier != rootTier) continue;
                    this.viewerModel.removeRow(i);
                    --i;
                }
                this.igtViewer.recalculateAllRows(true);
                break;
            }
            case 0: {
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl)) break;
                TierImpl invTier = (TierImpl)obj;
                if (invTier.hasParentTier()) {
                    TierImpl rootTier = invTier.getRootTier();
                    String rootTierName = rootTier.getName();
                    for (int i = 0; i < rowCount; ++i) {
                        IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
                        IGTTier igtTier = rowModel.getRootRow();
                        if (!igtTier.getTierName().equals(rootTierName)) continue;
                        rowModel.tierAdded(invTier, this.viewerModel.getHiddenTiers());
                    }
                    this.igtViewer.recalculateAllRows(true);
                    break;
                }
                if (this.viewerModel.getHiddenTiers().contains(invTier.getName())) break;
                ArrayList<AlignableAnnotation> allAnns = new ArrayList<AlignableAnnotation>();
                allAnns.addAll(invTier.getAlignableAnnotations());
                int nextIndex = 0;
                block15: while (allAnns.size() > 0) {
                    AlignableAnnotation aa = (AlignableAnnotation)allAnns.get(0);
                    IGTDefaultModel newRowModel = new IGTDefaultModel(aa, this.viewerModel.getHiddenTiers());
                    if (nextIndex >= rowCount - 1) {
                        this.viewerModel.addRow(newRowModel);
                        ++nextIndex;
                        continue;
                    }
                    for (int i = nextIndex; i < rowCount; ++i) {
                        IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
                        long beginTime = rowModel.getBeginTime();
                        if (aa.getBeginTimeBoundary() < beginTime) {
                            this.viewerModel.insertRow(newRowModel, i);
                            nextIndex = i + 1;
                            continue block15;
                        }
                        if (aa.getBeginTimeBoundary() > beginTime) continue;
                        if (aa.getEndTimeBoundary() < rowModel.getEndTime()) {
                            this.viewerModel.insertRow(newRowModel, i);
                            nextIndex = i + 1;
                            continue block15;
                        }
                        if (aa.getEndTimeBoundary() <= rowModel.getEndTime()) continue;
                    }
                }
                if (allAnns.size() <= 0) break;
                this.igtViewer.recalculateAllRows(true);
                break;
            }
        }
        this.paintBuffer();
    }

    private IGTDefaultModel findAnnotationRow(AbstractAnnotation changedAnn, TierImpl changedTier) {
        long bt = changedAnn.getBeginTimeBoundary();
        long et = changedAnn.getEndTimeBoundary();
        TierImpl rootTier = changedTier.getRootTier();
        String rootTierName = rootTier.getName();
        int rowCount = this.viewerModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IGTAnnotation igtAnn;
            ArrayList<IGTAnnotation> annos;
            IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
            IGTTier igtTier = rowModel.getRootRow();
            if (!igtTier.getTierName().equals(rootTierName) || (annos = igtTier.getAnnotations()) == null || annos.size() <= 0 || (igtAnn = (IGTAnnotation)annos.get(0)).getAnnotation().getBeginTimeBoundary() > bt || igtAnn.getAnnotation().getEndTimeBoundary() < et) continue;
            return rowModel;
        }
        return null;
    }

    private int findRowIndexForAnnotation(AbstractAnnotation aa) {
        long bt = aa.getBeginTimeBoundary();
        long et = aa.getEndTimeBoundary();
        int rowCount = this.viewerModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IGTTier igtTier;
            IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
            if (rowModel.getBeginTime() > bt || rowModel.getEndTime() < et || (igtTier = rowModel.getRowDataForTier(aa.getTier().getName())) == null) continue;
            for (IGTAnnotation igta : igtTier.getAnnotations()) {
                if (igta.getAnnotation() != aa) continue;
                return i;
            }
        }
        return -1;
    }

    private void eventChangeAnnotations() {
        int origditRow = this.viewerModel.getEditingRow();
        boolean justRebuild = true;
        long curTime = System.nanoTime();
        if (justRebuild) {
            while (this.viewerModel.getRowCount() > 0) {
                this.viewerModel.removeRow(this.viewerModel.getRowCount() - 1);
            }
            this.initModel();
            this.igtViewer.recalculateAllRows(true);
        } else {
            this.revalidateModel();
        }
        if (origditRow >= 0 && origditRow < this.viewerModel.getRowCount()) {
            this.igtViewer.updateStaleEditor(origditRow);
        }
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            long total = System.nanoTime() - curTime;
            ClientLogger.LOG.fine(String.format("Viewer update took: %d nano", total));
        }
    }

    private void revalidateModel() {
        int i;
        ArrayList<AlignableAnnotation> allAnns = new ArrayList<AlignableAnnotation>();
        ArrayList<IGTTierType> hiddenSpecialTiers = new ArrayList<IGTTierType>(3);
        if (!this.viewerModel.getSpecialTierVisibility(IGTTierType.TIME_CODE)) {
            hiddenSpecialTiers.add(IGTTierType.TIME_CODE);
        }
        if (!this.viewerModel.getSpecialTierVisibility(IGTTierType.SPEAKER_LABEL)) {
            hiddenSpecialTiers.add(IGTTierType.SPEAKER_LABEL);
        }
        for (TierImpl t : this.transcription.getTiers()) {
            if (t.hasParentTier() || this.viewerModel.getHiddenTiers().contains(t.getName())) continue;
            allAnns.addAll(t.getAlignableAnnotations());
        }
        AnnotationCoreComparator comparator = new AnnotationCoreComparator();
        Collections.sort(allAnns, comparator);
        for (i = this.viewerModel.getRowCount() - 1; i >= 0; --i) {
            IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
            AbstractAnnotation rootAnn = rowModel.getRootRow().getRootTier().getAnnotations().get(0).getAnnotation();
            if (allAnns.contains(rootAnn)) continue;
            this.viewerModel.removeRow(i);
        }
        block2: for (i = 0; i < allAnns.size(); ++i) {
            AlignableAnnotation aa = (AlignableAnnotation)allAnns.get(i);
            if (i < this.viewerModel.getRowCount()) {
                IGTDefaultModel rowModel = (IGTDefaultModel)this.viewerModel.getRowData(i);
                if (aa != rowModel.getRootRow().getRootTier().getAnnotations().get(0).getAnnotation()) {
                    IGTDefaultModel rowModelInsert = new IGTDefaultModel(aa, this.viewerModel.getHiddenTiers(), hiddenSpecialTiers);
                    this.viewerModel.insertRow(rowModelInsert, i);
                    this.igtViewer.calculateHeightForRow(i, false);
                    continue;
                }
                for (int j = 0; j < rowModel.getRowCount(); ++j) {
                    IGTTier loopTier = rowModel.getRowData(j);
                    if (loopTier.isSpecial()) continue;
                    TierImpl ti = this.transcription.getTierWithId(loopTier.getTierName());
                    if (loopTier.getAnnotations().size() == ti.getOverlappingAnnotations(rowModel.getBeginTime(), rowModel.getEndTime()).size()) continue;
                    this.viewerModel.removeRow(i);
                    IGTDefaultModel rowModelInsert = new IGTDefaultModel(aa, this.viewerModel.getHiddenTiers(), hiddenSpecialTiers);
                    this.viewerModel.insertRow(rowModelInsert, i);
                    this.igtViewer.calculateHeightForRow(i, false);
                    continue block2;
                }
                continue;
            }
            IGTDefaultModel rowModelInsert = new IGTDefaultModel(aa, this.viewerModel.getHiddenTiers(), hiddenSpecialTiers);
            this.viewerModel.addRow(rowModelInsert);
            this.igtViewer.calculateHeightForRow(this.viewerModel.getRowCount() - 1, false);
        }
    }

    @Override
    public void updateSelection() {
        if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
            this.igtViewer.selectRowForTime(this.getSelectionBeginTime());
        }
    }

    @Override
    public void updateActiveAnnotation() {
        this.igtViewer.updateActiveAnnotation(this.getActiveAnnotation());
    }

    @Override
    public void updateLocale() {
        if (this.interButton != null) {
            this.interButton.setText(ElanLocale.getString("InterlinearEditor.Button.Interlinearize"));
            this.recursiveCB.setText(ElanLocale.getString("InterlinearEditor.CheckBox.Recursive"));
        }
        if (this.configureButton != null) {
            this.configureButton.setToolTipText(ElanLocale.getString("InterlinearEditor.Button.ConfigureViewer"));
        }
        if (this.fontSizePanel != null) {
            this.fontSizePanel.updateLocale();
        }
    }

    @Override
    public void preferencesChanged() {
        Integer whiteSpaceWidth;
        Integer leftMargin;
        Color annBgColor;
        Color annBorderColor;
        Boolean showAnnBackground;
        Boolean showAnnBorders;
        Color oddRowColor;
        Color evenRowColor;
        this.setPreferredFontAndColorSettings();
        Boolean boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null);
        if (boolPref != null) {
            this.igtViewer.setDeselectCommits(boolPref);
        }
        if ((evenRowColor = Preferences.getColor("InterlinearEditor.BackgroundColor.Even", null)) != null) {
            this.igtViewer.getViewerRenderInfo().backgroundColor = evenRowColor;
        }
        if ((oddRowColor = Preferences.getColor("InterlinearEditor.BackgroundColor.Odd", null)) != null) {
            this.igtViewer.getViewerRenderInfo().backgroundColor2 = oddRowColor;
        }
        if ((showAnnBorders = Preferences.getBool("InterlinearEditor.PaintAnnotationBorders", null)) != null) {
            this.igtViewer.getViewerRenderInfo().showAnnoBorders = showAnnBorders;
        }
        if ((showAnnBackground = Preferences.getBool("InterlinearEditor.PaintAnnotationBackground", null)) != null) {
            this.igtViewer.getViewerRenderInfo().showAnnoBackground = showAnnBackground;
        }
        if ((annBorderColor = Preferences.getColor("InterlinearEditor.Annotation.BorderColor", null)) != null) {
            this.igtViewer.getViewerRenderInfo().annoBorderColor = annBorderColor;
        }
        if ((annBgColor = Preferences.getColor("InterlinearEditor.Annotation.BackgroundColor", null)) != null) {
            this.igtViewer.getViewerRenderInfo().annoBackgroundColor = annBgColor;
        }
        boolean needRecalc = false;
        Integer topMargin = Preferences.getInt("InterlinearEditor.Annotation.BB.TopMargin", null);
        Insets bBoxInsets = this.igtViewer.getViewerRenderInfo().annBBoxInsets;
        if (topMargin != null) {
            if (topMargin != bBoxInsets.top) {
                bBoxInsets.top = topMargin;
                needRecalc = true;
            }
            if (topMargin != bBoxInsets.bottom) {
                bBoxInsets.bottom = topMargin;
                needRecalc = true;
            }
        }
        if ((leftMargin = Preferences.getInt("InterlinearEditor.Annotation.BB.LeftMargin", null)) != null) {
            if (leftMargin != bBoxInsets.left) {
                bBoxInsets.left = leftMargin;
                needRecalc = true;
            }
            if (leftMargin != bBoxInsets.right) {
                bBoxInsets.right = leftMargin;
                needRecalc = true;
            }
        }
        if ((whiteSpaceWidth = Preferences.getInt("InterlinearEditor.WhitespaceWidth", null)) != null && this.igtViewer.getViewerRenderInfo().whitespaceWidth != whiteSpaceWidth) {
            this.igtViewer.getViewerRenderInfo().whitespaceWidth = whiteSpaceWidth;
            needRecalc = true;
        }
        if (needRecalc) {
            this.igtViewer.recalculateAllRows(true);
        }
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this.playerControlPanel) {
            int width = this.playerControlPanel.getWidth();
            this.igtViewer.setHeaderWidth(width + this.buttonSplitPane.getDividerSize() / 2);
        } else if (e.getSource() == this) {
            int w = e.getComponent().getWidth();
            int h = e.getComponent().getHeight();
            this.buttonSplitPane.setBounds(0, 0, w, this.bpHeight);
            this.igtViewer.setBounds(0, this.bpHeight, w, h - this.bpHeight);
            this.validate();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.interButton) {
            if (this.manager.getTextAnalyzerContext().isAutoAnalyzeMode()) {
                this.manager.getTextAnalyzerContext().setAutoAnalyzeMode(false);
                return;
            }
            Annotation activeAnn = this.getActiveAnnotation();
            TierImpl activeSourceTier = null;
            AnalyzerConfig ac = this.activeConfig;
            ArrayList<AnalyzerConfig> activeConfList = new ArrayList<AnalyzerConfig>();
            if (activeAnn != null) {
                activeSourceTier = (TierImpl)activeAnn.getTier();
                String activeTypeName = activeSourceTier.getLinguisticType().getLinguisticTypeName();
                List<AnalyzerConfig> configurations = this.manager.getTextAnalyzerContext().getConfigurations();
                for (AnalyzerConfig acf : configurations) {
                    if (acf.isTypeMode()) {
                        if (!acf.getSource().equals(activeTypeName)) continue;
                        activeConfList.addAll(acf.getTierConfigurations());
                        continue;
                    }
                    if (!acf.getSource().equals(activeSourceTier.getName())) continue;
                    activeConfList.add(acf);
                }
            } else if (ac == null) {
                List<AnalyzerConfig> configurations = this.manager.getTextAnalyzerContext().getConfigurations();
                if (configurations.size() > 0) {
                    ac = configurations.get(0);
                    activeConfList.addAll(ac.getTierConfigurations());
                }
            } else {
                activeConfList.addAll(ac.getTierConfigurations());
            }
            if (activeConfList.isEmpty()) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearEditor.Warning.NoConfig.Message"), ElanLocale.getString("InterlinearEditor.Warning.NoConfig.Title"), 2);
                return;
            }
            this.manager.getTextAnalyzerContext().setAutoAnalyzeMode(true);
            new AnalyzeThread(activeConfList, activeAnn).start();
        } else if (e.getSource() == this.recursiveCB) {
            this.manager.getTextAnalyzerContext().setRecursive(this.recursiveCB.isSelected());
        } else if (e.getSource() == this.configureButton) {
            RenderingConfigDialog dialog = new RenderingConfigDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("InterlinearEditor.RenderDialog.Title"), true);
            dialog.setVisible(true);
            this.applySettings(dialog.getSettings());
        }
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksNotToBeConsumed) {
        this.igtViewer.setKeyStrokesNotToBeConsumed(ksNotToBeConsumed);
    }

    private void applySettings(Map<String, Object> nextSettings) {
        if (nextSettings != null) {
            Color evenRowColor = (Color)nextSettings.get("InterlinearEditor.BackgroundColor.Even");
            if (evenRowColor != null) {
                this.igtViewer.getViewerRenderInfo().backgroundColor = evenRowColor;
                Preferences.set("InterlinearEditor.BackgroundColor.Even", evenRowColor, null);
            } else {
                this.igtViewer.getViewerRenderInfo().backgroundColor = IGTConstants.TABLE_BACKGROUND_COLOR1;
                Preferences.set("InterlinearEditor.BackgroundColor.Even", null, null);
            }
            Color oddRowColor = (Color)nextSettings.get("InterlinearEditor.BackgroundColor.Odd");
            if (oddRowColor != null) {
                this.igtViewer.getViewerRenderInfo().backgroundColor2 = oddRowColor;
                Preferences.set("InterlinearEditor.BackgroundColor.Odd", oddRowColor, null);
            } else {
                this.igtViewer.getViewerRenderInfo().backgroundColor2 = IGTConstants.TABLE_BACKGROUND_COLOR2;
                Preferences.set("InterlinearEditor.BackgroundColor.Odd", null, null);
            }
            Boolean showAnnBorders = (Boolean)nextSettings.get("InterlinearEditor.PaintAnnotationBorders");
            if (showAnnBorders != null) {
                this.igtViewer.getViewerRenderInfo().showAnnoBorders = showAnnBorders;
                Preferences.set("InterlinearEditor.PaintAnnotationBorders", showAnnBorders, null);
            } else {
                this.igtViewer.getViewerRenderInfo().showAnnoBorders = true;
                Preferences.set("InterlinearEditor.PaintAnnotationBorders", null, null);
            }
            Boolean showAnnBackground = (Boolean)nextSettings.get("InterlinearEditor.PaintAnnotationBackground");
            if (showAnnBackground != null) {
                this.igtViewer.getViewerRenderInfo().showAnnoBackground = showAnnBackground;
                Preferences.set("InterlinearEditor.PaintAnnotationBackground", showAnnBackground, null);
            } else {
                this.igtViewer.getViewerRenderInfo().showAnnoBackground = false;
                Preferences.set("InterlinearEditor.PaintAnnotationBackground", null, null);
            }
            Color annBorderColor = (Color)nextSettings.get("InterlinearEditor.Annotation.BorderColor");
            if (annBorderColor != null) {
                this.igtViewer.getViewerRenderInfo().annoBorderColor = annBorderColor;
                Preferences.set("InterlinearEditor.Annotation.BorderColor", annBorderColor, null);
            } else {
                this.igtViewer.getViewerRenderInfo().annoBorderColor = IGTConstants.ANNO_BORDER_COLOR;
                Preferences.set("InterlinearEditor.Annotation.BorderColor", null, null);
            }
            Color annBgColor = (Color)nextSettings.get("InterlinearEditor.Annotation.BackgroundColor");
            if (annBgColor != null) {
                this.igtViewer.getViewerRenderInfo().annoBackgroundColor = annBgColor;
                Preferences.set("InterlinearEditor.Annotation.BackgroundColor", annBgColor, null);
            } else {
                this.igtViewer.getViewerRenderInfo().annoBackgroundColor = IGTConstants.ANNO_BACKGROUND_COLOR;
                Preferences.set("InterlinearEditor.Annotation.BackgroundColor", null, null);
            }
            boolean needRecalc = false;
            Integer topMargin = (Integer)nextSettings.get("InterlinearEditor.Annotation.BB.TopMargin");
            Insets bBoxInsets = this.igtViewer.getViewerRenderInfo().annBBoxInsets;
            if (topMargin != null) {
                if (topMargin != bBoxInsets.top) {
                    bBoxInsets.top = topMargin;
                    needRecalc = true;
                }
                if (topMargin != bBoxInsets.bottom) {
                    bBoxInsets.bottom = topMargin;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.Annotation.BB.TopMargin", topMargin, null);
            } else {
                if (bBoxInsets.top != 2) {
                    bBoxInsets.top = 2;
                    needRecalc = true;
                }
                if (bBoxInsets.bottom != 2) {
                    bBoxInsets.bottom = 2;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.Annotation.BB.TopMargin", null, null);
            }
            Integer leftMargin = (Integer)nextSettings.get("InterlinearEditor.Annotation.BB.LeftMargin");
            if (leftMargin != null) {
                if (leftMargin != bBoxInsets.left) {
                    bBoxInsets.left = leftMargin;
                    needRecalc = true;
                }
                if (leftMargin != bBoxInsets.right) {
                    bBoxInsets.right = leftMargin;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.Annotation.BB.LeftMargin", leftMargin, null);
            } else {
                if (bBoxInsets.left != 4) {
                    bBoxInsets.left = 4;
                    needRecalc = true;
                }
                if (bBoxInsets.right != 4) {
                    bBoxInsets.right = 4;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.Annotation.BB.LeftMargin", null, null);
            }
            Integer whiteSpaceWidth = (Integer)nextSettings.get("InterlinearEditor.WhitespaceWidth");
            if (whiteSpaceWidth != null) {
                if (this.igtViewer.getViewerRenderInfo().whitespaceWidth != whiteSpaceWidth) {
                    this.igtViewer.getViewerRenderInfo().whitespaceWidth = whiteSpaceWidth;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.WhitespaceWidth", whiteSpaceWidth, null);
            } else {
                if (this.igtViewer.getViewerRenderInfo().whitespaceWidth != 8) {
                    this.igtViewer.getViewerRenderInfo().whitespaceWidth = 8;
                    needRecalc = true;
                }
                Preferences.set("InterlinearEditor.WhitespaceWidth", null, null);
            }
            if (needRecalc) {
                this.igtViewer.recalculateAllRows(true);
            }
            this.repaint();
        }
    }

    private class AnalyzeThread
    extends Thread {
        List<AnalyzerConfig> activeConfList;
        Annotation activeAnn;
        boolean interruptInternal = false;

        public AnalyzeThread(List<AnalyzerConfig> activeConfList, Annotation activeAnn) {
            this.activeConfList = activeConfList;
            this.activeAnn = activeAnn;
        }

        @Override
        public void run() {
            if (this.activeAnn == null) {
                int curRow;
                if (InterlinearEditor.this.igtViewer.getRowCount() == 0) {
                    return;
                }
                block0: for (int row = curRow = Math.max(0, InterlinearEditor.this.igtViewer.getSelectedRow()); row < InterlinearEditor.this.igtViewer.getRowCount(); ++row) {
                    long[] timeInterval = InterlinearEditor.this.igtViewer.getTimeIntervalForRow(row);
                    for (AnalyzerConfig conf : this.activeConfList) {
                        List<Annotation> annInInterval;
                        TierImpl tier = InterlinearEditor.this.transcription.getTierWithId(conf.getSource());
                        if (tier == null || !InterlinearEditor.this.igtViewer.isTierInRow(tier.getName(), row) || (annInInterval = tier.getOverlappingAnnotations(timeInterval[0], timeInterval[1])).size() <= 0) continue;
                        InterlinearEditor.this.setActiveAnnotation(annInInterval.get(0));
                        this.activeAnn = InterlinearEditor.this.getActiveAnnotation();
                        break block0;
                    }
                }
            }
            if (this.activeAnn != null) {
                int startRow;
                TierImpl activeSourceTier = (TierImpl)this.activeAnn.getTier();
                block2: for (int row = startRow = InterlinearEditor.this.igtViewer.getRowIndexForTierAndTime(activeSourceTier.getName(), this.activeAnn.getBeginTimeBoundary()); row < InterlinearEditor.this.igtViewer.getRowCount(); ++row) {
                    long[] timeInterval = InterlinearEditor.this.igtViewer.getTimeIntervalForRow(row);
                    if (timeInterval == null) continue;
                    if (row == startRow) {
                        int annIndex;
                        List<AbstractAnnotation> annotations = activeSourceTier.getAnnotations();
                        for (int i = annIndex = annotations.indexOf(this.activeAnn); i < annotations.size(); ++i) {
                            if (this.interruptInternal) {
                                InterlinearEditor.this.manager.getTextAnalyzerContext().setAutoAnalyzeMode(false);
                                return;
                            }
                            Annotation a = annotations.get(i);
                            if (a.getBeginTimeBoundary() < timeInterval[0] || a.getEndTimeBoundary() > timeInterval[1]) continue block2;
                            Position pos = new Position(activeSourceTier.getName(), a.getBeginTimeBoundary(), a.getEndTimeBoundary());
                            if (a != this.activeAnn) {
                                InterlinearEditor.this.setActiveAnnotation(a);
                            }
                            InterlinearEditor.this.manager.getTextAnalyzerContext().analyze(pos);
                            this.waitForNext();
                        }
                        continue;
                    }
                    for (AnalyzerConfig conf : this.activeConfList) {
                        TierImpl tier = InterlinearEditor.this.transcription.getTierWithId(conf.getSource());
                        if (tier == null || !InterlinearEditor.this.igtViewer.isTierInRow(tier.getName(), row)) continue;
                        List<Annotation> annInInterval = tier.getOverlappingAnnotations(timeInterval[0], timeInterval[1]);
                        for (Annotation a : annInInterval) {
                            if (this.interruptInternal) {
                                InterlinearEditor.this.manager.getTextAnalyzerContext().setAutoAnalyzeMode(false);
                                return;
                            }
                            Position pos = new Position(conf.getSource(), a.getBeginTimeBoundary(), a.getEndTimeBoundary());
                            if (a != this.activeAnn) {
                                InterlinearEditor.this.setActiveAnnotation(a);
                            }
                            InterlinearEditor.this.manager.getTextAnalyzerContext().analyze(pos);
                            this.waitForNext();
                        }
                    }
                }
            } else if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("No active annotation to start automatic interlinearization.");
            }
            InterlinearEditor.this.manager.getTextAnalyzerContext().setAutoAnalyzeMode(false);
        }

        private void waitForNext() {
            block5: {
                try {
                    Thread.sleep(300L);
                    while (InterlinearEditor.this.manager.getTextAnalyzerContext().isPositionPending()) {
                        Thread.sleep(300L);
                        if (!ClientLogger.LOG.isLoggable(Level.FINER)) continue;
                        ClientLogger.LOG.finer("Waiting for the suggestion window to close");
                    }
                }
                catch (Throwable t) {
                    if (!ClientLogger.LOG.isLoggable(Level.INFO)) break block5;
                    ClientLogger.LOG.info("Error while waiting for the suggestions window to be closed: " + t.getMessage());
                }
            }
            if (!InterlinearEditor.this.manager.getTextAnalyzerContext().isAutoAnalyzeMode()) {
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer("Auto Analyze mode has been canceled");
                }
                this.interruptInternal = true;
            }
        }
    }
}

