/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.interlinear.edit.SuggestionComponent;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.SuggestionFlowLayout;

public class SuggestionSetSelector
extends JComponent {
    private IGTSuggestionViewerModel viewerModel;
    private IGTViewerRenderInfo viewerRenderInfo;
    private int selectorWidth;
    private int selectorHeight;
    private boolean reversedOrder = false;

    public SuggestionSetSelector(IGTSuggestionViewerModel viewerModel, IGTViewerRenderInfo viewerRenderInfo) {
        this.viewerModel = viewerModel;
        this.viewerRenderInfo = viewerRenderInfo;
    }

    public void init() {
        this.initComponents();
    }

    private void initComponents() {
        if (this.viewerModel != null) {
            this.selectorWidth = this.viewerRenderInfo.headerWidth;
            this.selectorHeight = 0;
            int margin = this.viewerModel.getRenderInfo().suggestionMargin;
            this.setLayout(new SuggestionFlowLayout(0, margin, margin));
            int rowCount = this.viewerModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                SuggestionComponent comp = new SuggestionComponent(i, this.viewerRenderInfo, this.viewerModel);
                this.add(comp);
            }
            this.validate();
        } else {
            this.selectorWidth = 150;
            this.selectorHeight = 100;
            this.setSize(this.selectorWidth, this.selectorHeight);
            this.setPreferredSize(new Dimension(this.selectorWidth, this.selectorHeight));
        }
    }

    public IGTSuggestionViewerModel getModel() {
        return this.viewerModel;
    }

    @Override
    public Dimension getPreferredSize() {
        LayoutManager layout = this.getLayout();
        if (layout instanceof SuggestionFlowLayout) {
            return ((SuggestionFlowLayout)layout).getSize();
        }
        if (this.selectorHeight == 0 || this.selectorWidth == 0) {
            return new Dimension(260, 80);
        }
        return new Dimension(this.selectorWidth, this.selectorHeight);
    }

    public int getUnitHeight() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getHeight() + this.viewerModel.getRenderInfo().suggestionMargin;
        }
        return 80;
    }

    public int getSuggestionIndexAtPoint(int x, int y) {
        Component comp = this.getComponentAt(x, y);
        if (comp instanceof SuggestionComponent) {
            SuggestionComponent sugg = (SuggestionComponent)comp;
            return sugg.getIndex();
        }
        return -1;
    }

    public SuggestionComponent getSuggestionAtVisibleIndex(int visibleIndex) {
        if (visibleIndex < 0) {
            throw new IndexOutOfBoundsException(String.format("There is no visible suggestion at that index: %d (< 0)", visibleIndex));
        }
        int index = 0;
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SuggestionComponent)) continue;
            if (index == visibleIndex) {
                return (SuggestionComponent)c;
            }
            ++index;
        }
        if (visibleIndex >= index) {
            throw new IndexOutOfBoundsException(String.format("There is no visible suggestion at that index: %d (>= %d)", visibleIndex, index));
        }
        return null;
    }

    public void workAroundTooltipBug(SuggestionComponent.MouseAndMotionListener mml) {
        Component[] children;
        for (Component c : children = this.getComponents()) {
            if (!(c instanceof SuggestionComponent)) continue;
            SuggestionComponent sugg = (SuggestionComponent)c;
            sugg.workAroundToolTipBug(mml);
        }
    }

    public void removeWorkAroundToolTipBug(SuggestionComponent.MouseAndMotionListener mml) {
        Component[] children;
        for (Component c : children = this.getComponents()) {
            if (!(c instanceof SuggestionComponent)) continue;
            SuggestionComponent sugg = (SuggestionComponent)c;
            sugg.removeWorkAroundToolTipBug(mml);
        }
    }

    public void reverseOrderOfSuggestions() {
        if (this.viewerModel != null) {
            Component[] curComponents = this.getComponents();
            this.removeAll();
            for (int i = curComponents.length - 1; i >= 0; --i) {
                this.add(curComponents[i]);
            }
            this.reversedOrder = !this.reversedOrder;
            this.revalidate();
        }
    }

    public boolean isReversedOrder() {
        return this.reversedOrder;
    }

    public int getVisibleSuggestionCount() {
        int numVisible = 0;
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SuggestionComponent)) continue;
            ++numVisible;
        }
        return numVisible;
    }

    public int convertVisibleIndexToModel(int visibleIndex) {
        if (visibleIndex < 0) {
            throw new IndexOutOfBoundsException(String.format("There is no visible suggestion at that index: %d (< 0)", visibleIndex));
        }
        int index = 0;
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SuggestionComponent)) continue;
            if (index == visibleIndex) {
                return ((SuggestionComponent)c).getIndex();
            }
            ++index;
        }
        if (visibleIndex >= index) {
            throw new IndexOutOfBoundsException(String.format("There is no visible suggestion at that index: %d (>= %d)", visibleIndex, index));
        }
        return -1;
    }

    public int convertModelIndexToVisible(int modelIndex) {
        if (modelIndex < 0 || modelIndex >= this.viewerModel.getRowCount()) {
            throw new IndexOutOfBoundsException(String.format("There is no row in the model at that index: %d (valid 0-%d)", modelIndex, this.viewerModel.getRowCount() - 1));
        }
        int index = 0;
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !(c instanceof SuggestionComponent)) continue;
            if (((SuggestionComponent)c).getIndex() == modelIndex) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

