/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.edit.InterlinearEditor;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAbstractDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class IGTNavigateAction
extends AbstractAction {
    private InterlinearEditor interEditor;
    private Direction direction;
    private boolean skipEmptyLinesWithAnnotationUpDown = true;

    public IGTNavigateAction(InterlinearEditor interEditor, String name, Direction direction) {
        super(name);
        this.interEditor = interEditor;
        this.direction = direction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Annotation activeAnn = this.interEditor.getActiveAnnotation();
        if (activeAnn == null) {
            return;
        }
        AbstractAnnotation aa = (AbstractAnnotation)activeAnn;
        int rowIndex = this.interEditor.getRowForAnnotation(aa);
        if (rowIndex == -1) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("The active annotation is not found in the viewer");
            }
            return;
        }
        IGTAbstractDataModel rowModel = this.interEditor.getModelFromRow(rowIndex);
        int currentTierIndex = rowModel.getRowIndexForTier(aa.getTier().getName());
        IGTTier curIgtTier = rowModel.getRowData(currentTierIndex);
        ArrayList<IGTAnnotation> igtAnnList = curIgtTier.getAnnotations();
        int curAnnIndex = -1;
        IGTAnnotation curIgtAnn = null;
        for (IGTAnnotation ia : igtAnnList) {
            if (ia.getAnnotation() != aa) continue;
            curIgtAnn = ia;
            break;
        }
        if (curIgtAnn != null) {
            curAnnIndex = igtAnnList.indexOf(curIgtAnn);
        }
        if ((curIgtAnn == null || curAnnIndex < 0) && ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine(String.format("The active annotation is not found in the row it is supposed to be in: %d %s", currentTierIndex, curIgtTier.getTierName()));
        }
        IGTAnnotation nextIGTAnn = null;
        switch (this.direction) {
            case LEFT: {
                nextIGTAnn = curIgtTier.getPreviousAnnotation(curIgtAnn);
                if (nextIGTAnn != null) break;
                IGTTier nextIgtTier = null;
                if (currentTierIndex > 0) {
                    for (int i = currentTierIndex - 1; i >= 0; --i) {
                        nextIgtTier = rowModel.getRowData(i);
                        if (nextIgtTier.isSpecial() || nextIgtTier.getAnnotations().isEmpty()) continue;
                        nextIGTAnn = nextIgtTier.getAnnotations().get(nextIgtTier.getAnnotations().size() - 1);
                        break;
                    }
                }
                if (nextIGTAnn != null || rowIndex <= 0) break;
                nextIGTAnn = this.findAnnotationUpStartingFromRow(rowIndex - 1);
                break;
            }
            case RIGHT: {
                nextIGTAnn = curIgtTier.getNextAnnotation(curIgtAnn);
                if (nextIGTAnn != null) break;
                IGTTier nextIgtTier = null;
                if (currentTierIndex < rowModel.getRowCount() - 1) {
                    for (int i = currentTierIndex + 1; i < rowModel.getRowCount(); ++i) {
                        nextIgtTier = rowModel.getRowData(i);
                        if (nextIgtTier.isSpecial() || nextIgtTier.getAnnotations().isEmpty()) continue;
                        nextIGTAnn = nextIgtTier.getAnnotations().get(0);
                        break;
                    }
                }
                if (nextIGTAnn != null || rowIndex >= this.interEditor.getRowCount() - 1) break;
                nextIGTAnn = this.findAnnotationDownStartingFromRow(rowIndex + 1);
                break;
            }
            case UP: {
                if (currentTierIndex > 0) {
                    IGTTier nextTier;
                    int xCoord = curIgtAnn.getRenderInfo().x;
                    for (int i = currentTierIndex - 1; i >= 0 && ((nextTier = rowModel.getRowData(i)).isSpecial() || (nextIGTAnn = this.getAnnotationAtLocation(nextTier, xCoord)) == null); --i) {
                    }
                }
                if (nextIGTAnn != null || rowIndex <= 0) break;
                nextIGTAnn = this.findAnnotationUpStartingFromRow(rowIndex - 1);
                break;
            }
            case DOWN: {
                if (currentTierIndex < rowModel.getRowCount() - 1) {
                    IGTTier nextTier;
                    int xCoord = curIgtAnn.getRenderInfo().x;
                    for (int i = currentTierIndex + 1; i < rowModel.getRowCount() && ((nextTier = rowModel.getRowData(i)).isSpecial() || (nextIGTAnn = this.getAnnotationAtLocation(nextTier, xCoord)) == null); ++i) {
                    }
                }
                if (nextIGTAnn != null || rowIndex >= this.interEditor.getRowCount() - 1) break;
                nextIGTAnn = this.findAnnotationDownStartingFromRow(rowIndex + 1);
                break;
            }
        }
        if (nextIGTAnn != null) {
            Command actCom = ELANCommandFactory.createCommand(this.interEditor.getViewerManager().getTranscription(), "Commands.ActiveAnnotation");
            actCom.execute(this.interEditor.getViewerManager(), new Object[]{nextIGTAnn.getAnnotation(), Boolean.FALSE});
        }
    }

    private IGTAnnotation getAnnotationAtLocation(IGTTier igtTier, int xCoord) {
        IGTAnnotation traversAnn = null;
        IGTAnnotation matchAnn = null;
        for (int j = 0; j < igtTier.getAnnotations().size(); ++j) {
            IGTAnnotation loopAnn = igtTier.getAnnotations().get(j);
            if (loopAnn.getRenderInfo().x + loopAnn.getRenderInfo().calcWidth < xCoord) {
                traversAnn = loopAnn;
                continue;
            }
            if (xCoord >= loopAnn.getRenderInfo().x && xCoord <= loopAnn.getRenderInfo().x + loopAnn.getRenderInfo().calcWidth) {
                matchAnn = loopAnn;
                break;
            }
            if (traversAnn != null || this.skipEmptyLinesWithAnnotationUpDown) continue;
            matchAnn = loopAnn;
            break;
        }
        if (!this.skipEmptyLinesWithAnnotationUpDown && matchAnn == null && traversAnn != null) {
            matchAnn = traversAnn;
        }
        return matchAnn;
    }

    private IGTAnnotation findAnnotationUpStartingFromRow(int rowIndex) {
        for (int i = rowIndex; i >= 0; --i) {
            IGTAbstractDataModel rowModel = this.interEditor.getModelFromRow(i);
            for (int j = rowModel.getRowCount() - 1; j >= 0; --j) {
                IGTTier igtTier = rowModel.getRowData(j);
                if (igtTier.isSpecial() || igtTier.getAnnotations().isEmpty()) continue;
                switch (this.direction) {
                    case LEFT: {
                        return igtTier.getAnnotations().get(igtTier.getAnnotations().size() - 1);
                    }
                    case UP: {
                        return igtTier.getAnnotations().get(0);
                    }
                }
            }
        }
        return null;
    }

    private IGTAnnotation findAnnotationDownStartingFromRow(int rowIndex) {
        for (int i = rowIndex; i < this.interEditor.getRowCount(); ++i) {
            IGTAbstractDataModel rowModel = this.interEditor.getModelFromRow(i);
            for (int j = 0; j < rowModel.getRowCount(); ++j) {
                IGTTier igtTier = rowModel.getRowData(j);
                if (igtTier.isSpecial() || igtTier.getAnnotations().isEmpty()) continue;
                switch (this.direction) {
                    case RIGHT: 
                    case DOWN: {
                        return igtTier.getAnnotations().get(0);
                    }
                }
            }
        }
        return null;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

