/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfigPanel;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;

public class AnalyzerAndTypeConfigPanel
extends JPanel
implements ActionListener {
    public static final String CONF_ANALYZER = "ConfigAnalyzer";
    public static final String CONF_SOURCE_TARGET = "ConfigSourceTarget";
    private InterlinearizationManager manager;
    private JButton configTypesButton;
    private JLabel numCombinationsLabel;
    private TitledBorder titledBorder;

    public AnalyzerAndTypeConfigPanel(InterlinearizationManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        EmptyBorder marginBorder = new EmptyBorder(4, 6, 4, 6);
        this.titledBorder = new TitledBorder("");
        this.setBorder(new CompoundBorder(marginBorder, this.titledBorder));
        this.configTypesButton = new JButton();
        this.configTypesButton.addActionListener(this);
        this.numCombinationsLabel = new JLabel("");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 6, 4, 6);
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        this.add((Component)this.configTypesButton, gbc);
        gbc.gridy = 2;
        this.add((Component)this.numCombinationsLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel fillPanel = new JPanel();
        fillPanel.setPreferredSize(new Dimension(1, 0));
        this.add((Component)fillPanel, gbc);
        this.updateLocale();
    }

    public void updateLocale() {
        this.titledBorder.setTitle(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        this.configTypesButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigDlg.ButtonText"));
    }

    public void configsChanged() {
        try {
            this.numCombinationsLabel.setText(String.format(ElanLocale.getString("InterlinearAnalyzerConfigPanel.NumberConfigs"), this.manager.getTextAnalyzerContext().getConfigurations().size()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.configTypesButton || CONF_SOURCE_TARGET.equals(e.getActionCommand())) {
            AnalyzerConfigPanel configPanel = new AnalyzerConfigPanel(this.manager);
            configPanel.updateLocale();
            configPanel.configsChanged();
            ClosableDialog configureDialog = new ClosableDialog();
            configureDialog.setTitle(ElanLocale.getString("InterlinearAnalyzerConfigDlg.ButtonTitle"));
            configureDialog.getContentPane().add(configPanel);
            configureDialog.setModal(true);
            WindowLocationAndSizeManager.postInit(configureDialog, "ConfigureAnalyzersAndTierTypesDlg", 400, 300);
            configureDialog.setVisible(true);
            this.configsChanged();
            WindowLocationAndSizeManager.storeLocationAndSizePreferences(configureDialog, "ConfigureAnalyzersAndTierTypesDlg");
        }
    }
}

