/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfigDialog;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerSettingsDialog;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerTypeConfig;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import nl.mpi.lexan.analyzers.TextAnalyzer;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.Information;

public class AnalyzerConfigPanel
extends JPanel
implements ComponentListener,
ActionListener,
ListSelectionListener {
    private static final int ANALYZER_NAME_COL = 0;
    private static final int SOURCE_COL = 1;
    private static final int CONFIG_COL = 4;
    private static final int TIER_SUBCONFIG_COL = 5;
    private static final String LIN_TYPE = "LinType";
    private static final String ANNOT_CONFIG = "AnalyzerConfig";
    private static final String SUB_CONFIG = "SubConfig";
    private static final Color TYPE_BG = Color.WHITE;
    private static final Color TYPE_FG = Color.BLACK;
    private InterlinearizationManager manager;
    private JButton editConfigButton;
    private JButton closeButton;
    private JButton removeConfigButton;
    private JButton configAnalyzerButton;
    private JCheckBox showTiersCB;
    private JTable configsTable;
    private DefaultTableModel configsModel;
    private JPanel configPanel;
    private AnalyzerConfigRenderer anRenderer;

    public AnalyzerConfigPanel(InterlinearizationManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.configPanel = new JPanel(new GridBagLayout());
        this.configPanel.setBorder(new TitledBorder(""));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.configPanel, gbc);
        this.configsModel = new DefaultTableModel(new String[]{ElanLocale.getString("InterlinearAnalyzerConfigPanel.Analyzer"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.SourceTier"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.TargetTier"), LIN_TYPE, ANNOT_CONFIG, SUB_CONFIG}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.configsTable = new JTable(this.configsModel);
        this.anRenderer = new AnalyzerConfigRenderer();
        this.configsTable.setDefaultRenderer(Object.class, this.anRenderer);
        this.configsTable.getTableHeader().setReorderingAllowed(false);
        this.configsTable.getSelectionModel().setSelectionMode(0);
        this.configsTable.getSelectionModel().addListSelectionListener(this);
        this.configsTable.removeColumn(this.configsTable.getColumn(LIN_TYPE));
        this.configsTable.removeColumn(this.configsTable.getColumn(ANNOT_CONFIG));
        this.configsTable.removeColumn(this.configsTable.getColumn(SUB_CONFIG));
        this.removeConfigButton = new JButton();
        this.removeConfigButton.addActionListener(this);
        this.removeConfigButton.setEnabled(false);
        this.editConfigButton = new JButton();
        this.editConfigButton.addActionListener(this);
        this.configAnalyzerButton = new JButton();
        this.configAnalyzerButton.addActionListener(this);
        this.configAnalyzerButton.setEnabled(false);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(this);
        this.showTiersCB = new JCheckBox();
        this.showTiersCB.setSelected(true);
        this.showTiersCB.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridwidth = 4;
        this.configPanel.add((Component)new JScrollPane(this.configsTable), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.configPanel.add((Component)this.showTiersCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.configPanel.add((Component)this.configAnalyzerButton, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 12;
        this.configPanel.add((Component)new JPanel(), gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 12;
        this.configPanel.add((Component)this.removeConfigButton, gbc);
        gbc.gridx = 3;
        gbc.anchor = 12;
        this.configPanel.add((Component)this.editConfigButton, gbc);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 13;
        this.configPanel.add((Component)this.closeButton, gbc);
        this.addComponentListener(this);
        TableMouseListener mouseListener = new TableMouseListener();
        this.configsTable.addMouseListener(mouseListener);
        this.updateLocale();
    }

    public void updateLocale() {
        ((TitledBorder)this.configPanel.getBorder()).setTitle(ElanLocale.getString("InterlinearAnalyzerConfigDlg.Title"));
        this.removeConfigButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.RemoveConfig"));
        this.editConfigButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.EditConfig"));
        this.configAnalyzerButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.showTiersCB.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ShowTiers"));
    }

    public void configsChanged() {
        this.configsTable.getSelectionModel().removeListSelectionListener(this);
        if (this.configsModel.getRowCount() > 0) {
            for (int i = this.configsModel.getRowCount() - 1; i >= 0; --i) {
                this.configsModel.removeRow(i);
            }
        }
        List<AnalyzerConfig> conf = this.manager.getTextAnalyzerContext().getConfigurations();
        AnalyzerConfig activeConf = this.manager.getInterEditor().getActiveConfiguration();
        int activeConfRowIndex = -1;
        for (AnalyzerConfig ac : conf) {
            String target = null;
            for (String s : ac.getDest()) {
                if (target == null) {
                    target = s;
                    continue;
                }
                target = target.concat(", ").concat(s);
            }
            this.configsModel.addRow(new Object[]{ac.getAnnotId().getName(), ac.getSource(), target, ac.isTypeMode(), ac, null});
            if (activeConf != null) continue;
            activeConf = ac;
            activeConfRowIndex = 0;
            this.manager.getInterEditor().setActiveConfiguration(ac);
        }
        this.configsTable.getSelectionModel().addListSelectionListener(this);
        if (activeConfRowIndex < 0 && conf.size() > 0) {
            activeConfRowIndex = 0;
            activeConf = conf.get(0);
            this.configsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.manager.getInterEditor().setActiveConfiguration(activeConf);
        } else {
            this.configsTable.getSelectionModel().setSelectionInterval(activeConfRowIndex, activeConfRowIndex);
        }
        this.updateRowHeights();
    }

    protected void updateConfigurations(List<AnalyzerConfig> configList, boolean typeMode) {
        if (configList == null) {
            return;
        }
        List<Information> analyzers = this.manager.getTextAnalyzerContext().listTextAnalyzersInfo();
        ArrayList<AnalyzerConfig> oldConfigs = new ArrayList<AnalyzerConfig>(this.manager.getTextAnalyzerContext().getConfigurations());
        boolean changed = false;
        for (AnalyzerConfig annotConfig : configList) {
            String annot = annotConfig.getAnnotId().getName();
            String source = annotConfig.getSource();
            List<String> targetList = annotConfig.getDest();
            Information info = null;
            if (analyzers != null) {
                for (Information li : analyzers) {
                    if (!annot.equals(li.getName())) continue;
                    info = li;
                    break;
                }
            }
            if (info == null) {
                JOptionPane.showMessageDialog(this, annot + ": " + ElanLocale.getString("InterlinearAnalyzerConfigPanel.AnalyzerNotFound") + " -" + source, ElanLocale.getString("Message.Warning"), 2);
                continue;
            }
            if (typeMode) {
                AnalyzerTypeConfig atc = new AnalyzerTypeConfig(info, source, targetList);
                this.manager.fillWithTierConfigs(info, atc, null);
                changed = this.updateConfig(oldConfigs, atc) | changed;
                continue;
            }
            AnalyzerConfig ac = new AnalyzerConfig(info, source, targetList);
            changed = this.updateConfig(oldConfigs, ac) | changed;
        }
        for (AnalyzerConfig toRemove : oldConfigs) {
            if (toRemove.isTypeMode() != typeMode) continue;
            this.manager.getTextAnalyzerContext().removeConfig(toRemove);
            changed = true;
        }
        if (changed) {
            this.configsChanged();
        }
    }

    private boolean updateConfig(ArrayList<AnalyzerConfig> oldConfigs, AnalyzerConfig config) {
        int index = oldConfigs.indexOf(config);
        if (index < 0) {
            this.manager.getTextAnalyzerContext().addConfig(config);
            return true;
        }
        oldConfigs.remove(index);
        return false;
    }

    private void updateRowHeights() {
        for (int i = 0; i < this.configsTable.getRowCount(); ++i) {
            int h = 0;
            for (int j = 0; j < this.configsTable.getColumnCount(); ++j) {
                Component c = this.configsTable.getCellRenderer(i, j).getTableCellRendererComponent(this.configsTable, this.configsTable.getValueAt(i, j), false, false, i, j);
                int ch = c.getPreferredSize().height;
                if (ch <= h) continue;
                h = ch;
            }
            this.configsTable.setRowHeight(i, h);
        }
    }

    private void configureAnalyzerAtRow(int row) {
        if (row > -1) {
            AnalyzerTypeConfig atc = (AnalyzerTypeConfig)this.configsModel.getValueAt(row, 4);
            List<AnalyzerConfig> analyzerConfigs = this.manager.getTextAnalyzerContext().getConfigurations();
            if (analyzerConfigs.contains(atc)) {
                StringBuilder questionBuilder = new StringBuilder("<html>");
                questionBuilder.append(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigurationWhat"));
                questionBuilder.append("<ul><li>");
                questionBuilder.append(ElanLocale.getString("InterlinearAnalyzerConfigPanel.GlobalSettingsInfo"));
                questionBuilder.append("</li><li>");
                questionBuilder.append(ElanLocale.getString("InterlinearAnalyzerConfigPanel.SpecificSettingsInfo"));
                questionBuilder.append(String.format(" (%s - %s)", atc.getSource(), String.valueOf(atc.getDest())));
                questionBuilder.append("</li></ul></html>");
                Object[] configOptions = new String[]{ElanLocale.getString("InterlinearAnalyzerConfigPanel.GlobalSettingsButton"), String.format(ElanLocale.getString("InterlinearAnalyzerConfigPanel.SpecificSettingsButton"), new Object[0])};
                int selOption = JOptionPane.showOptionDialog(this, questionBuilder.toString(), ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"), -1, 3, null, configOptions, configOptions[0]);
                if (selOption < 0) {
                    return;
                }
                String configId = selOption == 1 ? atc.getConfigKey() : null;
                Component cc = this.manager.getTextAnalyzerContext().getConfigurationComponent(atc.getAnnotId(), configId, false);
                if (cc == null) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearAnalyzerConfigPanel.NoConfigPanel"), ElanLocale.getString("Message.Warning"), 2);
                    return;
                }
                List<ConfigurationChangeListener> listeners = this.toListenersList(this.manager.getTextAnalyzerContext().getAnalyzerInstances(atc.getAnnotId(), atc.getConfigKey()));
                AnalyzerSettingsDialog configureDialog = new AnalyzerSettingsDialog((Dialog)this.getTopLevelAncestor(), cc, listeners);
                WindowLocationAndSizeManager.postInit(configureDialog, "AnalyzerSettingsDialog", 400, 300);
                configureDialog.setVisible(true);
                WindowLocationAndSizeManager.storeLocationAndSizePreferences(configureDialog, "AnalyzerSettingsDialog");
            }
        }
    }

    private List<ConfigurationChangeListener> toListenersList(List<TextAnalyzer> analyzers) {
        if (analyzers != null && !analyzers.isEmpty()) {
            ArrayList<ConfigurationChangeListener> changeListeners = new ArrayList<ConfigurationChangeListener>();
            for (TextAnalyzer ta : analyzers) {
                if (!(ta instanceof ConfigurationChangeListener)) continue;
                changeListeners.add((ConfigurationChangeListener)ta);
            }
            return changeListeners;
        }
        return null;
    }

    public List<String> getTargetList(String target) {
        ArrayList<String> targetList = null;
        if (target != null) {
            String[] targets;
            targetList = new ArrayList<String>();
            for (String s : targets = target.split(",")) {
                targetList.add(s);
            }
        }
        return targetList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.configAnalyzerButton) {
            int row = this.configsTable.getSelectedRow();
            if (row > -1) {
                this.configureAnalyzerAtRow(row);
            }
        } else if (e.getSource() == this.closeButton) {
            Window parWindow = SwingUtilities.getWindowAncestor(this);
            if (parWindow != null) {
                parWindow.setVisible(false);
                parWindow.dispose();
            }
        } else if (e.getSource() == this.removeConfigButton) {
            int row = this.configsTable.getSelectedRow();
            if (row > -1) {
                int selOption = JOptionPane.showConfirmDialog(this, ElanLocale.getString("InterlinearAnalyzerConfigPanel.RemoveWarning"), ElanLocale.getString("Message.Warning"), 2, 2, null);
                if (selOption != 0) {
                    return;
                }
                AnalyzerConfig ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 4);
                if (ac instanceof AnalyzerTypeConfig) {
                    this.configsModel.removeRow(row);
                    this.manager.getTextAnalyzerContext().removeConfig(ac);
                    this.repaint();
                }
            }
        } else if (e.getSource() == this.editConfigButton) {
            AnalyzerConfigDialog configDialog = null;
            Container w = this.getTopLevelAncestor();
            configDialog = w instanceof Dialog ? new AnalyzerConfigDialog((Dialog)w, this.manager) : new AnalyzerConfigDialog((Frame)w, this.manager);
            WindowLocationAndSizeManager.postInit(configDialog, "AnalyzerConfigurationsDlg", 400, 300);
            configDialog.setVisible(true);
            WindowLocationAndSizeManager.storeLocationAndSizePreferences(configDialog, "AnalyzerConfigurationsDlg");
            if (configDialog.isApplied()) {
                this.updateConfigurations(configDialog.getConfigurationMap(false), false);
                this.updateConfigurations(configDialog.getConfigurationMap(true), true);
            }
        } else if (e.getSource() == this.showTiersCB) {
            this.anRenderer.setShowTiers(this.showTiersCB.isSelected());
            this.configsChanged();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
        this.updateRowHeights();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.configsTable.getSelectedRow();
        if (row > -1 && !e.getValueIsAdjusting()) {
            AnalyzerConfig ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 5);
            if (ac == null) {
                ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 4);
            }
            if (ac != null) {
                this.manager.getInterEditor().setActiveConfiguration(ac);
            }
        }
        this.configAnalyzerButton.setEnabled(this.configsTable.getRowCount() > 0 && row > -1);
        if (row > -1) {
            AnalyzerTypeConfig atc = (AnalyzerTypeConfig)this.configsModel.getValueAt(row, 4);
            if (this.manager.getTextAnalyzerContext().isConfigurable(atc.getAnnotId())) {
                this.configAnalyzerButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.Configure") + " " + atc.getAnnotId().getName());
                this.configAnalyzerButton.setEnabled(true);
            } else {
                this.configAnalyzerButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
                this.configAnalyzerButton.setEnabled(false);
            }
        } else {
            this.configAnalyzerButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        }
        this.removeConfigButton.setEnabled(this.configsTable.getRowCount() > 0 && row > -1);
    }

    class AnalyzerConfigRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel configIconLabel;
        private JLabel mainLabel;
        private ImageIcon confIcon;
        private JTextArea tierArea;
        private boolean showTiers = true;
        private String anTooltip = ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureAnalyzer");
        private String appliesToTiers = ElanLocale.getString("InterlinearAnalyzerConfigPanel.AppliesToTiers");

        public AnalyzerConfigRenderer() {
            this.initComponents();
        }

        public boolean isShowTiers() {
            return this.showTiers;
        }

        public void setShowTiers(boolean showTiers) {
            this.showTiers = showTiers;
        }

        private void initComponents() {
            this.configIconLabel = new JLabel();
            try {
                this.confIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Configure16.gif"));
                this.configIconLabel.setIcon(this.confIcon);
            }
            catch (Exception ex) {
                this.configIconLabel.setText("Conf.");
            }
            this.mainLabel = new JLabel();
            this.tierArea = new JTextArea();
            this.tierArea.setLineWrap(true);
            this.tierArea.setWrapStyleWord(true);
            this.tierArea.setOpaque(true);
            this.tierArea.setBackground(new Color(200, 200, 200, 64));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 2, 1, 2);
            gbc.anchor = 17;
            this.add((Component)this.configIconLabel, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.mainLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)this.tierArea, gbc);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(TYPE_BG);
            this.setForeground(TYPE_FG);
            this.tierArea.setVisible(this.showTiers);
            if (column == 0) {
                this.configIconLabel.setVisible(true);
                this.tierArea.setOpaque(false);
                this.tierArea.setText("");
                this.setToolTipText(this.anTooltip);
            } else {
                this.configIconLabel.setVisible(false);
                if (this.showTiers) {
                    this.tierArea.setOpaque(true);
                    this.tierArea.setText(this.appliesToTiers);
                    Object subConfObj = AnalyzerConfigPanel.this.configsModel.getValueAt(row, 4);
                    if (subConfObj instanceof AnalyzerTypeConfig) {
                        List<AnalyzerConfig> tierConfig = ((AnalyzerTypeConfig)subConfObj).getTierConfigurations();
                        for (AnalyzerConfig atc : tierConfig) {
                            String target = null;
                            if (column == 1) {
                                target = atc.getSource();
                            } else {
                                for (String s : atc.getDest()) {
                                    if (target == null) {
                                        target = s;
                                        continue;
                                    }
                                    target = target.concat(", ").concat(s);
                                }
                            }
                            if (target == null) continue;
                            this.tierArea.append("\n" + target);
                        }
                    }
                }
            }
            this.mainLabel.setText(String.valueOf(value));
            if (table.getSelectedRow() == row) {
                this.setBackground(table.getSelectionBackground());
                this.mainLabel.setForeground(table.getSelectionForeground());
                this.tierArea.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.mainLabel.setForeground(table.getForeground());
                this.tierArea.setForeground(table.getForeground());
            }
            return this;
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == AnalyzerConfigPanel.this.configsTable && e.getClickCount() > 1) {
                int column = AnalyzerConfigPanel.this.configsTable.columnAtPoint(e.getPoint());
                int row = AnalyzerConfigPanel.this.configsTable.rowAtPoint(e.getPoint());
                if (column == 0) {
                    if (row > -1) {
                        AnalyzerConfigPanel.this.configureAnalyzerAtRow(row);
                    }
                } else {
                    AnalyzerConfigPanel.this.editConfigButton.doClick();
                }
            }
        }
    }
}

