/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Information;

public class AnalyzerSettingsPanel
extends JPanel
implements ConfigurationChangeListener {
    private TextAnalyzerHostContext hostContext;
    private JTabbedPane tabPane;
    private TitledBorder titledBorder;

    public AnalyzerSettingsPanel(TextAnalyzerHostContext hostContext) {
        this.hostContext = hostContext;
        this.initForList(hostContext.listTextAnalyzersInfo());
    }

    public AnalyzerSettingsPanel(TextAnalyzerHostContext hostContext, AnalyzerConfig forConfig) {
        this.hostContext = hostContext;
        this.initForConfig(forConfig);
    }

    public AnalyzerSettingsPanel(TextAnalyzerHostContext hostContext, Information analyzerInfo) {
        this.hostContext = hostContext;
        this.initForAnalyzer(analyzerInfo);
    }

    private void initBorder() {
        EmptyBorder marginBorder = new EmptyBorder(4, 6, 4, 6);
        this.titledBorder = new TitledBorder(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        this.setBorder(new CompoundBorder(marginBorder, this.titledBorder));
    }

    private void initForList(List<Information> analyzers) {
        if (analyzers == null || analyzers.isEmpty()) {
            return;
        }
        this.initBorder();
        this.tabPane = new JTabbedPane();
        int tabNr = 0;
        for (int i = 0; i < analyzers.size(); ++i) {
            Information analyzer = analyzers.get(i);
            Component comp = this.hostContext.getConfigurationComponent(analyzer, null, true);
            if (comp == null) continue;
            this.tabPane.addTab(analyzer.getName(), new JScrollPane(comp));
            if (tabNr < 10) {
                this.tabPane.setMnemonicAt(tabNr, 48 + (tabNr + 1) % 10);
            }
            ++tabNr;
        }
        if (tabNr > 0) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)this.tabPane, gbc);
            this.readPreferences();
        }
    }

    private void initForConfig(AnalyzerConfig forConfig) {
        if (forConfig == null) {
            return;
        }
        Component comp = this.hostContext.getConfigurationComponent(forConfig.getAnnotId(), forConfig.getConfigKey(), false);
        if (comp == null) {
            return;
        }
        this.initBorder();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(comp), gbc);
        if (comp instanceof ConfigurationChanger) {
            ((ConfigurationChanger)comp).addConfigurationChangeListener((ConfigurationChangeListener)this);
        }
    }

    private void initForAnalyzer(Information analyzerInfo) {
        if (analyzerInfo == null) {
            return;
        }
        Component comp = this.hostContext.getConfigurationComponent(analyzerInfo, null, false);
        if (comp == null) {
            return;
        }
        this.initBorder();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(comp), gbc);
        if (comp instanceof ConfigurationChanger) {
            ((ConfigurationChanger)comp).addConfigurationChangeListener((ConfigurationChangeListener)this);
        }
    }

    public void updateLocale() {
        this.titledBorder.setTitle(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
    }

    private void readPreferences() {
        int tabNr;
        String analyzer;
        if (this.tabPane != null && (analyzer = Preferences.getString("AnalyzerConfigurationPanel.CurrentAnalyzer", this.hostContext.getTranscription())) != null && (tabNr = this.tabPane.indexOfTab(analyzer)) >= 0) {
            this.tabPane.setSelectedIndex(tabNr);
        }
    }

    public void storePreferences() {
        if (this.tabPane != null && this.tabPane.getSelectedIndex() >= 0) {
            Preferences.set("AnalyzerConfigurationPanel.CurrentAnalyzer", this.tabPane.getTitleAt(this.tabPane.getSelectedIndex()), this.hostContext.getTranscription());
        }
    }

    public void configurationChanged(final ConfigurationChanger cc) {
        if (this.getTopLevelAncestor() instanceof Dialog) {
            ((Dialog)this.getTopLevelAncestor()).setVisible(false);
            ((Dialog)this.getTopLevelAncestor()).dispose();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cc.removeConfigurationChangeListener((ConfigurationChangeListener)AnalyzerSettingsPanel.this);
                }
            });
        }
    }
}

