/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.lexicon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mpi.eudico.client.annotator.interlinear.edit.lexicon.LexanEntry;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexCont;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeEvent;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;
import nl.mpi.lexiconcomponent.events.LexiconEditListener;
import nl.mpi.lexiconcomponent.events.LexiconEvent;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconFields;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;
import nl.mpi.lexiconcomponent.model.Entry;
import nl.mpi.lexiconcomponent.model.Sense;
import nl.mpi.lexiconcomponent.query.EntryFieldGetter;
import nl.mpi.lexiconcomponent.query.EntryFieldGetterFactory;
import nl.mpi.lexiconcomponent.query.SenseFieldGetter;
import nl.mpi.lexiconcomponent.query.SenseFieldGetterFactory;

public class LexanLexiconImpl
implements LexanLexicon,
LexiconEditListener {
    private LexiconImpl sourceLexicon;
    private List<LexiconChangeListener> listeners;
    static final List<String> listId = Arrays.asList(LexiconFields.ENTRY_ID.getFieldName());
    static final List<String> listIds = Arrays.asList(LexiconFields.ENTRY_ID.getFieldName(), LexiconFields.SENSE_ID.getFieldName());

    public LexanLexiconImpl(LexiconImpl sourceLexicon) {
        this.sourceLexicon = sourceLexicon;
    }

    public String getName() {
        if (this.sourceLexicon != null) {
            return this.sourceLexicon.getHeader().getName();
        }
        return "Unknown";
    }

    public List<String> getEntryFieldNames() {
        if (this.sourceLexicon != null) {
            return this.sourceLexicon.getEntryFieldNames();
        }
        return null;
    }

    private LexanEntry toLexanEntry(EntryImpl entry) {
        LexanEntry lexanEntry = new LexanEntry(LexiconFields.ENTRY_LEX_UNIT.getFieldName(), entry.getLexicalUnit());
        String id = entry.getId();
        lexanEntry.addLexItem((LexItem)new LexAtom(LexiconFields.ENTRY_ID.getFieldName(), id));
        lexanEntry.setId(id);
        if (entry.getMorphType() != null) {
            lexanEntry.addLexItem((LexItem)new LexAtom(LexiconFields.ENTRY_MORPH_TYPE.getFieldName(), entry.getMorphType()));
        }
        return lexanEntry;
    }

    private LexEntry toLexanEntry(EntryImpl entry, String fieldId) {
        LexanEntry lexanEntry = this.toLexanEntry(entry);
        if (lexanEntry.getLexItem(fieldId) == null) {
            EntryFieldGetter efg = EntryFieldGetterFactory.createGetter((String)fieldId);
            for (String fieldvalue : efg.getValues(entry)) {
                lexanEntry.addLexItem((LexItem)new LexAtom(fieldId, fieldvalue));
            }
        }
        return lexanEntry;
    }

    private List<EntryFieldGetter> createGetters(List<String> fieldIds) {
        ArrayList<EntryFieldGetter> efgs = new ArrayList<EntryFieldGetter>(fieldIds.size());
        for (String f : fieldIds) {
            efgs.add(EntryFieldGetterFactory.createGetter((String)f));
        }
        return efgs;
    }

    private LexEntry toLexanEntry(EntryImpl entry, List<String> fieldIds, List<EntryFieldGetter> efgs) {
        LexanEntry lexanEntry = this.toLexanEntry(entry);
        List<String> includeFields = fieldIds;
        ArrayList<String> includeSenseFields = null;
        ArrayList<SenseFieldGetter> sfgs = null;
        if (fieldIds == null) {
            includeFields = this.getEntryFieldNames();
            efgs = this.createGetters(includeFields);
        }
        int numSenseFields = 0;
        boolean gramCatIncluded = false;
        for (String field : includeFields) {
            if (!field.startsWith(LexiconFields.SENSE.getFieldName())) continue;
            ++numSenseFields;
            if (!field.equals(LexiconFields.SENSE_GRAM_CAT.getFieldName())) continue;
            gramCatIncluded = true;
        }
        if (numSenseFields > 1 || numSenseFields == 1 && !gramCatIncluded) {
            includeFields = new ArrayList<String>(includeFields);
            includeSenseFields = new ArrayList<String>();
            sfgs = new ArrayList<SenseFieldGetter>();
            for (int i = includeFields.size() - 1; i >= 0; --i) {
                String f = includeFields.get(i);
                if (!f.startsWith(LexiconFields.SENSE.getFieldName())) continue;
                includeSenseFields.add(f);
                sfgs.add(SenseFieldGetterFactory.createGetter((String)f.substring(LexiconFields.SENSE.getFieldName().length() + 1)));
            }
            if (!gramCatIncluded) {
                includeSenseFields.add(0, LexiconFields.SENSE_GRAM_CAT.getFieldName());
                sfgs.add(0, SenseFieldGetterFactory.createGetter((String)LexiconFields.SENSE_GRAM_CAT.getFieldName().substring(LexiconFields.SENSE.getFieldName().length() + 1)));
            }
        }
        int i = 0;
        for (EntryFieldGetter getter : efgs) {
            String fieldId = includeFields.get(i);
            ++i;
            if (includeSenseFields != null && includeSenseFields.contains(fieldId) || lexanEntry.getLexItem(fieldId) != null) continue;
            List values = getter.getValues(entry);
            for (String value : values) {
                lexanEntry.addLexItem((LexItem)new LexAtom(fieldId, value));
            }
        }
        if (includeSenseFields != null) {
            for (Sense s : entry.getSense()) {
                LexCont lexCont = new LexCont(LexiconFields.SENSE.getFieldName());
                for (int j = 0; j < includeSenseFields.size(); ++j) {
                    String fieldId = (String)includeSenseFields.get(j);
                    SenseFieldGetter getter = (SenseFieldGetter)sfgs.get(j);
                    List values = getter.getValues((SenseImpl)s);
                    for (String value : values) {
                        lexCont.addLexItem((LexItem)new LexAtom(fieldId, value));
                    }
                }
                if (lexCont.getLexItems() == null) continue;
                lexanEntry.addLexItem((LexItem)lexCont);
            }
        }
        return lexanEntry;
    }

    private List<LexEntry> getListOfMatchEntries(LexAtom queryAtom) {
        ArrayList<LexEntry> matchEntries = new ArrayList<LexEntry>();
        EntryFieldGetter getter = EntryFieldGetterFactory.createGetter((String)queryAtom.getType());
        for (Entry sourceEntry : this.sourceLexicon.getEntries()) {
            EntryImpl entryImpl = (EntryImpl)sourceEntry;
            List values = getter.getValues(entryImpl);
            for (String value : values) {
                if (queryAtom.getLexValue() != null && !queryAtom.getLexValue().equals(value)) continue;
                matchEntries.add(this.toLexanEntry(entryImpl, queryAtom.getType()));
            }
        }
        return matchEntries;
    }

    private List<LexEntry> getListOfMatchEntries(LexAtom queryAtom, List<String> fieldsToInclude) {
        ArrayList<LexEntry> matchEntries = new ArrayList<LexEntry>();
        List<String> allFields = fieldsToInclude;
        if (!fieldsToInclude.contains(queryAtom.getType())) {
            allFields = new ArrayList<String>(fieldsToInclude.size() + 1);
            allFields.add(queryAtom.getType());
            allFields.addAll(fieldsToInclude);
        }
        EntryFieldGetter getter = EntryFieldGetterFactory.createGetter((String)queryAtom.getType());
        List<EntryFieldGetter> efgs = this.createGetters(allFields);
        for (Entry sourceEntry : this.sourceLexicon.getEntries()) {
            EntryImpl entryImpl = (EntryImpl)sourceEntry;
            List values = getter.getValues(entryImpl);
            for (String value : values) {
                if (queryAtom.getLexValue() != null && !queryAtom.getLexValue().equals(value)) continue;
                matchEntries.add(this.toLexanEntry(entryImpl, allFields, efgs));
            }
        }
        return matchEntries;
    }

    public List<LexEntry> getEntries(LexAtom queryItem) {
        if (queryItem == null) {
            return null;
        }
        if (queryItem.getType() == null) {
            return null;
        }
        return this.getListOfMatchEntries(queryItem);
    }

    public List<LexEntry> getEntries(LexAtom queryItem, List<String> fieldsToInclude) {
        if (queryItem == null) {
            return null;
        }
        if (queryItem.getType() == null) {
            return null;
        }
        return this.getListOfMatchEntries(queryItem, fieldsToInclude);
    }

    public LexEntry getEntryById(String id) {
        EntryImpl sourceEntry = this.sourceLexicon.getEntryWithId(id);
        if (sourceEntry != null) {
            return this.toLexanEntry(sourceEntry);
        }
        return null;
    }

    public LexEntry getEntryById(String id, List<String> includeFields) {
        EntryImpl sourceEntry = this.sourceLexicon.getEntryWithId(id);
        if (sourceEntry != null) {
            return this.toLexanEntry(sourceEntry, includeFields, this.createGetters(includeFields));
        }
        return null;
    }

    public void addLexiconChangeListener(LexiconChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<LexiconChangeListener>(2);
            }
            this.listeners.add(listener);
        }
    }

    public void removeLexiconChangeListener(LexiconChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyListeners(LexiconChangeEvent event) {
        if (event != null && this.listeners != null) {
            for (LexiconChangeListener l : this.listeners) {
                l.lexiconChanged(event);
            }
        }
    }

    public void lexiconEdited(LexiconEvent<LexiconImpl> event) {
        if (event.getSource() == this.sourceLexicon && event.getEditObject() == this.sourceLexicon) {
            LexiconChangeEvent.LexiconChangeType changeType = this.convertChangeType(event.getType());
            LexiconChangeEvent newEvent = new LexiconChangeEvent((Object)this, (Object)this, changeType);
            this.notifyListeners(newEvent);
        }
    }

    public void lexiconEntryEdited(LexiconEvent<EntryImpl> event) {
        if (event.getSource() == this.sourceLexicon) {
            LexiconChangeEvent.LexiconChangeType changeType = this.convertChangeType(event.getType());
            EntryImpl editObj = (EntryImpl)event.getEditObject();
            if (event.getType() == LexiconEvent.LexiconEventType.REMOVE) {
                LexEntry le = this.toLexanEntry(editObj, null, null);
                if (le != null) {
                    this.notifyListeners(new LexiconChangeEvent((Object)this, (Object)le, changeType));
                }
            } else {
                LexEntry le = this.toLexanEntry(editObj, null, null);
                if (le != null) {
                    this.notifyListeners(new LexiconChangeEvent((Object)this, (Object)le, changeType));
                }
            }
        }
    }

    public void lexiconSenseEdited(LexiconEvent<SenseImpl> event) {
        EntryImpl entryObj;
        if (event.getSource() == this.sourceLexicon) {
            LexEntry le;
            LexiconChangeEvent.LexiconChangeType changeType = this.convertChangeType(event.getType());
            SenseImpl editObj = (SenseImpl)event.getEditObject();
            EntryImpl entryObj2 = editObj.getEntry();
            if (entryObj2 != null && (le = this.toLexanEntry(entryObj2, null, null)) != null) {
                this.notifyListeners(new LexiconChangeEvent((Object)this, (Object)le, changeType));
            }
        } else if (event.getSource() instanceof EntryImpl && (entryObj = (EntryImpl)event.getSource()).getLexicon() == this.sourceLexicon) {
            LexiconChangeEvent.LexiconChangeType changeType = this.convertChangeType(event.getType());
            SenseImpl editObj = (SenseImpl)event.getEditObject();
            if (event.getType() == LexiconEvent.LexiconEventType.REMOVE) {
                LexEntry le = this.toLexanEntry(entryObj, listIds, this.createGetters(listIds));
                if (le != null) {
                    this.notifyListeners(new LexiconChangeEvent((Object)this, (Object)le, changeType));
                }
            } else {
                LexAtom la = new LexAtom(LexiconFields.ENTRY_LEX_UNIT.getFieldName(), entryObj.getLexicalUnit());
                List<LexEntry> lle = this.getEntries(la, listIds);
                if (lle != null) {
                    for (LexEntry le : lle) {
                        LexAtom atom;
                        if (!le.getId().equals(editObj.getId()) || (atom = (LexAtom)le.getLexItem(LexiconFields.SENSE_ID.getFieldName())) == null || !atom.getLexValue().equals(editObj.getId())) continue;
                        LexiconChangeEvent newEvent = new LexiconChangeEvent((Object)this, (Object)le, changeType);
                        this.notifyListeners(newEvent);
                    }
                }
            }
        }
    }

    protected LexiconChangeEvent.LexiconChangeType convertChangeType(LexiconEvent.LexiconEventType eventType) {
        LexiconChangeEvent.LexiconChangeType changeType = LexiconChangeEvent.LexiconChangeType.CHANGE;
        switch (eventType) {
            case ADD: {
                changeType = LexiconChangeEvent.LexiconChangeType.ADD;
                break;
            }
            case CHANGE: {
                changeType = LexiconChangeEvent.LexiconChangeType.CHANGE;
                break;
            }
            case ORDER_CHANGE: {
                changeType = LexiconChangeEvent.LexiconChangeType.CHANGE;
                break;
            }
            case REMOVE: {
                changeType = LexiconChangeEvent.LexiconChangeType.DELETE;
                break;
            }
            case SORT_ORDER_CHANGE: {
                changeType = LexiconChangeEvent.LexiconChangeType.CHANGE;
                break;
            }
        }
        return changeType;
    }
}

