/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelListener;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTRowHeader;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTBlockRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTRowHeaderRenderInfo;

public abstract class IGTAbstractDataModel
implements IGTDataModel {
    protected List<IGTTier> rowData = new ArrayList<IGTTier>();
    protected IGTRowHeader rowHeader = new IGTRowHeader();
    protected IGTRowHeaderRenderInfo rowHeaderRenderInfo = new IGTRowHeaderRenderInfo();
    protected IGTBlockRenderInfo renderInfo = new IGTBlockRenderInfo();
    protected List<IGTDataModelListener> listeners = new ArrayList<IGTDataModelListener>(4);

    @Override
    public int getRowCount() {
        return this.rowData.size();
    }

    @Override
    public int getColumnCountForRow(int row) {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index is less than zero: " + row);
        }
        if (row > this.rowData.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("Row index is greater than model size: " + row + " > " + this.rowData.size());
        }
        IGTTier igtTier = this.rowData.get(row);
        return igtTier.getAnnotations().size();
    }

    @Override
    public void insertRow(IGTTier data, int insertionRow) throws ArrayIndexOutOfBoundsException {
        if (insertionRow < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index is less than zero: " + insertionRow);
        }
        if (insertionRow > this.rowData.size()) {
            throw new ArrayIndexOutOfBoundsException("Row index is greater than model size: " + insertionRow);
        }
        IGTTier igtTier = data;
        if (insertionRow == this.rowData.size()) {
            this.rowData.add(igtTier);
            this.rowHeader.addHeader(igtTier.getTierName());
        } else {
            this.rowData.add(insertionRow, igtTier);
            this.rowHeader.addHeader(insertionRow, igtTier.getTierName());
        }
        this.notifyRowAdded();
    }

    @Override
    public void addRow(IGTTier igtTier) {
        if (igtTier != null) {
            this.rowData.add(igtTier);
            this.rowHeader.addHeader(igtTier.getTierName());
            this.notifyRowAdded();
        }
    }

    @Override
    public IGTTier getRootRow() {
        for (int i = 0; i < this.rowData.size(); ++i) {
            IGTTier t = this.rowData.get(i);
            if (t.getType() != IGTTierType.ROOT) continue;
            return t;
        }
        return this.rowData.get(0);
    }

    @Override
    public abstract long getBeginTime();

    @Override
    public abstract long getEndTime();

    @Override
    public List<IGTTier> getFirstLevelSubdivisionRows() {
        ArrayList<IGTTier> firstLevels = new ArrayList<IGTTier>(5);
        for (int i = 0; i < this.rowData.size(); ++i) {
            IGTTier t = this.rowData.get(i);
            if (t.getType() != IGTTierType.WORD_LEVEL_ROOT) continue;
            firstLevels.add(t);
        }
        return firstLevels;
    }

    @Override
    public IGTTier getRowData(int row) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index is less than zero: " + row);
        }
        if (row > this.rowData.size()) {
            throw new ArrayIndexOutOfBoundsException("Row index is greater than model size: " + row);
        }
        return this.rowData.get(row);
    }

    @Override
    public IGTTier getRowDataForTier(String tierName) {
        int index = this.rowHeader.getIndexForLabel(tierName);
        if (index > -1 && index < this.rowData.size()) {
            return this.rowData.get(index);
        }
        return null;
    }

    @Override
    public int getRowIndexForTier(String tierName) {
        if (tierName == null) {
            return -1;
        }
        return this.rowHeader.getIndexForLabel(tierName);
    }

    @Override
    public String getTierNameForIndex(int index) {
        try {
            return this.rowHeader.getLabelForIndex(index);
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    @Override
    public String getShortTierNameForIndex(int index) {
        try {
            return this.rowHeader.getHeaderText(index);
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    @Override
    public void setShortTierNameForIndex(int row, String shortName) {
        try {
            this.rowHeader.setHeaderText(row, shortName);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void setSpecialTierVisibility(IGTTierType specialTier, boolean visible) {
    }

    @Override
    public boolean getSpecialTierVisibility(IGTTierType specialTier) {
        return true;
    }

    @Override
    public IGTTierType getTypeForRow(int row) {
        try {
            IGTTier t = this.rowData.get(row);
            return t.getType();
        }
        catch (IndexOutOfBoundsException iobe) {
            return IGTTierType.NONE;
        }
    }

    @Override
    public void setTypeForRow(int row, IGTTierType type) {
        try {
            IGTTier t = this.rowData.get(row);
            t.setType(type);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public Object getValueAtRow(int row, int column) {
        try {
            IGTTier t = this.rowData.get(row);
            return t.getAnnotations().get(column);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public IGTBlockRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    @Override
    public IGTRowHeaderRenderInfo getRowHeaderRenderInfo() {
        return this.rowHeaderRenderInfo;
    }

    @Override
    public synchronized void addIGTDataModelListener(IGTDataModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeIGTDataModelListener(IGTDataModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void postEvent(IGTDataModelEvent event) {
        if (event != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                this.listeners.get(i).dataModelChanged(event);
            }
        }
    }

    protected void notifyRowAdded() {
        IGTDataModelEvent event = new IGTDataModelEvent(this);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).dataModelChanged(event);
        }
    }

    public List<String> getVisibleTierOrder() {
        ArrayList<String> tierNames = new ArrayList<String>();
        for (IGTTier igtt : this.rowData) {
            if (igtt.isSpecial()) continue;
            tierNames.add(igtt.getTierName());
        }
        return tierNames;
    }
}

