/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTTierRenderInfo;
import mpi.eudico.client.annotator.util.ClientLogger;

public class IGTTier {
    private String tierName;
    private ArrayList<IGTAnnotation> annotations;
    private IGTTier parentTier;
    private List<IGTTier> childTiers;
    private IGTTierType type;
    private IGTTierRenderInfo renderInfo;
    private boolean isInWordLevelBlock = false;

    public IGTTier(String tierName, IGTTierType type) {
        this(tierName, type, false);
        if (type != IGTTierType.ROOT && type != IGTTierType.FIRST_LEVEL_ASSOCIATION && !type.isSpecial()) {
            throw new IllegalArgumentException("This tier has the wrong type to be outside the word level blocks");
        }
    }

    public IGTTier(String tierName, IGTTierType type, boolean inWLBlock) {
        this.tierName = tierName;
        this.type = type;
        this.isInWordLevelBlock = inWLBlock;
        this.renderInfo = new IGTTierRenderInfo();
        this.annotations = new ArrayList();
        this.parentTier = null;
        this.childTiers = new ArrayList<IGTTier>(8);
    }

    public String getTierName() {
        return this.tierName;
    }

    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    public ArrayList<IGTAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ArrayList<IGTAnnotation> annotations) {
        if (annotations != null) {
            this.annotations = annotations;
        }
    }

    public IGTTierType getType() {
        return this.type;
    }

    public void setType(IGTTierType type) {
        this.type = type;
    }

    public boolean isSpecial() {
        return this.type.isSpecial();
    }

    public void addAnnotation(IGTAnnotation ann) {
        if (ann != null) {
            this.annotations.add(ann);
            ann.setIGTTier(this);
        }
    }

    public void insertAnnotation(IGTAnnotation ann, int index) throws ArrayIndexOutOfBoundsException {
        if (ann != null) {
            this.annotations.add(index, ann);
            ann.setIGTTier(this);
        }
    }

    public void removeAnnotation(IGTAnnotation ann) {
        if (ann != null) {
            this.annotations.remove(ann);
            ann.setIGTTier(null);
        }
    }

    public IGTAnnotation getNextAnnotation(IGTAnnotation ann) {
        if (ann == null) {
            return null;
        }
        int index = this.annotations.indexOf(ann);
        if (index > -1 && index < this.annotations.size() - 1) {
            return this.annotations.get(index + 1);
        }
        return null;
    }

    public IGTAnnotation getPreviousAnnotation(IGTAnnotation ann) {
        if (ann == null) {
            return null;
        }
        int index = this.annotations.indexOf(ann);
        if (index > 0) {
            return this.annotations.get(index - 1);
        }
        return null;
    }

    public IGTTierRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public IGTTier getParentTier() {
        return this.parentTier;
    }

    public final IGTTier getRootTier() {
        if (this.parentTier == null) {
            return this;
        }
        return this.parentTier.getRootTier();
    }

    public void setParentTier(IGTTier parentTier) {
        this.parentTier = parentTier;
    }

    public List<IGTTier> getChildTiers() {
        return this.childTiers;
    }

    public List<IGTTier> getDescendantTiers() {
        ArrayList<IGTTier> descendants = new ArrayList<IGTTier>();
        this.addDescendantsToList(descendants);
        return descendants;
    }

    public int getLevel() {
        if (this.isSpecial()) {
            return 0;
        }
        if (this.getParentTier() == null) {
            return 0;
        }
        int level = 0;
        IGTTier t = this;
        while (t.getParentTier() != null) {
            ++level;
            t = t.getParentTier();
        }
        return level;
    }

    private void addDescendantsToList(ArrayList<IGTTier> descendants) {
        if (descendants == null) {
            return;
        }
        for (int i = 0; i < this.childTiers.size(); ++i) {
            IGTTier t = this.childTiers.get(i);
            descendants.add(t);
            t.addDescendantsToList(descendants);
        }
    }

    public void addChildTier(IGTTier childTier) {
        if (childTier != null && !this.childTiers.contains(childTier)) {
            this.childTiers.add(childTier);
        }
    }

    public void removeChildTier(IGTTier childTier) {
        if (childTier != null && this.childTiers.contains(childTier)) {
            this.childTiers.remove(childTier);
        }
    }

    public boolean hasAncestor(IGTTier otherTier) {
        if (otherTier == null || otherTier == this) {
            return false;
        }
        for (IGTTier curParent = this.parentTier; curParent != null; curParent = curParent.getParentTier()) {
            if (curParent != otherTier) continue;
            return true;
        }
        return false;
    }

    public boolean isInWordLevelBlock() {
        return this.isInWordLevelBlock;
    }

    public void setInWordLevelBlock(boolean inBlock) {
        switch (this.type) {
            case ROOT: 
            case PHRASE_LEVEL_ROOT: 
            case FIRST_LEVEL_ASSOCIATION: 
            case SILENCE_DURATION: 
            case SPEAKER_LABEL: 
            case TIME_CODE: {
                if (inBlock && this.isInWordLevelBlock != inBlock) {
                    ClientLogger.LOG.warning(String.format("setInWordLevelBlock(true) for tier type %s", new Object[]{this.type}));
                }
                this.isInWordLevelBlock = inBlock;
                break;
            }
            case NONE: 
            case SUBDIVISION: 
            case WORD_LEVEL_ROOT: {
                if (!inBlock && this.isInWordLevelBlock != inBlock) {
                    ClientLogger.LOG.warning(String.format("setInWordLevelBlock(true) for tier type %s", new Object[]{this.type}));
                }
                this.isInWordLevelBlock = inBlock;
                break;
            }
            case ASSOCIATION: 
            case DEEPER_LEVEL_ASSOCIATION: {
                this.isInWordLevelBlock = inBlock;
            }
        }
    }

    public boolean isAtY(int y) {
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine(String.format("isAtY %d? numLines=%d isInWordLevelBlock=%b", y, this.renderInfo.getNumLines(), this.isInWordLevelBlock));
        }
        if (this.isInWordLevelBlock) {
            if (this.renderInfo.getYPositions() == null || this.renderInfo.getYPositions().size() <= 1) {
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(String.format("isAtY %d? .y=%d .height=%d => %b", y, this.renderInfo.y, this.renderInfo.height, y >= this.renderInfo.y && y <= this.renderInfo.y + this.renderInfo.height));
                }
                return y >= this.renderInfo.y && y <= this.renderInfo.y + this.renderInfo.height;
            }
            List<Integer> yPos = this.renderInfo.getYPositions();
            if (yPos != null) {
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(String.format("isAtY %d? %d Y positions", y, yPos.size()));
                }
                for (int i = 0; i < yPos.size(); ++i) {
                    int nextY = yPos.get(i);
                    if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                        ClientLogger.LOG.fine(String.format("isAtY %d? nextY=%d .height=%d => %b", y, nextY, this.renderInfo.height, y >= nextY && y <= nextY + this.renderInfo.height));
                    }
                    if (y >= nextY && y <= nextY + this.renderInfo.height) {
                        return true;
                    }
                    if (nextY <= y) continue;
                    return false;
                }
            }
        } else {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("isAtY %d? not inWLB. .y=%d .height=%d => %b", y, this.renderInfo.y, this.renderInfo.height, y >= this.renderInfo.y && y <= this.renderInfo.y + this.renderInfo.height));
            }
            return y >= this.renderInfo.y && y <= this.renderInfo.y + this.renderInfo.renderHeight;
        }
        return false;
    }

    public int getY(int lessThanY) {
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine(String.format("getY %d? numLines=%d isInWordLevelBlock=%b", lessThanY, this.renderInfo.getNumLines(), this.isInWordLevelBlock));
        }
        if (this.isInWordLevelBlock) {
            if (this.renderInfo.getYPositions() == null || this.renderInfo.getYPositions().size() <= 1) {
                return this.renderInfo.y;
            }
            List<Integer> yPos = this.renderInfo.getYPositions();
            if (yPos != null) {
                int prevY = this.renderInfo.y;
                for (int i = 0; i < yPos.size(); ++i) {
                    int nextY = yPos.get(i);
                    if (nextY >= lessThanY) {
                        return prevY;
                    }
                    prevY = nextY;
                }
                return prevY;
            }
        } else {
            return this.renderInfo.y;
        }
        return 0;
    }

    public IGTAnnotation getAnnotationAtPoint(Point p) {
        int size = this.annotations.size();
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("IGTTier.getAnnotationAtPoint(%s) isInWordLevelBlock=%b %s", String.valueOf(p), this.isInWordLevelBlock, String.valueOf(this.renderInfo)));
        }
        if (!this.isInWordLevelBlock) {
            if (size > 0) {
                IGTAnnotation igtAnn = this.annotations.get(0);
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer(String.format("IGTTier.getAnnotationAtPoint(%s) !isInWordLevelBlock, 1st annotation: %s", String.valueOf(p), String.valueOf(igtAnn.getRenderInfo())));
                }
                if (igtAnn.getRenderInfo().isPointInRenderArea(p)) {
                    ClientLogger.LOG.finer("IGTTier.getAnnotationAtPoint() found!");
                    return igtAnn;
                }
                ClientLogger.LOG.finer("IGTTier.getAnnotationAtPoint() not isPointInRenderArea()");
            }
        } else {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("IGTTier.getAnnotationAtPoint() isInWordLevelBlock=true %s", String.valueOf(this.getRenderInfo())));
            }
            int i = 0;
            List<Integer> wrapIndices = this.getRenderInfo().getWrapIndices();
            if (wrapIndices != null && !wrapIndices.isEmpty()) {
                List<Integer> yPositions = this.getRenderInfo().getYPositions();
                int wrapIndex = 1;
                int yPos = yPositions.get(wrapIndex);
                while (p.y > yPos && ++wrapIndex < yPositions.size()) {
                    yPos = yPositions.get(wrapIndex);
                }
                if (wrapIndex > 1) {
                    i = wrapIndices.get(wrapIndex - 2);
                }
            }
            while (i < size) {
                IGTAnnotation igtAnn = this.annotations.get(i);
                IGTNodeRenderInfo renderInfo2 = igtAnn.getRenderInfo();
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer(String.format("IGTTier.getAnnotationAtPoint(%s) in %s?", String.valueOf(p), String.valueOf(renderInfo2)));
                }
                if (renderInfo2.y > p.y) break;
                if (renderInfo2.isPointInRenderArea(p)) {
                    ClientLogger.LOG.finer("IGTTier.getAnnotationAtPoint() found!\n");
                    return igtAnn;
                }
                ++i;
            }
        }
        ClientLogger.LOG.finer("IGTTier.getAnnotationAtPoint() NULL...\n");
        return null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("IGTTier:[");
        s.append(" tierName=");
        s.append(String.valueOf(this.tierName));
        s.append(" type=");
        s.append(String.valueOf((Object)this.type));
        s.append(" isInWordLevelBlock=");
        s.append(String.valueOf(this.isInWordLevelBlock));
        s.append(String.valueOf(this.renderInfo));
        s.append("]");
        return s.toString();
    }
}

