/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.ModePanel;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SelectionButtonsPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.FontSizePanel;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.layout.VideoLayoutPanel;
import mpi.eudico.client.annotator.turnsandscenemode.TaSViewerControlPanel;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.turnsandscenemode.commands.CancelEditAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSActivateCellAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSContinuousPlayAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSDeleteAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSMergeAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSModifyTimeAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSPostCutAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSPostPasteAction;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSSplitAction;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.server.corpora.clom.Transcription;

public class TurnsAndSceneManager
implements ModeLayoutManager {
    private ElanLayoutManager layoutManager;
    private Container container;
    private ViewerManager2 viewerManager;
    private Transcription transcription;
    private JScrollPane signalViewerScrollPane;
    private SignalViewer signalViewer;
    private TurnsAndSceneViewer turnsAndSceneViewer;
    private TaSViewerControlPanel tasControlPanel;
    private JSplitPane vertSplitPane;
    private JSplitPane horiSplitPane;
    private JPanel videoAndControlPanel;
    private VideoLayoutPanel videoPanel;
    private JPanel controllerPanel;
    private JPanel viewerPanel;
    private JCheckBox continuousPlayCB;
    private TaSContinuousPlayAction continuousPlayAction;
    private ElanMediaPlayerController mediaPlayerController;
    private FontSizePanel fontSizePanel;
    private boolean initialized = false;
    private final int MIN_SIGNAL_HEIGHT = 100;
    final String prefKeyFontSize = "TurnsAndSceneMode.View.FontSize";
    final String prefKeyVertSplitLoc = "TurnsAndSceneMode.VertSplit.Location";
    final String prefKeyHoriSplitLoc = "TurnsAndSceneMode.HoriSplit.Location";
    final String prefKeyContinuousPlay = "TurnsAndSceneMode.ContinuousPlayMode";
    public static final List<String> REDEFINED_ACTIONS = new ArrayList<String>();

    public TurnsAndSceneManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.transcription = viewerManager.getTranscription();
        if (viewerManager.getMasterMediaPlayer() != null) {
            viewerManager.getMasterMediaPlayer().setMediaTime(0L);
        }
        this.container = this.layoutManager.getContainer();
    }

    @Override
    public void add(Object object) {
        if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof TurnsAndSceneViewer) {
            this.setSingleLayerViewer((TurnsAndSceneViewer)object);
        } else if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        } else if (object instanceof FontSizePanel) {
            this.setFontSizePanel((FontSizePanel)object);
        }
    }

    @Override
    public void remove(Object object) {
    }

    private void setSignalViewer(SignalViewer sigViewer) {
        this.signalViewer = sigViewer;
        this.signalViewer.setMediaTime(0L);
        this.signalViewer.setSelection(0L, 0L);
        this.signalViewerScrollPane = new JScrollPane(this.signalViewer, 21, 32);
        this.signalViewerScrollPane.setPreferredSize(new Dimension(100, 100));
        this.signalViewerScrollPane.setMinimumSize(this.signalViewerScrollPane.getPreferredSize());
        if (this.initialized) {
            this.doLayout();
        }
    }

    private void setSingleLayerViewer(TurnsAndSceneViewer slViewer) {
        this.turnsAndSceneViewer = slViewer;
        this.tasControlPanel = new TaSViewerControlPanel(slViewer);
        this.viewerManager.connectListener(this.tasControlPanel);
        this.viewerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.viewerPanel.add((Component)this.tasControlPanel, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 3, 3, 3);
        this.viewerPanel.add((Component)this.turnsAndSceneViewer, gbc);
        if (this.continuousPlayAction != null) {
            this.continuousPlayAction.setViewer(this.turnsAndSceneViewer);
        }
        if (this.initialized) {
            this.doLayout();
        }
    }

    private void setFontSizePanel(FontSizePanel fontSizePane) {
        this.fontSizePanel = fontSizePane;
        if (this.viewerPanel != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(3, 3, 3, 3);
            this.viewerPanel.add((Component)this.fontSizePanel, gbc);
        }
    }

    private void setMediaPlayer() {
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        PlayerLayoutModel playerModelToAdd = null;
        for (PlayerLayoutModel plModel : visualPlayers) {
            if (playerModelToAdd == null) {
                playerModelToAdd = plModel;
            }
            if (plModel == playerModelToAdd) continue;
            this.viewerManager.destroyMediaPlayer(plModel.player);
            this.container.remove(plModel.visualComponent);
        }
        if (playerModelToAdd != null && this.videoPanel == null) {
            this.videoPanel = new VideoLayoutPanel();
            this.videoPanel.setPlayerLayoutModel(playerModelToAdd);
            if (this.videoAndControlPanel == null) {
                this.videoAndControlPanel = new JPanel(new GridBagLayout());
            }
            GridBagConstraints gbc = new GridBagConstraints();
            int margin = 3;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.01;
            gbc.insets = new Insets(margin, margin, 0, margin);
            this.videoAndControlPanel.add((Component)this.videoPanel, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            JPanel filler = new JPanel();
            filler.setPreferredSize(new Dimension(2, 2));
            this.videoAndControlPanel.add((Component)filler, gbc);
            this.videoAndControlPanel.addComponentListener(this.videoPanel);
        }
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerControl) {
        this.mediaPlayerController = mediaPlayerControl;
        if (this.videoAndControlPanel == null) {
            this.videoAndControlPanel = new JPanel(new GridBagLayout());
        }
        int sliderHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
        this.mediaPlayerController.getSliderPanel().setPreferredSize(new Dimension(200, sliderHeight));
        this.mediaPlayerController.getSliderPanel().setMinimumSize(new Dimension(200, sliderHeight));
        this.mediaPlayerController.getAnnotationDensityViewer().setPreferredSize(new Dimension(200, this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height));
        this.mediaPlayerController.getAnnotationDensityViewer().setMinimumSize(new Dimension(200, this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height));
        this.continuousPlayAction = new TaSContinuousPlayAction(this.turnsAndSceneViewer);
        this.continuousPlayAction.putValue("Name", ElanLocale.getString("CommandActions.ContinuousPlaybackMode"));
        this.continuousPlayAction.putValue("ShortDescription", ElanLocale.getString("CommandActions.ContinuousPlaybackModeToolTip"));
        this.continuousPlayCB = new JCheckBox(this.continuousPlayAction);
        int margin = 3;
        this.controllerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 4;
        gbc.insets = new Insets(margin, margin, 0, margin);
        this.controllerPanel.add((Component)this.mediaPlayerController.getSliderPanel(), gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(-sliderHeight - 3, margin, margin, margin);
        this.controllerPanel.add((Component)this.mediaPlayerController.getAnnotationDensityViewer(), gbc);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        JPanel fill1 = new JPanel();
        fill1.setPreferredSize(new Dimension(2, 10));
        fill1.setMinimumSize(new Dimension(2, 10));
        this.controllerPanel.add((Component)fill1, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, margin, margin, margin);
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.controllerPanel.add((Component)this.mediaPlayerController.getTimePanel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        this.controllerPanel.add((Component)this.mediaPlayerController.getPlayButtonsPanel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        SelectionButtonsPanel selectionBP = this.mediaPlayerController.getSelectionButtonsPanel();
        selectionBP.setSeparateLeftRightMode(true);
        this.controllerPanel.add((Component)selectionBP, gbc);
        gbc.gridx = 2;
        gbc.anchor = 13;
        ((ModePanel)this.mediaPlayerController.getModePanel()).setModeVisible("CommandActions.SelectionMode", false);
        this.controllerPanel.add((Component)this.mediaPlayerController.getModePanel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.controllerPanel.add((Component)this.continuousPlayCB, gbc);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        JPanel fill2 = new JPanel();
        fill2.setPreferredSize(new Dimension(2, 10));
        fill2.setMinimumSize(new Dimension(2, 10));
        this.controllerPanel.add((Component)fill2, gbc);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridy = 1;
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(margin, margin, 0, margin);
        gbc.anchor = 11;
        this.videoAndControlPanel.add((Component)this.controllerPanel, gbc2);
    }

    private void completeInitialization() {
        this.setMediaPlayer();
        this.container.add(this.vertSplitPane);
        if (this.signalViewerScrollPane != null) {
            this.vertSplitPane.setBottomComponent(this.signalViewerScrollPane);
        }
        if (this.videoPanel == null) {
            this.vertSplitPane.setTopComponent(this.viewerPanel);
            this.container.add(this.videoAndControlPanel);
        } else {
            this.horiSplitPane = new JSplitPane(1);
            this.horiSplitPane.setResizeWeight(0.0);
            this.vertSplitPane.setTopComponent(this.horiSplitPane);
            this.horiSplitPane.setOneTouchExpandable(true);
            this.horiSplitPane.setTopComponent(this.videoAndControlPanel);
            this.horiSplitPane.setBottomComponent(this.viewerPanel);
        }
        this.vertSplitPane.revalidate();
    }

    @Override
    public void doLayout() {
        if (!this.initialized) {
            this.completeInitialization();
            this.initialized = true;
        }
        int containerMargin = 3;
        if (this.videoPanel != null) {
            this.vertSplitPane.setBounds(containerMargin, containerMargin, this.container.getWidth() - 2 * containerMargin, this.container.getHeight() - 2 * containerMargin);
            this.vertSplitPane.revalidate();
        } else {
            int videoAndControlPanelHeight = this.videoAndControlPanel.getPreferredSize().height;
            this.vertSplitPane.setBounds(containerMargin, containerMargin, this.container.getWidth() - 2 * containerMargin, this.container.getHeight() - 2 * containerMargin - videoAndControlPanelHeight);
            this.videoAndControlPanel.setBounds(containerMargin, this.container.getHeight() - containerMargin - videoAndControlPanelHeight, this.container.getWidth() - 2 * containerMargin, videoAndControlPanelHeight);
            this.videoAndControlPanel.revalidate();
        }
    }

    @Override
    public void updateLocale() {
        if (this.fontSizePanel != null) {
            this.fontSizePanel.updateLocale();
        }
        if (this.continuousPlayAction != null) {
            this.continuousPlayAction.putValue("Name", ElanLocale.getString("CommandActions.ContinuousPlaybackMode"));
            this.continuousPlayAction.putValue("ShortDescription", ElanLocale.getString("CommandActions.ContinuousPlaybackModeToolTip"));
        }
    }

    @Override
    public void clearLayout() {
    }

    @Override
    public void initComponents() {
        this.vertSplitPane = new JSplitPane(0);
        this.vertSplitPane.setOneTouchExpandable(true);
        this.vertSplitPane.setResizeWeight(1.0);
        this.add(this.viewerManager.getMediaPlayerController());
        this.add(this.viewerManager.createTurnsAndSceneViewer());
        if (this.turnsAndSceneViewer != null) {
            this.add(new FontSizePanel(this.turnsAndSceneViewer));
        }
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
    }

    @Override
    public void shortcutsChanged() {
        if (this.turnsAndSceneViewer != null) {
            InputMap textInputMap = this.turnsAndSceneViewer.getEditor().getTextArea().getInputMap();
            ActionMap textActionMap = this.turnsAndSceneViewer.getEditor().getTextArea().getActionMap();
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.SplitAnnotation", "Menu.Options.TurnsAndSceneMode"), "Menu.Annotation.SplitAnnotation");
            textActionMap.put("Menu.Annotation.SplitAnnotation", new TaSSplitAction(this.turnsAndSceneViewer));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithBefore", "Menu.Options.TurnsAndSceneMode"), "Menu.Annotation.MergeWithBefore");
            textActionMap.put("Menu.Annotation.MergeWithBefore", new TaSMergeAction(this.turnsAndSceneViewer, TaSMergeAction.MERGE_ROW.PREVIOUS));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithNext", "Menu.Options.TurnsAndSceneMode"), "Menu.Annotation.MergeWithNext");
            textActionMap.put("Menu.Annotation.MergeWithNext", new TaSMergeAction(this.turnsAndSceneViewer, TaSMergeAction.MERGE_ROW.NEXT));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.AnnotationDown", "Menu.Options.TurnsAndSceneMode"), "CommandActions.AnnotationDown");
            textActionMap.put("CommandActions.AnnotationDown", new TaSActivateCellAction(this.turnsAndSceneViewer, 12));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.AnnotationUp", "Menu.Options.TurnsAndSceneMode"), "CommandActions.AnnotationUp");
            textActionMap.put("CommandActions.AnnotationUp", new TaSActivateCellAction(this.turnsAndSceneViewer, 13));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.TurnsAndSceneMode"), "Menu.Annotation.DeleteAnnotation");
            textActionMap.put("Menu.Annotation.DeleteAnnotation", new TaSDeleteAction(this.turnsAndSceneViewer));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.RemoveAnnotationValue", "Menu.Options.TurnsAndSceneMode"), "Menu.Annotation.RemoveAnnotationValue");
            textActionMap.put("Menu.Annotation.RemoveAnnotationValue", ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.RemoveAnnotationValue"));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.ModifyAnnotationTime", "Menu.Options.TurnsAndSceneMode"), "CommandActions.ModifyAnnotationTime");
            textActionMap.put("CommandActions.ModifyAnnotationTime", new TaSModifyTimeAction(this.turnsAndSceneViewer));
            textActionMap.put("PostCut", new TaSPostCutAction(this.turnsAndSceneViewer));
            textActionMap.put("PostPaste", new TaSPostPasteAction(this.turnsAndSceneViewer));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.CancelAnnotationEdit", "Menu.Options.TurnsAndSceneMode"), "CommandActions.CancelAnnotationEdit");
            textActionMap.put("CommandActions.CancelAnnotationEdit", new CancelEditAction(this.turnsAndSceneViewer));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlaySelection", "Menu.Options.TurnsAndSceneMode"), "Menu.Play.PlaySelection");
            textActionMap.put("Menu.Play.PlaySelection", ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlaySelection"));
            textInputMap.put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.PlayAroundSelection", "Menu.Options.TurnsAndSceneMode"), "CommandActions.PlayAroundSelection");
            textActionMap.put("CommandActions.PlayAroundSelection", ELANCommandFactory.getCommandAction(this.transcription, "CommandActions.PlayAroundSelection"));
            KeyStroke TAB_KS = KeyStroke.getKeyStroke(9, 0, false);
            String tabPS = "TAB_PLAY_SEL";
            textInputMap.put(TAB_KS, tabPS);
            textActionMap.put(tabPS, ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlaySelection"));
            JRootPane rootPane = SwingUtilities.getRootPane(this.container);
            if (rootPane != null) {
                rootPane.getInputMap(2).put(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.AnnotationAtCurrentTime", "Menu.Options.TurnsAndSceneMode"), "CommandActions.AnnotationAtCurrentTime");
                rootPane.getActionMap().put("CommandActions.AnnotationAtCurrentTime", new TaSActivateCellAction(this.turnsAndSceneViewer, 0));
                if (this.continuousPlayAction != null) {
                    KeyStroke ks = ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.ContinuousPlaybackMode", "Menu.Options.TurnsAndSceneMode");
                    rootPane.getInputMap(2).put(ks, "CommandActions.ContinuousPlaybackMode");
                    rootPane.getActionMap().put("CommandActions.ContinuousPlaybackMode", this.continuousPlayAction);
                    if (ks != null) {
                        String ksDesc = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ks);
                        Object tooltip = ElanLocale.getString("CommandActions.ContinuousPlaybackModeToolTip");
                        tooltip = (String)tooltip + " (" + ksDesc + ")";
                        this.continuousPlayAction.putValue("ShortDescription", tooltip);
                        this.continuousPlayAction.putValue("AcceleratorKey", ks);
                    }
                }
            }
        }
    }

    @Override
    public void createAndAddViewer(String viewerName) {
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        return false;
    }

    @Override
    public void detach(Object object) {
        if (object instanceof PlayerLayoutModel && this.videoPanel != null) {
            this.videoPanel.detach((PlayerLayoutModel)object);
            this.videoAndControlPanel.removeComponentListener(this.videoPanel);
            this.videoAndControlPanel.remove(this.videoPanel);
            this.doLayout();
        }
    }

    @Override
    public void attach(Object object) {
        if (object instanceof PlayerLayoutModel && this.videoPanel != null) {
            this.container.remove(((PlayerLayoutModel)object).visualComponent);
            this.videoPanel.attach((PlayerLayoutModel)object);
            this.videoAndControlPanel.addComponentListener(this.videoPanel);
            GridBagConstraints gbc = new GridBagConstraints();
            int margin = 3;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.01;
            gbc.insets = new Insets(margin, margin, 0, margin);
            this.videoAndControlPanel.add((Component)this.videoPanel, gbc);
            this.doLayout();
        }
    }

    @Override
    public void preferencesChanged() {
        Boolean contPlayMode;
        Float horiDivLocation;
        int paneHeight;
        Float vertDivLocation;
        Integer fontSize;
        if (!this.initialized) {
            this.doLayout();
        }
        if ((fontSize = Preferences.getInt("TurnsAndSceneMode.View.FontSize", this.transcription)) != null && this.fontSizePanel != null) {
            this.fontSizePanel.setFontSize(fontSize);
        }
        if ((vertDivLocation = Preferences.getFloat("TurnsAndSceneMode.VertSplit.Location", this.transcription)) != null && this.vertSplitPane != null && (paneHeight = this.vertSplitPane.getHeight()) != 0) {
            int divLoc = (int)((float)paneHeight * vertDivLocation.floatValue());
            this.vertSplitPane.setDividerLocation(divLoc);
        }
        if ((horiDivLocation = Preferences.getFloat("TurnsAndSceneMode.HoriSplit.Location", this.transcription)) != null && this.horiSplitPane != null) {
            int paneWidth = this.horiSplitPane.getWidth();
            if (paneWidth == 0 && this.vertSplitPane != null) {
                paneWidth = this.vertSplitPane.getWidth();
            }
            if (paneWidth != 0) {
                int divLoc = (int)((float)paneWidth * horiDivLocation.floatValue());
                this.horiSplitPane.setDividerLocation(divLoc);
            }
        }
        if ((contPlayMode = Preferences.getBool("TurnsAndSceneMode.ContinuousPlayMode", this.transcription)) != null && contPlayMode.booleanValue()) {
            this.turnsAndSceneViewer.setContinuousPlayMode(contPlayMode);
            if (this.continuousPlayAction != null) {
                this.continuousPlayAction.putValue("SwingSelectedKey", contPlayMode);
            }
        }
        this.doLayout();
    }

    @Override
    public void cleanUpOnClose() {
        if (this.tasControlPanel != null) {
            this.viewerManager.disconnectListener(this.tasControlPanel);
        }
        if (this.videoAndControlPanel != null && this.videoPanel != null) {
            this.videoAndControlPanel.removeComponentListener(this.videoPanel);
        }
    }

    @Override
    public void isClosing() {
        float relLoc;
        if (this.vertSplitPane != null) {
            float paneHeight = this.vertSplitPane.getHeight();
            int vdivLoc = this.vertSplitPane.getDividerLocation();
            relLoc = (float)vdivLoc / paneHeight;
            this.layoutManager.setPreference("TurnsAndSceneMode.VertSplit.Location", Float.valueOf(relLoc), this.transcription);
        }
        if (this.horiSplitPane != null) {
            float paneWidth = this.horiSplitPane.getWidth();
            int hdivLoc = this.horiSplitPane.getDividerLocation();
            relLoc = (float)hdivLoc / paneWidth;
            this.layoutManager.setPreference("TurnsAndSceneMode.HoriSplit.Location", Float.valueOf(relLoc), this.transcription);
        }
        this.layoutManager.setPreference("TurnsAndSceneMode.View.FontSize", this.turnsAndSceneViewer.getFontSize(), this.transcription);
        this.layoutManager.setPreference("TurnsAndSceneMode.ContinuousPlayMode", this.turnsAndSceneViewer.isContinuousPlayMode(), this.transcription);
    }

    @Override
    public List<Zoomable> getZoomableViewers() {
        ArrayList<Zoomable> zoomList = new ArrayList<Zoomable>(2);
        if (this.signalViewer != null) {
            zoomList.add(this.signalViewer);
        }
        if (this.fontSizePanel != null) {
            zoomList.add(this.fontSizePanel);
        }
        return zoomList;
    }

    static {
        REDEFINED_ACTIONS.add("Menu.Annotation.SplitAnnotation");
        REDEFINED_ACTIONS.add("Menu.Annotation.MergeWithBefore");
        REDEFINED_ACTIONS.add("Menu.Annotation.MergeWithNext");
        REDEFINED_ACTIONS.add("CommandActions.AnnotationDown");
        REDEFINED_ACTIONS.add("CommandActions.AnnotationUp");
        REDEFINED_ACTIONS.add("Menu.Annotation.DeleteAnnotation");
        REDEFINED_ACTIONS.add("Menu.Annotation.RemoveAnnotationValue");
        REDEFINED_ACTIONS.add("CommandActions.ModifyAnnotationTime");
        REDEFINED_ACTIONS.add("CommandActions.CancelAnnotationEdit");
        REDEFINED_ACTIONS.add("CommandActions.AnnotationAtCurrentTime");
    }
}

