/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;

public class ValueChooseDialog
extends ClosableDialog
implements ActionListener,
ListSelectionListener {
    private ArrayList<String> values;
    private JLabel msgLabel;
    private JLabel titleLabel;
    private JList valueList;
    private JScrollPane valueListScroller;
    private JButton okButton;
    private JButton cancelButton;
    private Component parent;
    private boolean canceled;

    public ValueChooseDialog(Frame parent, ArrayList<String> values) {
        super(parent, true);
        this.parent = parent;
        this.values = values;
        this.canceled = false;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ValueChooseDialog.this.closeDialog();
            }
        });
        this.titleLabel = new JLabel();
        this.msgLabel = new JLabel();
        this.valueList = new JList<Object>(this.values.toArray());
        this.valueList.setSelectionMode(0);
        this.valueList.addListSelectionListener(this);
        this.valueListScroller = new JScrollPane(this.valueList);
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(6, 6, 6, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        c.fill = 2;
        c.anchor = 11;
        c.insets = insets;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.add((Component)this.titleLabel, c);
        c.fill = 0;
        c.insets = insets;
        c.anchor = 21;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.add((Component)this.msgLabel, c);
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 2;
        this.add((Component)this.valueListScroller, c);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        c.insets = insets;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 15;
        this.add((Component)buttonPanel, c);
    }

    private void postInit() {
        this.updateLocale();
        this.okButton.setEnabled(false);
        this.setLocationRelativeTo(this.getParent());
        this.pack();
        int w = 450;
        int h = 250;
        this.setSize(w, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.parent);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("LexiconEntryViewer.ValueChooseDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("LexiconEntryViewer.ValueChooseDialog.Title"));
        this.msgLabel.setText(ElanLocale.getString("LexiconEntryViewer.ValueChooseDialog.Message"));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.closeDialog();
        } else if (event.getSource() == this.cancelButton) {
            this.canceled = true;
            this.closeDialog();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.valueList) {
            if (this.valueList.getSelectedIndex() > -1) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getSelectedValue() {
        if (this.valueList.getSelectedIndex() > -1) {
            return this.values.get(this.valueList.getSelectedIndex());
        }
        return null;
    }
}

