/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntBundle;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntLoader;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntParser;
import mpi.eudico.client.annotator.lexicon.api.Param;
import mpi.eudico.client.annotator.util.AvailabilityDetector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;
import org.xml.sax.SAXException;

public class LexSrvcAvailabilityDetector {
    private static Map<String, LexSrvcClntBundle> lexSrvcClntBundles = new HashMap<String, LexSrvcClntBundle>();
    private static LexSrvcClntLoader lexSrvcClntLoader;

    private LexSrvcAvailabilityDetector() {
    }

    public static HashMap<String, LexiconServiceClientFactory> getLexiconServiceClientFactories() {
        AvailabilityDetector.loadFilesFromExtensionsFolder();
        HashMap<String, LexiconServiceClientFactory> lexSrvcClnts = new HashMap<String, LexiconServiceClientFactory>(6);
        for (String key : lexSrvcClntBundles.keySet()) {
            LexSrvcClntBundle bundle = lexSrvcClntBundles.get(key);
            if (bundle.getJavaLibs() != null) {
                if (lexSrvcClntLoader == null) {
                    lexSrvcClntLoader = new LexSrvcClntLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
                } else {
                    lexSrvcClntLoader.addLibs(bundle.getJavaLibs());
                    lexSrvcClntLoader.addNativeLibs(bundle.getNativeLibs());
                }
                try {
                    LexiconServiceClientFactory clientFactory = (LexiconServiceClientFactory)Class.forName(bundle.getLexSrvcClntClass(), true, lexSrvcClntLoader).newInstance();
                    clientFactory.setType(bundle.getName());
                    clientFactory.setDescription(bundle.getDescription());
                    for (Param p : bundle.getParamList()) {
                        if (p.getType().equals("defaultUrl")) {
                            clientFactory.setDefaultUrl(p.getContent());
                            continue;
                        }
                        if (!p.getType().equals("searchConstraint")) continue;
                        clientFactory.addSearchConstraint(p.getContent());
                    }
                    lexSrvcClnts.put(key, clientFactory);
                }
                catch (ClassNotFoundException cnfe) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + bundle.getLexSrvcClntClass() + " - Class not found");
                }
                catch (InstantiationException ie) {
                    ClientLogger.LOG.severe("Cannot instantiate the lexicon service client class: " + bundle.getLexSrvcClntClass());
                }
                catch (IllegalAccessException iae) {
                    ClientLogger.LOG.severe("Cannot access the lexicon service client class: " + bundle.getLexSrvcClntClass());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client: " + bundle.getLexSrvcClntClass() + " - " + ex.getMessage());
                    ex.printStackTrace();
                }
                continue;
            }
            ClientLogger.LOG.severe("Cannot load the lexicon service client: no Java library has been found ");
        }
        return lexSrvcClnts;
    }

    public static int getNumberOfFactories() {
        return lexSrvcClntBundles.size();
    }

    public static List<String> getFactoryNames() {
        if (lexSrvcClntBundles.size() > 0) {
            ArrayList<String> names = new ArrayList<String>(lexSrvcClntBundles.size());
            names.addAll(lexSrvcClntBundles.keySet());
            return names;
        }
        return null;
    }

    public static LexiconServiceClientFactory getFactoryByName(String name) {
        LexSrvcClntBundle bundle = lexSrvcClntBundles.get(name);
        if (bundle == null) {
            return null;
        }
        if (bundle.getJavaLibs() != null) {
            if (lexSrvcClntLoader == null) {
                lexSrvcClntLoader = new LexSrvcClntLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
            } else {
                lexSrvcClntLoader.addLibs(bundle.getJavaLibs());
                lexSrvcClntLoader.addNativeLibs(bundle.getNativeLibs());
            }
            try {
                LexiconServiceClientFactory clientFactory = (LexiconServiceClientFactory)Class.forName(bundle.getLexSrvcClntClass(), true, lexSrvcClntLoader).newInstance();
                clientFactory.setType(bundle.getName());
                clientFactory.setDescription(bundle.getDescription());
                for (Param p : bundle.getParamList()) {
                    if (p.getType().equals("defaultUrl")) {
                        clientFactory.setDefaultUrl(p.getContent());
                        continue;
                    }
                    if (!p.getType().equals("searchConstraint")) continue;
                    clientFactory.addSearchConstraint(p.getContent());
                }
                return clientFactory;
            }
            catch (ClassNotFoundException cnfe) {
                ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + bundle.getLexSrvcClntClass() + " - Class not found");
            }
            catch (InstantiationException ie) {
                ClientLogger.LOG.severe("Cannot instantiate the lexicon service client class: " + bundle.getLexSrvcClntClass());
            }
            catch (IllegalAccessException iae) {
                ClientLogger.LOG.severe("Cannot access the lexicon service client class: " + bundle.getLexSrvcClntClass());
            }
            catch (Exception ex) {
                ClientLogger.LOG.severe("Cannot load the lexicon service client: " + bundle.getLexSrvcClntClass() + " - " + ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            ClientLogger.LOG.severe("Cannot load the lexicon service client: no Java library has been found ");
        }
        return null;
    }

    public static void createBundle(InputStream lexStream, URL[] libs, URL[] natLibs, File baseDir) {
        boolean isLexClient = false;
        String binaryName = null;
        LexSrvcClntBundle bundle = null;
        LexSrvcClntParser parser = null;
        try {
            parser = new LexSrvcClntParser(lexStream);
            parser.parse();
            if (!parser.curOsSupported) {
                ClientLogger.LOG.warning("Lexicon service client does not support this Operating System: " + parser.name);
                return;
            }
            if (parser.implementor == null) {
                ClientLogger.LOG.warning("The implementing class name has not been specified.");
                return;
            }
            isLexClient = true;
            binaryName = parser.implementor;
        }
        catch (SAXException sax) {
            ClientLogger.LOG.severe("Cannot parse metadata file: " + sax.getMessage());
        }
        if (isLexClient) {
            LexSrvcClntLoader loader = new LexSrvcClntLoader(libs, natLibs);
            if (binaryName != null) {
                try {
                    Class<?> c = loader.loadClass(binaryName);
                    bundle = new LexSrvcClntBundle();
                    bundle.setName(parser.name);
                    bundle.setDescription(parser.description);
                    bundle.setParamList(parser.paramList);
                    bundle.setLexSrvcClntClass(binaryName);
                    bundle.setJavaLibs(libs);
                    bundle.setNativeLibs(natLibs);
                    bundle.setBaseDir(baseDir);
                    lexSrvcClntBundles.put(bundle.getName(), bundle);
                }
                catch (ClassNotFoundException cne) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + binaryName + " - Class not found");
                }
            } else {
                ClientLogger.LOG.warning("Cannot load the lexicon service client class: Class not found");
            }
        }
    }
}

