/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.imdi.ImdiKeyRenderer;
import mpi.eudico.client.annotator.md.spi.MDConfigurationPanel;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;

public class ImdiConfigurationPanel
extends MDConfigurationPanel
implements ActionListener {
    private ImdiFileServiceProvider provider;
    private TierExportTableModel model;
    private TierExportTable keyTable;
    private static final String SEL_COLUMN = "Select";
    private static final String KEY_COLUMN = "Key";

    public ImdiConfigurationPanel(ImdiFileServiceProvider provider) {
        this.provider = provider;
        this.initComponents();
    }

    private void initComponents() {
        List<String> keys;
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(ElanLocale.getString("MetadataViewer.SelectKeys")));
        this.model = new TierExportTableModel();
        this.model.setColumnIdentifiers(new String[]{SEL_COLUMN, KEY_COLUMN});
        this.keyTable = new TierExportTable(this.model);
        this.keyTable.getColumn(KEY_COLUMN).setCellRenderer(new ImdiKeyRenderer());
        this.keyTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        if (this.provider != null && (keys = this.provider.getKeys()) != null) {
            List<String> selectedKeys = this.provider.getSelectedKeys();
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                String key = keys.get(i);
                if (selectedKeys.contains(key)) {
                    this.model.addRow(Boolean.TRUE, key);
                    continue;
                }
                this.model.addRow(Boolean.FALSE, key);
            }
        }
        JScrollPane keyScrollPane = new JScrollPane(this.keyTable);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add((Component)keyScrollPane, gbc);
    }

    @Override
    public void applyChanges() {
        ArrayList<String> nextSelected = new ArrayList();
        nextSelected = this.model.getSelectedTiers();
        if (this.provider != null) {
            this.provider.setSelectedKeys(nextSelected);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }
}

