/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.mediadisplayer;

import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.mediadisplayer.MediaBundle;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayer;
import mpi.eudico.client.annotator.mediadisplayer.MediaProvider;
import mpi.eudico.client.annotator.mediadisplayer.VideoDisplayer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import nl.mpi.util.FileExtension;

public class MediaDisplayerFactory {
    public static MediaDisplayer createMediaDisplayer(MEDIA_TYPE type, MediaBundle mediaBundle) {
        VideoDisplayer displayer = null;
        if (type == MEDIA_TYPE.VIDEO) {
            displayer = new VideoDisplayer();
            displayer.setMediaBundle(mediaBundle);
        }
        return displayer;
    }

    public static MediaDisplayer getMediaDisplayer(Object[] arguments) {
        Object mediaUser = arguments[0];
        MediaDisplayer mediaDisplayer = null;
        if (mediaUser instanceof Annotation) {
            Annotation annot = (Annotation)mediaUser;
            mediaDisplayer = MediaDisplayerFactory.getMediaDisplayerFor(annot);
        } else if (mediaUser instanceof String && arguments[1] instanceof Annotation) {
            mediaDisplayer = MediaDisplayerFactory.getMediaDisplayerFromLexiconService(mediaUser, (Annotation)arguments[1]);
        }
        return mediaDisplayer;
    }

    private static MediaDisplayer getMediaDisplayerFor(Annotation annotation) {
        MediaDisplayer mediaDisplayer = MediaDisplayerFactory.getMediaDisplayerFromExternalRef(annotation);
        if (mediaDisplayer != null) {
            return mediaDisplayer;
        }
        mediaDisplayer = MediaDisplayerFactory.getMediaDisplayerFromLexiconService(annotation);
        if (mediaDisplayer != null) {
            return mediaDisplayer;
        }
        return null;
    }

    private static MediaDisplayer getMediaDisplayerFromExternalRef(Annotation annotation) {
        AbstractAnnotation abstrAnnot;
        ExternalReference extRef;
        MediaDisplayer mediaDisplayer = null;
        if (annotation instanceof AbstractAnnotation && (extRef = (abstrAnnot = (AbstractAnnotation)annotation).getExtRef()) != null && extRef.getReferenceType() == 3) {
            String resourceUrl = extRef.getValue();
            MediaBundle mediaBundle = new MediaBundle();
            mediaBundle.setMediaUrl(resourceUrl);
            MEDIA_TYPE mediaType = MediaDisplayerFactory.getMediaTypeFromUrlString(resourceUrl);
            mediaDisplayer = MediaDisplayerFactory.createMediaDisplayer(mediaType, mediaBundle);
        }
        return mediaDisplayer;
    }

    private static MediaDisplayer getMediaDisplayerFromLexiconService(Object mediaIdentifier, Annotation annotation) {
        MediaDisplayer mediaDisplayer = null;
        LinguisticType lingType = annotation.getTier().getLinguisticType();
        LexiconQueryBundle2 lexQueryBndl = lingType.getLexiconQueryBundle();
        if (lexQueryBndl != null) {
            LexiconServiceClient srvcClient;
            TranscriptionImpl transcriptionImpl = (TranscriptionImpl)annotation.getTier().getTranscription();
            if (!transcriptionImpl.isLexiconServicesLoaded()) {
                new LexiconClientFactoryLoader().loadLexiconClientFactories(transcriptionImpl);
                transcriptionImpl.setLexiconServicesLoaded(true);
            }
            if ((srvcClient = lexQueryBndl.getLink().getSrvcClient()) instanceof MediaProvider) {
                MediaProvider mediaProvider = (MediaProvider)((Object)srvcClient);
                MEDIA_TYPE mediaType = mediaProvider.getPreferredMediaType();
                MediaBundle mediaBundle = mediaProvider.getMedia(mediaType, new Object[]{mediaIdentifier, lexQueryBndl.getLink().getLexId()});
                if (mediaBundle != null) {
                    mediaDisplayer = MediaDisplayerFactory.createMediaDisplayer(mediaType, mediaBundle);
                }
            }
        }
        return mediaDisplayer;
    }

    private static MediaDisplayer getMediaDisplayerFromLexiconService(Annotation annotation) {
        return MediaDisplayerFactory.getMediaDisplayerFromLexiconService(annotation, annotation);
    }

    private static MEDIA_TYPE getMediaTypeFromUrlString(String url) {
        if (MediaDisplayerFactory.endsWithOneOf(url, FileExtension.MISC_VIDEO_EXT).booleanValue()) {
            return MEDIA_TYPE.VIDEO;
        }
        return null;
    }

    private static Boolean endsWithOneOf(String target, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!target.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static enum MEDIA_TYPE {
        VIDEO,
        IMAGE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum MEDIA_ORIENTATION {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

