/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.UpdateTranscriptionsForECVCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;

public class UpdateTranscriptionsForECVDialog
extends ClosableDialog
implements ActionListener,
ChangeListener,
ProgressListener {
    private JButton sourceButton;
    private JRadioButton sameFolderRB;
    private JRadioButton otherFolderRB;
    private JButton destFolderButton;
    private JButton startButton;
    private JButton closeButton;
    private JTextField sourceTF;
    private JTextField destFolderTF;
    private JTextField languageTF;
    private JComboBox newLanguageComboBox;
    private JCheckBox recursiveCB;
    private JProgressBar progressBar;
    private Command command;
    private SwingWorker<Void, Void> task;
    private JCheckBox annoValuePrecedenceCB;

    public UpdateTranscriptionsForECVDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public UpdateTranscriptionsForECVDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.updateNewLanguageComboBox();
        this.loadPreferences();
        this.pack();
        this.setSize(this.getWidth() + 60, this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.Title"));
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        Insets insets = new Insets(4, 6, 0, 6);
        Insets indent = new Insets(4, 26, 0, 6);
        JLabel sourceLabel = new JLabel(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.SourceFolder"));
        this.sourceTF = new JTextField();
        this.sourceTF.setEnabled(false);
        this.sourceButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.recursiveCB = new JCheckBox(ElanLocale.getString("CreateMultiEAFDialog.Button.Recursive"));
        JLabel transLocationLabel = new JLabel(ElanLocale.getString("CreateMultiEAFDialog.Label.EAFLocation"));
        this.sameFolderRB = new JRadioButton(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.Button.Overwrite"));
        this.sameFolderRB.setSelected(true);
        this.otherFolderRB = new JRadioButton(ElanLocale.getString("CreateMultiEAFDialog.Button.OtherFolder"));
        ButtonGroup fGroup = new ButtonGroup();
        fGroup.add(this.sameFolderRB);
        fGroup.add(this.otherFolderRB);
        this.destFolderButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.destFolderButton.setEnabled(false);
        this.destFolderTF = new JTextField();
        this.destFolderTF.setEnabled(false);
        JLabel languageLabel = new JLabel(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.Language"));
        this.newLanguageComboBox = this.getNewLanguageComboBox();
        this.annoValuePrecedenceCB = new JCheckBox(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.AnnotationValuePrecedence"));
        JLabel progressLabel = new JLabel(ElanLocale.getString("MultipleFileSearch.FindReplace.Progress"));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        this.startButton = new JButton(ElanLocale.getString("Button.Start"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.closeButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        pane.add((Component)sourceLabel, gbc);
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        pane.add((Component)this.sourceTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        pane.add((Component)this.sourceButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 26, 6, 6);
        pane.add((Component)this.recursiveCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        pane.add((Component)transLocationLabel, gbc);
        gbc.gridy = 4;
        gbc.insets = indent;
        pane.add((Component)this.sameFolderRB, gbc);
        gbc.gridy = 5;
        pane.add((Component)this.otherFolderRB, gbc);
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 26, 6, 6);
        pane.add((Component)this.destFolderTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(4, 6, 6, 6);
        pane.add((Component)this.destFolderButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pane.add((Component)languageLabel, gbc);
        gbc.gridy = 8;
        pane.add((Component)this.newLanguageComboBox, gbc);
        gbc.gridy = 9;
        gbc.insets = new Insets(8, 6, 0, 6);
        pane.add((Component)this.annoValuePrecedenceCB, gbc);
        gbc.gridy = 10;
        gbc.insets = new Insets(12, 6, 0, 6);
        pane.add((Component)progressLabel, gbc);
        gbc.gridy = 11;
        gbc.insets = insets;
        pane.add((Component)this.progressBar, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)pane, gbc);
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.sourceButton.addActionListener(this);
        this.destFolderButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.sameFolderRB.addChangeListener(this);
        this.otherFolderRB.addChangeListener(this);
    }

    private void loadPreferences() {
        Boolean boolPref;
        String stringPref = Preferences.getString("UpdateTranscriptionsForECV.SourcePath", null);
        if (stringPref != null) {
            this.sourceTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("UpdateTranscriptionsForECV.Recursive", null)) != null) {
            this.recursiveCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("UpdateTranscriptionsForECV.OtherDestination", null)) != null) {
            this.otherFolderRB.setSelected(boolPref);
            this.destFolderButton.setEnabled(this.otherFolderRB.isSelected());
        }
        if ((stringPref = Preferences.getString("UpdateTranscriptionsForECV.DestinationPath", null)) != null) {
            this.destFolderTF.setText(stringPref);
        }
        if ((stringPref = Preferences.getString("UpdateTranscriptionsForECV.LanguageRef", null)) != null) {
            LangInfo langInfo = LanguageCollection.getLanguageInfo(stringPref);
            this.newLanguageComboBox.getModel().setSelectedItem(langInfo);
        }
        if ((boolPref = Preferences.getBool("UpdateTranscriptionsForECV.AnnotationValuePrecedence", null)) != null) {
            this.annoValuePrecedenceCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        String langRef;
        String sourcePath = this.sourceTF.getText();
        if (sourcePath != null && sourcePath.length() > 0) {
            Preferences.set("UpdateTranscriptionsForECV.SourcePath", sourcePath, null, false, false);
        }
        Preferences.set("UpdateTranscriptionsForECV.Recursive", this.recursiveCB.isSelected(), null, false, false);
        boolean otherDest = this.otherFolderRB.isSelected();
        Preferences.set("UpdateTranscriptionsForECV.OtherDestination", otherDest, null, false, false);
        String destPath = this.destFolderTF.getText();
        if (destPath != null && destPath.length() > 0) {
            Preferences.set("UpdateTranscriptionsForECV.DestinationPath", destPath, null, false, false);
        }
        if (this.newLanguageComboBox.getSelectedIndex() > -1 && (langRef = ((LangInfo)this.newLanguageComboBox.getSelectedItem()).getId()) != null && langRef.length() > 0) {
            Preferences.set("UpdateTranscriptionsForECV.LanguageRef", langRef, null, false, false);
        }
        Preferences.set("UpdateTranscriptionsForECV.AnnotationValuePrecedence", this.annoValuePrecedenceCB.isSelected(), null, false, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sourceButton) {
            this.getSourceFolder();
        } else if (e.getSource() == this.destFolderButton) {
            this.getDestinationFolder();
        } else if (e.getSource() == this.startButton) {
            this.startButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.task = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (UpdateTranscriptionsForECVDialog.this.create() && !((UpdateTranscriptionsForECVCommand)UpdateTranscriptionsForECVDialog.this.command).isCanceled().booleanValue()) {
                        UpdateTranscriptionsForECVDialog.this.savePreferences();
                        if (UpdateTranscriptionsForECVDialog.this.command instanceof ProcessReporter) {
                            ProcessReport report = ((ProcessReporter)((Object)UpdateTranscriptionsForECVDialog.this.command)).getProcessReport();
                            if (report != null) {
                                ReportDialog rd = new ReportDialog((Dialog)UpdateTranscriptionsForECVDialog.this, report);
                                rd.setVisible(true);
                            }
                        } else {
                            UpdateTranscriptionsForECVDialog.this.setVisible(false);
                            UpdateTranscriptionsForECVDialog.this.dispose();
                        }
                    }
                    return null;
                }

                @Override
                public void done() {
                    UpdateTranscriptionsForECVDialog.this.progressBar.setValue(100);
                    UpdateTranscriptionsForECVDialog.this.progressBar.setIndeterminate(false);
                    UpdateTranscriptionsForECVDialog.this.startButton.setEnabled(true);
                    UpdateTranscriptionsForECVDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            this.task.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress" == evt.getPropertyName()) {
                        int progress = (Integer)evt.getNewValue();
                        UpdateTranscriptionsForECVDialog.this.progressBar.setValue(progress);
                    }
                }
            });
            this.progressBar.setIndeterminate(true);
            this.task.execute();
        } else if (e.getSource() == this.closeButton) {
            this.savePreferences();
            if (this.command != null && this.command instanceof UpdateTranscriptionsForECVCommand) {
                ((UpdateTranscriptionsForECVCommand)this.command).cancel();
            }
            if (this.task != null) {
                this.task.cancel(true);
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sameFolderRB) {
            this.destFolderButton.setEnabled(false);
        } else if (e.getSource() == this.otherFolderRB) {
            this.destFolderButton.setEnabled(true);
        }
    }

    private void getSourceFolder() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectSourceFolder"), 0, ElanLocale.getString("Button.Select"), null, null, true, "LastUsedEAFDir", 1, null);
        File selDir = chooser.getSelectedFile();
        if (selDir != null) {
            this.sourceTF.setText(selDir.getAbsolutePath());
        }
    }

    private void getDestinationFolder() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.EAFLocation"), 0, ElanLocale.getString("Button.Select"), null, null, true, "LastUsedEAFDir", 1, null);
        File selDir = chooser.getSelectedFile();
        if (selDir != null) {
            this.destFolderTF.setText(selDir.getAbsolutePath());
        }
    }

    private boolean create() {
        String sourceFol = this.sourceTF.getText();
        if (sourceFol == null || sourceFol.length() == 0) {
            this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoSource"));
            this.sourceButton.requestFocus();
            return false;
        }
        File f = new File(sourceFol);
        try {
            if (!f.exists() || !f.isDirectory()) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NonExistSource"));
                this.sourceButton.requestFocus();
                return false;
            }
        }
        catch (SecurityException ex) {
            this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoAccessSource"));
            return false;
        }
        String destFol = null;
        if (this.otherFolderRB.isSelected()) {
            destFol = this.destFolderTF.getText();
            if (destFol == null || destFol.length() == 0) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoDestination"));
                this.destFolderButton.requestFocus();
                return false;
            }
            File f2 = new File(destFol);
            try {
                if (!f2.exists() || !f2.isDirectory()) {
                    this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NonExistDestination"));
                    this.destFolderButton.requestFocus();
                    return false;
                }
            }
            catch (SecurityException se) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoAccessDestination"));
                return false;
            }
        }
        boolean recursive = this.recursiveCB.isSelected();
        boolean annoPrecedence = this.annoValuePrecedenceCB.isSelected();
        String language = ((LangInfo)this.newLanguageComboBox.getSelectedItem()).getId();
        this.command = new UpdateTranscriptionsForECVCommand("Menu.File.MultiEAFECVUpdater");
        if (this.command instanceof ProcessReporter) {
            ((ProcessReporter)((Object)this.command)).setProcessReport(new SimpleReport(ElanLocale.getString("UpdateMTranscriptionsForECVDialog.Title")));
        }
        this.command.execute(this, new Object[]{sourceFol, destFol, recursive, language, annoPrecedence});
        return true;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    protected JComboBox getNewLanguageComboBox() {
        JComboBox box = new JComboBox();
        box.setEditable(false);
        return box;
    }

    protected void updateNewLanguageComboBox() {
        if (!(this.newLanguageComboBox instanceof RecentLanguagesBox)) {
            LanguageCollection.setLocalCacheFolder(Constants.ELAN_DATA_DIR);
            List<LangInfo> languages = LanguageCollection.getLanguages();
            LanguagesListModel m = new LanguagesListModel(languages);
            this.newLanguageComboBox.setPrototypeDisplayValue(languages.get(0));
            this.newLanguageComboBox.setModel(m);
        }
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        this.progressBar.setString(message);
    }

    @Override
    public void progressCompleted(Object source, String message) {
    }

    @Override
    public void progressInterrupted(Object source, String message) {
    }

    public static void main(String[] args) {
        new UpdateTranscriptionsForECVDialog(null, false).setVisible(true);
    }

    private static class LanguagesListModel
    extends AbstractListModel
    implements ComboBoxModel {
        final List<LangInfo> languages;
        final int size;
        Object selectedItem;

        LanguagesListModel(List<LangInfo> languages) {
            this.languages = languages;
            this.size = languages.size();
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0) {
                return "";
            }
            if (index < this.size) {
                return this.languages.get(index);
            }
            return "";
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

