/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.ngramstats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.ngramstats.NgramAnnotation;

public class Ngram {
    private final int ngramSize;
    protected final String filePath;
    protected final List<NgramAnnotation> annotations = new ArrayList<NgramAnnotation>();
    protected Long duration = 0L;
    protected Long totalAnnotationTime = 0L;
    protected Long totalIntervalTime = 0L;
    protected int position;

    public Ngram(String path, int size) {
        this.filePath = path;
        this.ngramSize = size;
    }

    protected String annotationsAsString() {
        StringBuilder rv = new StringBuilder();
        for (NgramAnnotation ann : this.annotations) {
            rv.append(ann.value + "|");
        }
        rv.deleteCharAt(rv.length() - 1);
        return rv.toString();
    }

    private void sanityCheck() throws Exception {
        if (this.annotations.size() != this.ngramSize) {
            throw new Exception("Invalid ngram size" + this.toString());
        }
        long ts = 0L;
        for (NgramAnnotation ann : this.annotations) {
            if (ann.beginTime < ts) {
                throw new Exception("Annotation time snafu" + this.toString());
            }
            ts = ann.endTime;
        }
    }

    protected void calculateStatistics() throws Exception {
        this.sanityCheck();
        this.duration = this.annotations.get((int)(this.ngramSize - 1)).endTime - this.annotations.get((int)0).beginTime;
        long tempTimeStamp = 0L;
        for (NgramAnnotation ann : this.annotations) {
            this.totalAnnotationTime = this.totalAnnotationTime + (ann.endTime - ann.beginTime);
            if (tempTimeStamp != 0L) {
                this.totalIntervalTime = this.totalIntervalTime + (ann.beginTime - tempTimeStamp);
            }
            tempTimeStamp = ann.endTime;
        }
        if (this.duration - this.totalIntervalTime != this.totalAnnotationTime) {
            throw new Exception("Invalid annotationTime" + this.toString());
        }
    }

    public String toString() {
        StringBuilder rv = new StringBuilder();
        rv.append("Ngram(" + this.annotationsAsString() + ")[" + this.hashCode() + "] in " + this.filePath);
        rv.append("\n\t beginTime=" + this.annotations.get((int)0).beginTime);
        rv.append("\n\t endTime=" + this.annotations.get((int)(this.ngramSize - 1)).endTime);
        rv.append("\n\t duration=" + this.duration);
        rv.append("\n\t annotationTime=" + this.totalAnnotationTime);
        rv.append("\n\t intervalTime=" + this.totalIntervalTime);
        rv.append("\n\t Annotations:");
        for (NgramAnnotation ann : this.annotations) {
            rv.append("\n\t\t " + ann.toString());
        }
        return rv.toString();
    }

    public List<String> toCSVColumns() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("N-gram");
        Collections.addAll(rv, "After Interval", "Before Interval", "Duration", "File", "First N-gram", "Last N-gram", "Latency", "N-gram Position");
        if (this.ngramSize > 1) {
            Collections.addAll(rv, "Total Annotation Time", "Total Interval Time");
        }
        return rv;
    }

    public String toCSV(String delim) {
        StringBuilder rv = new StringBuilder();
        rv.append(this.annotationsAsString() + delim);
        if (this.annotations.get((int)(this.annotations.size() - 1)).hasAfterInterval) {
            rv.append((double)this.annotations.get((int)(this.annotations.size() - 1)).afterInterval / 1000.0);
        } else {
            rv.append("NaN");
        }
        rv.append(delim);
        if (this.annotations.get((int)0).hasBeforeInterval) {
            rv.append((double)this.annotations.get((int)0).beforeInterval / 1000.0);
        } else {
            rv.append("NaN");
        }
        rv.append(delim);
        rv.append((double)this.duration.longValue() / 1000.0 + delim);
        rv.append(this.filePath + delim);
        if (this.annotations.get((int)0).hasBeforeInterval) {
            rv.append("0");
        } else {
            rv.append("1");
        }
        rv.append(delim);
        if (this.annotations.get((int)(this.annotations.size() - 1)).hasAfterInterval) {
            rv.append("0");
        } else {
            rv.append("1");
        }
        rv.append(delim);
        rv.append((double)this.annotations.get((int)0).beginTime / 1000.0 + delim);
        rv.append(this.position + delim);
        if (this.ngramSize > 1) {
            rv.append((double)this.totalAnnotationTime.longValue() / 1000.0 + delim);
            rv.append((double)this.totalIntervalTime.longValue() / 1000.0 + delim);
        }
        return rv.toString();
    }
}

