/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.ngramstats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.ngramstats.Ngram;
import mpi.eudico.client.annotator.ngramstats.NgramStatsResult;

public class NgramCollection {
    protected final List<Ngram> ngrams = new ArrayList<Ngram>();
    private final int ngramSize;
    private static final DecimalFormat timeFormat = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private final HashMap<String, Double> stats = new HashMap();
    private int[][] cT;
    private double[][] cT_exp;

    public NgramCollection(int size) {
        this.ngramSize = size;
    }

    public String getName() {
        return this.ngrams.get(0).annotationsAsString();
    }

    public int getOccurrences() {
        return this.ngrams.size();
    }

    public int getFileOccurrences() {
        return (int)Math.round(this.stats.get("File Occurrences"));
    }

    public String getAvgDuration() {
        return timeFormat.format(this.stats.get("Duration|Mean"));
    }

    public String getMinDuration() {
        return timeFormat.format(this.stats.get("Duration|Min"));
    }

    public String getMaxDuration() {
        return timeFormat.format(this.stats.get("Duration|Max"));
    }

    public String getAvgAnnotationTime() {
        if (this.ngramSize > 1) {
            return timeFormat.format(this.stats.get("Total Annotation Time|Mean"));
        }
        return null;
    }

    public String getAvgIntervalTime() {
        if (this.ngramSize > 1) {
            return timeFormat.format(this.stats.get("Total Interval Time|Mean"));
        }
        return null;
    }

    private void sanityCheck() throws Exception {
        if (this.ngrams.size() == 0) {
            throw new Exception("No ngram exists in this collation" + this.toString());
        }
        String masterNgram = this.ngrams.get(0).annotationsAsString();
        for (int i = 1; i < this.ngrams.size(); ++i) {
            if (masterNgram.equals(this.ngrams.get(i).annotationsAsString())) continue;
            throw new Exception("Not all ngrams have identical annotations" + this.toString());
        }
    }

    private void calcDescriptiveStats(String name, List<Double> data) {
        double iq3;
        double iq1;
        double kurtosis;
        double skewness;
        double stddev;
        double variance;
        double mean = 0.0;
        double moment2 = 0.0;
        double moment3 = 0.0;
        double moment4 = 0.0;
        if (data.size() > 0) {
            for (Double x : data) {
                mean += x.doubleValue();
            }
            mean /= (double)data.size();
            if (data.size() > 1) {
                for (Double x : data) {
                    moment2 += Math.pow(x - mean, 2.0);
                    moment3 += Math.pow(x - mean, 3.0);
                    moment4 += Math.pow(x - mean, 4.0);
                }
                variance = moment2 / (double)(data.size() - 1);
                stddev = Math.sqrt(variance);
                skewness = moment3 / Math.pow(Math.sqrt(moment2), 3.0);
                kurtosis = moment4 / Math.pow(moment2, 2.0);
            } else {
                stddev = Double.NaN;
                kurtosis = Double.NaN;
                skewness = Double.NaN;
                variance = Double.NaN;
            }
        } else {
            stddev = Double.NaN;
            kurtosis = Double.NaN;
            skewness = Double.NaN;
            variance = Double.NaN;
            mean = Double.NaN;
        }
        this.stats.put(name + "|Mean", mean);
        this.stats.put(name + "|Variance", variance);
        this.stats.put(name + "|StdDev", stddev);
        this.stats.put(name + "|Skewness", skewness);
        this.stats.put(name + "|Kurtosis", kurtosis);
        double min = data.size() > 0 ? Double.MAX_VALUE : Double.NaN;
        for (Double x : data) {
            if (!(x < min)) continue;
            min = x;
        }
        this.stats.put(name + "|Min", min);
        double max = data.size() > 0 ? -1.7976931348623157E308 : Double.NaN;
        for (Double x : data) {
            if (!(x > max)) continue;
            max = x;
        }
        this.stats.put(name + "|Max", max);
        Collections.sort(data);
        this.stats.put(name + "|Median", this.calcMedian(data));
        if (data.size() > 2) {
            if (data.size() % 2 == 0) {
                iq1 = this.calcMedian(data.subList(0, data.size() / 2));
                iq3 = this.calcMedian(data.subList(data.size() / 2, data.size()));
            } else {
                iq1 = this.calcMedian(data.subList(0, (int)Math.ceil(data.size() / 2)));
                iq3 = this.calcMedian(data.subList((int)Math.floor(data.size() / 2), data.size()));
            }
        } else {
            iq3 = Double.NaN;
            iq1 = Double.NaN;
        }
        this.stats.put(name + "|Quartile1", iq1);
        this.stats.put(name + "|Quartile3", iq3);
        HashMap<Double, Integer> modeMap = new HashMap<Double, Integer>();
        for (Double x : data) {
            if (modeMap.get(x) != null) {
                modeMap.put(x, (Integer)modeMap.get(x) + 1);
                continue;
            }
            modeMap.put(x, 1);
        }
        double mode = modeMap.size() > 0 ? Double.MIN_VALUE : Double.NaN;
        int count = 0;
        for (Double x : modeMap.keySet()) {
            if ((Integer)modeMap.get(x) == count && x > mode) {
                mode = x;
                continue;
            }
            if ((Integer)modeMap.get(x) <= count) continue;
            mode = x;
            count = (Integer)modeMap.get(x);
        }
        this.stats.put(name + "|Mode", mode);
    }

    private double calcMedian(List<Double> data) {
        if (data.size() == 0) {
            return Double.NaN;
        }
        if (data.size() % 2 == 0) {
            double median = data.get(data.size() / 2 - 1);
            return (median += data.get(data.size() / 2).doubleValue()) / 2.0;
        }
        return data.get((int)Math.floor(data.size() / 2));
    }

    protected void calculateStatistics(NgramStatsResult result) throws Exception {
        this.sanityCheck();
        this.stats.put("Occurrences", Double.valueOf(this.ngrams.size()));
        HashMap<String, Integer> files = new HashMap<String, Integer>();
        for (Ngram n : this.ngrams) {
            files.put(n.filePath, 1);
        }
        this.stats.put("File Occurrences", Double.valueOf(files.size()));
        ArrayList<Double> duration = new ArrayList<Double>();
        for (Ngram n : this.ngrams) {
            duration.add((double)n.duration.longValue() / 1000.0);
        }
        this.calcDescriptiveStats("Duration", duration);
        if (this.ngramSize > 1) {
            ArrayList<Double> annTime = new ArrayList<Double>();
            for (Ngram n : this.ngrams) {
                annTime.add((double)n.totalAnnotationTime.longValue() / 1000.0);
            }
            this.calcDescriptiveStats("Total Annotation Time", annTime);
        }
        if (this.ngramSize > 1) {
            ArrayList<Double> intTime = new ArrayList<Double>();
            for (Ngram n : this.ngrams) {
                intTime.add((double)n.totalIntervalTime.longValue() / 1000.0);
            }
            this.calcDescriptiveStats("Total Interval Time", intTime);
        }
        ArrayList<Double> latency = new ArrayList<Double>();
        for (Ngram n : this.ngrams) {
            latency.add((double)n.annotations.get((int)0).beginTime / 1000.0);
        }
        this.calcDescriptiveStats("Latency", latency);
        ArrayList<Double> interval = new ArrayList<Double>();
        int first = 0;
        int last = 0;
        for (Ngram n : this.ngrams) {
            if (n.annotations.get((int)0).hasBeforeInterval) {
                interval.add((double)n.annotations.get((int)0).beforeInterval / 1000.0);
                continue;
            }
            ++first;
        }
        this.calcDescriptiveStats("Before Interval", interval);
        this.stats.put("First N-gram", Double.valueOf(first));
        interval.clear();
        for (Ngram n : this.ngrams) {
            if (n.annotations.get((int)(n.annotations.size() - 1)).hasAfterInterval) {
                interval.add((double)n.annotations.get((int)(n.annotations.size() - 1)).afterInterval / 1000.0);
                continue;
            }
            ++last;
        }
        this.calcDescriptiveStats("After Interval", interval);
        this.stats.put("Last N-gram", Double.valueOf(last));
        ArrayList<Double> pos = new ArrayList<Double>();
        for (Ngram n : this.ngrams) {
            pos.add(Double.valueOf(n.position));
        }
        this.calcDescriptiveStats("N-gram Position", pos);
        if (this.ngramSize == 2) {
            this.createContingencyTable(result);
        }
    }

    private void analyzeContingencyTable() {
        HashMap<Integer, Double> probabilities;
        Integer k;
        double chi = this.calcDeviation(this.cT[0][0], this.cT_exp[0][0]);
        chi += this.calcDeviation(this.cT[0][1], this.cT_exp[0][1]);
        chi += this.calcDeviation(this.cT[1][0], this.cT_exp[1][0]);
        this.stats.put("cT|Chi-squared", chi += this.calcDeviation(this.cT[1][1], this.cT_exp[1][1]));
        this.stats.put("cT|Phi Coefficient", chi / (double)this.cT[2][2]);
        this.stats.put("cT|T-score", ((double)this.cT[0][0] - this.cT_exp[0][0]) / Math.sqrt(this.cT[0][0]));
        double dice = (double)(2 * this.cT[0][0]) / (double)(this.cT[0][2] + this.cT[2][0]);
        this.stats.put("cT|Dice Coefficient", dice);
        this.stats.put("cT|Jaccard Coefficient", dice / (2.0 - dice));
        double ll = (double)this.cT[0][0] * this.calcPMI(this.cT[0][0], this.cT_exp[0][0]);
        ll += (double)this.cT[0][1] * this.calcPMI(this.cT[0][1], this.cT_exp[0][1]);
        ll += (double)this.cT[1][0] * this.calcPMI(this.cT[1][0], this.cT_exp[1][0]);
        this.stats.put("cT|Log-likelihood", 2.0 * (ll += (double)this.cT[1][1] * this.calcPMI(this.cT[1][1], this.cT_exp[1][1])));
        this.stats.put("cT|Pointwise Mutual Information", this.calcPMI(this.cT[0][0], this.cT_exp[0][0]) / Math.log(2.0));
        this.stats.put("cT|Poisson-Stirling Measure", (double)this.cT[0][0] * (this.calcPMI(this.cT[0][0], this.cT_exp[0][0]) - 1.0));
        double tmi = (double)this.cT[0][0] / (double)this.cT[2][2] * this.calcPMI(this.cT[0][0], this.cT_exp[0][0]) / Math.log(2.0);
        tmi += (double)this.cT[0][1] / (double)this.cT[2][2] * this.calcPMI(this.cT[0][1], this.cT_exp[0][1]) / Math.log(2.0);
        tmi += (double)this.cT[1][0] / (double)this.cT[2][2] * this.calcPMI(this.cT[1][0], this.cT_exp[1][0]) / Math.log(2.0);
        this.stats.put("cT|True Mutual Information", tmi += (double)this.cT[1][1] / (double)this.cT[2][2] * this.calcPMI(this.cT[1][1], this.cT_exp[1][1]) / Math.log(2.0));
        int n21 = this.cT[1][0] == 0 ? 1 : this.cT[1][0];
        int n12 = this.cT[0][1] == 0 ? 1 : this.cT[0][1];
        this.stats.put("cT|Odds Ratio", (double)(this.cT[0][0] * this.cT[1][1]) / (double)(n12 * n21));
        int start_range = this.cT[0][2] + this.cT[2][0] - this.cT[2][2];
        if (start_range < 0) {
            start_range = 0;
        }
        HashMap<Integer, Double> probabilities2 = this.calcDistribution(start_range, this.cT[0][0]);
        ArrayList<Integer> keys = new ArrayList<Integer>(probabilities2.keySet());
        Collections.sort(keys);
        double leftfisher = 0.0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext() && (k = (Integer)iterator.next()) <= this.cT[0][0]) {
            leftfisher += probabilities2.get(k).doubleValue();
        }
        this.stats.put("cT|Fisher Exact Left Sided", leftfisher);
        boolean left_flag = false;
        int final_limit = this.cT[0][2] < this.cT[2][0] ? this.cT[0][2] : this.cT[2][0];
        int n11_start = this.cT[0][2] + this.cT[2][0] - this.cT[2][2];
        if (n11_start < this.cT[0][0]) {
            n11_start = this.cT[0][0];
        }
        int left_final_limit = this.cT[0][0] - 1;
        int left_n11 = this.cT[0][2] + this.cT[2][0] - this.cT[2][2];
        if (left_n11 < 0) {
            left_n11 = 0;
        }
        if (left_final_limit - left_n11 < final_limit - n11_start) {
            left_flag = true;
            probabilities = this.calcDistribution(left_n11, left_final_limit);
        } else {
            probabilities = this.calcDistribution(n11_start, final_limit);
        }
        ArrayList<Integer> keys2 = new ArrayList<Integer>(probabilities.keySet());
        Collections.sort(keys2, Collections.reverseOrder());
        double rightfisher = 0.0;
        for (Integer k2 : keys2) {
            if (left_flag ? k2 >= this.cT[0][0] : k2 < this.cT[0][0]) break;
            rightfisher += probabilities.get(k2).doubleValue();
        }
        if (left_flag) {
            rightfisher = 1.0 - rightfisher;
        }
        this.stats.put("cT|Fisher Exact Right Sided", rightfisher);
        int final_limit2 = this.cT[0][2] < this.cT[2][0] ? this.cT[0][2] : this.cT[2][0];
        int n11_start2 = this.cT[0][2] + this.cT[2][0] - this.cT[2][2];
        if (n11_start2 < 0) {
            n11_start2 = 0;
        }
        HashMap<Integer, Double> probabilities3 = this.calcDistribution(n11_start2, final_limit2);
        ArrayList<Double> values = new ArrayList<Double>(probabilities3.values());
        Collections.sort(values);
        double ttfisher = 0.0;
        for (Double v : values) {
            if (!(v <= probabilities3.get(this.cT[0][0]))) continue;
            ttfisher += v.doubleValue();
        }
        this.stats.put("cT|Fisher Exact Two Tailed", ttfisher);
    }

    private HashMap<Integer, Double> calcDistribution(int start, int end) {
        HashMap<Integer, Double> rv = new HashMap<Integer, Double>();
        int n11 = start;
        int n12 = this.cT[0][2] - n11;
        int n21 = this.cT[2][0] - n11;
        int n22 = this.cT[1][2] - n21;
        while (n22 < 0) {
            n12 = this.cT[0][2] - ++n11;
            n21 = this.cT[2][0] - n11;
            n22 = this.cT[1][2] - n21;
        }
        for (int i = n11; i <= end; ++i) {
            n12 = this.cT[0][2] - i;
            n21 = this.cT[2][0] - i;
            n22 = this.cT[1][2] - n21;
            rv.put(i, this.calcHypergeometric(i, n12, n21, n22));
        }
        return rv;
    }

    private double calcHypergeometric(int n11, int n12, int n21, int n22) {
        ArrayList nums = new ArrayList();
        Collections.addAll(nums, this.cT[0][2], this.cT[1][2], this.cT[2][0], this.cT[2][1]);
        Collections.sort(nums, Collections.reverseOrder());
        ArrayList dems = new ArrayList();
        Collections.addAll(dems, this.cT[2][2], n11, n12, n21, n22);
        Collections.sort(dems, Collections.reverseOrder());
        double product = 1.0;
        ArrayList<Integer> dLimits = new ArrayList<Integer>();
        ArrayList<Integer> nLimits = new ArrayList<Integer>();
        int dIndex = 0;
        int nIndex = 0;
        for (int i = 0; i < 4; ++i) {
            if ((Integer)nums.get(i) > (Integer)dems.get(i)) {
                nLimits.add(nIndex++, (Integer)dems.get(i) + 1);
                nLimits.add(nIndex++, (Integer)nums.get(i));
                continue;
            }
            if ((Integer)dems.get(i) <= (Integer)nums.get(i)) continue;
            dLimits.add(dIndex++, (Integer)nums.get(i) + 1);
            dLimits.add(dIndex++, (Integer)dems.get(i));
        }
        dLimits.add(dIndex++, 1);
        dLimits.add(dIndex, (Integer)dems.get(4));
        while (!nLimits.isEmpty()) {
            while (product < 1.0E7 && !nLimits.isEmpty()) {
                product *= (double)((Integer)nLimits.get(0)).intValue();
                nLimits.set(0, (Integer)nLimits.get(0) + 1);
                if ((Integer)nLimits.get(0) <= (Integer)nLimits.get(1)) continue;
                nLimits.remove(0);
                nLimits.remove(0);
            }
            while (product > 1.0) {
                product /= (double)((Integer)dLimits.get(0)).intValue();
                dLimits.set(0, (Integer)dLimits.get(0) + 1);
                if ((Integer)dLimits.get(0) <= (Integer)dLimits.get(1)) continue;
                dLimits.remove(0);
                dLimits.remove(0);
            }
        }
        while (!dLimits.isEmpty()) {
            product /= (double)((Integer)dLimits.get(0)).intValue();
            dLimits.set(0, (Integer)dLimits.get(0) + 1);
            if ((Integer)dLimits.get(0) <= (Integer)dLimits.get(1)) continue;
            dLimits.remove(0);
            dLimits.remove(0);
        }
        return product;
    }

    private double calcPMI(double n, double m) {
        if (n > 0.0) {
            return Math.log(n / m);
        }
        return 0.0;
    }

    private double calcDeviation(double n, double m) {
        if (m > 0.0) {
            return Math.pow(n - m, 2.0) / m;
        }
        return 0.0;
    }

    private void createContingencyTable(NgramStatsResult result) throws Exception {
        this.cT = new int[3][3];
        this.cT[0][0] = this.ngrams.size();
        this.cT[2][2] = result.getNumNgrams();
        String a1 = this.ngrams.get((int)0).annotations.get((int)0).value;
        String a2 = this.ngrams.get((int)0).annotations.get((int)1).value;
        List<Ngram> a1List = result.findNgramsWithAnnotation(a1);
        ArrayList<Ngram> a1NOa2 = new ArrayList<Ngram>();
        for (Ngram n : a1List) {
            if (!n.annotations.get((int)0).value.equals(a1) || n.annotations.get((int)1).value.equals(a2)) continue;
            a1NOa2.add(n);
        }
        this.cT[0][1] = a1NOa2.size();
        List<Ngram> a2List = result.findNgramsWithAnnotation(a2);
        ArrayList<Ngram> a2NOa1 = new ArrayList<Ngram>();
        for (Ngram n : a2List) {
            if (!n.annotations.get((int)1).value.equals(a2) || n.annotations.get((int)0).value.equals(a1)) continue;
            a2NOa1.add(n);
        }
        this.cT[1][0] = a2NOa1.size();
        this.cT[1][1] = this.cT[2][2] - (this.cT[0][0] + this.cT[0][1] + this.cT[1][0]);
        this.cT[0][2] = this.cT[0][0] + this.cT[0][1];
        this.cT[1][2] = this.cT[1][0] + this.cT[1][1];
        this.cT[2][0] = this.cT[0][0] + this.cT[1][0];
        this.cT[2][1] = this.cT[0][1] + this.cT[1][1];
        this.cT_exp = new double[2][2];
        this.cT_exp[0][0] = (double)(this.cT[0][2] * this.cT[2][0]) / (double)this.cT[2][2];
        this.cT_exp[0][1] = (double)(this.cT[0][2] * this.cT[2][1]) / (double)this.cT[2][2];
        this.cT_exp[1][0] = (double)(this.cT[1][2] * this.cT[2][0]) / (double)this.cT[2][2];
        this.cT_exp[1][1] = (double)(this.cT[1][2] * this.cT[2][1]) / (double)this.cT[2][2];
        this.sanityCheckContingencyTable();
        this.analyzeContingencyTable();
    }

    private void sanityCheckContingencyTable() throws Exception {
        if (this.cT[0][0] + this.cT[0][1] + this.cT[1][0] + this.cT[1][1] != this.cT[2][2]) {
            throw new Exception("sum of cells != total" + this.toString());
        }
        if (this.cT[0][0] <= 0) {
            throw new Exception("n11 with no hits" + this.toString());
        }
        if (this.cT[0][0] > this.cT[2][2]) {
            throw new Exception("n11 > npp" + this.toString());
        }
        if (this.cT[0][0] > this.cT[2][0] || this.cT[0][0] > this.cT[0][2]) {
            throw new Exception("n11 > np1 || n11 > np1" + this.toString());
        }
        if (this.cT[0][1] < 0) {
            throw new Exception("n12 < 0" + this.toString());
        }
        if (this.cT[1][0] < 0) {
            throw new Exception("n21 < 0" + this.toString());
        }
        if (this.cT[1][1] < 0) {
            throw new Exception("n22 < 0" + this.toString());
        }
        if (this.cT[0][2] < 1 || this.cT[0][2] > this.cT[2][2]) {
            throw new Exception("n1p < 1 || > npp" + this.toString());
        }
        if (this.cT[2][0] < 1 || this.cT[2][0] > this.cT[2][2]) {
            throw new Exception("np1 < 1 || > npp" + this.toString());
        }
        if (this.cT[1][2] != this.cT[2][2] - this.cT[0][2]) {
            throw new Exception("n2p != npp-n1p" + this.toString());
        }
        if (this.cT[2][1] != this.cT[2][2] - this.cT[2][0]) {
            throw new Exception("np2 != npp-np1" + this.toString());
        }
        if (this.cT[0][0] > 0 && this.cT_exp[0][0] == 0.0) {
            throw new Exception("m11 == 0" + this.toString());
        }
        if (this.cT[0][1] > 0 && this.cT_exp[0][1] == 0.0) {
            throw new Exception("m12 == 0" + this.toString());
        }
        if (this.cT[1][0] > 0 && this.cT_exp[1][0] == 0.0) {
            throw new Exception("m21 == 0" + this.toString());
        }
        if (this.cT[1][1] > 0 && this.cT_exp[1][1] == 0.0) {
            throw new Exception("m22 == 0" + this.toString());
        }
        if (this.cT_exp[0][0] < 0.0) {
            throw new Exception("m11 < 0" + this.toString());
        }
        if (this.cT_exp[0][1] < 0.0) {
            throw new Exception("m12 < 0" + this.toString());
        }
        if (this.cT_exp[1][0] < 0.0) {
            throw new Exception("m21 < 0" + this.toString());
        }
        if (this.cT_exp[1][1] < 0.0) {
            throw new Exception("m22 < 0" + this.toString());
        }
    }

    public List<String> toCSVColumns() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("N-gram");
        ArrayList<String> sortedKeys = new ArrayList<String>(this.stats.keySet());
        Collections.sort(sortedKeys);
        rv.addAll(sortedKeys);
        return rv;
    }

    public String toCSV(String d) {
        StringBuilder rv = new StringBuilder();
        rv.append(this.getName() + d);
        ArrayList<String> sortedKeys = new ArrayList<String>(this.stats.keySet());
        Collections.sort(sortedKeys);
        Iterator itr = sortedKeys.iterator();
        while (itr.hasNext()) {
            rv.append(this.stats.get((String)itr.next()));
            if (!itr.hasNext()) continue;
            rv.append(d);
        }
        return rv.toString();
    }

    public String toString() {
        StringBuilder rv = new StringBuilder();
        rv.append("\n NgramCollection(" + this.getName() + ")");
        ArrayList<String> sortedKeys = new ArrayList<String>(this.stats.keySet());
        Collections.sort(sortedKeys);
        for (String k : sortedKeys) {
            rv.append("\n\t " + k + ": " + this.stats.get(k));
        }
        try {
            rv.append("\n\t cT: n11=" + this.cT[0][0]);
            rv.append("\n\t cT: n12=" + this.cT[0][1]);
            rv.append("\n\t cT: n21=" + this.cT[1][0]);
            rv.append("\n\t cT: n22=" + this.cT[1][1]);
            rv.append("\n\t cT: n1p=" + this.cT[0][2]);
            rv.append("\n\t cT: n2p=" + this.cT[1][2]);
            rv.append("\n\t cT: np1=" + this.cT[2][0]);
            rv.append("\n\t cT: np2=" + this.cT[2][1]);
            rv.append("\n\t cT: npp=" + this.cT[2][2]);
            rv.append("\n\t cT_exp m11=" + this.cT_exp[0][0]);
            rv.append("\n\t cT_exp m12=" + this.cT_exp[0][1]);
            rv.append("\n\t cT_exp m21=" + this.cT_exp[1][0]);
            rv.append("\n\t cT_exp m22=" + this.cT_exp[1][1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rv.toString();
    }
}

