/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.ngramstats;

import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ngramstats.NgramCollection;
import mpi.eudico.client.annotator.ngramstats.NgramStatsResult;

public class NgramStatsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3664457083389501427L;
    private NgramStatsResult result;
    private final String[] tableColumns = new String[]{ElanLocale.getString("Statistics.NGram"), ElanLocale.getString("Statistics.Occurrences"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageAnnotationTime"), ElanLocale.getString("Statistics.AverageIntervalTime")};

    public NgramStatsTableModel(NgramStatsResult r) {
        this.result = r;
    }

    public NgramStatsResult getResult() {
        return this.result;
    }

    @Override
    public String getColumnName(int col) {
        return this.tableColumns[col];
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.length;
    }

    @Override
    public int getRowCount() {
        if (this.result != null) {
            return this.result.getNumCollectedNgrams();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.result != null) {
            NgramCollection nc = this.result.getCollectedNgramAt(row);
            switch (col) {
                case 0: {
                    return nc.getName();
                }
                case 1: {
                    return nc.getOccurrences();
                }
                case 2: {
                    return nc.getAvgDuration();
                }
                case 3: {
                    return nc.getMinDuration();
                }
                case 4: {
                    return nc.getMaxDuration();
                }
                case 5: {
                    return nc.getAvgAnnotationTime();
                }
                case 6: {
                    return nc.getAvgIntervalTime();
                }
            }
            return null;
        }
        return null;
    }
}

