/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.WritableImage;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaMarkerEvent;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.media.Track;
import javafx.scene.media.VideoTrack;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.jfx.JFXVideoPanel;

public class JFXMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ActionListener,
VideoFrameGrabber {
    private MediaDescriptor mediaDescriptor;
    private Media media;
    private MediaPlayer mediaPlayer;
    private JFXVideoPanel jfxVideoPanel;
    private MediaView mediaView;
    private ElanLayoutManager layoutManager;
    private long offset = 0L;
    private boolean playingInterval;
    private long intervalStopTime;
    private MarkerHandler intervalMarkerHandler;
    private IntervalStopHandler intervalStopHandler;
    private int intervalSleepTime = 10;
    private boolean isInited = false;
    private float cachedVolume = 1.0f;
    private float cachedRate = 1.0f;
    private float curSubVolume;
    private boolean mute;
    private long duration;
    private long origDuration;
    private float origAspectRatio = 0.0f;
    private float aspectRatio = 0.0f;
    private boolean isWavPlayer = true;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private boolean frameStepsToFrameBegin = false;
    private double milliSecondsPerSample;
    private boolean frameRateAutoDetected = false;
    private boolean detached;
    private final String SEL_STOP = "SEL_STOP";
    private static final Logger LOG = Logger.getLogger("JFX");

    public JFXMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        String mediaURLString;
        if (mediaDescriptor == null) {
            throw new NoPlayerException("The media descriptor is null");
        }
        this.mediaDescriptor = mediaDescriptor;
        this.offset = mediaDescriptor.timeOrigin;
        try {
            mediaURLString = this.toSupportedMediaURLString(mediaDescriptor.mediaURL);
        }
        catch (Exception ex) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Could not create a valid URL for the media: " + ex.getMessage());
            }
            throw new NoPlayerException(ex.getMessage());
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("JFXMediaPlayer URL: " + mediaURLString);
        }
        this.jfxVideoPanel = new JFXVideoPanel();
        try {
            this.media = new Media(mediaURLString);
            if (this.media.getError() != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("JFXMediaPlayer error: " + this.media.getError().getMessage());
                }
                throw new NoPlayerException("JFXMediaPlayer cannot handle the file: " + this.media.getError().getMessage());
            }
        }
        catch (MediaException me) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("JFXMediaPlayer Media Exception: " + me.getMessage());
            }
            throw new NoPlayerException("JFXMediaPlayer cannot handle the file: " + me.getMessage());
        }
        try {
            this.mediaPlayer = new MediaPlayer(this.media);
            this.mediaPlayer.setOnEndOfMedia(() -> this.handleEndOfMedia());
            if (this.mediaPlayer.getError() != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("JFXMediaPlayer error: " + this.mediaPlayer.getError().getMessage());
                }
                throw new NoPlayerException("JFXMediaPlayer cannot handle the file: " + this.mediaPlayer.getError().getMessage());
            }
        }
        catch (MediaException me) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("JFXMediaPlayer Media Exception: " + me.getMessage());
            }
            me.printStackTrace();
            throw new NoPlayerException("JFXMediaPlayer cannot handle the file: " + me.getMessage());
        }
        this.mediaPlayer.setOnReady(() -> {
            for (Track tr : this.mediaPlayer.getMedia().getTracks()) {
                if (!(tr instanceof VideoTrack)) continue;
                this.isWavPlayer = false;
            }
            this.printMediaInfo(this.mediaPlayer.getMedia());
            if (!this.isWavPlayer) {
                MouseHandler mh = new MouseHandler();
                this.jfxVideoPanel.addMouseListener(mh);
                this.jfxVideoPanel.addMouseMotionListener(mh);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOG.info("Setting up the Scene.");
                            JFXMediaPlayer.this.addScene(JFXMediaPlayer.this.mediaPlayer);
                        }
                        catch (MediaException me) {
                            LOG.warning("Add Scene Media Exception: " + me.getMessage());
                        }
                    }
                });
            } else {
                this.isInited = true;
            }
            this.mediaPlayer.setStopTime(new Duration(this.mediaPlayer.getMedia().getDuration().toMillis() - 220.0));
        });
    }

    private void addScene(MediaPlayer player) {
        this.mediaView = new MediaView(this.mediaPlayer);
        Group root = new Group();
        Scene scene = new Scene((Parent)root);
        root.getChildren().add((Object)this.mediaView);
        this.jfxVideoPanel.setScene(scene);
        this.isInited = true;
    }

    private String toSupportedMediaURLString(String mediaURLString) throws URISyntaxException, MalformedURLException, ProtocolException {
        URI mediaURI = new URI(mediaURLString);
        URL mediaURL = mediaURI.toURL();
        if (!mediaURL.getProtocol().equalsIgnoreCase("file") && !mediaURL.getProtocol().equalsIgnoreCase("http")) {
            throw new ProtocolException("JFX Media only supports the FILE and HTTP protocols, not: " + mediaURL.getProtocol());
        }
        return mediaURL.toString();
    }

    private void printMediaInfo(Media media) {
        StringBuilder sb = new StringBuilder("Media Information:\n");
        if (media.getMetadata().size() > 0) {
            for (Map.Entry entry : media.getMetadata().entrySet()) {
                sb.append((String)entry.getKey() + ": " + entry.getValue() + "\n");
                if (!((String)entry.getKey()).equals("framerate") || !(entry.getValue() instanceof Double)) continue;
                this.milliSecondsPerSample = 1.0 / (Double)entry.getValue();
                this.frameRateAutoDetected = true;
            }
        }
        for (Track track : media.getTracks()) {
            sb.append("Track: " + track.getTrackID() + " " + track.getName() + "\n");
            for (Map.Entry entry : track.getMetadata().entrySet()) {
                sb.append((String)entry.getKey() + ": " + entry.getValue() + "\n");
            }
        }
        LOG.info(sb.toString());
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public void start() {
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.getStatus() == MediaPlayer.Status.PAUSED || this.mediaPlayer.getStatus() == MediaPlayer.Status.READY) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Play Request Time: " + this.getMediaTime());
                }
                this.startControllers();
                this.mediaPlayer.play();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Started At: " + this.getMediaTime());
                }
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot start player, status is: " + this.mediaPlayer.getStatus());
            }
        }
    }

    @Override
    public void stop() {
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Pause Request Time: " + this.getMediaTime());
                }
                if (this.intervalStopHandler != null) {
                    this.intervalStopHandler.setStopped();
                    this.intervalStopHandler = null;
                }
                long curTime = this.getMediaTime();
                this.stopControllers();
                this.mediaPlayer.pause();
                long st = System.currentTimeMillis();
                while (this.mediaPlayer.getStatus() != MediaPlayer.Status.PAUSED) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - st <= 2000L) continue;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.info("Paused At: " + this.getMediaTime());
                }
                this.setMediaTime(curTime);
                this.playingInterval = false;
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot pause player, status is: " + this.mediaPlayer.getStatus());
            }
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING;
        }
        return false;
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.mediaPlayer != null) {
            if (this.isPlaying()) {
                this.mediaPlayer.pause();
            }
            this.setStopTime(stopTime);
            if (this.getMediaTime() != startTime) {
                this.mediaPlayer.seek(new Duration((double)(startTime + this.offset)));
            }
            this.startInterval();
        }
    }

    void startInterval() {
        if (this.mediaPlayer != null) {
            if (this.intervalStopHandler != null && this.intervalStopHandler.isAlive()) {
                this.intervalStopHandler.setStopped();
            }
            this.intervalStopHandler = new IntervalStopHandler(this.intervalStopTime, this.intervalSleepTime);
            this.playingInterval = true;
            this.mediaPlayer.play();
            this.startControllers();
            this.intervalStopHandler.start();
        }
    }

    @Override
    public boolean isPlayingInterval() {
        return this.playingInterval;
    }

    @Override
    public void setStopTime(long stopTime) {
        long nFrames;
        double msps;
        this.intervalStopTime = stopTime;
        if (this.mediaPlayer != null && (msps = this.getMilliSecondsPerSample()) != 0.0 && (long)Math.ceil((double)(nFrames = (long)((double)(this.intervalStopTime + this.offset) / msps)) * msps) == this.intervalStopTime + this.offset) {
            ++this.intervalStopTime;
        }
        this.setControllersStopTime(this.intervalStopTime);
    }

    private void handleEndOfMedia() {
        LOG.warning("Player status is: " + this.mediaPlayer.getStatus());
        this.mediaPlayer.pause();
        this.stopControllers();
        this.mediaPlayer.seek(this.mediaPlayer.getCurrentTime());
        this.mediaPlayer.pause();
    }

    @Override
    public void setOffset(long offset) {
        long diff = this.offset - offset;
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.mediaPlayer != null) {
            if (this.origDuration == 0L) {
                this.origDuration = (long)this.mediaPlayer.getTotalDuration().toMillis();
            }
            this.duration = this.origDuration - offset;
        }
        this.setStopTime(this.intervalStopTime + diff);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void nextFrame() {
        if (this.mediaPlayer != null) {
            double nextMediaTime;
            if (this.isPlaying()) {
                this.stop();
            }
            double currentMediaTime = this.mediaPlayer.getCurrentTime().toMillis();
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)(currentMediaTime / this.getMilliSecondsPerSample());
                nextMediaTime = (double)(curFrame + 1L) * this.getMilliSecondsPerSample() + 1.0;
            } else {
                nextMediaTime = currentMediaTime + this.getMilliSecondsPerSample();
            }
            if (nextMediaTime < (double)this.getMediaDuration()) {
                this.mediaPlayer.seek(new Duration(nextMediaTime));
                this.setControllersMediaTime((long)nextMediaTime);
            } else {
                this.mediaPlayer.seek(new Duration((double)this.getMediaDuration()));
                this.setControllersMediaTime(this.getMediaDuration());
            }
        }
    }

    @Override
    public void previousFrame() {
        if (this.mediaPlayer != null) {
            double nextMediaTime;
            if (this.isPlaying()) {
                this.stop();
            }
            double currentMediaTime = this.mediaPlayer.getCurrentTime().toMillis();
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)(currentMediaTime / this.getMilliSecondsPerSample());
                nextMediaTime = (double)(curFrame - 1L) * this.getMilliSecondsPerSample() + 1.0;
            } else {
                nextMediaTime = currentMediaTime - this.getMilliSecondsPerSample();
            }
            if (nextMediaTime >= 0.0) {
                this.mediaPlayer.seek(new Duration(nextMediaTime));
                this.setControllersMediaTime((long)nextMediaTime);
            } else {
                this.mediaPlayer.seek(new Duration(0.0));
                this.setControllersMediaTime(0L);
            }
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public void setMediaTime(long time) {
        if (this.mediaPlayer != null) {
            if (this.isPlaying()) {
                this.mediaPlayer.pause();
            }
            this.mediaPlayer.seek(new Duration((double)(time + this.offset)));
            this.setControllersMediaTime(time);
        }
    }

    @Override
    public long getMediaTime() {
        if (this.mediaPlayer != null) {
            return (long)this.mediaPlayer.getCurrentTime().toMillis() - this.offset;
        }
        return 0L;
    }

    @Override
    public void setRate(float rate) {
        if (!this.isInited) {
            this.cachedRate = rate;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setRate((double)rate);
        }
        this.setControllersRate(rate);
    }

    @Override
    public float getRate() {
        if (this.mediaPlayer != null) {
            return (long)this.mediaPlayer.getRate();
        }
        return 0.0f;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    @Override
    public long getMediaDuration() {
        if (this.duration <= 0L && this.media != null) {
            if (this.origDuration == 0L) {
                this.origDuration = (long)this.media.getDuration().toMillis();
            }
            this.duration = this.origDuration - this.offset;
        }
        return this.duration;
    }

    @Override
    public float getVolume() {
        if (this.mediaPlayer != null) {
            return (float)this.mediaPlayer.getVolume();
        }
        return 0.0f;
    }

    @Override
    public void setVolume(float level) {
        if (!this.isInited) {
            this.cachedVolume = level;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume((double)level);
        }
    }

    @Override
    public void setSubVolume(float level) {
        this.curSubVolume = level;
    }

    @Override
    public float getSubVolume() {
        return this.curSubVolume;
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        if (this.layoutManager != null) {
            this.detached = !this.layoutManager.isAttached(this);
        }
    }

    @Override
    public Component getVisualComponent() {
        if (this.isInited) {
            if (this.isWavPlayer) {
                return null;
            }
            return this.jfxVideoPanel;
        }
        long curTime = System.currentTimeMillis();
        while (!this.isInited) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= curTime + 4000L) continue;
            break;
        }
        return this.jfxVideoPanel;
    }

    @Override
    public int getSourceWidth() {
        if (this.media != null) {
            return this.media.getWidth();
        }
        return 0;
    }

    @Override
    public int getSourceHeight() {
        if (this.media != null) {
            return this.media.getHeight();
        }
        return 0;
    }

    @Override
    public float getAspectRatio() {
        int h;
        if (this.aspectRatio != 0.0f) {
            return this.aspectRatio;
        }
        if (this.media != null && (h = this.media.getHeight()) != 0) {
            this.aspectRatio = this.origAspectRatio = (float)this.media.getWidth() / (float)h;
            return this.aspectRatio;
        }
        return 0.0f;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        if (this.mediaView != null) {
            this.mediaView.setPreserveRatio(false);
        }
        this.aspectRatio = aspectRatio;
    }

    @Override
    public double getMilliSecondsPerSample() {
        if (this.milliSecondsPerSample == 0.0) {
            return 40.0;
        }
        return this.milliSecondsPerSample;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.milliSecondsPerSample = milliSeconds;
        }
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.Attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
            }
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
            this.durationItem.setText(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        }
    }

    @Override
    public String getFrameworkDescription() {
        return "Java FX Media Player";
    }

    @Override
    public void cleanUpOnClose() {
        if (this.mediaPlayer != null) {
            this.stop();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFXMediaPlayer.this.mediaPlayer.stop();
                    if (JFXMediaPlayer.this.jfxVideoPanel != null) {
                        JFXMediaPlayer.this.jfxVideoPanel.setScene(null);
                    }
                    JFXMediaPlayer.this.mediaPlayer.dispose();
                    JFXMediaPlayer.this.mediaPlayer = null;
                    JFXMediaPlayer.this.mediaView = null;
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.Attach"));
                this.detached = true;
            }
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.saveItem) {
            Image snap = this.getCurrentFrameImage();
            ImageExporter export = new ImageExporter();
            export.exportImage(snap, this.mediaDescriptor.mediaURL, this.getMediaTime() + this.offset);
        }
    }

    private void initPopupMenu() {
        if (this.jfxVideoPanel == null) {
            return;
        }
        this.popup = new JPopupMenu();
        this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.Detach"));
        this.detachItem.addActionListener(this);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(this.duration));
        this.durationItem.setEnabled(false);
        this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
        this.saveItem.addActionListener(this);
        this.popup.add(this.detachItem);
        this.popup.addSeparator();
        this.popup.add(this.saveItem);
        this.popup.add(this.infoItem);
        this.popup.add(this.durationItem);
    }

    @Override
    public Image getCurrentFrameImage() {
        if (this.mediaView != null) {
            double scale = (double)this.mediaPlayer.getMedia().getWidth() / this.mediaView.getBoundsInParent().getWidth();
            Scale transform = new Scale(scale, scale);
            ImageRetriever imageRetr = new ImageRetriever();
            imageRetr.transform = transform;
            Platform.runLater((Runnable)imageRetr);
            long curTime = System.currentTimeMillis();
            while (!imageRetr.ready) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    LOG.warning("Image wait interrupted.");
                }
                if (System.currentTimeMillis() <= curTime + 5000L) continue;
                LOG.warning("Waited more than 5 sec for image, breaking");
                break;
            }
            return imageRetr.bufImg;
        }
        return null;
    }

    @Override
    public Image getFrameImageForTime(long time) {
        return null;
    }

    static {
        try {
            Platform.setImplicitExit((boolean)false);
        }
        catch (Throwable t) {
            LOG.warning("Could not set the JFX Runtime flag for Implicit Exit to false");
        }
    }

    private class IntervalStopHandler
    extends Thread {
        private long curStopTime;
        private int sleepInterval = 250;
        private boolean stopped = false;

        public IntervalStopHandler(long curStopTime, int sleepInterval) {
            if (JFXMediaPlayer.this.intervalStopTime > 0L) {
                this.curStopTime = curStopTime;
            }
            if (sleepInterval > 0) {
                this.sleepInterval = sleepInterval;
            }
        }

        public void setStopped() {
            this.stopped = true;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                long curTime = JFXMediaPlayer.this.getMediaTime();
                MediaPlayer.Status curStatus = JFXMediaPlayer.this.mediaPlayer.getStatus();
                if (curTime >= this.curStopTime) {
                    if (curStatus == MediaPlayer.Status.PAUSED) break;
                    this.stopPlayer();
                    break;
                }
                if (curTime - this.curStopTime < (long)this.sleepInterval) {
                    this.sleepInterval = (int)(this.curStopTime - curTime);
                }
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.stopped) continue;
                return;
            }
        }

        private void stopPlayer() {
            JFXMediaPlayer.this.stop();
        }
    }

    private class ImageRetriever
    implements Runnable {
        BufferedImage bufImg;
        Transform transform;
        boolean ready = false;

        private ImageRetriever() {
        }

        @Override
        public void run() {
            SnapshotParameters snapPar = new SnapshotParameters();
            snapPar.setTransform(this.transform);
            WritableImage snapImg = JFXMediaPlayer.this.mediaView.snapshot(snapPar, null);
            if (snapImg != null) {
                this.bufImg = SwingFXUtils.fromFXImage((javafx.scene.image.Image)snapImg, null);
            }
            this.ready = true;
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (JFXMediaPlayer.this.layoutManager != null) {
                    JFXMediaPlayer.this.layoutManager.setFirstPlayer(JFXMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JFXMediaPlayer.this.popup == null) {
                JFXMediaPlayer.this.initPopupMenu();
            }
            Point cl = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                if (JFXMediaPlayer.this.layoutManager.isAttached(JFXMediaPlayer.this) && JFXMediaPlayer.this.detached) {
                    JFXMediaPlayer.this.detached = false;
                    JFXMediaPlayer.this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
                }
                JFXMediaPlayer.this.durationItem.setText(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(JFXMediaPlayer.this.duration));
                JFXMediaPlayer.this.popup.show(JFXMediaPlayer.this.getVisualComponent(), (int)cl.getX(), (int)cl.getY());
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    public class MarkerHandler
    implements EventHandler<MediaMarkerEvent> {
        public void handle(MediaMarkerEvent mmEvent) {
            if (mmEvent.getMarker().getKey() == "SEL_STOP") {
                JFXMediaPlayer.this.stop();
                System.out.println("Handle marker event: " + JFXMediaPlayer.this.mediaPlayer.getCurrentTime());
            }
        }
    }
}

