/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.player.VideoScaleAndMove;
import mpi.eudico.util.TimeFormatter;

public class VideoMouseAdapter
implements MouseListener,
MouseMotionListener,
ActionListener {
    private ElanMediaPlayer player;
    private VideoScaleAndMove scaledPlayer;
    private ElanLayoutManager layoutManager;
    private Component visualComponent;
    private final DecimalFormat flFormat = new DecimalFormat("#.###");
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JMenu arMenu;
    private JRadioButtonMenuItem origRatioItem;
    private JRadioButtonMenuItem ratio_1_1_Item;
    private JRadioButtonMenuItem ratio_5_4_Item;
    private JRadioButtonMenuItem ratio_4_3_Item;
    private JRadioButtonMenuItem ratio_3_2_Item;
    private JRadioButtonMenuItem ratio_16_10_Item;
    private JRadioButtonMenuItem ratio_16_9_Item;
    private JRadioButtonMenuItem ratio_185_1_Item;
    private JRadioButtonMenuItem ratio_221_1_Item;
    private JRadioButtonMenuItem ratio_235_1_Item;
    private JRadioButtonMenuItem ratio_239_1_Item;
    private JMenuItem copyOrigTimeItem;
    private boolean detached;
    private JMenu zoomMenu;
    private JRadioButtonMenuItem zoom100;
    private JRadioButtonMenuItem zoom150;
    private JRadioButtonMenuItem zoom200;
    private JRadioButtonMenuItem zoom300;
    private JRadioButtonMenuItem zoom400;
    private float videoScaleFactor = 1.0f;
    private int dragX = 0;
    private int dragY = 0;

    public VideoMouseAdapter(ElanMediaPlayer player, ElanLayoutManager layoutManager, Component visualComponent) {
        this.player = player;
        this.layoutManager = layoutManager;
        this.visualComponent = visualComponent;
        this.visualComponent.addMouseListener(this);
        this.visualComponent.addMouseMotionListener(this);
        if (this.player instanceof VideoScaleAndMove) {
            this.scaledPlayer = (VideoScaleAndMove)((Object)this.player);
        }
        this.detached = !layoutManager.isAttached(this.player);
    }

    public void updateVisualComponent(Component nextVisualComponent) {
        this.visualComponent.removeMouseListener(this);
        this.visualComponent.removeMouseMotionListener(this);
        this.visualComponent = nextVisualComponent;
        this.visualComponent.addMouseListener(this);
        this.visualComponent.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (this.scaledPlayer == null) {
            return;
        }
        int dx = this.dragX - e.getX();
        int dy = this.dragY - e.getY();
        this.scaledPlayer.moveVideoPos(-dx, -dy);
        this.dragX = e.getX();
        this.dragY = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            if (this.layoutManager != null) {
                this.layoutManager.setFirstPlayer(this.player);
            }
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (this.scaledPlayer != null) {
            try {
                int[] videoBounds = this.scaledPlayer.getVideoBounds();
                float videoScale = this.scaledPlayer.getVideoScaleFactor();
                int canvasW = e.getComponent().getWidth();
                int canvasH = e.getComponent().getHeight();
                int x = e.getX();
                int y = e.getY();
                int nx = x;
                int ny = y;
                float relX = (float)x / (float)canvasW;
                float relY = (float)y / (float)canvasH;
                if (videoScale > 1.0f) {
                    relX = (float)(nx -= videoBounds[0]) / (float)videoBounds[2];
                    relY = (float)(ny -= videoBounds[1]) / (float)videoBounds[3];
                }
                int sw = this.player.getSourceWidth();
                int sh = this.player.getSourceHeight();
                if (e.isAltDown() && e.isShiftDown()) {
                    this.copyToClipboard(String.format("%d,%d [%d,%d]", x, y, canvasW, canvasH));
                } else if (e.isAltDown()) {
                    this.copyToClipboard(String.format("%s,%s", this.flFormat.format(relX), this.flFormat.format(relY)));
                } else if (e.isShiftDown()) {
                    this.copyToClipboard(String.format("%d,%d", (int)((float)sw / (float)videoBounds[2] * (float)nx), (int)((float)sh / (float)videoBounds[3] * (float)ny)));
                } else {
                    this.copyToClipboard(String.format("%d,%d [%d,%d]", (int)((float)sw / (float)videoBounds[2] * (float)nx), (int)((float)sh / (float)videoBounds[3] * (float)ny), sw, sh));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point cl = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopup();
            }
            if (this.layoutManager.isAttached(this.player) && this.detached) {
                this.detached = false;
                this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
            }
            this.durationItem.setText(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(this.player.getMediaDuration()));
            this.popup.show(this.visualComponent, (int)cl.getX(), (int)cl.getY());
            return;
        }
        this.dragX = (int)cl.getX();
        this.dragY = (int)cl.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.Detach"));
        this.detachItem.addActionListener(this);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(0L));
        this.durationItem.setEnabled(false);
        this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
        this.saveItem.addActionListener(this);
        this.saveItem.setEnabled(this.player instanceof VideoFrameGrabber);
        this.origRatioItem = new JRadioButtonMenuItem(ElanLocale.getString("Player.ResetAspectRatio"), true);
        this.origRatioItem.setActionCommand("ratio_orig");
        this.origRatioItem.addActionListener(this);
        this.ratio_1_1_Item = new JRadioButtonMenuItem("1:1");
        this.ratio_1_1_Item.setActionCommand("ratio_1_1");
        this.ratio_1_1_Item.addActionListener(this);
        this.ratio_5_4_Item = new JRadioButtonMenuItem("5:4");
        this.ratio_5_4_Item.setActionCommand("ratio_5_4");
        this.ratio_5_4_Item.addActionListener(this);
        this.ratio_4_3_Item = new JRadioButtonMenuItem("4:3");
        this.ratio_4_3_Item.setActionCommand("ratio_4_3");
        this.ratio_4_3_Item.addActionListener(this);
        this.ratio_3_2_Item = new JRadioButtonMenuItem("3:2");
        this.ratio_3_2_Item.setActionCommand("ratio_3_2");
        this.ratio_3_2_Item.addActionListener(this);
        this.ratio_16_10_Item = new JRadioButtonMenuItem("16:10");
        this.ratio_16_10_Item.setActionCommand("ratio_16_10");
        this.ratio_16_10_Item.addActionListener(this);
        this.ratio_16_9_Item = new JRadioButtonMenuItem("16:9");
        this.ratio_16_9_Item.setActionCommand("ratio_16_9");
        this.ratio_16_9_Item.addActionListener(this);
        this.ratio_185_1_Item = new JRadioButtonMenuItem("1.85:1");
        this.ratio_185_1_Item.setActionCommand("ratio_185_1");
        this.ratio_185_1_Item.addActionListener(this);
        this.ratio_221_1_Item = new JRadioButtonMenuItem("2.21:1");
        this.ratio_221_1_Item.setActionCommand("ratio_221_1");
        this.ratio_221_1_Item.addActionListener(this);
        this.ratio_235_1_Item = new JRadioButtonMenuItem("2.35:1");
        this.ratio_235_1_Item.setActionCommand("ratio_235_1");
        this.ratio_235_1_Item.addActionListener(this);
        this.ratio_239_1_Item = new JRadioButtonMenuItem("2.39:1");
        this.ratio_239_1_Item.setActionCommand("ratio_239_1");
        this.ratio_239_1_Item.addActionListener(this);
        this.arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
        ButtonGroup arbg = new ButtonGroup();
        arbg.add(this.origRatioItem);
        arbg.add(this.ratio_1_1_Item);
        arbg.add(this.ratio_5_4_Item);
        arbg.add(this.ratio_4_3_Item);
        arbg.add(this.ratio_3_2_Item);
        arbg.add(this.ratio_16_10_Item);
        arbg.add(this.ratio_16_9_Item);
        arbg.add(this.ratio_185_1_Item);
        arbg.add(this.ratio_221_1_Item);
        arbg.add(this.ratio_235_1_Item);
        arbg.add(this.ratio_239_1_Item);
        this.arMenu.add(this.origRatioItem);
        this.arMenu.addSeparator();
        this.arMenu.add(this.ratio_1_1_Item);
        this.arMenu.add(this.ratio_5_4_Item);
        this.arMenu.add(this.ratio_4_3_Item);
        this.arMenu.add(this.ratio_3_2_Item);
        this.arMenu.add(this.ratio_16_10_Item);
        this.arMenu.add(this.ratio_16_9_Item);
        this.arMenu.add(this.ratio_185_1_Item);
        this.arMenu.add(this.ratio_221_1_Item);
        this.arMenu.add(this.ratio_235_1_Item);
        this.arMenu.add(this.ratio_239_1_Item);
        this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        this.copyOrigTimeItem.addActionListener(this);
        this.zoomMenu = new JMenu(ElanLocale.getString("Menu.Zoom"));
        this.zoom100 = new JRadioButtonMenuItem("100%", this.videoScaleFactor == 1.0f);
        this.zoom100.setActionCommand("zoom100");
        this.zoom100.addActionListener(this);
        this.zoom150 = new JRadioButtonMenuItem("150%", (double)this.videoScaleFactor == 1.5);
        this.zoom150.setActionCommand("zoom150");
        this.zoom150.addActionListener(this);
        this.zoom200 = new JRadioButtonMenuItem("200%", this.videoScaleFactor == 2.0f);
        this.zoom200.setActionCommand("zoom200");
        this.zoom200.addActionListener(this);
        this.zoom300 = new JRadioButtonMenuItem("300%", this.videoScaleFactor == 3.0f);
        this.zoom300.setActionCommand("zoom300");
        this.zoom300.addActionListener(this);
        this.zoom400 = new JRadioButtonMenuItem("400%", this.videoScaleFactor == 4.0f);
        this.zoom400.setActionCommand("zoom400");
        this.zoom400.addActionListener(this);
        ButtonGroup zbg = new ButtonGroup();
        zbg.add(this.zoom100);
        zbg.add(this.zoom150);
        zbg.add(this.zoom200);
        zbg.add(this.zoom300);
        zbg.add(this.zoom400);
        this.zoomMenu.add(this.zoom100);
        this.zoomMenu.add(this.zoom150);
        this.zoomMenu.add(this.zoom200);
        this.zoomMenu.add(this.zoom300);
        this.zoomMenu.add(this.zoom400);
        this.zoomMenu.setEnabled(this.scaledPlayer != null);
        this.popup.add(this.detachItem);
        this.popup.addSeparator();
        this.popup.add(this.saveItem);
        this.popup.add(this.infoItem);
        this.popup.add(this.arMenu);
        this.popup.add(this.zoomMenu);
        this.popup.add(this.durationItem);
        this.popup.add(this.copyOrigTimeItem);
    }

    public void updateLocale() {
        if (this.popup != null) {
            if (!this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.Attach"));
            }
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
            this.durationItem.setText(ElanLocale.getString("Player.Duration") + ":  " + TimeFormatter.toString(this.player.getMediaDuration()));
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
            this.arMenu.setText(ElanLocale.getString("Player.ForceAspectRatio"));
            this.origRatioItem.setText(ElanLocale.getString("Player.ResetAspectRatio"));
            this.copyOrigTimeItem.setText(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
            this.zoomMenu.setText(ElanLocale.getString("Menu.Zoom"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.visualComponent);
                this.detachItem.setText(ElanLocale.getString("Detachable.Detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.visualComponent);
                this.detachItem.setText(ElanLocale.getString("Detachable.Attach"));
                this.detached = true;
            }
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this.player);
        } else if (e.getSource() == this.saveItem) {
            Image frameImg = ((VideoFrameGrabber)((Object)this.player)).getCurrentFrameImage();
            ImageExporter imgExporter = new ImageExporter();
            imgExporter.exportImage(frameImg, this.player.getMediaDescriptor().mediaURL, this.player.getMediaTime() + this.player.getOffset());
        } else if (e.getActionCommand().startsWith("ratio")) {
            float aspectRatio = 0.0f;
            if (e.getSource() == this.origRatioItem) {
                if (this.player.getSourceHeight() > 0) {
                    aspectRatio = (float)this.player.getSourceWidth() / (float)this.player.getSourceHeight();
                }
            } else if (e.getSource() == this.ratio_4_3_Item) {
                aspectRatio = 1.33f;
            } else if (e.getSource() == this.ratio_3_2_Item) {
                aspectRatio = 1.66f;
            } else if (e.getSource() == this.ratio_16_9_Item) {
                aspectRatio = 1.78f;
            } else if (e.getSource() == this.ratio_185_1_Item) {
                aspectRatio = 1.85f;
            } else if (e.getSource() == this.ratio_235_1_Item) {
                aspectRatio = 2.35f;
            }
            this.player.setAspectRatio(aspectRatio);
            this.layoutManager.doLayout();
            if (e.getSource() != this.origRatioItem) {
                this.layoutManager.setPreference("AspectRatio(" + this.player.getMediaDescriptor().mediaURL + ")", Float.valueOf(aspectRatio), this.layoutManager.getViewerManager().getTranscription());
            } else {
                this.layoutManager.setPreference("AspectRatio(" + this.player.getMediaDescriptor().mediaURL + ")", null, this.layoutManager.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().startsWith("zoom")) {
            if (e.getSource() == this.zoom100) {
                this.videoScaleFactor = 1.0f;
            } else if (e.getSource() == this.zoom150) {
                this.videoScaleFactor = 1.5f;
            } else if (e.getSource() == this.zoom200) {
                this.videoScaleFactor = 2.0f;
            } else if (e.getSource() == this.zoom300) {
                this.videoScaleFactor = 3.0f;
            } else if (e.getSource() == this.zoom400) {
                this.videoScaleFactor = 4.0f;
            }
            this.scaledPlayer.setVideoScaleFactor(this.videoScaleFactor);
            this.layoutManager.setPreference("VideoZoom(" + this.player.getMediaDescriptor().mediaURL + ")", Float.valueOf(this.videoScaleFactor), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.player.getMediaTime() + this.player.getOffset();
            String timeFormat = Preferences.getString("CurrentTime.Copy.TimeFormat", null);
            String currentTime = null;
            currentTime = timeFormat != null ? (timeFormat.equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : (timeFormat.equals("PAL-50fps") ? TimeFormatter.toTimecodePAL50(t) : Long.toString(t)))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException ssVal) {
            }
            catch (IllegalStateException ssVal) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

