/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.client.annotator.prefs.ObjectPref;
import mpi.eudico.client.annotator.prefs.Pref;
import mpi.eudico.client.annotator.prefs.PrefObjectConverter;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PreferencesReader
extends DefaultHandler {
    private final int BL_TYPE = 0;
    private final int INT_TYPE = 1;
    private final int LONG_TYPE = 2;
    private final int FLOAT_TYPE = 3;
    private final int DOUBLE_TYPE = 4;
    private final int STR_TYPE = 5;
    private final int OBJ_TYPE = 6;
    private SAXParser parser;
    private ArrayList<Pref> preferences;
    private Deque<Map<String, Object>> mapStack;
    private Map<String, Object> curMap;
    private Pref curMapPref;
    private List<Object> curList;
    private Pref curListPref;
    private Pref curPref;
    private ObjectPref curObj;
    private String curKey;
    private String content;
    private int curType = -1;
    private PrefObjectConverter converter = new PrefObjectConverter();
    private boolean parseSuccess = false;

    public PreferencesReader() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema prefSchema = schemaFactory.newSchema(this.getClass().getResource("/mpi/eudico/resources/Prefs_v1.1.xsd"));
            parserFactory.setSchema(prefSchema);
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException se) {
            ClientLogger.LOG.severe("Could not create xml reader: " + se.getMessage());
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.severe("Could not create xml sax parser: " + pce.getMessage());
            pce.printStackTrace();
        }
        this.curMap = null;
        this.curList = null;
        this.content = "";
        this.mapStack = new LinkedList<Map<String, Object>>();
    }

    public boolean isParsingSuccessful() {
        return this.parseSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map parse(String fileName) {
        this.preferences = new ArrayList();
        if (this.parser == null || fileName == null) {
            ClientLogger.LOG.warning("Cannot parse preferences file: " + fileName);
            this.parseSuccess = false;
            return new HashMap(0);
        }
        if (this.curMap != null) {
            this.curMap.clear();
        }
        if (this.curList != null) {
            this.curList.clear();
        }
        this.curPref = null;
        this.curObj = null;
        this.content = "";
        this.mapStack.clear();
        File pf = new File(fileName);
        if (pf.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(pf);
                InputSource source = new InputSource(fis);
                this.parser.parse(source, (DefaultHandler)this);
                ClientLogger.LOG.info("Reading preferences: " + fileName);
                this.parseSuccess = true;
            }
            catch (Exception e) {
                ClientLogger.LOG.warning("Exception while parsing preferences file: " + pf.getAbsolutePath());
                ClientLogger.LOG.warning(e.getMessage());
                this.parseSuccess = false;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
        } else if (fileName.startsWith("http")) {
            InputStream inStream = null;
            try {
                URI fileURI = new URI(fileName);
                HttpURLConnection urlConnect = (HttpURLConnection)fileURI.toURL().openConnection();
                urlConnect.setConnectTimeout(4000);
                urlConnect.setReadTimeout(1000);
                urlConnect.setRequestProperty("Accept", "text/xml+pfsx");
                urlConnect.connect();
                int responseCode = urlConnect.getResponseCode();
                if (responseCode == 200) {
                    inStream = urlConnect.getInputStream();
                    InputSource is = new InputSource(inStream);
                    is.setSystemId(fileName);
                    is.setPublicId(fileName);
                    this.parser.parse(is, (DefaultHandler)this);
                    ClientLogger.LOG.info("Reading remote preferences: " + fileName);
                    this.parseSuccess = true;
                }
                ClientLogger.LOG.warning("Remote preferences file does not exist (" + responseCode + "): " + fileName);
                this.parseSuccess = false;
            }
            catch (Throwable th) {
                ClientLogger.LOG.warning("Exception while parsing remote preferences file: " + fileName);
                ClientLogger.LOG.warning(th.getMessage());
                this.parseSuccess = false;
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable fileURI) {}
            }
        } else {
            ClientLogger.LOG.info("Preferences file does not exist: " + fileName);
            this.parseSuccess = false;
            return new HashMap(0);
        }
        HashMap<String, Object> prefMap = new HashMap<String, Object>(this.preferences.size());
        for (int i = 0; i < this.preferences.size(); ++i) {
            Pref iterPref = this.preferences.get(i);
            if (iterPref.getKey().equals("LastUsedShoeboxMarkers")) continue;
            prefMap.put(iterPref.getKey(), iterPref.getValue());
        }
        return prefMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.content = "";
        if (localName.equals("pref")) {
            if (this.curMap == null) {
                this.curPref = new Pref(atts.getValue("key"), null);
                this.preferences.add(this.curPref);
            } else {
                this.curKey = atts.getValue("key");
            }
        } else if (localName.equals("prefGroup")) {
            this.curMap = new HashMap<String, Object>();
            if (this.mapStack.isEmpty()) {
                this.curMapPref = new Pref(atts.getValue("key"), this.curMap);
                this.preferences.add(this.curMapPref);
            } else {
                this.mapStack.peekFirst().put(atts.getValue("key"), this.curMap);
            }
            this.mapStack.addFirst(this.curMap);
        } else if (localName.equals("prefList")) {
            this.curList = new ArrayList<Object>();
            if (this.mapStack.isEmpty()) {
                this.curListPref = new Pref(atts.getValue("key"), this.curList);
                this.preferences.add(this.curListPref);
            } else {
                this.mapStack.peekFirst().put(atts.getValue("key"), this.curList);
            }
        } else if (localName.equals("Boolean")) {
            this.curType = 0;
        } else if (localName.equals("Int")) {
            this.curType = 1;
        } else if (localName.equals("Long")) {
            this.curType = 2;
        } else if (localName.equals("Float")) {
            this.curType = 3;
        } else if (localName.equals("Double")) {
            this.curType = 4;
        } else if (localName.equals("String")) {
            this.curType = 5;
        } else if (localName.equals("Object")) {
            this.curType = 6;
            this.curObj = new ObjectPref(atts.getValue("class"), null);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("pref")) {
            if (this.curObj != null) {
                if (this.curObj.getObject() != null) {
                    if (this.curMap != null) {
                        this.curMap.put(this.curKey, this.curObj.getObject());
                    } else {
                        this.curPref.setValue(this.curObj.getObject());
                    }
                } else if (this.curMap == null) {
                    this.preferences.remove(this.curPref);
                }
                this.curObj = null;
            } else {
                Object value = this.getCurrentValue();
                if (this.curMap != null) {
                    if (value != null) {
                        this.curMap.put(this.curKey, value);
                    }
                } else if (value != null) {
                    this.curPref.setValue(value);
                } else {
                    this.preferences.remove(this.curPref);
                }
            }
            this.curPref = null;
            if (this.content.length() > 0) {
                this.content = "";
            }
        } else if (localName.equals("prefGroup")) {
            if (!this.mapStack.isEmpty()) {
                this.mapStack.removeFirst();
                if (this.mapStack.isEmpty()) {
                    this.curMap = null;
                    this.curMapPref = null;
                } else {
                    this.curMap = this.mapStack.peekFirst();
                }
            } else {
                this.curMap = null;
                this.curMapPref = null;
            }
        } else if (localName.equals("prefList")) {
            this.curList = null;
            this.curListPref = null;
        } else if (localName.equals("Object")) {
            Object value = this.getCurrentValue();
            if (value instanceof String) {
                this.curObj.setValue((String)value);
                if (this.curList != null) {
                    this.curList.add(this.curObj);
                    this.curObj = null;
                }
            } else if (this.curList != null) {
                this.curList.add(value);
                this.curObj = null;
            } else {
                this.curObj.setObject(value);
            }
            this.content = "";
        } else if (this.curList != null) {
            Object value = this.getCurrentValue();
            if (value != null) {
                this.curList.add(value);
            }
            this.content = "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content = this.content + new String(ch, start, length);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        System.out.println("Error: " + exception.getMessage() + "\n" + exception.getLineNumber() + " " + exception.getColumnNumber());
        System.out.println("systemID: " + exception.getSystemId());
        System.out.println("publicID: " + exception.getPublicId());
        exception.printStackTrace();
    }

    private Object getCurrentValue() {
        if (this.content == null || this.content.length() == 0) {
            return null;
        }
        this.content = this.content.trim();
        Object vl = null;
        switch (this.curType) {
            case 0: {
                vl = Boolean.valueOf(this.content);
                break;
            }
            case 1: {
                try {
                    vl = Integer.parseInt(this.content);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 2: {
                try {
                    vl = Long.parseLong(this.content);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 3: {
                try {
                    vl = Float.valueOf(Float.parseFloat(this.content));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 4: {
                try {
                    vl = Double.parseDouble(this.content);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 6: {
                if (this.curObj != null) {
                    vl = this.converter.stringToObject(this.curObj.getClassName(), this.content);
                    break;
                }
                vl = this.content;
                break;
            }
            default: {
                vl = this.content;
            }
        }
        return vl;
    }
}

