/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.prefs.PrefConstants;
import mpi.eudico.client.annotator.prefs.PrefObjectConverter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PreferencesWriter
implements PrefConstants {
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;
    private PrefObjectConverter poConverter = new PrefObjectConverter();
    public final String VERSION = "1.1";

    public PreferencesWriter() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (FactoryConfigurationError fce) {
            ClientLogger.LOG.severe("Unable to create a Document Builder: " + fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.severe("Unable to create a Document Builder: " + pce.getMessage());
        }
    }

    public synchronized void encodeAndSave(Map<String, ?> prefs, String path) {
        if (prefs == null || path == null) {
            return;
        }
        Element root = this.createDOM(prefs);
        try {
            ClientLogger.LOG.info("Writing preferences: " + path);
            IoUtil.writeEncodedFile("UTF-8", path, root);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not save the preferences xml file to: " + path + "\n Cause: " + ioe.getMessage());
        }
        catch (Exception e) {
            ClientLogger.LOG.severe("Could not save the preferences xml file to: " + path + "\n Cause: " + e.getMessage());
        }
    }

    private Element createDOM(Map<String, ?> prefs) {
        if (this.db != null) {
            Document doc = this.db.newDocument();
            Element root = doc.createElement("preferences");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.mpi.nl/tools/elan/Prefs_v1.1.xsd");
            root.setAttribute("version", "1.1");
            doc.appendChild(root);
            for (String keyObj : prefs.keySet()) {
                Element nextElem;
                if (!(keyObj instanceof String)) continue;
                String key = keyObj;
                Object value = prefs.get(key);
                if (key == null || value == null || (nextElem = this.createPrefElement(doc, key, value)) == null) continue;
                root.appendChild(nextElem);
            }
            return root;
        }
        return null;
    }

    private Element createPrefElement(Document doc, String key, Object value) {
        Element pref = null;
        if (value instanceof Map) {
            pref = doc.createElement("prefGroup");
            pref.setAttribute("key", key);
            for (String childKey : ((Map)value).keySet()) {
                Element childElem;
                Object obj = ((Map)value).get(childKey);
                if (obj == null || (childElem = this.createPrefElement(doc, childKey, obj)) == null) continue;
                pref.appendChild(childElem);
            }
        } else if (value instanceof List) {
            pref = doc.createElement("prefList");
            pref.setAttribute("key", key);
            List l = (List)value;
            for (int i = 0; i < l.size(); ++i) {
                Object obj = l.get(i);
                Element childElem = this.createContentELement(doc, obj);
                if (childElem == null) continue;
                pref.appendChild(childElem);
            }
        } else if (value instanceof Object[]) {
            Object[] objArray;
            pref = doc.createElement("prefList");
            pref.setAttribute("key", key);
            for (Object element : objArray = (Object[])value) {
                Object obj = element;
                Element childElem = this.createContentELement(doc, obj);
                if (childElem == null) continue;
                pref.appendChild(childElem);
            }
        } else {
            pref = doc.createElement("pref");
            pref.setAttribute("key", key);
            Element childElem = this.createContentELement(doc, value);
            if (childElem != null) {
                pref.appendChild(childElem);
            }
        }
        return pref;
    }

    private Element createContentELement(Document doc, Object value) {
        if (value == null) {
            return null;
        }
        Element objPref = null;
        if (value instanceof String) {
            objPref = doc.createElement("String");
            objPref.appendChild(doc.createTextNode((String)value));
        } else if (value instanceof Boolean) {
            objPref = doc.createElement("Boolean");
            objPref.appendChild(doc.createTextNode(((Boolean)value).toString()));
        } else if (value instanceof Integer) {
            objPref = doc.createElement("Int");
            objPref.appendChild(doc.createTextNode(((Integer)value).toString()));
        } else if (value instanceof Long) {
            objPref = doc.createElement("Long");
            objPref.appendChild(doc.createTextNode(((Long)value).toString()));
        } else if (value instanceof Float) {
            objPref = doc.createElement("Float");
            objPref.appendChild(doc.createTextNode(((Float)value).toString()));
        } else if (value instanceof Double) {
            objPref = doc.createElement("Double");
            objPref.appendChild(doc.createTextNode(((Double)value).toString()));
        } else {
            objPref = doc.createElement("Object");
            objPref.setAttribute("class", value.getClass().getName());
            objPref.appendChild(doc.createTextNode(this.poConverter.objectToString(value)));
        }
        return objPref;
    }
}

