/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;

public class MetadataPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor {
    private ImdiFileServiceProvider provider;
    private List<String> origKeys = null;
    private List<String> afterKeys = null;
    private TierExportTableModel model;
    private JTable keyTable;
    private final String SEL_COLUMN = "Select";
    private final String KEY_COLUMN = "Key";

    public MetadataPanel() {
        super(ElanLocale.getString("PreferencesDialog.Metadata.IMDI"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        List<String> val = Preferences.getListOfString("Metadata.IMDI.Defaults", null);
        if (val != null) {
            this.origKeys = val;
        }
    }

    private void initComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.provider = new ImdiFileServiceProvider();
        URL imdiUrl = this.getClass().getResource("/mpi/eudico/client/annotator/resources/Session.imdi");
        this.provider.setMetadataFile(imdiUrl.toString());
        this.provider.initialize();
        this.model = new TierExportTableModel();
        this.model.setColumnIdentifiers(new String[]{"Select", "Key"});
        this.keyTable = new TierExportTable(this.model);
        this.keyTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.keyTable.setBorder(new LineBorder(Color.LIGHT_GRAY));
        if (this.provider != null && this.provider.getKeys() != null) {
            for (int i = 0; i < this.provider.getKeys().size(); ++i) {
                String key = this.provider.getKeys().get(i);
                if (this.origKeys != null && this.origKeys.contains(key)) {
                    this.model.addRow(Boolean.TRUE, key);
                    continue;
                }
                this.model.addRow(Boolean.FALSE, key);
            }
        }
        this.outerPanel.add((Component)this.keyTable, gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.afterKeys != null) {
            HashMap<String, Object> prefs = new HashMap<String, Object>(1);
            prefs.put("Metadata.IMDI.Defaults", this.afterKeys);
            return prefs;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        this.afterKeys = new ArrayList<String>();
        int includeCol = this.model.findColumn("Select");
        int nameCol = this.model.findColumn("Key");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            this.afterKeys.add((String)this.model.getValueAt(i, nameCol));
        }
        if (this.origKeys == null && this.afterKeys.size() > 0) {
            return true;
        }
        if (this.origKeys != null && this.afterKeys.size() != this.origKeys.size()) {
            return true;
        }
        if (this.origKeys != null) {
            for (String key : this.origKeys) {
                if (this.afterKeys.contains(key)) continue;
                return true;
            }
            for (String key : this.afterKeys) {
                if (this.origKeys.contains(key)) continue;
                return true;
            }
        }
        this.afterKeys = null;
        return false;
    }
}

