/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.annotator.util.SystemReporting;

public class PlatformPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox macScreenBarCB;
    private boolean origMacUseScreenBar = false;
    private JCheckBox macLAndFCB;
    private boolean origMacLF = true;
    private JCheckBox macFileDialogCB;
    private boolean origMacFileDialog = true;
    private JRadioButton jfxRB;
    private JRadioButton javaSoundRB;
    private JRadioButton javfRB;
    private JCheckBox javfJavaCB;
    private String origMacPrefFramework = "AVFN";
    private JCheckBox javfDebugModeCB;
    private boolean origJAVFDebugMode = false;
    private JRadioButton jdsRB;
    private JCheckBox jmmfCB;
    private String origWinPrefFramework = "JDS";
    private JCheckBox winLAndFCB;
    private boolean origWinLF = false;
    private boolean origJMMFEnabled = true;
    private JCheckBox correctAtPauseCB;
    private boolean origCorrectAtPause = true;
    private JCheckBox jmmfSynchronousModeCB;
    private boolean origJMMFSynchronousMode = false;
    private JCheckBox jmmfDebugModeCB;
    private boolean origJMMFDebugMode = false;
    private String origLinuxPrefFramework = "VLCJ";
    private String origLinuxLFPref = LFOption.CROSS_PLATFORM_LF.name();
    private JRadioButton vlcjB;
    private JRadioButton crossPlatformLAndFRB;
    private JRadioButton systemLAndFRB;
    private JRadioButton nimbusLAndFRB;

    public PlatformPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        if (SystemReporting.isMacOS()) {
            String stringPref;
            Boolean boolPref = Preferences.getBool("OS.Mac.useScreenMenuBar", null);
            if (boolPref != null) {
                this.origMacUseScreenBar = boolPref;
            }
            if ((boolPref = Preferences.getBool("UseMacLF", null)) != null) {
                this.origMacLF = boolPref;
            }
            if ((boolPref = Preferences.getBool("UseMacFileDialog", null)) != null) {
                this.origMacFileDialog = boolPref;
            }
            if (!((stringPref = Preferences.getString("Mac.PrefMediaFramework", null)) == null || stringPref.equals("CocoaQT") || stringPref.equals("QT") || stringPref.equals("JAVF"))) {
                this.origMacPrefFramework = stringPref;
            }
            if ((boolPref = Preferences.getBool("NativePlayer.DebugMode", null)) != null) {
                this.origJAVFDebugMode = boolPref;
            }
        } else if (SystemReporting.isWindows()) {
            Boolean boolPref;
            String stringPref = Preferences.getString("Windows.PrefMediaFramework", null);
            if (stringPref != null && !stringPref.equals("JMF") && !stringPref.equals("QT")) {
                this.origWinPrefFramework = stringPref;
            }
            if ((boolPref = Preferences.getBool("UseWinLF", null)) != null) {
                this.origWinLF = boolPref;
            }
            if ((boolPref = Preferences.getBool("Windows.JMMFEnabled", null)) != null) {
                this.origJMMFEnabled = boolPref;
            }
            if ((boolPref = Preferences.getBool("Windows.JMMFPlayer.CorrectAtPause", null)) != null) {
                this.origCorrectAtPause = boolPref;
            }
            if ((boolPref = Preferences.getBool("Windows.JMMFPlayer.SynchronousMode", null)) != null) {
                this.origJMMFSynchronousMode = boolPref;
            }
            if ((boolPref = Preferences.getBool("NativePlayer.DebugMode", null)) != null) {
                this.origJMMFDebugMode = boolPref;
            }
        } else if (SystemReporting.isLinux()) {
            String stringPref = Preferences.getString("Linux.PrefMediaFramework", null);
            if (stringPref != null) {
                this.origLinuxPrefFramework = stringPref;
            }
            this.origLinuxLFPref = (stringPref = Preferences.getString("Linux.PrefLookAndFeel", null)) == null ? LFOption.CROSS_PLATFORM_LF.name() : stringPref;
        }
    }

    private void initComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        Font plainFont = null;
        int gy = 0;
        if (SystemReporting.isMacOS()) {
            super.setTitle(ElanLocale.getString("PreferencesDialog.OS.Mac"));
            this.macScreenBarCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.ScreenMenuBar"));
            this.macScreenBarCB.setSelected(this.origMacUseScreenBar);
            plainFont = this.macScreenBarCB.getFont().deriveFont(0);
            this.macScreenBarCB.setFont(plainFont);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridy = gy++;
            gbc.gridwidth = 1;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.macScreenBarCB, gbc);
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macScreenBarCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.outerPanel.add((Component)relaunchLabel, gbc);
            this.macLAndFCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.LF"));
            this.macLAndFCB.setSelected(this.origMacLF);
            this.macLAndFCB.setFont(plainFont);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.outerPanel.add((Component)this.macLAndFCB, gbc);
            JLabel relaunchLabel2 = new JLabel();
            if (relaunchIcon != null) {
                relaunchLabel2.setIcon(relaunchIcon);
            } else {
                relaunchLabel2.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel2.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macLAndFCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.outerPanel.add((Component)relaunchLabel2, gbc);
            this.macFileDialogCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.FileDialog"));
            this.macFileDialogCB.setSelected(this.origMacFileDialog);
            this.macFileDialogCB.setFont(plainFont);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.outerPanel.add((Component)this.macFileDialogCB, gbc);
            JLabel frameworkLabel = new JLabel(ElanLocale.getString("Player.Framework"));
            frameworkLabel.setFont(plainFont);
            this.jfxRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JFX"));
            this.jfxRB.setFont(plainFont);
            this.javaSoundRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JavaSound"));
            this.javaSoundRB.setFont(plainFont);
            this.javfRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JAVF"), true);
            this.javfRB.setFont(plainFont);
            this.javfJavaCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JAVF") + " (Java Rendering)");
            this.javfJavaCB.setFont(plainFont);
            this.vlcjB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.VLCJ"));
            this.vlcjB.setFont(plainFont);
            this.javfDebugModeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.Debug"), this.origJAVFDebugMode);
            this.javfDebugModeCB.setFont(plainFont);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.javfRB);
            gr.add(this.jfxRB);
            gr.add(this.vlcjB);
            gr.add(this.javaSoundRB);
            this.javfRB.addChangeListener(this);
            if (!(this.origMacPrefFramework.equals("CocoaQT") || this.origMacPrefFramework.equals("QT") || this.origMacPrefFramework.equals("JAVF"))) {
                if (this.origMacPrefFramework.equals("JFX")) {
                    this.jfxRB.setSelected(true);
                } else if (this.origMacPrefFramework.equals("JavaSound")) {
                    this.javaSoundRB.setSelected(true);
                } else if (this.origMacPrefFramework.equals("VLCJ")) {
                    this.vlcjB.setSelected(true);
                }
            }
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.insets = this.catInset;
            this.outerPanel.add((Component)frameworkLabel, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.javfRB, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.singleTabInset;
            this.outerPanel.add((Component)this.javfDebugModeCB, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.jfxRB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.vlcjB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.javaSoundRB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.outerPanel.add((Component)new JPanel(), gbc);
        } else if (SystemReporting.isWindows()) {
            super.setTitle(ElanLocale.getString("PreferencesDialog.OS.Windows"));
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.winLAndFCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Windows.LF"), this.origWinLF);
            this.winLAndFCB.setFont(plainFont);
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridy = gy++;
            gbc.gridwidth = 1;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.winLAndFCB, gbc);
            gbc.gridx = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.outerPanel.add((Component)relaunchLabel, gbc);
            ButtonGroup winBG = new ButtonGroup();
            this.jdsRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JDS"), true);
            this.jmmfCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JMMF"), this.origJMMFEnabled);
            this.correctAtPauseCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JMMF.CorrectAtPause"), this.origCorrectAtPause);
            this.jmmfSynchronousModeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JMMF.SynchronousMode"), this.origJMMFSynchronousMode);
            this.jmmfDebugModeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.Debug"), this.origJMMFDebugMode);
            this.jfxRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JFX"));
            this.javaSoundRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JavaSound"));
            this.vlcjB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.VLCJ"));
            winBG.add(this.jdsRB);
            winBG.add(this.javaSoundRB);
            winBG.add(this.jfxRB);
            winBG.add(this.vlcjB);
            plainFont = this.jdsRB.getFont().deriveFont(0);
            JLabel winMedia = new JLabel(ElanLocale.getString("Player.Framework"));
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.insets = this.catInset;
            this.outerPanel.add((Component)winMedia, gbc);
            if (!this.origWinPrefFramework.equals("QT") && !this.origWinPrefFramework.equals("JMF")) {
                if (this.origWinPrefFramework.equals("JFX")) {
                    this.jfxRB.setSelected(true);
                } else if (this.origWinPrefFramework.equals("JavaSound")) {
                    this.javaSoundRB.setSelected(true);
                } else if (this.origWinPrefFramework.equals("VLCJ")) {
                    this.vlcjB.setSelected(true);
                }
            }
            this.jdsRB.setFont(plainFont);
            this.jmmfCB.setFont(plainFont);
            this.jfxRB.setFont(plainFont);
            this.javaSoundRB.setFont(plainFont);
            this.vlcjB.setFont(plainFont);
            this.correctAtPauseCB.setFont(plainFont);
            this.jmmfSynchronousModeCB.setFont(plainFont);
            this.jmmfDebugModeCB.setFont(plainFont);
            gbc.insets = this.globalInset;
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.jdsRB, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.singleTabInset;
            this.outerPanel.add((Component)this.jmmfCB, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.doubleTabInset;
            this.outerPanel.add((Component)this.correctAtPauseCB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.jmmfSynchronousModeCB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.jmmfDebugModeCB, gbc);
            gbc.insets = this.globalInset;
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.jfxRB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.vlcjB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.javaSoundRB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.outerPanel.add((Component)new JPanel(), gbc);
            if (SystemReporting.isWindows7OrHigher() || SystemReporting.isWindowsVista()) {
                this.jdsRB.addChangeListener(this);
                this.jmmfCB.setEnabled(this.jdsRB.isSelected());
                this.correctAtPauseCB.setEnabled(this.jdsRB.isSelected());
            } else {
                this.jmmfCB.setEnabled(false);
                this.jmmfCB.setVisible(false);
                this.correctAtPauseCB.setVisible(false);
            }
        } else if (SystemReporting.isLinux()) {
            super.setTitle(ElanLocale.getString("PreferencesDialog.OS.Linux"));
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            JLabel lAndFLabel = new JLabel(ElanLocale.getString("PreferencesDialog.OS.Linux.LFLabel"));
            this.crossPlatformLAndFRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.OS.Linux.LF.CrossPlatform"), true);
            this.systemLAndFRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.OS.Linux.LF.System"));
            this.nimbusLAndFRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.OS.Linux.LF.Nimbus"));
            ButtonGroup lAndFGroup = new ButtonGroup();
            lAndFGroup.add(this.crossPlatformLAndFRB);
            lAndFGroup.add(this.systemLAndFRB);
            lAndFGroup.add(this.nimbusLAndFRB);
            if (LFOption.SYSTEM_LF.name().equals(this.origLinuxLFPref)) {
                this.systemLAndFRB.setSelected(true);
            } else if (LFOption.NIMBUS_LF.name().equals(this.origLinuxLFPref)) {
                this.nimbusLAndFRB.setSelected(true);
            }
            plainFont = this.crossPlatformLAndFRB.getFont().deriveFont(0);
            this.crossPlatformLAndFRB.setFont(plainFont);
            this.systemLAndFRB.setFont(plainFont);
            this.nimbusLAndFRB.setFont(plainFont);
            JLabel frameworkLabel = new JLabel(ElanLocale.getString("Player.Framework"));
            this.vlcjB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.VLCJ"), true);
            this.vlcjB.setFont(plainFont);
            this.jfxRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JFX"));
            this.jfxRB.setFont(plainFont);
            this.javaSoundRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JavaSound"));
            this.javaSoundRB.setFont(plainFont);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.vlcjB);
            gr.add(this.jfxRB);
            gr.add(this.javaSoundRB);
            if (!this.origLinuxPrefFramework.equals("JMF")) {
                if (this.origLinuxPrefFramework.equals("JFX")) {
                    this.jfxRB.setSelected(true);
                } else if (this.origLinuxPrefFramework.equals("JavaSound")) {
                    this.javaSoundRB.setSelected(true);
                } else {
                    this.vlcjB.setSelected(true);
                }
            }
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.insets = this.catInset;
            this.outerPanel.add((Component)lAndFLabel, gbc);
            gbc.gridx = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.outerPanel.add((Component)relaunchLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.crossPlatformLAndFRB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.systemLAndFRB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.nimbusLAndFRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.insets = this.catInset;
            this.outerPanel.add((Component)frameworkLabel, gbc);
            gbc.gridy = gy++;
            gbc.insets = this.globalInset;
            this.outerPanel.add((Component)this.vlcjB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.jfxRB, gbc);
            gbc.gridy = gy++;
            this.outerPanel.add((Component)this.javaSoundRB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.outerPanel.add((Component)new JPanel(), gbc);
        }
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(4);
            if (SystemReporting.isMacOS()) {
                if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar) {
                    chMap.put("OS.Mac.useScreenMenuBar", this.macScreenBarCB.isSelected());
                }
                if (this.macLAndFCB.isSelected() != this.origMacLF) {
                    chMap.put("UseMacLF", this.macLAndFCB.isSelected());
                }
                if (this.macFileDialogCB.isSelected() != this.origMacFileDialog) {
                    chMap.put("UseMacFileDialog", this.macFileDialogCB.isSelected());
                }
                String tmp = "AVFN";
                if (!this.javfRB.isSelected()) {
                    if (this.jfxRB.isSelected()) {
                        tmp = "JFX";
                    } else if (this.javaSoundRB.isSelected()) {
                        tmp = "JavaSound";
                    } else if (this.vlcjB.isSelected()) {
                        tmp = "VLCJ";
                    }
                }
                if (!this.origMacPrefFramework.equals(tmp)) {
                    chMap.put("Mac.PrefMediaFramework", tmp);
                    System.setProperty("PreferredMediaFramework", tmp);
                }
                if (this.javfDebugModeCB.isSelected() != this.origJAVFDebugMode) {
                    chMap.put("NativePlayer.DebugMode", this.javfDebugModeCB.isSelected());
                }
            } else if (SystemReporting.isWindows()) {
                String winTmp = "JDS";
                if (this.jfxRB.isSelected()) {
                    winTmp = "JFX";
                } else if (this.javaSoundRB.isSelected()) {
                    winTmp = "JavaSound";
                } else if (this.vlcjB.isSelected()) {
                    winTmp = "VLCJ";
                }
                if (!this.origWinPrefFramework.equals(winTmp)) {
                    chMap.put("Windows.PrefMediaFramework", winTmp);
                    System.setProperty("PreferredMediaFramework", winTmp);
                }
                if (this.origWinLF != this.winLAndFCB.isSelected()) {
                    chMap.put("UseWinLF", this.winLAndFCB.isSelected());
                }
                if (this.origJMMFEnabled != this.jmmfCB.isSelected()) {
                    chMap.put("Windows.JMMFEnabled", this.jmmfCB.isSelected());
                }
                if (this.origCorrectAtPause != this.correctAtPauseCB.isSelected()) {
                    chMap.put("Windows.JMMFPlayer.CorrectAtPause", this.correctAtPauseCB.isSelected());
                }
                if (this.origJMMFSynchronousMode != this.jmmfSynchronousModeCB.isSelected()) {
                    chMap.put("Windows.JMMFPlayer.SynchronousMode", this.jmmfSynchronousModeCB.isSelected());
                }
                if (this.origJMMFDebugMode != this.jmmfDebugModeCB.isSelected()) {
                    chMap.put("NativePlayer.DebugMode", this.jmmfDebugModeCB.isSelected());
                }
            } else if (SystemReporting.isLinux()) {
                String tmpLF = LFOption.CROSS_PLATFORM_LF.name();
                if (this.systemLAndFRB.isSelected()) {
                    tmpLF = LFOption.SYSTEM_LF.name();
                } else if (this.nimbusLAndFRB.isSelected()) {
                    tmpLF = LFOption.NIMBUS_LF.name();
                }
                if (!tmpLF.equals(this.origLinuxLFPref)) {
                    chMap.put("Linux.PrefLookAndFeel", tmpLF);
                }
                String tmp = "VLCJ";
                if (this.jfxRB.isSelected()) {
                    tmp = "JFX";
                } else if (this.javaSoundRB.isSelected()) {
                    tmp = "JavaSound";
                }
                if (!this.origLinuxPrefFramework.equals(tmp)) {
                    chMap.put("Linux.PrefMediaFramework", tmp);
                    System.setProperty("PreferredMediaFramework", tmp);
                }
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        if (SystemReporting.isMacOS()) {
            if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar || this.macLAndFCB.isSelected() != this.origMacLF || this.macFileDialogCB.isSelected() != this.origMacFileDialog) {
                return true;
            }
            if (this.origJAVFDebugMode != this.javfDebugModeCB.isSelected()) {
                return true;
            }
            String tmp = "AVFN";
            if (!this.javfRB.isSelected()) {
                if (this.jfxRB.isSelected()) {
                    tmp = "JFX";
                } else if (this.javaSoundRB.isSelected()) {
                    tmp = "JavaSound";
                } else if (this.vlcjB.isSelected()) {
                    tmp = "VLCJ";
                }
            }
            if (!this.origMacPrefFramework.equals(tmp)) {
                return true;
            }
        } else if (SystemReporting.isWindows()) {
            String winTmp = "JDS";
            if (this.jfxRB.isSelected()) {
                winTmp = "JFX";
            } else if (this.javaSoundRB.isSelected()) {
                winTmp = "JavaSound";
            } else if (this.vlcjB.isSelected()) {
                winTmp = "VLCJ";
            }
            if (!this.origWinPrefFramework.equals(winTmp)) {
                return true;
            }
            if (this.origWinLF != this.winLAndFCB.isSelected()) {
                return true;
            }
            if (this.origJMMFEnabled != this.jmmfCB.isSelected()) {
                return true;
            }
            if (this.origCorrectAtPause != this.correctAtPauseCB.isSelected()) {
                return true;
            }
            if (this.origJMMFSynchronousMode != this.jmmfSynchronousModeCB.isSelected()) {
                return true;
            }
            if (this.origJMMFDebugMode != this.jmmfDebugModeCB.isSelected()) {
                return true;
            }
        } else if (SystemReporting.isLinux()) {
            String tmpLF = LFOption.CROSS_PLATFORM_LF.name();
            if (this.systemLAndFRB.isSelected()) {
                tmpLF = LFOption.SYSTEM_LF.name();
            } else if (this.nimbusLAndFRB.isSelected()) {
                tmpLF = LFOption.NIMBUS_LF.name();
            }
            if (!tmpLF.equals(this.origLinuxLFPref)) {
                return true;
            }
            String tmp = "VLCJ";
            if (this.jfxRB.isSelected()) {
                tmp = "JFX";
            } else if (this.javaSoundRB.isSelected()) {
                tmp = "JavaSound";
            }
            if (!this.origLinuxPrefFramework.equals(tmp)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (SystemReporting.isWindows()) {
            this.jmmfCB.setEnabled(this.jdsRB.isSelected());
            this.correctAtPauseCB.setEnabled(this.jdsRB.isSelected());
            this.jmmfSynchronousModeCB.setEnabled(this.jdsRB.isSelected());
            this.jmmfDebugModeCB.setEnabled(this.jdsRB.isSelected());
        } else if (SystemReporting.isMacOS()) {
            this.javfJavaCB.setEnabled(this.javfRB.isSelected());
        }
    }

    public static enum LFOption {
        CROSS_PLATFORM_LF,
        SYSTEM_LF,
        NIMBUS_LF;

    }
}

