/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class RecentLanguagesBox
extends JComboBox {
    public RecentLanguagesBox(String initialValue) {
        this.initAndSetSelectedItem(initialValue);
    }

    private void initAndSetSelectedItem(String value) {
        boolean selected = false;
        this.removeAllItems();
        for (LangInfo li : RecentLanguages.getInstance().getRecentLanguages()) {
            if (li == null) continue;
            this.addItem(li);
            if (!li.getId().equals(value) && !li.getLongId().equals(value)) continue;
            super.setSelectedItem(li);
            selected = true;
        }
        if (selected) {
            this.setEditable(false);
        } else {
            super.setSelectedItem(value);
        }
    }

    public void addNoLanguageItem() {
        this.addItem(new LangInfo("", "", "None"));
    }

    public void setSelectedItem(String selectId) {
        if (selectId == null) {
            selectId = "";
        }
        boolean selected = false;
        ComboBoxModel m = this.getModel();
        int max = this.getItemCount();
        for (int i = 0; i < max; ++i) {
            Object o = m.getElementAt(i);
            String lid = "";
            String sid = "";
            if (o instanceof LangInfo) {
                lid = ((LangInfo)o).getLongId();
                sid = ((LangInfo)o).getId();
            } else if (o instanceof String) {
                lid = (String)o;
            }
            if (!lid.equals(selectId) && !sid.equals(selectId)) continue;
            super.setSelectedIndex(i);
            selected = true;
            break;
        }
        if (selected) {
            this.setEditable(false);
        } else {
            super.setSelectedItem(selectId);
        }
    }

    @Override
    public void setSelectedItem(Object o) {
        if (o instanceof String) {
            this.setSelectedItem((String)o);
        } else {
            super.setSelectedItem(o);
        }
    }

    private LangInfo getLangInfo() {
        Object obj = this.getSelectedItem();
        if (obj instanceof LangInfo) {
            LangInfo li = (LangInfo)obj;
            return li;
        }
        if (obj instanceof String) {
            String text = (String)obj;
            LangInfo li = LanguageCollection.tryParse(text);
            return li;
        }
        return null;
    }

    public String getId() {
        LangInfo li = this.getLangInfo();
        if (li != null) {
            return li.getId();
        }
        return "";
    }

    public String getLongId() {
        LangInfo li = this.getLangInfo();
        if (li != null) {
            return li.getLongId();
        }
        return "";
    }
}

