/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.JFontChooser;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;

public class UIPrefsPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor {
    private JComboBox nrOfRecentItemsCBox;
    private Integer origNrRecentItems = 5;
    private JCheckBox tooltipCB;
    private boolean origToolTipEnabled = true;
    private JCheckBox showAnnotationCountCB;
    private boolean origShowAnnotationCount = false;
    private JRadioButton useBufferedPaintingRB;
    private JRadioButton useDirectPaintingRB;
    private boolean origUseBufferedPainting = false;
    private JSlider fontScaleSlider;
    private int origFontScaleInt = 100;
    private JTextField defTierFontField;
    private String origDefTierFontName = "";
    private JButton fontSelectButton;
    private JButton fontResetButton;
    private JTextField defTierFontSizeField;
    private int origDefTierFontSize = 0;
    private int modDefTierFontSize = 0;
    private JButton fontSizeResetButton;
    private Font curTierFont = null;

    public UIPrefsPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.UI"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        String stringPref;
        Float scalePref;
        Boolean boolPref;
        Integer intPref = Preferences.getInt("UI.RecentItems", null);
        if (intPref != null) {
            this.origNrRecentItems = intPref;
        }
        if ((boolPref = Preferences.getBool("UI.ToolTips.Enabled", null)) != null) {
            this.origToolTipEnabled = boolPref;
        }
        if ((boolPref = Preferences.getBool("UI.MenuItems.ShowAnnotationCount", null)) != null) {
            this.origShowAnnotationCount = boolPref;
        }
        if ((boolPref = Preferences.getBool("UI.UseBufferedPainting", null)) != null) {
            this.origUseBufferedPainting = boolPref;
        }
        if ((scalePref = Preferences.getFloat("UI.FontScaleFactor", null)) != null) {
            float origFontScale = scalePref.floatValue();
            if (origFontScale < 1.0f) {
                origFontScale = 1.0f;
            } else if (origFontScale > 2.0f) {
                origFontScale = 2.0f;
            }
            this.origFontScaleInt = (int)(100.0f * origFontScale);
        }
        if ((stringPref = Preferences.getString("Tiers.DefaultFontName", null)) != null) {
            this.origDefTierFontName = stringPref;
        }
        if ((intPref = Preferences.getInt("Tiers.DefaultFontSize", null)) != null) {
            this.origDefTierFontSize = intPref;
        }
    }

    private void initComponents() {
        Integer[] nrOfRecentItemsList = new Integer[]{5, 10, 15, 20, 25, 30};
        this.nrOfRecentItemsCBox = new JComboBox<Integer>(nrOfRecentItemsList);
        this.nrOfRecentItemsCBox.setSelectedItem(this.origNrRecentItems);
        Font plainFont = this.nrOfRecentItemsCBox.getFont().deriveFont(0);
        this.nrOfRecentItemsCBox.setFont(plainFont);
        this.nrOfRecentItemsCBox.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
        JLabel recentItemsLabel = new JLabel(ElanLocale.getString("PreferencesDialog.UI.RecentItems"));
        recentItemsLabel.setFont(plainFont);
        JPanel recentItemsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.topInset;
        recentItemsPanel.add((Component)recentItemsLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        recentItemsPanel.add((Component)this.nrOfRecentItemsCBox, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        recentItemsPanel.add((Component)new JPanel(), gbc);
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.catInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)recentItemsPanel, gbc);
        JLabel uiFontScaleLabel = new JLabel(ElanLocale.getString("PreferencesDialog.UI.FontScaling"));
        this.fontScaleSlider = new JSlider(0, 100, 200, this.origFontScaleInt);
        this.fontScaleSlider.setMajorTickSpacing(20);
        this.fontScaleSlider.setPaintLabels(true);
        this.fontScaleSlider.setPaintTicks(true);
        JPanel fontScalePanel = new JPanel(new GridBagLayout());
        GridBagConstraints fbc = new GridBagConstraints();
        fbc.anchor = 18;
        fbc.insets = this.topInset;
        fbc.fill = 2;
        fbc.weightx = 0.1;
        fbc.gridwidth = 1;
        fbc.gridheight = 1;
        fontScalePanel.add((Component)uiFontScaleLabel, fbc);
        fbc.gridy = 1;
        fbc.insets = this.globalInset;
        fontScalePanel.add((Component)this.fontScaleSlider, fbc);
        JLabel relaunchLabel = new JLabel();
        ImageIcon relaunchIcon = null;
        try {
            relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
            relaunchLabel.setIcon(relaunchIcon);
        }
        catch (Exception ex) {
            relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
        }
        relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
        fbc.gridx = 1;
        fbc.gridy = 0;
        fbc.gridheight = 2;
        fbc.fill = 0;
        fbc.anchor = 10;
        fbc.weightx = 0.0;
        fontScalePanel.add((Component)relaunchLabel, fbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)fontScalePanel, gbc);
        JPanel tierFontPanel = new JPanel(new GridBagLayout());
        this.defTierFontField = new JTextField(this.origDefTierFontName);
        if (this.origDefTierFontName.isEmpty()) {
            this.defTierFontField.setText(ElanLocale.getString("Button.Default"));
            this.defTierFontField.setForeground(Constants.SHAREDCOLOR3);
        }
        this.defTierFontField.setEditable(false);
        this.fontSelectButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.fontResetButton = new JButton();
        this.fontResetButton.setToolTipText(ElanLocale.getString("Button.Default"));
        this.defTierFontSizeField = new JTextField(String.valueOf(this.origDefTierFontSize));
        if (this.origDefTierFontSize == 0) {
            this.defTierFontSizeField.setText("");
            this.defTierFontSizeField.setForeground(Constants.SHAREDCOLOR3);
        }
        this.fontSizeResetButton = new JButton();
        this.fontSizeResetButton.setToolTipText(ElanLocale.getString("Button.Default"));
        try {
            ImageIcon resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.fontResetButton.setIcon(resetIcon);
            this.fontSizeResetButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.fontResetButton.setText("X");
            this.fontSizeResetButton.setText("X");
        }
        JLabel relaunch2Label = new JLabel(relaunchIcon);
        relaunch2Label.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
        fbc = new GridBagConstraints();
        fbc.anchor = 18;
        fbc.insets = this.topInset;
        fbc.fill = 2;
        fbc.weightx = 1.0;
        fbc.gridwidth = 5;
        fbc.gridheight = 1;
        tierFontPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.DefaultContentFont")), fbc);
        fbc.gridy = 1;
        fbc.gridwidth = 1;
        fbc.fill = 0;
        fbc.weightx = 0.0;
        fbc.insets = this.globalPanelInset;
        tierFontPanel.add((Component)new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.Font")), fbc);
        fbc.gridx = 1;
        fbc.fill = 2;
        fbc.weightx = 0.1;
        fbc.insets = this.globalInset;
        tierFontPanel.add((Component)this.defTierFontField, fbc);
        fbc.gridx = 2;
        fbc.fill = 0;
        fbc.weightx = 0.0;
        tierFontPanel.add((Component)this.fontSelectButton, fbc);
        fbc.gridx = 3;
        tierFontPanel.add((Component)this.fontResetButton, fbc);
        fbc.gridx = 0;
        fbc.gridy = 2;
        fbc.insets = this.globalPanelInset;
        tierFontPanel.add((Component)new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.FontSize")), fbc);
        fbc.gridx = 1;
        this.defTierFontSizeField.setColumns(10);
        fbc.insets = this.globalInset;
        tierFontPanel.add((Component)this.defTierFontSizeField, fbc);
        fbc.gridx = 3;
        fbc.fill = 0;
        fbc.weightx = 0.0;
        tierFontPanel.add((Component)this.fontSizeResetButton, fbc);
        fbc.gridx = 4;
        fbc.gridy = 1;
        fbc.gridheight = 2;
        tierFontPanel.add((Component)relaunch2Label, fbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)tierFontPanel, gbc);
        ActListener acl = new ActListener();
        this.fontSelectButton.addActionListener(acl);
        this.fontResetButton.addActionListener(acl);
        this.fontSizeResetButton.addActionListener(acl);
        this.defTierFontSizeField.addCaretListener(acl);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        gbc.fill = 2;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.ToolTip")), gbc);
        this.tooltipCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.UI.ToolTip.Enabled"));
        this.tooltipCB.setSelected(this.origToolTipEnabled);
        this.tooltipCB.setFont(this.tooltipCB.getFont().deriveFont(0));
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.tooltipCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.MenuOptions")), gbc);
        this.showAnnotationCountCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.UI.MenuOptions.ShowAnnotationCount"));
        this.showAnnotationCountCB.setSelected(this.origShowAnnotationCount);
        this.showAnnotationCountCB.setFont(this.showAnnotationCountCB.getFont().deriveFont(0));
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.showAnnotationCountCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.PaintingStrategy")), gbc);
        ButtonGroup bGroup = new ButtonGroup();
        this.useBufferedPaintingRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.UI.UseBufferedPainting"));
        this.useBufferedPaintingRB.setSelected(this.origUseBufferedPainting);
        this.useBufferedPaintingRB.setFont(this.tooltipCB.getFont().deriveFont(0));
        this.useDirectPaintingRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.UI.UseDirectPainting"));
        this.useDirectPaintingRB.setSelected(!this.origUseBufferedPainting);
        this.useDirectPaintingRB.setFont(this.tooltipCB.getFont().deriveFont(0));
        bGroup.add(this.useBufferedPaintingRB);
        bGroup.add(this.useDirectPaintingRB);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.useBufferedPaintingRB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.useDirectPaintingRB, gbc);
        gbc.gridy = gy++;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(6);
            if (this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems) {
                chMap.put("UI.RecentItems", this.nrOfRecentItemsCBox.getSelectedItem());
            }
            if (this.fontScaleSlider.getValue() != this.origFontScaleInt) {
                if (this.fontScaleSlider.getValue() == 100) {
                    chMap.put("UI.FontScaleFactor", null);
                } else {
                    chMap.put("UI.FontScaleFactor", Float.valueOf((float)this.fontScaleSlider.getValue() / 100.0f));
                }
            }
            if (this.tooltipCB.isSelected() != this.origToolTipEnabled) {
                chMap.put("UI.ToolTips.Enabled", this.tooltipCB.isSelected());
            }
            if (this.showAnnotationCountCB.isSelected() != this.origShowAnnotationCount) {
                chMap.put("UI.MenuItems.ShowAnnotationCount", this.showAnnotationCountCB.isSelected());
            }
            if (this.useBufferedPaintingRB.isSelected() != this.origUseBufferedPainting) {
                chMap.put("UI.UseBufferedPainting", this.useBufferedPaintingRB.isSelected());
            }
            if (!this.origDefTierFontName.equals(this.defTierFontField.getText())) {
                chMap.put("Tiers.DefaultFontName", this.defTierFontField.getText());
            }
            if (this.origDefTierFontSize != this.modDefTierFontSize) {
                if (this.modDefTierFontSize == 0) {
                    chMap.put("Tiers.DefaultFontSize", null);
                } else {
                    chMap.put("Tiers.DefaultFontSize", this.modDefTierFontSize);
                }
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems || this.tooltipCB.isSelected() != this.origToolTipEnabled || this.showAnnotationCountCB.isSelected() != this.origShowAnnotationCount || this.origUseBufferedPainting != this.useBufferedPaintingRB.isSelected() || this.origFontScaleInt != this.fontScaleSlider.getValue() || this.origDefTierFontName.equals(this.defTierFontField.getText()) || this.origDefTierFontSize != this.modDefTierFontSize;
    }

    private class ActListener
    implements ActionListener,
    CaretListener {
        private ActListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == UIPrefsPanel.this.fontSelectButton) {
                JFontChooser fontChooser = new JFontChooser();
                Font f = fontChooser.showDialog((JDialog)SwingUtilities.getWindowAncestor(UIPrefsPanel.this), true, UIPrefsPanel.this.curTierFont);
                if (f != null) {
                    UIPrefsPanel.this.defTierFontField.setText(f.getFontName());
                    UIPrefsPanel.this.defTierFontField.setForeground(Constants.DEFAULTFOREGROUNDCOLOR);
                    UIPrefsPanel.this.curTierFont = f;
                }
            } else if (e.getSource() == UIPrefsPanel.this.fontResetButton) {
                UIPrefsPanel.this.defTierFontField.setText(ElanLocale.getString("Button.Default"));
                UIPrefsPanel.this.defTierFontField.setForeground(Constants.SHAREDCOLOR3);
                UIPrefsPanel.this.curTierFont = null;
            } else if (e.getSource() == UIPrefsPanel.this.fontSizeResetButton) {
                UIPrefsPanel.this.defTierFontSizeField.setText("");
                UIPrefsPanel.this.defTierFontSizeField.setForeground(Constants.SHAREDCOLOR3);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (e.getSource() == UIPrefsPanel.this.defTierFontSizeField) {
                if (!UIPrefsPanel.this.defTierFontSizeField.getText().isEmpty()) {
                    try {
                        UIPrefsPanel.this.modDefTierFontSize = Integer.parseInt(UIPrefsPanel.this.defTierFontSizeField.getText());
                        UIPrefsPanel.this.defTierFontSizeField.setForeground(Constants.DEFAULTFOREGROUNDCOLOR);
                    }
                    catch (Throwable t) {
                        UIPrefsPanel.this.defTierFontSizeField.setForeground(Constants.SHAREDCOLOR3);
                        UIPrefsPanel.this.modDefTierFontSize = 0;
                    }
                } else {
                    UIPrefsPanel.this.defTierFontSizeField.setForeground(Constants.SHAREDCOLOR3);
                    UIPrefsPanel.this.modDefTierFontSize = 0;
                }
            }
        }
    }
}

