/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.query.viewer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.im.ImUtil;
import mpi.search.content.query.viewer.AbstractConstraintPanel;
import mpi.search.content.query.viewer.AbstractPopupMenu;

public class EAFPopupMenu
extends AbstractPopupMenu
implements FocusListener {
    private static final Locale[] imLocales = ImUtil.getLanguages();

    public EAFPopupMenu(Component component, AbstractConstraintPanel constraintPanel) {
        super(component, constraintPanel);
    }

    @Override
    public void fillMenu() {
        this.setLabel("Select Language");
        try {
            for (int i = 0; i < imLocales.length; ++i) {
                JMenuItem item = i == 0 && imLocales[i] == Locale.getDefault() ? new JMenuItem(imLocales[i].getDisplayName() + " (System default)") : new JMenuItem(imLocales[i].getDisplayName());
                this.add(item);
                item.addActionListener(this);
            }
            this.component.addFocusListener(this);
        }
        catch (NoSuchMethodError nsme) {
            System.err.println("No input methods found. Probably class ImUtil not in java.lib.ext");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.show(this.component, e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        for (int i = 0; i < imLocales.length; ++i) {
            if (i == 0 && imLocales[i] == Locale.getDefault() && command.indexOf(imLocales[i].getDisplayName()) > -1) {
                ImUtil.setLanguage(this.component, imLocales[i]);
                break;
            }
            if (!command.equals(imLocales[i].getDisplayName())) continue;
            ImUtil.setLanguage(this.component, imLocales[i]);
            break;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

