/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.result.viewer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.grid.GridRenderer;
import mpi.eudico.client.annotator.search.result.model.ElanMatch;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerTableModel;
import mpi.eudico.client.annotator.search.result.viewer.ElanResult2HTML;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.util.TimeRelation;
import mpi.search.content.result.model.ContentMatch;

public class EAFResultViewerGridRenderer
extends GridRenderer {
    public EAFResultViewerGridRenderer(AbstractTableModel tableModel) {
        this(null, tableModel);
    }

    public EAFResultViewerGridRenderer(AbstractViewer viewer, AbstractTableModel tableModel) {
        super(viewer, tableModel);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isInSelection = isSelected;
        if (value instanceof ContentMatch) {
            ContentMatch contentMatch = (ContentMatch)value;
            if (this.viewer != null) {
                isInSelection = TimeRelation.overlaps(contentMatch, this.viewer.getSelectionBeginTime(), this.viewer.getSelectionEndTime());
            }
            boolean isActive = false;
            if (this.viewer != null && value instanceof ElanMatch) {
                isActive = this.viewer.getActiveAnnotation() == ((ElanMatch)value).getAnnotation();
            }
            EAFResultViewerGridRenderer.setComponentLayout(this.label, table, value, isInSelection, isActive, column);
            EAFResultViewerGridRenderer.setAlignment(this.label, table.getColumnName(column));
            this.label.setText(ElanResult2HTML.translate(contentMatch, false));
            this.label.setToolTipText(ElanResult2HTML.translate(contentMatch, true));
            return this.label;
        }
        int modelRow = table.convertRowIndexToModel(row);
        if (this.tableModel instanceof EAFResultViewerTableModel && this.viewer != null) {
            AnnotationCore ac = ((EAFResultViewerTableModel)this.tableModel).getAnnotationCore(modelRow);
            isInSelection = TimeRelation.overlaps(ac, this.viewer.getSelectionBeginTime(), this.viewer.getSelectionEndTime());
        }
        return super.getTableCellRendererComponent(table, value, isInSelection, hasFocus, modelRow, column);
    }
}

