/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.prefs.MultipleFileDomains;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.model.FASTSearchEngine;
import mpi.eudico.client.annotator.search.result.viewer.ContentMatch2TabDelimitedText;
import mpi.eudico.client.annotator.search.result.viewer.EAFMultipleFileResultViewer;
import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileUtilities;
import mpi.eudico.client.util.LinkButton;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.result.viewer.ContentMatchCounter;
import mpi.search.model.DefaultSearchController;
import mpi.search.query.model.Query;
import mpi.search.query.viewer.AbstractSimpleSearchPanel;
import mpi.search.query.viewer.StartStopPanel;
import org.xml.sax.SAXException;

public class FASTSearchPanel
extends AbstractSimpleSearchPanel {
    private static final long serialVersionUID = 2833583409122787971L;
    protected static final String LAST_DIR_KEY = "MultipleFileSearchLastDir";
    protected static final String PREFERENCES_DIRS_KEY = "MultipleFileSearchDirs";
    protected static final String PREFERENCES_PATHS_KEY = "MultipleFileSearchPaths";
    protected static final String PREFERENCES_LAST_DOMAIN = "LastUsedMFSearchDomain";
    private final Action defineDomainAction;
    private List<String> searchDirs;
    private List<String> searchPaths;
    private final Box optionBox = new Box(1);
    private final Box searchCategoryBox = new Box(0);
    private final JCheckBox caseSensitiveCheckBox;
    private final JCheckBox regexCheckBox;
    private final JLabel searchLogo = new JLabel("FASTSearch");
    private final JLabel infoLabel = new JLabel();
    private final JLabel domainLabel = new JLabel();
    private final JPanel centralPanel;
    private final JTextField searchField = new JTextField(18);
    private final LinkButton exportButton;
    private File[] searchFiles;
    private final FASTSearchEngine FASTSearcher;

    public FASTSearchPanel(ElanFrame2 elanFrame) {
        this.matchCounter = new ContentMatchCounter();
        this.defineDomainAction = new AbstractAction(SearchLocale.getString("Action.DefineDomain")){
            private static final long serialVersionUID = -8606295445946585789L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MFDomainDialog mfDialog = null;
                Container w = FASTSearchPanel.this.getTopLevelAncestor();
                if (w instanceof Frame) {
                    mfDialog = new MFDomainDialog((Frame)w, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
                } else if (w instanceof Dialog) {
                    mfDialog = new MFDomainDialog((Dialog)w, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
                } else {
                    return;
                }
                mfDialog.setSearchDirs(FASTSearchPanel.this.searchDirs);
                mfDialog.setSearchPaths(FASTSearchPanel.this.searchPaths);
                mfDialog.setVisible(true);
                FASTSearchPanel.this.searchDirs = mfDialog.getSearchDirs();
                FASTSearchPanel.this.searchPaths = mfDialog.getSearchPaths();
                FASTSearchPanel.access$202(FASTSearchPanel.this, EAFMultipleFileUtilities.getUniqueEAFFilesIn(FASTSearchPanel.this.searchDirs, FASTSearchPanel.this.searchPaths));
                String val = Preferences.getString(FASTSearchPanel.PREFERENCES_LAST_DOMAIN, null);
                if (val != null) {
                    FASTSearchPanel.this.domainLabel.setText(ElanLocale.getString("MultipleFileSearch.SelectedDomain") + " " + val);
                }
            }
        };
        this.defineDomainAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.DefineDomain"));
        KeyStroke ks = KeyStroke.getKeyStroke(68, 2);
        this.defineDomainAction.putValue("AcceleratorKey", ks);
        this.regexCheckBox = new JCheckBox(SearchLocale.getString("Search.Constraint.RegularExpression"));
        this.caseSensitiveCheckBox = new JCheckBox(SearchLocale.getString("Search.Constraint.CaseSensitive"));
        this.caseSensitiveCheckBox.setSelected(true);
        this.startStopPanel = new StartStopPanel(this.startAction, this.stopAction);
        this.resultViewer = new EAFMultipleFileResultViewer(elanFrame);
        this.exportButton = new LinkButton(this.exportAction);
        this.matchCounter.setHorizontalAlignment(4);
        this.centralPanel = new JPanel(new BorderLayout());
        this.initComponents();
        this.makeInitialPanel();
        this.setVisible(true);
        this.searchField.addActionListener(this.startAction);
        String domainName = Preferences.getString(PREFERENCES_LAST_DOMAIN, null);
        if (domainName != null) {
            this.domainLabel.setText(ElanLocale.getString("MultipleFileSearch.SelectedDomain") + " " + domainName);
            Map<String, List<String>> domain = MultipleFileDomains.getInstance().getDomain(domainName);
            if (domain != null) {
                List<String> paths;
                List<String> dirs = domain.get(domainName + ".Dirs");
                if (dirs != null) {
                    this.searchDirs = dirs;
                }
                if ((paths = domain.get(domainName + ".Paths")) != null) {
                    this.searchPaths = paths;
                }
            }
        }
        if (this.searchDirs == null && this.searchPaths == null) {
            List<Object> listPref = Preferences.getListOfString(PREFERENCES_DIRS_KEY, null);
            this.searchDirs = listPref != null ? listPref : new ArrayList(0);
            listPref = Preferences.getListOfString(PREFERENCES_PATHS_KEY, null);
            this.searchPaths = listPref != null ? listPref : new ArrayList(0);
            this.domainLabel.setText(ElanLocale.getString("MultipleFileSearch.SelectedDomain") + " " + ElanLocale.getString("MultipleFileSearch.SelectedDomainNone"));
        } else {
            if (this.searchDirs == null) {
                this.searchDirs = new ArrayList<String>(0);
            }
            if (this.searchPaths == null) {
                this.searchPaths = new ArrayList<String>(0);
            }
        }
        this.FASTSearcher = new FASTSearchEngine(this.progressViewer);
        this.searchEngine = new DefaultSearchController(this, this.FASTSearcher);
        this.searchFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(this.searchDirs, this.searchPaths);
    }

    public FASTSearchEngine getSearchController() {
        return this.FASTSearcher;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(900, 600);
    }

    public File[] getSelectedFiles() {
        return this.searchFiles;
    }

    public List getSelectedNodes() {
        return new ArrayList();
    }

    @Override
    public void executionStarted() {
        super.executionStarted();
        if (((JComponent)((Object)this.resultViewer)).getWidth() == 0) {
            this.removeAll();
            this.makeResultsPanel();
            this.validate();
        }
        this.infoLabel.setText("");
    }

    @Override
    public void executionStopped() {
        super.executionStopped();
        this.infoLabel.setText("in " + this.searchFiles.length + " files (" + (double)this.searchEngine.getSearchDuration() / 1000.0 + " seconds)");
    }

    @Override
    public void handleException(Exception e) {
        if (e instanceof PatternSyntaxException) {
            JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.Formulation"), 0);
            this.searchEngine.stopExecution();
        } else if (e instanceof SAXException || e instanceof IOException) {
            JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.Parse"), 0);
        } else {
            super.handleException(e);
        }
    }

    @Override
    protected Query getQuery() {
        AnchorConstraint ac = new AnchorConstraint("", this.searchField.getText(), this.regexCheckBox.isSelected(), this.caseSensitiveCheckBox.isSelected());
        return new ContentQuery(ac, new EAFType(), this.searchFiles);
    }

    @Override
    protected void export() {
        FileChooser fc = new FileChooser(this);
        fc.createAndShowFileDialog(null, 1, null, LAST_DIR_KEY);
        if (fc.getSelectedFile() != null) {
            try {
                ContentResult result = (ContentResult)this.searchEngine.getResult();
                ContentMatch2TabDelimitedText.exportMatches(result.getMatches(), fc.getSelectedFile());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), ElanLocale.getString("MultipleFileSearch.Message.ExportError"), 0);
            }
        }
    }

    private void initComponents() {
        this.setBackground(Color.white);
        this.searchLogo.setFont(new Font("Serif", 0, 36));
        this.searchLogo.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.searchLogo.setForeground(Color.BLUE);
        this.searchField.setFont(this.searchField.getFont().deriveFont(16.0f));
        this.regexCheckBox.setOpaque(false);
        this.regexCheckBox.setFont(this.regexCheckBox.getFont().deriveFont(10.0f));
        this.regexCheckBox.setBackground(this.getBackground());
        this.caseSensitiveCheckBox.setOpaque(false);
        this.caseSensitiveCheckBox.setFont(this.caseSensitiveCheckBox.getFont().deriveFont(10.0f));
        this.caseSensitiveCheckBox.setBackground(this.getBackground());
        this.startStopPanel.setOpaque(false);
        this.exportButton.setFont(this.searchField.getFont().deriveFont(10.0f));
        this.exportButton.setEnabled(false);
        this.progressViewer.setOpaque(false);
        this.progressViewer.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), this.progressViewer.getBorder()));
        this.searchCategoryBox.setOpaque(false);
        this.searchCategoryBox.setBorder(new EmptyBorder(3, 0, 3, 0));
    }

    private void makeResultsPanel() {
        this.exportButton.setAlignmentX(0.0f);
        this.optionBox.add(this.exportButton);
        JPanel infoPanel = new JPanel(new FlowLayout());
        infoPanel.setOpaque(false);
        infoPanel.add(this.matchCounter);
        infoPanel.add(this.infoLabel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setOpaque(false);
        statusPanel.add((Component)((EAFMultipleFileResultViewer)this.resultViewer).getControlPanel(), "West");
        statusPanel.add((Component)infoPanel, "East");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.anchor = 17;
        this.add((Component)this.searchLogo, c);
        c.anchor = 10;
        this.add((Component)this.centralPanel, c);
        this.add((Component)this.startStopPanel, c);
        this.add((Component)this.optionBox, c);
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.progressViewer, c);
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)statusPanel, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)((JComponent)((Object)this.resultViewer)), c);
        ((EAFMultipleFileResultViewer)this.resultViewer).setColumnVisible("ColumnTriangle", false);
    }

    private void makeInitialPanel() {
        this.setLayout(new GridBagLayout());
        LinkButton defineDomainButton = new LinkButton(this.defineDomainAction);
        defineDomainButton.setFont(this.searchField.getFont().deriveFont(10.0f));
        defineDomainButton.setAlignmentX(0.0f);
        this.optionBox.add(defineDomainButton);
        this.domainLabel.setFont(this.searchField.getFont().deriveFont(10.0f));
        this.domainLabel.setAlignmentX(0.0f);
        this.optionBox.add(this.domainLabel);
        JPanel flagPanel = new JPanel(new GridLayout(1, 0));
        flagPanel.setOpaque(false);
        flagPanel.add(this.regexCheckBox);
        flagPanel.add(this.caseSensitiveCheckBox);
        this.centralPanel.setOpaque(false);
        this.centralPanel.add((Component)this.searchCategoryBox, "North");
        this.centralPanel.add((Component)this.searchField, "Center");
        this.centralPanel.add((Component)flagPanel, "South");
        JPanel panel = new JPanel(new FlowLayout());
        panel.setOpaque(false);
        panel.add(this.centralPanel);
        panel.add(this.optionBox);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add((Component)this.searchLogo, c);
        this.add((Component)panel, c);
        this.add((Component)this.startStopPanel, c);
    }

    static /* synthetic */ File[] access$202(FASTSearchPanel x0, File[] x1) {
        x0.searchFiles = x1;
        return x1;
    }
}

