/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.smfsearch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.mpi.util.FileUtility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IMDISessionParser {
    public static final String EAF = "text/x-eaf+xml";
    private SAXParser parser;
    private List<String> files = new ArrayList<String>(5);

    public IMDISessionParser() throws SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        try {
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }

    public synchronized List<String> parse(String pathToImdiSession) throws IOException, SAXException {
        if (pathToImdiSession == null) {
            return null;
        }
        this.files.clear();
        this.parser.parse(pathToImdiSession, (DefaultHandler)new SessionHandler());
        pathToImdiSession = pathToImdiSession.replace('\\', '/');
        ArrayList<String> retList = new ArrayList<String>(this.files.size());
        String path = null;
        for (int i = 0; i < this.files.size(); ++i) {
            path = this.files.get(i);
            if (path.startsWith("../") || path.startsWith("./")) {
                retList.add(FileUtility.getAbsolutePath(pathToImdiSession, path));
                continue;
            }
            retList.add(path);
        }
        return retList;
    }

    class SessionHandler
    extends DefaultHandler {
        private final String WRITTEN_RES = "WrittenResource";
        private final String LINK = "ResourceLink";
        private final String TYPE = "Type";
        private final String FORMAT = "Format";
        private String curResLink;
        private String curContent;
        private String curFormat;
        private String curType;
        private boolean inWritten = false;

        SessionHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = new String(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.inWritten) {
                if (localName.equals("Type")) {
                    this.curType = this.curContent;
                } else if (localName.equals("Format")) {
                    this.curFormat = this.curContent;
                } else if (localName.equals("ResourceLink")) {
                    this.curResLink = this.curContent;
                } else if (localName.equals("WrittenResource")) {
                    if (this.curFormat != null && this.curFormat.equalsIgnoreCase(IMDISessionParser.EAF)) {
                        if (this.curResLink != null) {
                            IMDISessionParser.this.files.add(this.urlToPath(this.curResLink));
                        }
                    } else if (this.curResLink != null && this.curResLink.toLowerCase().endsWith(".eaf")) {
                        IMDISessionParser.this.files.add(this.curResLink);
                    }
                    this.resetFields();
                    this.inWritten = false;
                }
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("WrittenResource")) {
                this.inWritten = true;
            }
        }

        void resetFields() {
            this.curResLink = null;
            this.curContent = null;
            this.curFormat = null;
            this.curType = null;
        }

        private String urlToPath(String url) {
            if (url == null) {
                return url;
            }
            try {
                int prevSl;
                URL u = new URL(url);
                String prot = u.getProtocol();
                if (prot != null) {
                    if (prot.equals("file")) {
                        int prevSl2;
                        Object path = u.getPath();
                        int index = ((String)path).indexOf("/../");
                        if (index > 0 && (prevSl2 = ((String)path).lastIndexOf(47, index - 1)) > -1) {
                            path = ((String)path).substring(0, prevSl2) + ((String)path).substring(index + 3);
                        }
                        return path;
                    }
                    return url;
                }
                Object path = url;
                int index = ((String)path).indexOf("/../");
                if (index > 0 && (prevSl = ((String)path).lastIndexOf(47, index - 1)) > -1) {
                    path = ((String)path).substring(0, prevSl) + ((String)path).substring(index + 3);
                }
                return path;
            }
            catch (MalformedURLException mue) {
                return url;
            }
        }
    }
}

