/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import mpi.eudico.client.annotator.spellcheck.WebServiceClient;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClamClient
implements WebServiceClient {
    String host;
    HttpHost httpHost;
    protected String basePath;
    HttpClientContext context;
    private WebServiceClient.AuthenticationProtocol protocol;
    private String username;
    private String password;
    private String scheme;
    private CloseableHttpClient httpclient;

    public ClamClient(String host, String scheme, String path, String username, String password) {
        this.host = host;
        this.scheme = scheme;
        this.basePath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        this.username = username;
        this.password = password;
        this.protocol = WebServiceClient.AuthenticationProtocol.DIGEST;
    }

    public void initialize() {
        this.createOrUpdateHttpHost();
        this.creatOrUpdateContext();
        this.httpclient = HttpClients.createDefault();
    }

    private void createOrUpdateHttpHost() {
        int port = this.scheme.equals("https") ? 443 : 80;
        this.httpHost = new HttpHost(this.host, port, this.scheme);
    }

    private void creatOrUpdateContext() {
        if (this.protocol.equals((Object)WebServiceClient.AuthenticationProtocol.DIGEST)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            BasicAuthCache authCache = new BasicAuthCache();
            DigestScheme digestAuth = new DigestScheme();
            authCache.put(this.httpHost, (AuthScheme)digestAuth);
            this.context = HttpClientContext.create();
            this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        } else if (this.protocol.equals((Object)WebServiceClient.AuthenticationProtocol.OAUTH)) {
            // empty if block
        }
    }

    protected String request(Method method, String fullPath, List<NameValuePair> data) {
        String body;
        block11: {
            body = null;
            try {
                HttpPut request = null;
                switch (method) {
                    case GET: {
                        if (data != null && !data.isEmpty()) {
                            fullPath = ((String)fullPath).endsWith("?") ? fullPath : (String)fullPath + "?";
                            fullPath = (String)fullPath + URLEncodedUtils.format(data, (String)"utf-8");
                        }
                        request = new HttpGet((String)fullPath);
                        break;
                    }
                    case POST: {
                        HttpPost httpPost = new HttpPost((String)fullPath);
                        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
                        request = httpPost;
                        break;
                    }
                    case PUT: {
                        request = new HttpPut((String)fullPath);
                        break;
                    }
                    case DELETE: {
                        request = new HttpDelete((String)fullPath);
                    }
                }
                CloseableHttpResponse response = this.httpclient.execute(this.httpHost, (HttpRequest)request, (HttpContext)this.context);
                HttpEntity entity = response.getEntity();
                body = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (ClientProtocolException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Error in the http protocol when connecting to " + (String)fullPath + " (" + e.getMessage() + ")");
                }
            }
            catch (IOException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block11;
                ClientLogger.LOG.warning("Error connecting to " + (String)fullPath + " (" + e.getMessage() + ")");
            }
        }
        return body;
    }

    public void createProject(String projectName) {
        this.request(Method.PUT, this.basePath + "/" + projectName, null);
    }

    public void deleteProject(String projectName) {
        this.request(Method.DELETE, this.basePath + "/" + projectName, null);
    }

    public void uploadText(String projectName, String fileName, String text) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        data.add(ClamClient.makeNameValuePair("inputtemplate", "textinput"));
        data.add(ClamClient.makeNameValuePair("contents", text));
        this.request(Method.POST, this.basePath + "/" + projectName + "/input/" + fileName, data);
    }

    public void startProject(String projectName, String sensitivity) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        data.add(ClamClient.makeNameValuePair("sensitivity", sensitivity));
        this.request(Method.POST, this.basePath + "/" + projectName, data);
    }

    public void pollProject(String projectName) {
        block8: {
            String body = this.request(Method.GET, this.basePath + "/" + projectName, null);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader(body)));
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodeList = (NodeList)xPath.evaluate("/clam/status/@errors", document.getDocumentElement(), XPathConstants.NODESET);
            }
            catch (ParserConfigurationException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Error in parser configuration when parsing XML from " + this.basePath + " (" + e.getMessage() + ")");
                }
            }
            catch (SAXException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Error when parsing XML from " + this.basePath + " (" + e.getMessage() + ")");
                }
            }
            catch (IOException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Error when connecting to " + this.basePath + " (" + e.getMessage() + ")");
                }
            }
            catch (XPathExpressionException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block8;
                ClientLogger.LOG.warning("Error in XPath expression when extracting nodes on " + this.basePath + " (" + e.getMessage() + ")");
            }
        }
    }

    public void retrieveOutput(String projectName, String outputFile) {
        String body = this.request(Method.GET, this.basePath + "/" + projectName + "/output/" + outputFile, null);
    }

    public static NameValuePair makeNameValuePair(final String name, final String value) {
        return new NameValuePair(){

            public String getValue() {
                return value;
            }

            public String getName() {
                return name;
            }
        };
    }

    @Override
    public void setHost(HttpHost host) {
        this.httpHost = host;
    }

    @Override
    public HttpHost getHost() {
        return this.httpHost;
    }

    @Override
    public void setPath(String path) {
        this.basePath = path;
    }

    @Override
    public String getPath() {
        return this.basePath;
    }

    @Override
    public void setUsername(String username) {
        if (!this.username.equals(username)) {
            this.username = username;
            this.creatOrUpdateContext();
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(String password) {
        if (!this.password.equals(password)) {
            this.password = password;
            this.creatOrUpdateContext();
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setSecure(Boolean ssl) {
        String scheme;
        String string = scheme = ssl != false ? "https" : "http";
        if (this.scheme != scheme) {
            this.scheme = scheme;
            this.createOrUpdateHttpHost();
        }
    }

    @Override
    public Boolean getSecure() {
        return this.scheme.equals("https");
    }

    @Override
    public void setAuthenticationProtocol(WebServiceClient.AuthenticationProtocol protocol) {
        if (this.protocol != protocol) {
            this.protocol = protocol;
            this.creatOrUpdateContext();
        }
    }

    @Override
    public WebServiceClient.AuthenticationProtocol getAuthenticationProtocol() {
        return this.protocol;
    }

    @Override
    public void setAuthentication(WebServiceClient.AuthenticationProtocol protocol, String username, String password) {
        if (this.protocol != protocol || !this.username.equals(username) || !this.password.equals(password)) {
            this.protocol = protocol;
            this.username = username;
            this.password = password;
            this.creatOrUpdateContext();
        }
    }

    protected static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

