/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.spellcheck.GeccoClient;
import mpi.eudico.client.annotator.spellcheck.HunspellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.util.Pair;

public class SpellCheckerFactory {
    public static ArrayList<Pair<String, String>> getDataFields(SpellCheckerType type) {
        switch (type) {
            case HUNSPELL: {
                return HunspellChecker.getDataFields();
            }
            case GECCO: {
                return GeccoClient.getDataFields();
            }
        }
        return null;
    }

    public static SpellChecker create(SpellCheckerType type, HashMap<String, String> args) {
        switch (type) {
            case HUNSPELL: {
                return HunspellChecker.create(args);
            }
            case GECCO: {
                return GeccoClient.create(args);
            }
        }
        return null;
    }

    public static String[] getTypes() {
        String[] types = new String[SpellCheckerType.values().length];
        int i = 0;
        for (SpellCheckerType type : SpellCheckerType.values()) {
            types[i] = type.name();
            ++i;
        }
        return types;
    }

    static enum SpellCheckerType {
        HUNSPELL,
        GECCO;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

