/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ShutdownListener;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerFactory;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerInitializationException;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.IoUtil;
import org.apache.xerces.impl.dv.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpellCheckerRegistry
implements ShutdownListener {
    private HashMap<String, SpellChecker> spellCheckers;
    Set<String> defaultCheckers = new HashSet<String>();
    private static SpellCheckerRegistry instance = null;
    public static final String privatePreferencesFile = "SpellCheckers.xml";

    private SpellCheckerRegistry() {
        FrameManager.getInstance().addWindowCloseListener(this);
        this.spellCheckers = new HashMap();
    }

    public static synchronized SpellCheckerRegistry getInstance() {
        if (instance == null) {
            instance = new SpellCheckerRegistry();
            instance.loadFrom(SettingSource.PREFERENCES);
        }
        return instance;
    }

    public SpellChecker getSpellChecker(String languageRef) {
        return this.spellCheckers.get(languageRef);
    }

    public Boolean hasSpellCheckerLoaded(String languageRef) {
        return this.spellCheckers.containsKey(languageRef);
    }

    public void putSpellChecker(String languageRef, SpellChecker checker) {
        this.putSpellChecker(languageRef, checker, false);
    }

    public void putSpellChecker(String languageRef, SpellChecker checker, Boolean isDefault) {
        this.spellCheckers.put(languageRef, checker);
        if (isDefault.booleanValue()) {
            this.defaultCheckers.add(languageRef);
        } else if (this.defaultCheckers.contains(languageRef)) {
            this.defaultCheckers.remove(languageRef);
        }
        this.updatePreferences();
    }

    public void delete(String languageRef) {
        this.spellCheckers.remove(languageRef);
        if (this.defaultCheckers.contains(languageRef)) {
            this.defaultCheckers.remove(languageRef);
        }
        this.updatePreferences();
    }

    private void updatePreferences() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Map.Entry<String, SpellChecker> entry : this.spellCheckers.entrySet()) {
            SpellChecker checker = entry.getValue();
            list.add((CallSite)((Object)(entry.getKey() + "," + checker.getPreferencesString())));
        }
        Preferences.set("SpellCheckerRegistry", list, null, true, true);
    }

    public HashMap<String, SpellChecker> getSpellCheckers() {
        return this.spellCheckers;
    }

    public synchronized void loadFrom(SettingSource source) {
        if (source.equals((Object)SettingSource.PROPERTIES)) {
            this.loadFromProperties();
        } else if (source.equals((Object)SettingSource.PREFERENCES)) {
            this.loadFromPreferences();
        }
    }

    public void loadFromProperties() {
        ResourceBundle resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanDefault");
        String geccoClientLanguages = resourcebundle.getString("GeccoClient.Languages");
        if (geccoClientLanguages != null) {
            String[] languages;
            for (String language : languages = geccoClientLanguages.split(",")) {
                if (SpellCheckerRegistry.getInstance().hasSpellCheckerLoaded(language).booleanValue()) continue;
                String url = resourcebundle.getString("GeccoClient.Url." + language);
                String username = resourcebundle.getString("GeccoClient.Username." + language);
                String passwordEncoded = resourcebundle.getString("GeccoClient.Password." + language);
                String password = new String(Base64.decode(passwordEncoded));
                HashMap<String, String> spellCheckerSettings = new HashMap<String, String>();
                spellCheckerSettings.put("url", url);
                spellCheckerSettings.put("username", username);
                spellCheckerSettings.put("password", password);
                SpellChecker spellChecker = SpellCheckerFactory.create(SpellCheckerFactory.SpellCheckerType.GECCO, spellCheckerSettings);
                if (spellChecker == null) continue;
                try {
                    spellChecker.initializeSpellChecker();
                    this.putSpellChecker(language, spellChecker, true);
                }
                catch (SpellCheckerInitializationException e) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) continue;
                    ClientLogger.LOG.warning("The spell checker '" + spellChecker.getInfo() + "'could not be initialized (" + e.getMessage() + ")");
                }
            }
        }
    }

    public void loadFromPreferences() {
        this.syncWithPrivatePreferences();
    }

    @Override
    public void somethingIsClosing(ShutdownListener.Event e) {
        if (e.getType() == 3) {
            this.savePrivatePreferences();
        }
    }

    private void savePrivatePreferences() {
        block6: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element root = doc.createElement("SPELL_CHECKERS");
                doc.appendChild(root);
                for (String languageRef : this.spellCheckers.keySet()) {
                    if (this.defaultCheckers.contains(languageRef)) continue;
                    SpellChecker checker = this.spellCheckers.get(languageRef);
                    Element l = doc.createElement("SPELL_CHECKER");
                    l.setAttribute("LANG_ID", languageRef);
                    l.setAttribute("PREFS", checker.getPreferencesString());
                    for (String newWord : checker.getUserDefinedWords()) {
                        Element w = doc.createElement("USER_DEFINED_WORD");
                        w.setTextContent(newWord);
                        l.appendChild(w);
                    }
                    root.appendChild(l);
                }
                String fileName = Constants.ELAN_DATA_DIR + File.separator + privatePreferencesFile;
                IoUtil.writeEncodedFile("UTF-8", fileName, doc.getDocumentElement());
            }
            catch (ParserConfigurationException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Error in XML parser configuration (" + e.getMessage() + ")");
                }
            }
            catch (Exception e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                ClientLogger.LOG.warning("Error when writing private preferences for spell checkers (" + e.getMessage() + ")");
            }
        }
    }

    private void syncWithPrivatePreferences() {
        block7: {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(false);
                parserFactory.setValidating(false);
                SAXParser parser = parserFactory.newSAXParser();
                SpellCheckersHandler sch = new SpellCheckersHandler();
                String fileName = Constants.ELAN_DATA_DIR + File.separator + privatePreferencesFile;
                parser.parse(fileName, (DefaultHandler)sch);
            }
            catch (SAXException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("The XML of the spell checking private preferences could not be read (" + e.getMessage() + ")");
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("The file of the spell checking private preferences could not be read (" + e.getMessage() + ")");
                }
            }
            catch (ParserConfigurationException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block7;
                ClientLogger.LOG.warning("No parser for the XML of the spell checking private preferences (" + e.getMessage() + ")");
            }
        }
    }

    public static enum SettingSource {
        PROPERTIES,
        PREFERENCES;

    }

    private class SpellCheckersHandler
    extends DefaultHandler {
        SpellChecker currentChecker;
        private StringBuffer curCharValue = new StringBuffer(1024);

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attrs) throws SAXException {
            if ("SPELL_CHECKER".equals(rawName)) {
                HashMap<String, String> args;
                String id = attrs.getValue("LANG_ID");
                String checkerStr = attrs.getValue("PREFS");
                SpellChecker checker = null;
                String[] checkerSettings = checkerStr.split(",");
                if (checkerSettings[0].equals(SpellCheckerFactory.SpellCheckerType.GECCO.toString())) {
                    args = new HashMap<String, String>();
                    args.put("url", checkerSettings[2] + checkerSettings[3]);
                    args.put("username", checkerSettings[4]);
                    args.put("password", checkerSettings[5]);
                    checker = SpellCheckerFactory.create(SpellCheckerFactory.SpellCheckerType.GECCO, args);
                } else if (checkerSettings[0].equals(SpellCheckerFactory.SpellCheckerType.HUNSPELL.toString())) {
                    args = new HashMap();
                    args.put("path", checkerSettings[1]);
                    checker = SpellCheckerFactory.create(SpellCheckerFactory.SpellCheckerType.HUNSPELL, args);
                }
                if (checker != null) {
                    try {
                        checker.initializeSpellChecker();
                        SpellCheckerRegistry.this.putSpellChecker(id, checker);
                        this.currentChecker = checker;
                    }
                    catch (SpellCheckerInitializationException e) {
                        if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                            ClientLogger.LOG.warning("The spell checker '" + checker.getInfo() + " could not be initialized (" + e.getMessage() + ")");
                        }
                    }
                }
            } else if ("USER_DEFINED_WORD".equals(rawName)) {
                this.curCharValue.setLength(0);
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) {
            if ("USER_DEFINED_WORD".equals(rawName)) {
                String word = this.curCharValue.toString();
                if (this.currentChecker != null) {
                    this.currentChecker.addUserDefinedWord(word);
                }
                this.curCharValue.setLength(0);
            } else if ("SPELL_CHECKER".equals(rawName)) {
                this.currentChecker = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curCharValue.append(ch, start, length);
        }
    }
}

