/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public abstract class AbstractDestTierAnnValueSpecStepPane
extends StepPane
implements ActionListener,
KeyListener,
ListSelectionListener {
    protected JRadioButton durationRadioButton;
    protected JRadioButton specificValueRB;
    protected JRadioButton tierValueRadioButton;
    protected JRadioButton smpteRB;
    protected JRadioButton palRB;
    protected JRadioButton pal50RB;
    protected JRadioButton ntscRB;
    protected JRadioButton msecRB;
    protected JRadioButton secRB;
    protected JRadioButton hrRB;
    protected JRadioButton concatValuesRB;
    protected JRadioButton sortByTimeRB;
    protected JRadioButton sortBySelectionRB;
    protected JTextField specificValueTF;
    protected JPanel tierValuePanel;
    protected JPanel buttonPanel;
    protected JScrollPane tierTableScrollPane;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected ButtonGroup valueKindRadioGroup;
    protected ButtonGroup concatValueRadioGroup;
    protected ButtonGroup timeRadioGroup;
    protected ButtonGroup smpteRadioGroup;
    protected JComboBox tierSelectBox;
    protected JTable sortTierTable;
    protected DefaultTableModel model;
    public static final int ANN_VALUE_TIME_FORMAT = 0;
    public static final int ANN_VALUE_SPECIFIC_VALUE = 1;
    public static final int ANN_VALUE_FROM_TIER = 2;
    public static final int ANN_VALUE_CONCAT_BASED_ON_TIME = 3;
    public static final int ANN_VALUE_CONCAT_BASED_ON_TIERORDER = 4;

    public AbstractDestTierAnnValueSpecStepPane(MultiStepPane mp) {
        super(mp);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        Insets globalInset = new Insets(5, 10, 5, 10);
        Insets singleTabInset = new Insets(0, 30, 0, 10);
        Insets doubleTabInset = new Insets(0, 50, 0, 10);
        Insets firstSingleTabInset = new Insets(5, 10, 0, 10);
        this.durationRadioButton = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.DurationValue"));
        this.specificValueRB = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.SpecificValue"));
        this.tierValueRadioButton = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.SpecificTier"));
        this.concatValuesRB = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.ConcatValues"), true);
        this.durationRadioButton.addActionListener(this);
        this.specificValueRB.addActionListener(this);
        this.tierValueRadioButton.addActionListener(this);
        this.concatValuesRB.addActionListener(this);
        this.valueKindRadioGroup = new ButtonGroup();
        this.valueKindRadioGroup.add(this.durationRadioButton);
        this.valueKindRadioGroup.add(this.tierValueRadioButton);
        this.valueKindRadioGroup.add(this.specificValueRB);
        this.valueKindRadioGroup.add(this.concatValuesRB);
        this.msecRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.MilliSec"), true);
        this.secRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.Seconds"));
        this.hrRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.smpteRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE"));
        this.palRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"), true);
        this.pal50RB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50"));
        this.ntscRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
        this.msecRB.addActionListener(this);
        this.secRB.addActionListener(this);
        this.hrRB.addActionListener(this);
        this.smpteRB.addActionListener(this);
        this.msecRB.setEnabled(false);
        this.secRB.setEnabled(false);
        this.hrRB.setEnabled(false);
        this.smpteRB.setEnabled(false);
        this.palRB.setEnabled(false);
        this.pal50RB.setEnabled(false);
        this.ntscRB.setEnabled(false);
        this.timeRadioGroup = new ButtonGroup();
        this.timeRadioGroup.add(this.msecRB);
        this.timeRadioGroup.add(this.secRB);
        this.timeRadioGroup.add(this.hrRB);
        this.timeRadioGroup.add(this.smpteRB);
        this.smpteRadioGroup = new ButtonGroup();
        this.smpteRadioGroup.add(this.palRB);
        this.smpteRadioGroup.add(this.pal50RB);
        this.smpteRadioGroup.add(this.ntscRB);
        JPanel smptePanel = new JPanel(new GridBagLayout());
        this.sortByTimeRB = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.ConcatValues.SortByAnnotationTime"), true);
        this.sortBySelectionRB = new JRadioButton(ElanLocale.getString("DestTierAnnValue.Radio.ConcatValues.SortByTierOrderSelection"));
        this.sortBySelectionRB.addActionListener(this);
        this.sortByTimeRB.addActionListener(this);
        this.concatValueRadioGroup = new ButtonGroup();
        this.concatValueRadioGroup.add(this.sortByTimeRB);
        this.concatValueRadioGroup.add(this.sortBySelectionRB);
        this.specificValueTF = new JTextField();
        this.specificValueTF.setEnabled(false);
        this.specificValueTF.addKeyListener(this);
        this.tierSelectBox = new JComboBox();
        this.tierSelectBox.setEnabled(false);
        this.model = new DefaultTableModel();
        this.sortTierTable = new JTable(this.model);
        this.model.addColumn(ElanLocale.getString("DestTierAnnValue.Column.SelectedTiers"));
        this.sortTierTable.setSelectionMode(0);
        this.sortTierTable.getSelectionModel().addListSelectionListener(this);
        this.tierTableScrollPane = new JScrollPane(this.sortTierTable);
        this.tierTableScrollPane.setSize(200, 100);
        this.tierTableScrollPane.setEnabled(false);
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.moveUpButton.setIcon(upIcon);
            this.moveDownButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.moveUpButton.setText("Up");
            this.moveDownButton.setText("Down");
        }
        this.buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.moveUpButton, gbc);
        gbc.gridx = 1;
        this.buttonPanel.add((Component)this.moveDownButton, gbc);
        this.tierValuePanel = new JPanel(new GridBagLayout());
        this.tierValuePanel.setBorder(new TitledBorder(ElanLocale.getString("DestTierAnnValue.Panel.Title.TierValue")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = firstSingleTabInset;
        this.tierValuePanel.add((Component)this.durationRadioButton, gbc);
        gbc.insets = singleTabInset;
        gbc.gridy = 1;
        this.tierValuePanel.add((Component)this.msecRB, gbc);
        gbc.gridy = 2;
        this.tierValuePanel.add((Component)this.secRB, gbc);
        gbc.gridy = 3;
        this.tierValuePanel.add((Component)this.hrRB, gbc);
        gbc.gridy = 4;
        this.tierValuePanel.add((Component)this.smpteRB, gbc);
        GridBagConstraints smpteGbc = new GridBagConstraints();
        smpteGbc.anchor = 18;
        smpteGbc.fill = 0;
        smptePanel.add((Component)this.palRB, smpteGbc);
        smpteGbc.gridx = 1;
        smptePanel.add((Component)this.pal50RB, smpteGbc);
        smpteGbc.gridx = 2;
        smpteGbc.fill = 2;
        smpteGbc.weightx = 1.0;
        smptePanel.add((Component)this.ntscRB, smpteGbc);
        gbc.gridy = 5;
        gbc.insets = doubleTabInset;
        this.tierValuePanel.add((Component)smptePanel, gbc);
        gbc.gridy = 6;
        gbc.insets = globalInset;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.tierValuePanel.add((Component)this.specificValueRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.tierValuePanel.add((Component)this.specificValueTF, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        this.tierValuePanel.add((Component)this.tierValueRadioButton, gbc);
        gbc.gridx = 1;
        this.tierValuePanel.add((Component)this.tierSelectBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        this.tierValuePanel.add((Component)this.concatValuesRB, gbc);
        gbc.gridy = 9;
        gbc.insets = singleTabInset;
        this.tierValuePanel.add((Component)this.sortByTimeRB, gbc);
        gbc.gridy = 10;
        gbc.insets = singleTabInset;
        this.tierValuePanel.add((Component)this.sortBySelectionRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 50, 0, 10);
        this.tierValuePanel.add((Component)this.tierTableScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 12;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 50, 0, 10);
        this.tierValuePanel.add((Component)this.buttonPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.insets = globalInset;
        this.add((Component)this.tierValuePanel, gbc);
    }

    @Override
    public abstract String getStepTitle();

    @Override
    public void enterStepForward() {
        int i;
        List tierList = (List)this.multiPane.getStepProperty("SelectedTiers");
        this.tierSelectBox.removeAllItems();
        for (i = 0; i < tierList.size(); ++i) {
            this.tierSelectBox.addItem(((String)tierList.get(i)).toString());
        }
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        if (!this.sortBySelectionRB.isSelected()) {
            this.sortTierTable.setForeground(Color.LIGHT_GRAY);
            this.sortTierTable.setEnabled(false);
        }
        for (i = 0; i < tierList.size(); ++i) {
            this.model.addRow(new String[]{(String)tierList.get(i)});
        }
        this.updateButtonStates();
        this.updateUIElements();
    }

    @Override
    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        return true;
    }

    @Override
    public boolean leaveStepForward() {
        ArrayList<String> tierOrder = null;
        int annotationValueType = -1;
        if (this.durationRadioButton.isSelected()) {
            annotationValueType = 0;
        } else if (this.specificValueRB.isSelected()) {
            annotationValueType = 1;
        } else if (this.tierValueRadioButton.isSelected()) {
            annotationValueType = 2;
        } else if (this.concatValuesRB.isSelected()) {
            if (this.sortByTimeRB.isSelected()) {
                annotationValueType = 3;
            } else if (this.sortBySelectionRB.isSelected()) {
                annotationValueType = 4;
                tierOrder = new ArrayList<String>();
                for (int i = 0; i < this.sortTierTable.getRowCount(); ++i) {
                    tierOrder.add((String)this.sortTierTable.getValueAt(i, 0));
                }
            }
        }
        this.multiPane.putStepProperty("AnnotationValueType", annotationValueType);
        this.multiPane.putStepProperty("TierOrder", tierOrder);
        String timeFormat = null;
        boolean usePalFormat = true;
        if (this.msecRB.isSelected()) {
            timeFormat = "ms";
        } else if (this.secRB.isSelected()) {
            timeFormat = "ss.ms";
        } else if (this.hrRB.isSelected()) {
            timeFormat = "hh:mm:ss.ms";
        } else if (this.smpteRB.isSelected() && this.palRB.isSelected()) {
            timeFormat = "PAL";
            usePalFormat = true;
        } else if (this.smpteRB.isSelected() && this.pal50RB.isSelected()) {
            timeFormat = "PAL-50fps";
            usePalFormat = false;
        } else if (this.smpteRB.isSelected() && this.ntscRB.isSelected()) {
            timeFormat = "NTSC";
            usePalFormat = false;
        }
        this.multiPane.putStepProperty("TimeFormat", timeFormat);
        this.multiPane.putStepProperty("UsePalFormat", usePalFormat);
        this.multiPane.putStepProperty("AnnotationValue", this.specificValueTF.getText().trim());
        this.multiPane.putStepProperty("AnnFromTier", this.tierSelectBox.getSelectedItem());
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public boolean doFinish() {
        this.multiPane.nextStep();
        return false;
    }

    protected void moveDown() {
        if (this.sortTierTable == null || this.model == null) {
            return;
        }
        int row = this.sortTierTable.getSelectedRow();
        this.model.moveRow(row, row, row + 1);
        this.sortTierTable.changeSelection(row + 1, 0, false, false);
    }

    protected void moveUp() {
        if (this.sortTierTable == null || this.model == null) {
            return;
        }
        int row = this.sortTierTable.getSelectedRow();
        this.model.moveRow(row, row, row - 1);
        this.sortTierTable.changeSelection(row - 1, 0, false, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.moveUpButton) {
            this.moveUp();
            return;
        }
        if (e.getSource() == this.moveDownButton) {
            this.moveDown();
            return;
        }
        this.updateUIElements();
    }

    private void updateUIElements() {
        boolean b = this.durationRadioButton.isSelected();
        this.msecRB.setEnabled(b);
        this.secRB.setEnabled(b);
        this.hrRB.setEnabled(b);
        this.smpteRB.setEnabled(b);
        this.palRB.setEnabled(b && this.smpteRB.isSelected());
        this.pal50RB.setEnabled(b && this.smpteRB.isSelected());
        this.ntscRB.setEnabled(b && this.smpteRB.isSelected());
        b = this.concatValuesRB.isSelected();
        this.sortByTimeRB.setEnabled(b);
        this.sortBySelectionRB.setEnabled(b);
        this.sortTierTable.setEnabled(b && this.sortBySelectionRB.isSelected());
        if (this.sortTierTable.isEnabled()) {
            this.sortTierTable.setForeground(Color.BLACK);
        } else {
            this.sortTierTable.setForeground(Color.LIGHT_GRAY);
        }
        this.tierSelectBox.setEnabled(this.tierValueRadioButton.isSelected());
        this.specificValueTF.setEnabled(this.specificValueRB.isSelected());
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.sortTierTable.getSelectedRow() == 0) {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(true);
        } else if (this.sortTierTable.getSelectedRow() == this.sortTierTable.getRowCount() - 1) {
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(false);
        } else if (this.sortTierTable.getSelectedRow() > 0) {
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(true);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }
}

