/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotationsToTiersDlg
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private JTable tierTable;
    private TierTableModel tierModel;
    private SpinnerNumberModel spinnerModel;
    private JSpinner maxNumSpinner;

    public AnnotationsToTiersDlg(Frame owner, TranscriptionImpl transcription) throws HeadlessException {
        super(owner);
        this.transcription = transcription;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.tierModel = new TierTableModel(this.transcription.getTiers(), new String[]{"TierName"});
        this.tierTable = new JTable(this.tierModel);
        this.tierTable.getSelectionModel().setSelectionMode(0);
        TableRowSorter<TierTableModel> rowSorter = new TableRowSorter<TierTableModel>(this.tierModel);
        this.tierTable.setRowSorter(rowSorter);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.tierPanel.setLayout(new GridBagLayout());
        Dimension tableDim = new Dimension(450, 160);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)tierScrollPane, gbc);
        this.optionsPanel.setLayout(new GridBagLayout());
        insets.bottom = 3;
        JLabel maxNumLabel = new JLabel(ElanLocale.getString("AnnotationsToTiersDlg.Label.MaxNumTiers"));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)maxNumLabel, gbc);
        this.spinnerModel = new SpinnerNumberModel(10, 1, 100, 1);
        this.maxNumSpinner = new JSpinner(this.spinnerModel);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.maxNumSpinner, gbc);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("AnnotationsToTiersDlg.Title"));
        this.titleLabel.setText(ElanLocale.getString("AnnotationsToTiersDlg.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("FillGapsDialog.Label.SelectTiers")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Options")));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void extractTiers() {
        if (this.transcription != null) {
            if (this.tierTable.getRowCount() > 0) {
                this.tierTable.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                this.startButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.startButton) {
            int selectedRow = this.tierTable.getSelectedRow();
            if (selectedRow < 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
                return;
            }
            int row = this.tierTable.convertRowIndexToModel(selectedRow);
            String tierName = this.tierModel.getValueAt(row, 0);
            int maxNumTier = this.spinnerModel.getNumber().intValue();
            Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationValuesToTiers");
            command.execute(this.transcription, new Object[]{tierName, maxNumTier});
        }
    }
}

