/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyAnnotationsOfTierStep2
extends StepPane
implements ListSelectionListener {
    private TranscriptionImpl transcription;
    private TierTableModel tierTableModel;
    private JTable tierTable;
    protected JScrollPane tierTableScrollPane;
    protected JPanel tierSelectionPanel;
    private Insets globalInset = new Insets(5, 10, 5, 10);
    protected String curSourceTierName;

    public CopyAnnotationsOfTierStep2(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.tierTableScrollPane = new JScrollPane();
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.globalInset = new Insets(5, 10, 5, 10);
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("CopyAnnotationsDialog.SelectTarget")));
        this.tierTable = new JTable();
        this.tierTable.setSelectionMode(0);
        this.tierTable.setShowVerticalLines(true);
        if (this.transcription != null) {
            this.tierTableModel = new TierTableModel(new ArrayList<TierImpl>(), new String[]{"TierName", "Parent"});
            this.tierTable = new JTable(this.tierTableModel);
            this.tierTable.getSelectionModel().setSelectionMode(0);
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            TableRowSorter<TierTableModel> rowSorter = new TableRowSorter<TierTableModel>(this.tierTableModel);
            this.tierTable.setRowSorter(rowSorter);
            this.tierTableScrollPane.setViewportView(this.tierTable);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
        this.add((Component)this.tierSelectionPanel, "Center");
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CopyAnnotationsDialog.SelectTarget");
    }

    @Override
    public void enterStepForward() {
        String sourceTierName = null;
        List selectedTiers = (List)this.multiPane.getStepProperty("SelectedTiers");
        if (selectedTiers != null && !selectedTiers.isEmpty()) {
            sourceTierName = String.valueOf(selectedTiers.get(0));
        }
        if (sourceTierName != null) {
            TierImpl sourceTier;
            if (this.curSourceTierName != null) {
                if (this.curSourceTierName.equals(sourceTierName)) {
                    this.multiPane.setButtonEnabled(1, this.tierTable.getSelectedRow() > -1);
                    return;
                }
                if (this.tierTableModel.getRowCount() > 0) {
                    this.tierTable.setRowSorter(null);
                    this.tierTableModel.removeAllRows();
                }
                this.curSourceTierName = sourceTierName;
            } else {
                this.curSourceTierName = sourceTierName;
            }
            if (this.transcription != null && (sourceTier = this.transcription.getTierWithId(sourceTierName)) != null) {
                List<TierImpl> childTiers = sourceTier.getChildTiers();
                for (TierImpl tier : childTiers) {
                    this.tierTableModel.addRow(tier);
                }
                for (TierImpl tier : this.transcription.getTiers()) {
                    if (tier.getParentTier() != null || tier == sourceTier) continue;
                    this.tierTableModel.addRow(tier);
                }
            }
        } else if (this.tierTableModel.getRowCount() > 0) {
            this.tierTable.setRowSorter(null);
            this.tierTableModel.removeAllRows();
        }
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTable.getSelectedRow() > -1) {
            int row = this.tierTable.getSelectedRow();
            int column = this.tierTableModel.findColumn("TierName");
            String tierName = this.tierTableModel.getValueAt(this.tierTable.convertRowIndexToModel(row), column);
            this.multiPane.putStepProperty("TargetTier", tierName);
            return true;
        }
        return false;
    }

    @Override
    public boolean leaveStepBackward() {
        return super.leaveStepBackward();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.multiPane.setButtonEnabled(1, this.tierTable.getSelectedRow() > -1);
    }
}

