/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.CopyTierCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.EditTypeDialog2;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class CopyTierStep3
extends ProgressStepPane
implements ListSelectionListener,
ActionListener,
ProgressListener {
    private TranscriptionImpl transcription;
    private JLabel tierOverview;
    private JTable typeTable;
    private JScrollPane scrollPane;
    private String tierName;
    private String newParentName;
    private TierImpl selTier;
    private TierImpl newParent;
    private LinguisticType curType;
    private LinguisticType selType;
    private String selTypeName;
    private LinguisticTypeTableModel typeModel;
    private String[] columns;
    private List<LinguisticType> types;
    private JButton typButton;
    private GridBagLayout layout;
    private CopyTierCommand com;
    private boolean copyMode = false;
    private boolean includeDepTiers = true;
    private boolean copyIncludesTimeAlignableChild;
    private JCheckBox omitDependingTiersCB;

    public CopyTierStep3(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.types = this.transcription.getLinguisticTypes();
        if (multiPane.getStepProperty("CopyMode") != null) {
            this.copyMode = true;
        }
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.tierOverview = new JLabel();
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setIcon(untickIcon);
        cbRenderer.setSelectedIcon(tickIcon);
        cbRenderer.setHorizontalAlignment(0);
        if (this.types != null) {
            this.columns = new String[]{"Type", "Stereotype", "CV", "TimeAlignable"};
            this.typeModel = new LinguisticTypeTableModel(this.types, this.columns);
        } else {
            this.typeModel = new LinguisticTypeTableModel();
        }
        this.typeTable = new JTable(this.typeModel);
        this.typeTable.getSelectionModel().setSelectionMode(0);
        this.typeTable.getSelectionModel().addListSelectionListener(this);
        int columnCount = this.typeModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.typeModel.getColumnClass(i) != String.class) {
                this.typeTable.getColumnModel().getColumn(i).setPreferredWidth(35);
            }
            if (this.typeModel.getColumnClass(i) != Boolean.class) continue;
            this.typeTable.getColumnModel().getColumn(i).setCellRenderer(cbRenderer);
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.typeTable);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.tierOverview, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        this.typButton = new JButton(ElanLocale.getString("Menu.Type.AddNewType"));
        this.typButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        gbc.weightx = 0.0;
        this.add((Component)this.typButton, gbc);
        this.omitDependingTiersCB = new JCheckBox(ElanLocale.getString("MultiStep.Reparent.OmitDepTiers"));
        this.omitDependingTiersCB.setVisible(false);
        this.omitDependingTiersCB.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        gbc.weightx = 0.0;
        this.add((Component)this.omitDependingTiersCB, gbc);
    }

    private void adjustComponents() {
        JPanel progressPanel = new JPanel(new GridBagLayout());
        JPanel filler = new JPanel();
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        progressPanel.add((Component)filler, gbc);
        this.progressLabel = new JTextArea("...");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        progressPanel.add((Component)this.progressLabel, gbc);
        this.progressLabel.setEditable(false);
        this.progressLabel.setBackground(progressPanel.getBackground());
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setValue(0);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        progressPanel.add((Component)this.progressBar, gbc);
        this.remove(this.scrollPane);
        this.remove(this.typButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)progressPanel, gbc);
        this.revalidate();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiStep.Reparent.SelectType");
    }

    @Override
    public void enterStepForward() {
        Object par;
        this.tierName = (String)this.multiPane.getStepProperty("SelTier");
        this.selTier = this.transcription.getTierWithId(this.tierName);
        if (this.selTier != null) {
            this.curType = this.selTier.getLinguisticType();
        }
        if ((par = this.multiPane.getStepProperty("SelNewParent")) != null) {
            this.newParentName = (String)par;
            this.newParent = this.transcription.getTierWithId(this.newParentName);
        } else {
            this.newParent = null;
            this.newParentName = "-";
        }
        this.tierOverview.setText("<html><table><tr><td>" + ElanLocale.getString("MultiStep.Reparent.SelectedTier") + " </td><td>" + this.tierName + "</td></tr><tr><td>" + ElanLocale.getString("MultiStep.Reparent.SelectedParent") + " </td><td>" + this.newParentName + "</td></tr>");
        Constraint con = null;
        if (this.newParent != null) {
            con = this.newParent.getLinguisticType().getConstraints();
        }
        if (this.newParent == null) {
            this.typeModel.showOnlyStereoTypes(new int[]{-1});
        } else if (con == null || con.getStereoType() == 0 || con.getStereoType() == 1) {
            this.typeModel.showOnlyStereoTypes(new int[]{0, 1, 3, 4});
        } else {
            this.typeModel.showOnlyStereoTypes(new int[]{3, 4});
        }
        Object include = this.multiPane.getStepProperty("IncludeDepTiers");
        if (include instanceof Boolean) {
            this.includeDepTiers = (Boolean)include;
        }
        this.copyIncludesTimeAlignableChild = false;
        if (this.includeDepTiers) {
            List<TierImpl> depTiers = this.selTier.getChildTiers();
            for (TierImpl dep : depTiers) {
                if (!dep.isTimeAlignable()) continue;
                this.copyIncludesTimeAlignableChild = true;
                break;
            }
        }
        this.omitDependingTiersCB.setVisible(false);
        int col = this.typeModel.findColumn("Type");
        for (int i = 0; i < this.typeModel.getRowCount(); ++i) {
            Object o = this.typeModel.getValueAt(i, col);
            if (!(o instanceof String) || !this.curType.getLinguisticTypeName().equals(o)) continue;
            this.selTypeName = (String)o;
            this.typeTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    @Override
    public void enterStepBackward() {
    }

    @Override
    public boolean leaveStepForward() {
        return false;
    }

    @Override
    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        return true;
    }

    @Override
    public void cancelled() {
    }

    @Override
    public void finished() {
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        this.adjustComponents();
        if (this.tierName != null && this.newParentName != null && this.selTypeName != null) {
            Boolean renameOriginalTiers = Boolean.FALSE;
            if (this.copyMode) {
                this.com = (CopyTierCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.CopyTier");
                Object rename = this.multiPane.getStepProperty("RenameOriginalTiers");
                if (rename instanceof Boolean) {
                    renameOriginalTiers = (Boolean)rename;
                }
            } else {
                this.com = (CopyTierCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ReparentTier");
            }
            boolean omitDependentTiers = this.omitDependingTiersCB.isVisible() && this.omitDependingTiersCB.isSelected();
            this.com.addProgressListener(this);
            this.com.execute(this.transcription, new Object[]{this.tierName, this.newParentName, this.selTypeName, this.includeDepTiers && !omitDependentTiers, renameOriginalTiers});
            return false;
        }
        this.progressLabel.setText("Illegal selection");
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.typeModel != null && !lse.getValueIsAdjusting()) {
            int row = this.typeTable.getSelectedRow();
            if (row > -1) {
                int col = this.typeModel.findColumn("Type");
                String typeName = (String)this.typeModel.getValueAt(row, col);
                int size = this.types.size();
                for (int i = 0; i < size; ++i) {
                    LinguisticType t = this.types.get(i);
                    if (!t.getLinguisticTypeName().equals(typeName)) continue;
                    this.selTypeName = typeName;
                    this.selType = t;
                    break;
                }
            } else {
                this.selTypeName = null;
                this.selType = null;
            }
        }
        this.maybeEnableFinish();
    }

    private void maybeEnableFinish() {
        boolean enableFinish;
        if (this.selType == null) {
            enableFinish = false;
        } else if (this.copyIncludesTimeAlignableChild) {
            enableFinish = this.selType.isTimeAlignable();
            this.omitDependingTiersCB.setVisible(!enableFinish);
            if (this.omitDependingTiersCB.isVisible() && this.omitDependingTiersCB.isSelected()) {
                enableFinish = true;
            }
        } else {
            enableFinish = true;
        }
        this.multiPane.setButtonEnabled(3, enableFinish);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.omitDependingTiersCB) {
            this.maybeEnableFinish();
        } else if (source == this.typButton) {
            this.addNewLinguisticType();
        }
    }

    private void addNewLinguisticType() {
        int i;
        int i2;
        int col;
        int row;
        String typeName = null;
        if (this.typeTable.getRowCount() > 0 && (row = this.typeTable.getSelectedRow()) > -1) {
            col = this.typeModel.findColumn("Type");
            typeName = (String)this.typeModel.getValueAt(row, col);
        }
        ArrayList<String> curTypes = new ArrayList<String>();
        col = this.typeModel.findColumn("Type");
        for (i2 = 0; i2 < this.typeModel.getRowCount(); ++i2) {
            curTypes.add((String)this.typeModel.getValueAt(i2, col));
        }
        new EditTypeDialog2(null, true, this.transcription, 0).setVisible(true);
        this.typeModel.removeAllRows();
        for (i2 = 0; i2 < this.types.size(); ++i2) {
            this.typeModel.addLinguisticType(this.types.get(i2));
        }
        int firstNewOrChanged = -1;
        String tname = null;
        for (i = 0; i < this.typeModel.getRowCount(); ++i) {
            tname = (String)this.typeModel.getValueAt(i, col);
            if (curTypes.contains(tname)) continue;
            firstNewOrChanged = i;
            break;
        }
        if (firstNewOrChanged > -1) {
            this.selTypeName = (String)this.typeTable.getValueAt(firstNewOrChanged, col);
            this.typeTable.setRowSelectionInterval(firstNewOrChanged, firstNewOrChanged);
        } else if (typeName != null) {
            tname = null;
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                tname = (String)this.typeModel.getValueAt(i, col);
                if (!typeName.equals(tname)) continue;
                this.selTypeName = tname;
                this.typeTable.setRowSelectionInterval(i, i);
                break;
            }
        }
    }

    @Override
    protected void endOfProcess() {
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.multiPane.close();
    }
}

