/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateAnnsOnDependentTiersStep1
extends StepPane
implements TableModelListener {
    private TranscriptionImpl transcription;
    private JTable tierTable;
    private TierExportTableModel model;

    public CreateAnnsOnDependentTiersStep1(MultiStepPane multiPane, TranscriptionImpl trans) {
        super(multiPane);
        this.transcription = trans;
        this.initComponents();
        this.extractTiers();
        this.loadPreferences();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.model = new TierExportTableModel();
        this.tierTable = new TierExportTable(this.model);
        this.model.addTableModelListener(this);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension tableDim = new Dimension(450, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)tierScrollPane, gridBagConstraints);
    }

    private void extractTiers() {
        if (this.transcription != null) {
            List<TierImpl> v = this.transcription.getTiers();
            for (int i = 0; i < v.size(); ++i) {
                TierImpl t = v.get(i);
                if (t.getChildTiers().size() <= 0) continue;
                this.model.addRow(Boolean.FALSE, t.getName());
            }
        }
    }

    private List<String> getSelectedTiers() {
        ArrayList<String> tiers = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object nameObj;
            String nameString;
            TierImpl t;
            Object selObj = this.model.getValueAt(i, 0);
            if (selObj != Boolean.TRUE || (t = this.transcription.getTierWithId(nameString = (nameObj = this.model.getValueAt(i, 1)).toString())) == null) continue;
            if (t.hasParentTier()) {
                if (tiers.contains(t.getParentTier().getName())) continue;
                tiers.add(nameString);
                continue;
            }
            tiers.add(nameString);
        }
        return tiers;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Title");
    }

    @Override
    public void enterStepForward() {
        List<String> selectedTiers = this.getSelectedTiers();
        if (!selectedTiers.isEmpty()) {
            this.multiPane.setButtonEnabled(1, true);
        }
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(4, true);
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("SelectedParentTiers", this.getSelectedTiers());
        this.savePreferences();
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() != 0 || e.getFirstRow() < 0 || e.getColumn() == -1) {
            return;
        }
        List<String> selectedTiers = this.getSelectedTiers();
        this.multiPane.setButtonEnabled(1, !selectedTiers.isEmpty());
    }

    private void savePreferences() {
        List<String> selTiers = this.getSelectedTiers();
        if (!selTiers.isEmpty()) {
            Preferences.set("CreateAnnsOnDependentTiers.SelectedParentTiers", selTiers, null);
        }
    }

    private void loadPreferences() {
        List<String> selTiers = Preferences.getListOfString("CreateAnnsOnDependentTiers.SelectedParentTiers", null);
        int selected = 0;
        if (selTiers != null && !selTiers.isEmpty()) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                Object nameObj = this.model.getValueAt(i, 1);
                if (!selTiers.contains(nameObj)) continue;
                this.model.setValueAt(Boolean.TRUE, i, 0);
                ++selected;
            }
        }
        if (selected == 0) {
            this.model.setValueAt(Boolean.TRUE, 0, 0);
        }
    }
}

