/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.tier.AnnotationFromOverlaps;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MergeTiers
extends AnnotationFromOverlaps {
    private boolean overlapsOnly;

    public MergeTiers(String name) {
        super(name);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.report.setName(ElanLocale.getString("MergeTiers.Title.Report"));
        this.overlapsOnly = (Boolean)arguments[13];
        arguments[13] = null;
        super.execute(receiver, arguments);
    }

    protected ArrayList<AnnotationValuesRecord> getComputedAnnRecord(List<TierImpl> tierList, TranscriptionImpl transcription) {
        ArrayList<AnnotationValuesRecord> mergedAnnList = new ArrayList<AnnotationValuesRecord>();
        if (tierList.size() <= 0) {
            return mergedAnnList;
        }
        List<Object> annotations = new ArrayList<AbstractAnnotation>();
        if (this.overlapsOnly) {
            AnnotationValuesRecord mergeRecord;
            long endTime;
            long beginTime;
            int i;
            TierImpl currentTier = tierList.get(0);
            int annCount = currentTier.getNumberOfAnnotations();
            float perAnn = 60.0f;
            if (this.processMode == 0) {
                if (annCount > 0) {
                    perAnn = 60.0f / (float)annCount;
                }
                this.progressUpdate(10, this.calculating);
            }
            if (annCount <= 0) {
                return mergedAnnList;
            }
            boolean valueFromCurrentTier = this.annotationValueType == 2 && currentTier.getName().equals(this.annFromTier);
            String constraint = this.getConstraint(currentTier.getName());
            annotations = currentTier.getAnnotations();
            for (i = 0; i < annotations.size(); ++i) {
                beginTime = ((AbstractAnnotation)annotations.get(i)).getBeginTimeBoundary();
                endTime = ((AbstractAnnotation)annotations.get(i)).getEndTimeBoundary();
                if (this.overlapsCriteria == 3 && constraint != null && (constraint == null || !constraint.equals(((AbstractAnnotation)annotations.get(i)).getValue()))) continue;
                mergeRecord = new AnnotationValuesRecord(currentTier.getName(), ((AbstractAnnotation)annotations.get(i)).getValue(), beginTime, endTime);
                if (valueFromCurrentTier || this.annotationValueType != 2) {
                    mergeRecord.setNewLabelValue(((AbstractAnnotation)annotations.get(i)).getValue());
                } else {
                    mergeRecord.setNewLabelValue("");
                }
                mergedAnnList.add(mergeRecord);
            }
            block1: for (i = 1; i < tierList.size(); ++i) {
                AnnotationValuesRecord annRecord;
                if (this.processMode == 0) {
                    this.progressUpdate((int)(10.0f + (float)i * perAnn), this.calculating);
                }
                if (mergedAnnList.size() <= 0) break;
                currentTier = tierList.get(i);
                annotations = currentTier.getAnnotations();
                valueFromCurrentTier = this.annotationValueType == 2 && currentTier.getName().equals(this.annFromTier);
                ArrayList<AnnotationValuesRecord> annotationsRecord = new ArrayList<AnnotationValuesRecord>();
                for (int a = 0; a < annotations.size(); ++a) {
                    AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(a);
                    beginTime = abstrAnnotation.getBeginTimeBoundary();
                    endTime = abstrAnnotation.getEndTimeBoundary();
                    annRecord = new AnnotationValuesRecord(currentTier.getName(), abstrAnnotation.getValue(), beginTime, endTime);
                    if (valueFromCurrentTier || this.annotationValueType != 2) {
                        annRecord.setNewLabelValue(abstrAnnotation.getValue());
                    } else {
                        annRecord.setNewLabelValue("");
                    }
                    annotationsRecord.add(annRecord);
                }
                constraint = this.getConstraint(currentTier.getName());
                block3: for (int overlapNr = 0; overlapNr < mergedAnnList.size(); ++overlapNr) {
                    if (annotationsRecord.size() <= 0) {
                        for (int j = mergedAnnList.size() - 1; j >= overlapNr; --j) {
                            mergedAnnList.remove(j);
                        }
                        continue block1;
                    }
                    annRecord = (AnnotationValuesRecord)annotationsRecord.get(0);
                    beginTime = annRecord.getBeginTime();
                    endTime = annRecord.getEndTime();
                    mergeRecord = mergedAnnList.get(overlapNr);
                    valueFromCurrentTier = this.annotationValueType == 2 && annRecord.getTierName().equals(this.annFromTier);
                    constraint = this.getConstraint(currentTier.getName());
                    boolean matchConstraint = this.checkConstraint(mergeRecord.getValue(), annRecord.getValue(), this.overlapsCriteria, constraint);
                    if (!matchConstraint) {
                        if (endTime < mergeRecord.getEndTime()) {
                            annotationsRecord.remove(0);
                        } else {
                            mergedAnnList.remove(overlapNr);
                        }
                        --overlapNr;
                        continue;
                    }
                    if (endTime < mergeRecord.getBeginTime()) {
                        annotationsRecord.remove(0);
                        --overlapNr;
                        continue;
                    }
                    if (beginTime >= mergeRecord.getEndTime()) {
                        mergedAnnList.remove(overlapNr);
                        --overlapNr;
                        continue;
                    }
                    if (beginTime < mergeRecord.getBeginTime() && endTime <= mergeRecord.getEndTime()) {
                        mergeRecord.setBeginTime(beginTime);
                        if (valueFromCurrentTier) {
                            if (mergeRecord.getTierName().equals(this.annFromTier)) {
                                if (mergeRecord.getNewLabelValue().trim().length() > 0) {
                                    mergeRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                                } else {
                                    mergeRecord.setNewLabelValue(annRecord.getNewLabelValue());
                                }
                            }
                        } else if (this.annotationValueType == 3) {
                            mergeRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                        } else if (this.annotationValueType == 4) {
                            mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                        }
                        if (annotationsRecord.size() >= 2) {
                            while (((AnnotationValuesRecord)annotationsRecord.get(1)).getBeginTime() < mergeRecord.getEndTime()) {
                                matchConstraint = this.checkConstraint(mergeRecord.getValue(), ((AnnotationValuesRecord)annotationsRecord.get(1)).getValue(), this.overlapsCriteria, constraint);
                                if (matchConstraint) {
                                    --overlapNr;
                                    break;
                                }
                                if (((AnnotationValuesRecord)annotationsRecord.get(1)).getEndTime() <= mergeRecord.getEndTime()) {
                                    annotationsRecord.remove(1);
                                    if (annotationsRecord.size() >= 2) continue;
                                    break;
                                }
                                ((AnnotationValuesRecord)annotationsRecord.get(1)).setBeginTime(mergeRecord.getEndTime());
                                break;
                            }
                        }
                        annotationsRecord.remove(0);
                        continue;
                    }
                    if (beginTime >= mergeRecord.getBeginTime() && endTime <= mergeRecord.getEndTime()) {
                        if (valueFromCurrentTier) {
                            if (mergeRecord.getNewLabelValue().trim().length() > 0) {
                                mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                            } else {
                                mergeRecord.setNewLabelValue(annRecord.getNewLabelValue());
                            }
                        } else if (this.annotationValueType == 3 || this.annotationValueType == 4) {
                            mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                        }
                        if (annotationsRecord.size() >= 2) {
                            while (((AnnotationValuesRecord)annotationsRecord.get(1)).getBeginTime() < mergeRecord.getEndTime()) {
                                matchConstraint = this.checkConstraint(mergeRecord.getValue(), ((AnnotationValuesRecord)annotationsRecord.get(1)).getValue(), this.overlapsCriteria, constraint);
                                if (matchConstraint) {
                                    --overlapNr;
                                    break;
                                }
                                if (((AnnotationValuesRecord)annotationsRecord.get(1)).getEndTime() <= mergeRecord.getEndTime()) {
                                    annotationsRecord.remove(1);
                                    if (annotationsRecord.size() >= 2) continue;
                                    break;
                                }
                                ((AnnotationValuesRecord)annotationsRecord.get(1)).setBeginTime(mergeRecord.getEndTime());
                                break;
                            }
                        }
                        annotationsRecord.remove(0);
                        continue;
                    }
                    if (beginTime >= mergeRecord.getBeginTime() && endTime > mergeRecord.getEndTime()) {
                        if (overlapNr + 1 < mergedAnnList.size()) {
                            while (mergedAnnList.get(overlapNr + 1).getBeginTime() < endTime) {
                                matchConstraint = this.checkConstraint(mergedAnnList.get(overlapNr + 1).getValue(), annRecord.getValue(), this.overlapsCriteria, constraint);
                                if (matchConstraint) {
                                    if (valueFromCurrentTier) {
                                        if (mergeRecord.getNewLabelValue().trim().length() > 0) {
                                            annRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                                        } else {
                                            annRecord.setNewLabelValue(annRecord.getNewLabelValue());
                                        }
                                    } else if (this.annotationValueType == 3 || this.annotationValueType == 4) {
                                        annRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                                    } else {
                                        annRecord.setNewLabelValue(mergeRecord.getNewLabelValue());
                                        annRecord.setTierName(mergeRecord.getTierName());
                                    }
                                    annRecord.setBeginTime(mergeRecord.getBeginTime());
                                    mergedAnnList.remove(overlapNr);
                                    --overlapNr;
                                    continue block3;
                                }
                                if (mergedAnnList.get(overlapNr + 1).getEndTime() <= endTime) {
                                    mergedAnnList.remove(overlapNr + 1);
                                    if (overlapNr + 1 < mergedAnnList.size()) continue;
                                    break;
                                }
                                mergedAnnList.get(overlapNr + 1).setBeginTime(endTime);
                                break;
                            }
                        }
                        if (valueFromCurrentTier) {
                            if (mergeRecord.getNewLabelValue().trim().length() > 0) {
                                mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                            } else {
                                mergeRecord.setNewLabelValue(annRecord.getNewLabelValue());
                            }
                        } else if (this.annotationValueType == 3 || this.annotationValueType == 4) {
                            mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                        }
                        mergeRecord.setEndTime(endTime);
                        annotationsRecord.remove(0);
                        continue;
                    }
                    if (beginTime >= mergeRecord.getBeginTime() || endTime <= mergeRecord.getEndTime()) continue;
                    if (overlapNr + 1 < mergedAnnList.size()) {
                        while (mergedAnnList.get(overlapNr + 1).getBeginTime() < endTime) {
                            matchConstraint = this.checkConstraint(mergedAnnList.get(overlapNr + 1).getValue(), annRecord.getValue(), this.overlapsCriteria, constraint);
                            if (matchConstraint) {
                                if (valueFromCurrentTier) {
                                    if (mergeRecord.getNewLabelValue().trim().length() > 0) {
                                        annRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                                    } else {
                                        annRecord.setNewLabelValue(annRecord.getNewLabelValue());
                                    }
                                } else if (this.annotationValueType == 3) {
                                    annRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                                } else if (this.annotationValueType == 4) {
                                    annRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                                } else {
                                    annRecord.setNewLabelValue(mergeRecord.getNewLabelValue());
                                    annRecord.setTierName(mergeRecord.getTierName());
                                }
                                mergedAnnList.remove(overlapNr);
                                --overlapNr;
                                continue block3;
                            }
                            if (mergedAnnList.get(overlapNr + 1).getEndTime() <= endTime) {
                                mergedAnnList.remove(overlapNr + 1);
                                if (overlapNr + 1 < mergedAnnList.size()) continue;
                                break;
                            }
                            mergedAnnList.get(overlapNr + 1).setBeginTime(endTime);
                            break;
                        }
                    }
                    if (valueFromCurrentTier) {
                        if (mergeRecord.getTierName().equals(this.annFromTier)) {
                            mergeRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                        } else {
                            mergeRecord.setNewLabelValue(annRecord.getNewLabelValue());
                            mergeRecord.setTierName(annRecord.getTierName());
                        }
                    } else if (this.annotationValueType == 3) {
                        mergeRecord.setNewLabelValue(annRecord.getNewLabelValue() + " " + mergeRecord.getNewLabelValue());
                    } else if (this.annotationValueType == 4) {
                        mergeRecord.setNewLabelValue(mergeRecord.getNewLabelValue() + " " + annRecord.getNewLabelValue());
                    }
                    mergeRecord.setBeginTime(beginTime);
                    mergeRecord.setEndTime(endTime);
                    annotationsRecord.remove(0);
                }
            }
        } else {
            for (int i = 0; i < tierList.size(); ++i) {
                annotations.addAll(tierList.get(i).getAnnotations());
            }
            if (annotations.size() == 0) {
                return mergedAnnList;
            }
            AnnotationComparator annComparator = new AnnotationComparator();
            Collections.sort(annotations, annComparator);
            int annCount = annotations.size();
            float perAnn = 60.0f;
            if (this.processMode == 0) {
                if (annCount > 0) {
                    perAnn = 60.0f / (float)annCount;
                }
                this.progressUpdate(10, this.calculating);
            }
            for (int i = 0; i < annotations.size(); ++i) {
                Object newValue;
                AnnotationValuesRecord mergeRecord;
                if (this.processMode == 0) {
                    this.progressUpdate((int)(10.0f + (float)i * perAnn), this.calculating);
                }
                AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(i);
                long beginTime = abstrAnnotation.getBeginTimeBoundary();
                long endTime = abstrAnnotation.getEndTimeBoundary();
                String constraint = this.getConstraint(abstrAnnotation.getTier().getName());
                if (mergedAnnList.size() == 0) {
                    if (this.overlapsCriteria == 3 && constraint != null && (constraint == null || !constraint.equals(abstrAnnotation.getValue()))) continue;
                    mergeRecord = new AnnotationValuesRecord(abstrAnnotation.getTier().getName(), null, beginTime, endTime);
                    mergeRecord.setNewLabelValue(abstrAnnotation.getValue());
                    mergedAnnList.add(mergeRecord);
                    continue;
                }
                mergeRecord = mergedAnnList.get(mergedAnnList.size() - 1);
                boolean matchConstraint = this.checkConstraint(mergeRecord.getNewLabelValue(), abstrAnnotation.getValue(), this.overlapsCriteria, constraint);
                if (!matchConstraint) continue;
                if (beginTime >= mergeRecord.getEndTime()) {
                    mergeRecord = new AnnotationValuesRecord(abstrAnnotation.getTier().getName(), null, beginTime, endTime);
                    mergeRecord.setNewLabelValue(abstrAnnotation.getValue());
                    mergedAnnList.add(mergeRecord);
                    continue;
                }
                if (beginTime >= mergeRecord.getBeginTime() && endTime <= mergeRecord.getEndTime()) {
                    newValue = null;
                    newValue = this.annotationValueType == 3 ? mergeRecord.getNewLabelValue() + " " + abstrAnnotation.getValue() : (this.annotationValueType == 4 ? (tierList.indexOf(transcription.getTierWithId(mergeRecord.getTierName())) <= tierList.indexOf(abstrAnnotation.getTier()) ? mergeRecord.getNewLabelValue() + " " + abstrAnnotation.getValue() : abstrAnnotation.getValue() + " " + mergeRecord.getNewLabelValue()) : mergeRecord.getNewLabelValue());
                    mergeRecord.setNewLabelValue((String)newValue);
                    continue;
                }
                if (beginTime < mergeRecord.getBeginTime() || endTime <= mergeRecord.getEndTime()) continue;
                mergeRecord.setEndTime(endTime);
                newValue = null;
                newValue = this.annotationValueType == 3 ? mergeRecord.getNewLabelValue() + " " + abstrAnnotation.getValue() : (this.annotationValueType == 4 ? (tierList.indexOf(transcription.getTierWithId(mergeRecord.getTierName())) <= tierList.indexOf(abstrAnnotation.getTier()) ? mergeRecord.getNewLabelValue() + " " + abstrAnnotation.getValue() : abstrAnnotation.getValue() + " " + mergeRecord.getNewLabelValue()) : mergeRecord.getNewLabelValue());
                mergeRecord.setNewLabelValue((String)newValue);
            }
        }
        return mergedAnnList;
    }

    @Override
    protected boolean checkConstraint(String mergeValue, String newValue, int criteria, String constraint) {
        if (this.overlapsCriteria == 0) {
            return true;
        }
        if (this.overlapsCriteria == 1) {
            return mergeValue.equals(newValue);
        }
        if (this.overlapsCriteria == 2) {
            return !mergeValue.equals(newValue);
        }
        if (this.overlapsCriteria == 3) {
            return constraint == null || newValue.equals(constraint);
        }
        return true;
    }

    @Override
    protected String getConstraint(String tierName) {
        if (this.overlapsCriteria == 1) {
            if (this.tierValueConstraints.size() == 1) {
                return ((String[])this.tierValueConstraints.get(0))[0];
            }
        } else {
            for (int i = 0; i < this.tierValueConstraints.size(); ++i) {
                if (!((String[])this.tierValueConstraints.get(i))[0].equals(tierName)) continue;
                return ((String[])this.tierValueConstraints.get(i))[1];
            }
        }
        return null;
    }

    private class AnnotationComparator
    implements Comparator<Annotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            Long bt2;
            Long bt1 = o1.getBeginTimeBoundary();
            if (bt1 != (bt2 = Long.valueOf(o2.getBeginTimeBoundary()))) {
                return bt1.compareTo(bt2);
            }
            Long et1 = o1.getEndTimeBoundary();
            Long et2 = o2.getEndTimeBoundary();
            return et1.compareTo(et2);
        }
    }
}

