/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AnnotationsFromOverlapsUndoableCommand;
import mpi.eudico.client.annotator.commands.AnnotationsFromSubtractionUndoableCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.AbstractProgressStepPane;
import mpi.eudico.client.annotator.tier.AnnotationFromOverlaps;
import mpi.eudico.client.annotator.tier.AnnotationFromSubtraction;
import mpi.eudico.server.corpora.clom.Transcription;

public class OverlapsOrSubtractionStep5
extends AbstractProgressStepPane {
    protected List<String> files;
    protected List<String> selectedTiers;
    protected String destTierName;
    protected String destLingType;
    protected String parentTierName;
    protected int annotationValueType;
    protected String timeFormat;
    protected boolean usePalFormat;
    protected String annWithValue;
    protected String annFromTier;
    protected int processMode;
    protected List<String> tierOrder;
    protected int overlapsCriteria;
    protected List<String[]> tierValuePairs;
    protected Transcription transcription;
    private boolean subtractionDialog;

    public OverlapsOrSubtractionStep5(MultiStepPane multiPane, Transcription transcription) {
        this(multiPane, transcription, false);
    }

    public OverlapsOrSubtractionStep5(MultiStepPane multiPane, Transcription transcription, boolean subtractionDialog) {
        super(multiPane);
        this.subtractionDialog = subtractionDialog;
        this.transcription = transcription;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.Calculating");
    }

    @Override
    public void enterStepForward() {
        this.files = (List)this.multiPane.getStepProperty("OpenedFiles");
        this.selectedTiers = (List)this.multiPane.getStepProperty("SelectedTiers");
        this.destTierName = (String)this.multiPane.getStepProperty("DestinationTierName");
        this.destLingType = (String)this.multiPane.getStepProperty("linguisticType");
        this.parentTierName = (String)this.multiPane.getStepProperty("ParentTierName");
        Integer avType = (Integer)this.multiPane.getStepProperty("AnnotationValueType");
        if (avType != null) {
            this.annotationValueType = avType;
        }
        this.timeFormat = (String)this.multiPane.getStepProperty("TimeFormat");
        Boolean usePal = (Boolean)this.multiPane.getStepProperty("UsePalFormat");
        if (usePal != null) {
            this.usePalFormat = usePal;
        }
        this.annWithValue = (String)this.multiPane.getStepProperty("AnnotationValue");
        this.annFromTier = (String)this.multiPane.getStepProperty("AnnFromTier");
        Integer procMode = (Integer)this.multiPane.getStepProperty("ProcessMode");
        if (procMode != null) {
            this.processMode = procMode;
        }
        this.tierOrder = (List)this.multiPane.getStepProperty("TierOrder");
        Integer olCrit = (Integer)this.multiPane.getStepProperty("overlapsCriteria");
        if (olCrit != null) {
            this.overlapsCriteria = olCrit;
        }
        this.tierValuePairs = (List)this.multiPane.getStepProperty("tierValueConstraints");
        super.enterStepForward();
    }

    @Override
    public void startProcess() {
        String[] sourceTiers = new String[this.selectedTiers.size()];
        for (int i = 0; i < this.selectedTiers.size(); ++i) {
            sourceTiers[i] = this.selectedTiers.get(i);
        }
        Object[] filenames = null;
        if (this.files != null) {
            filenames = this.files.toArray();
        }
        Object[] args = null;
        AnnotationFromOverlaps com = null;
        if (this.subtractionDialog) {
            String referenceTierName = (String)this.multiPane.getStepProperty("ReferenceTierName");
            args = new Object[]{sourceTiers, this.destTierName, this.destLingType, this.annotationValueType, this.timeFormat, this.annWithValue, this.processMode, filenames, this.usePalFormat, this.parentTierName, referenceTierName};
            com = this.transcription != null ? (AnnotationsFromSubtractionUndoableCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromSubtraction") : new AnnotationFromSubtraction("Menu.Tier.AnnotationsFromOverlaps");
        } else {
            args = new Object[]{sourceTiers, this.destTierName, this.destLingType, this.annotationValueType, this.timeFormat, this.annWithValue, this.annFromTier, this.tierOrder, this.overlapsCriteria, this.tierValuePairs, this.processMode, filenames, this.usePalFormat, this.parentTierName};
            com = this.transcription != null ? (AnnotationsFromOverlapsUndoableCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromOverlaps") : new AnnotationFromOverlaps("Menu.Tier.AnnotationsFromOverlaps");
        }
        com.addProgressListener(this);
        ((AnnotationFromOverlaps)com).execute(this.transcription, args);
    }
}

