/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public class SubtractionStep2
extends StepPane {
    private JRadioButton exclusiveOrRB;
    private JRadioButton subtractionRB;
    private JComboBox tierNameCB;
    private JDialog helpDialog;

    public SubtractionStep2(MultiStepPane mp) {
        super(mp);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        JLabel createAnnotationLabel = new JLabel(ElanLocale.getString("SubtractAnnotationDialog.Label.CreateAnnotation"));
        JLabel subtractfromTierLabel = new JLabel(ElanLocale.getString("SubtractAnnotationDialog.Label.SubtractFromTier"));
        this.exclusiveOrRB = new JRadioButton(ElanLocale.getString("SubtractAnnotationDialog.Radio.ExclusiveOr"), true);
        this.subtractionRB = new JRadioButton(ElanLocale.getString("SubtractAnnotationDialog.Radio.Subtraction"));
        final JButton helpButton = new JButton(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help24.gif")));
        helpButton.setPreferredSize(new Dimension(24, 24));
        helpButton.setToolTipText(ElanLocale.getString("SubtractAnnotationDialog.Button.Help.ToolTip"));
        this.tierNameCB = new JComboBox();
        this.tierNameCB.setEnabled(false);
        ButtonGroup criteriaButtonGroup = new ButtonGroup();
        criteriaButtonGroup.add(this.exclusiveOrRB);
        criteriaButtonGroup.add(this.subtractionRB);
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JRadioButton) {
                    SubtractionStep2.this.tierNameCB.setEnabled(SubtractionStep2.this.subtractionRB.isSelected());
                } else if (e.getSource() == helpButton) {
                    SubtractionStep2.this.showHelpDialog();
                }
            }
        };
        this.exclusiveOrRB.addActionListener(radioButtonListener);
        this.subtractionRB.addActionListener(radioButtonListener);
        helpButton.addActionListener(radioButtonListener);
        JPanel criteriaPanel = new JPanel(new GridBagLayout());
        criteriaPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.Criteria")));
        Insets globalInset = new Insets(5, 10, 5, 10);
        Insets singleTabInset = new Insets(5, 30, 5, 10);
        Insets doubleTabInset = new Insets(5, 50, 5, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = globalInset;
        criteriaPanel.add((Component)createAnnotationLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = singleTabInset;
        gbc.anchor = 14;
        criteriaPanel.add((Component)helpButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = singleTabInset;
        criteriaPanel.add((Component)this.exclusiveOrRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        criteriaPanel.add((Component)this.subtractionRB, gbc);
        JPanel controlPanel = new JPanel(new GridLayout(1, 3, 6, 6));
        controlPanel.add(subtractfromTierLabel);
        controlPanel.add(this.tierNameCB);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = doubleTabInset;
        gbc.gridwidth = 1;
        criteriaPanel.add((Component)controlPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets = globalInset;
        gbc.fill = 2;
        this.add((Component)criteriaPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("SubtractAnnotationDialog.Title.Step2Title");
    }

    @Override
    public void enterStepForward() {
        List tierList = (List)this.multiPane.getStepProperty("SelectedTiers");
        this.tierNameCB.removeAllItems();
        for (int i = 0; i < tierList.size(); ++i) {
            this.tierNameCB.addItem(tierList.get(i));
        }
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        String refTierName = null;
        if (this.subtractionRB.isSelected()) {
            refTierName = (String)this.tierNameCB.getSelectedItem();
        }
        this.multiPane.putStepProperty("ReferenceTierName", refTierName);
        this.updateButtonStates();
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    private void showHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = new JDialog(this.multiPane.getDialog(), ElanLocale.getString("SubtractAnnotationDialog.Dialog.Help.Title"), false);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane(panel);
            this.helpDialog.add(scrollPane);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 10, 5, 10);
            panel.add((Component)new JLabel(ElanLocale.getString("SubtractAnnotationDialog.Dialog.Help.Label1")), gbc);
            gbc.gridy = 2;
            panel.add((Component)new JLabel(ElanLocale.getString("SubtractAnnotationDialog.Dialog.Help.Label2")), gbc);
            gbc.gridy = 1;
            gbc.insets = new Insets(5, 30, 5, 10);
            panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Subtraction.png"))), gbc);
            gbc.gridy = 3;
            panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Exclusive-or.png"))), gbc);
            gbc.gridy = 4;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            panel.add((Component)new JPanel(), gbc);
        }
        if (this.helpDialog.isVisible()) {
            return;
        }
        this.helpDialog.pack();
        this.helpDialog.setVisible(true);
    }
}

