/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeListener;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceRegistry;
import nl.mpi.util.FileUtility;

public class TSConfigurationUI {
    public void showNoConfigMessage(Component parent) {
        this.showWarningMessage(parent, ElanLocale.getString("TimeSeriesViewer.Config.NoConfigurableSource"));
    }

    private void showWarningMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, ElanLocale.getString("Message.Warning"), 2);
    }

    public TSSourceConfiguration selectConfigurableSource(Component parent, List<TSSourceConfiguration> sources) {
        if (sources == null) {
            return null;
        }
        TSSourceConfiguration config = null;
        Object[] urls = new String[sources.size()];
        for (int i = 0; i < sources.size(); ++i) {
            urls[i] = sources.get(i).getSource();
        }
        Object selection = JOptionPane.showInputDialog(parent, ElanLocale.getString("TimeSeriesViewer.Config.SelectSource"), ElanLocale.getString("Button.Select"), 3, null, urls, urls[0]);
        if (selection != null) {
            for (int i = 0; i < sources.size(); ++i) {
                TSSourceConfiguration key = sources.get(i);
                if (key.getSource() != selection) continue;
                config = key;
                break;
            }
        }
        return config;
    }

    public void showConfigDialog(Component parent, TSSourceConfiguration cfg, TimeSeriesChangeListener li) {
        if (cfg == null || !FileUtility.fileExists(cfg.getSource())) {
            this.showWarningMessage(parent, ElanLocale.getString("TimeSeriesViewer.Config.Message.NoSource"));
            return;
        }
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        TSServiceProvider provider = cfg.getProviderClassName() != null ? registry.getProviderByClassName(cfg.getProviderClassName()) : registry.getProviderForFile(cfg.getSource());
        if (provider == null) {
            this.showWarningMessage(parent, ElanLocale.getString("TimeSeriesViewer.Config.Message.NoProvider"));
            return;
        }
        TSConfigPanel panel = provider.getConfigPanel(cfg);
        if (panel == null) {
            this.showWarningMessage(parent, ElanLocale.getString("TimeSeriesViewer.Config.Message.NoConfigPanel"));
            return;
        }
        panel.addTimeSeriesChangeListener(li);
        ConfigDialog dialog = null;
        Window w = SwingUtilities.windowForComponent(parent);
        dialog = w instanceof Dialog ? new ConfigDialog((Dialog)w) : (w instanceof Frame ? new ConfigDialog((Frame)w) : new ConfigDialog());
        dialog.setModal(true);
        dialog.setTitle(ElanLocale.getString("TimeSeriesViewer.Config.Tracks.Title"));
        dialog.addConfigPanel(panel);
        dialog.pack();
        int maxH = Toolkit.getDefaultToolkit().getScreenSize().height - Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)w.getGraphicsConfiguration()).top - Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)w.getGraphicsConfiguration()).bottom;
        if (dialog.getHeight() > maxH) {
            dialog.setBounds(new Rectangle(dialog.getWidth(), maxH));
        }
        dialog.setLocationRelativeTo(w);
        dialog.setResizable(true);
        dialog.setVisible(true);
    }

    public class ConfigDialog
    extends JDialog {
        public ConfigDialog() {
            this.initComponents();
        }

        public ConfigDialog(Dialog parent) {
            super(parent);
            this.initComponents();
        }

        public ConfigDialog(Frame parent) {
            super(parent);
            this.initComponents();
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 2, 2));
            JButton closeButton = new JButton(ElanLocale.getString("Button.Close"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ConfigDialog.this.dispose();
                }
            });
            buttonPanel.add(closeButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 15;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)buttonPanel, gbc);
        }

        public void addConfigPanel(JComponent panel) {
            if (panel != null) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 11;
                gbc.gridy = 0;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)panel, gbc);
            }
        }
    }
}

