/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;

public class TrackTableModel
extends AbstractTableModel {
    public static final String NAME = "TimeSeriesViewer.Config.TrackName";
    public static final String DESCRIPTION = "TimeSeriesViewer.Config.TrackDesc";
    private final String N_A = "-";
    private List<TSTrackConfiguration> trackList;
    private List<String> columnIds;
    private List<List<String>> tableData;

    public TrackTableModel() {
        this(null);
    }

    public TrackTableModel(List<TSTrackConfiguration> tracks) {
        this.trackList = tracks == null ? new ArrayList<TSTrackConfiguration>(0) : new ArrayList<TSTrackConfiguration>(tracks);
        this.columnIds = new ArrayList<String>(2);
        this.columnIds.add(NAME);
        this.columnIds.add(DESCRIPTION);
        this.initData();
    }

    private void initData() {
        this.tableData = new ArrayList<List<String>>(this.trackList.size());
        for (int i = 0; i < this.trackList.size(); ++i) {
            TSTrackConfiguration track = this.trackList.get(i);
            this.addRowData(track);
        }
        this.fireTableDataChanged();
    }

    private void addRowData(TSTrackConfiguration track) {
        if (track == null) {
            return;
        }
        ArrayList<String> rowData = new ArrayList<String>(2);
        rowData.add(track.getTrackName());
        AbstractTSTrack tr = (AbstractTSTrack)track.getObject(track.getTrackName());
        if (tr != null) {
            rowData.add(tr.getDescription());
        } else {
            rowData.add("-");
        }
        this.tableData.add(rowData);
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    @Override
    public String getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        List<String> row = this.tableData.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnIds.indexOf(columnName);
    }

    public Class<String> getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return "";
        }
        return ElanLocale.getString(this.columnIds.get(columnIndex));
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.tableData.size()) {
            this.tableData.remove(rowIndex);
            this.trackList.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeAllRows() {
        this.tableData.clear();
        this.trackList.clear();
        this.fireTableDataChanged();
    }

    public void addRow(TSTrackConfiguration track) {
        if (track == null || this.trackList.contains(track)) {
            return;
        }
        this.trackList.add(track);
        this.addRowData(track);
        this.fireTableDataChanged();
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }
}

