/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.io;

import java.awt.Color;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.IoUtil;
import nl.mpi.util.FileUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TSConfigurationEncoder {
    protected final String VERSION = "1.0";
    protected String configFile;
    protected DocumentBuilder db;
    protected Document doc;

    public void encodeAndSave(TranscriptionImpl transcription, Collection tsConfigs) {
        if (transcription == null || transcription.getPathName().equals("aishug294879ryshfda9763afo8947a5gf")) {
            return;
        }
        String existingConf = this.getExistingConfFile(transcription);
        this.configFile = existingConf == null ? this.createPath(transcription.getFullPath()) : existingConf;
        this.doc = this.createNewDocument();
        if (this.doc != null) {
            Element docElement = this.createDOM(tsConfigs);
            try {
                LinkedFileDescriptor lfd;
                IoUtil.writeEncodedFile("UTF-8", this.configFile.substring(5), docElement);
                ClientLogger.LOG.info("Configuration file saved: " + this.configFile);
                for (int i = 0; i < transcription.getLinkedFileDescriptors().size(); ++i) {
                    lfd = transcription.getLinkedFileDescriptors().get(i);
                    if (!lfd.linkURL.toLowerCase().endsWith("_tsconf.xml")) continue;
                    return;
                }
                lfd = new LinkedFileDescriptor(this.configFile, "text/xml");
                transcription.getLinkedFileDescriptors().add(lfd);
                transcription.setChanged();
            }
            catch (Exception e) {
                ClientLogger.LOG.warning("Could not save configuration file: " + e.getMessage());
            }
        }
    }

    private String getExistingConfFile(TranscriptionImpl transcription) {
        for (int i = 0; i < transcription.getLinkedFileDescriptors().size(); ++i) {
            LinkedFileDescriptor lfd = transcription.getLinkedFileDescriptors().get(i);
            if (!lfd.linkURL.endsWith("_tsconf.xml") || !new File(lfd.linkURL).exists()) continue;
            return lfd.linkURL;
        }
        return null;
    }

    protected String createPath(String eafPath) {
        Object cp = eafPath;
        if (((String)cp).startsWith("file:")) {
            cp = ((String)cp).substring(5);
        }
        if (((String)(cp = FileUtility.pathToURLString((String)cp))).endsWith(".eaf")) {
            cp = ((String)cp).substring(0, ((String)cp).length() - 4);
        }
        cp = (String)cp + "_tsconf.xml";
        System.out.println("config path: " + (String)cp);
        return cp;
    }

    protected Document createNewDocument() {
        if (this.db == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                this.db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                ClientLogger.LOG.severe("Cannot create document builder: " + pce.getMessage());
                return null;
            }
        }
        return this.db.newDocument();
    }

    protected Element createDOM(Collection configs) {
        Element rootElem = this.createDocElement();
        this.doc.appendChild(rootElem);
        for (Object sc : configs) {
            if (!(sc instanceof TSSourceConfiguration)) continue;
            rootElem.appendChild(this.createTrackSourceElement((TSSourceConfiguration)sc));
        }
        return rootElem;
    }

    protected Element createDocElement() {
        Element root = this.doc.createElement("timeseries");
        root.setAttribute("date", this.getDate());
        root.setAttribute("version", "1.0");
        return root;
    }

    protected Element createTrackSourceElement(TSSourceConfiguration tsc) {
        if (tsc == null || tsc.getSource() == null) {
            return null;
        }
        Element sourceElem = this.doc.createElement("tracksource");
        sourceElem.setAttribute("source-url", tsc.getSource());
        if (tsc.getTimeOrigin() != 0) {
            sourceElem.setAttribute("time-origin", String.valueOf(tsc.getTimeOrigin()));
        }
        if (tsc.getSampleType() != null) {
            sourceElem.setAttribute("sample-type", tsc.getSampleType());
        }
        if (tsc.getProviderClassName() != null) {
            sourceElem.appendChild(this.createPropertyElement("provider", tsc.getProviderClassName()));
        }
        if (tsc.getTimeColumn() > -1) {
            sourceElem.setAttribute("time-column", String.valueOf(tsc.getTimeColumn()));
        }
        Enumeration<?> propEnum = tsc.propertyNames();
        while (propEnum.hasMoreElements()) {
            String val;
            String prop = (String)propEnum.nextElement();
            Element propElem = this.createPropertyElement(prop, val = tsc.getProperty(prop));
            if (propElem == null) continue;
            sourceElem.appendChild(propElem);
        }
        for (Object key : tsc.objectKeySet()) {
            Element trackElem;
            Object oval = tsc.getObject(key);
            if (!(oval instanceof TSTrackConfiguration) || (trackElem = this.createTrackElement((TSTrackConfiguration)oval)) == null) continue;
            sourceElem.appendChild(trackElem);
        }
        return sourceElem;
    }

    protected Element createPropertyElement(String key, String value) {
        if (key == null || value == null) {
            return null;
        }
        Element propElement = this.doc.createElement("property");
        propElement.setAttribute("key", key);
        propElement.setAttribute("value", value);
        return propElement;
    }

    protected Element createTrackElement(TSTrackConfiguration trConfig) {
        Object obj;
        if (trConfig == null || trConfig.getTrackName() == null) {
            return null;
        }
        Element trackElem = this.doc.createElement("track");
        trackElem.setAttribute("name", trConfig.getTrackName());
        Enumeration<?> propEnum = trConfig.propertyNames();
        while (propEnum.hasMoreElements()) {
            String val;
            String prop = (String)propEnum.nextElement();
            Element propElem = this.createPropertyElement(prop, val = trConfig.getProperty(prop));
            if (propElem == null) continue;
            trackElem.appendChild(propElem);
        }
        SamplePosition spos = trConfig.getSamplePos();
        if (spos != null) {
            Element spElem = this.doc.createElement("sample-position");
            if (spos.getDescription() != null) {
                Element ds = this.doc.createElement("description");
                ds.appendChild(this.doc.createTextNode(spos.getDescription()));
                spElem.appendChild(ds);
            }
            for (int i = 0; i < spos.getRows().length; ++i) {
                Element pos = this.doc.createElement("pos");
                pos.setAttribute("row", String.valueOf(spos.getRows()[i]));
                pos.setAttribute("col", String.valueOf(spos.getColumns()[i]));
                spElem.appendChild(pos);
            }
            trackElem.appendChild(spElem);
        }
        if ((obj = trConfig.getObject(trConfig.getTrackName())) instanceof AbstractTSTrack) {
            AbstractTSTrack track = (AbstractTSTrack)obj;
            trackElem.setAttribute("derivative", String.valueOf(track.getDerivativeLevel()));
            if (track.getDescription() != null) {
                Element descElem = this.doc.createElement("description");
                descElem.appendChild(this.doc.createTextNode(track.getDescription()));
                trackElem.appendChild(descElem);
            }
            if (track.getUnitString() != null) {
                Element unitElem = this.doc.createElement("units");
                unitElem.appendChild(this.doc.createTextNode(track.getUnitString()));
                trackElem.appendChild(unitElem);
            }
            if (track.getRange() != null) {
                Element rangeElem = this.doc.createElement("range");
                rangeElem.setAttribute("min", String.valueOf(track.getRange()[0]));
                rangeElem.setAttribute("max", String.valueOf(track.getRange()[1]));
                trackElem.appendChild(rangeElem);
            }
            Element colElem = this.doc.createElement("color");
            Color c = track.getColor();
            String cs = c.getRed() + "," + c.getGreen() + "," + c.getBlue();
            colElem.appendChild(this.doc.createTextNode(cs));
            trackElem.appendChild(colElem);
        }
        return trackElem;
    }

    private String getDate() {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        StringBuilder buf = new StringBuilder(dateFmt.format(Calendar.getInstance().getTime()));
        int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
        if (offsetGMT > 0) {
            buf.append('+');
            if (offsetGMT < 10) {
                buf.append('0');
            }
        } else {
            buf.append('-');
            if (offsetGMT > -10) {
                buf.append('0');
            }
        }
        buf.append(Math.abs(offsetGMT));
        buf.append(":00");
        int firstSpace = buf.indexOf(" ");
        if (firstSpace > -1) {
            buf.setCharAt(firstSpace, 'T');
        }
        return buf.toString().replace('.', '-');
    }
}

