/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.TimeFormatter;

public class BasicTSFileReader {
    private File sourceFile;
    private boolean validFile = true;
    private FileReader fileRead;
    private BufferedReader bufRead;
    private StringTokenizer tokenizer;
    private float msPerSample = 0.0f;
    private int sampleFrequency = 0;
    private float min = Float.MAX_VALUE;
    private float max = -2.1474836E9f;

    public BasicTSFileReader(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("The file name is null");
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.sourceFile = new File(fileName);
        this.validFile = this.isValidTSFile();
    }

    private boolean isValidTSFile() {
        if (this.sourceFile == null) {
            return false;
        }
        boolean valid = true;
        try {
            this.fileRead = new FileReader(this.sourceFile);
            this.bufRead = new BufferedReader(this.fileRead);
            int rowIndex = 0;
            String li = null;
            while ((li = this.bufRead.readLine()) != null && rowIndex < 20) {
                if (li.length() == 0 || li.charAt(0) == '#') continue;
                this.tokenizer = new StringTokenizer(li);
                if (this.tokenizer.countTokens() != 2) {
                    valid = false;
                    break;
                }
                ++rowIndex;
            }
            try {
                this.bufRead.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return valid;
    }

    public boolean isValidFile() {
        return this.validFile;
    }

    public int detectSampleFrequency() throws IOException {
        if (!this.validFile) {
            return 0;
        }
        this.sampleFrequency = 0;
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        int numSamplesRead = 0;
        long curTime = 0L;
        String li = null;
        while ((li = this.bufRead.readLine()) != null && numSamplesRead < 20) {
            if (li.length() == 0 || li.charAt(0) == '#') continue;
            this.tokenizer = new StringTokenizer(li);
            if (this.tokenizer.countTokens() != 2) continue;
            curTime = TimeFormatter.toMilliSeconds(this.tokenizer.nextToken());
            ++numSamplesRead;
        }
        if (numSamplesRead > 1) {
            float average = curTime / (long)(numSamplesRead - 1);
            this.sampleFrequency = Math.round(1000.0f / average);
            this.msPerSample = 1000.0f / (float)this.sampleFrequency;
            ClientLogger.LOG.info("Sec Per Sample: " + average + " - Freq. " + this.sampleFrequency);
            ClientLogger.LOG.info("Ms per sample: " + this.msPerSample);
        }
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sampleFrequency;
    }

    public float[] readTrack() throws IOException {
        if (!this.validFile) {
            return null;
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<Float> values = new ArrayList<Float>();
        long curTimeStamp = 0L;
        float curSample = 0.0f;
        int sampleCount = 0;
        String li = null;
        while ((li = this.bufRead.readLine()) != null) {
            if (li.length() == 0 || li.charAt(0) == '#') continue;
            this.tokenizer = new StringTokenizer(li);
            if (this.tokenizer.countTokens() < 2) continue;
            curTimeStamp = TimeFormatter.toMilliSeconds(this.tokenizer.nextToken());
            if ((float)curTimeStamp - (float)sampleCount * this.msPerSample > this.msPerSample / 2.0f) {
                ClientLogger.LOG.info("Adding fill-in at sample: " + sampleCount);
                values.add(Float.valueOf(curSample));
                ++sampleCount;
            }
            if ((curSample = this.toFloat(this.tokenizer.nextToken())) < this.min) {
                this.min = curSample;
            }
            if (curSample > this.max) {
                this.max = curSample;
            }
            values.add(Float.valueOf(curSample));
            ++sampleCount;
        }
        ClientLogger.LOG.info("Number of samples: " + sampleCount);
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        float[] result = new float[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            Float fl = (Float)values.get(i);
            result[i] = fl.floatValue();
        }
        return result;
    }

    public float getMsPerSample() {
        return this.msPerSample;
    }

    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    private float toFloat(String value) {
        if (value == null || value.length() == 0) {
            ClientLogger.LOG.severe("No float value: " + value);
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            ClientLogger.LOG.severe("No float value: " + value);
            return Float.NaN;
        }
    }
}

