/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.spi;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.spi.BasicTSFileReader;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;

public class BasicTSServiceProvider
implements TSServiceProvider {
    private static final String suffix = "txt";
    private Map<String, BasicTSFileReader> sourceToReaderMap;
    private int trackCount = 0;
    private final Color color = new Color(0, 160, 0);

    public BasicTSServiceProvider() {
        this.sourceToReaderMap = new HashMap<String, BasicTSFileReader>();
    }

    @Override
    public boolean canHandle(String filePath) {
        ClientLogger.LOG.info("Polling: " + filePath);
        if (filePath == null || filePath.length() < 5) {
            return false;
        }
        if (!filePath.toLowerCase().endsWith(suffix)) {
            return false;
        }
        BasicTSFileReader reader = null;
        if (this.sourceToReaderMap.get(filePath) != null) {
            return true;
        }
        reader = new BasicTSFileReader(filePath);
        if (reader.isValidFile()) {
            try {
                reader.detectSampleFrequency();
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not detect the sample frequency.");
            }
            this.sourceToReaderMap.put(filePath, reader);
            return true;
        }
        ClientLogger.LOG.info("Not a valid basic timeseries file: " + filePath);
        return false;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config) {
        return null;
    }

    @Override
    public void autoCreateTracks(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        BasicTSFileReader reader = null;
        String source = config.getSource();
        if (this.sourceToReaderMap.containsKey(source)) {
            reader = this.sourceToReaderMap.get(source);
        } else {
            reader = new BasicTSFileReader(source);
            try {
                reader.detectSampleFrequency();
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not detect the sample frequency.");
            }
            this.sourceToReaderMap.put(source, reader);
        }
        ContinuousRateTSTrack track = new ContinuousRateTSTrack();
        track.setName("BasicTrack-" + this.trackCount++);
        track.setColor(this.color);
        try {
            float[] data = reader.readTrack();
            if (data != null) {
                try {
                    track.setData(data);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            track.setSampleRate(reader.getSampleFrequency());
            track.setRange(new float[]{reader.getMin(), reader.getMax()});
            track.setType(1);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not read data from the timeseries file " + source);
        }
        TSTrackConfiguration trconf = new TSTrackConfiguration(track.getName(), track);
        config.putObject(track.getName(), trconf);
    }

    @Override
    public void createTracksFromConfiguration(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        BasicTSFileReader reader = null;
        if (this.sourceToReaderMap.containsKey(config.getSource())) {
            reader = this.sourceToReaderMap.get(config.getSource());
        } else {
            reader = new BasicTSFileReader(config.getSource());
            try {
                reader.detectSampleFrequency();
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not detect the sample frequency.");
            }
            this.sourceToReaderMap.put(config.getSource(), reader);
        }
        Iterator<Object> trIt = config.objectKeySet().iterator();
        int offset = config.getTimeOrigin();
        while (trIt.hasNext()) {
            Object key = trIt.next();
            Object val = config.getObject(key);
            if (!(val instanceof TSTrackConfiguration)) continue;
            TSTrackConfiguration trconf = (TSTrackConfiguration)val;
            ContinuousRateTSTrack track = new ContinuousRateTSTrack();
            track.setName(trconf.getTrackName());
            track.setTimeOffset(offset);
            try {
                track.setData(reader.readTrack());
                track.setSampleRate(reader.getSampleFrequency());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not read track: " + trconf.getTrackName() + " from: " + config.getSource());
            }
            track.setDescription(trconf.getProperty("description"));
            track.setUnitString(trconf.getProperty("units"));
            track.setType(1);
            float min = 0.0f;
            float max = 100.0f;
            try {
                min = Float.parseFloat(trconf.getProperty("min"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                max = Float.parseFloat(trconf.getProperty("max"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            track.setRange(new float[]{min, max});
            Color c = this.parseColor(trconf.getProperty("color"));
            track.setColor(c);
            trconf.putObject(track.getName(), track);
            trconf.removeProperty("derivative");
            trconf.removeProperty("description");
            trconf.removeProperty("units");
            trconf.removeProperty("min");
            trconf.removeProperty("max");
            trconf.removeProperty("color");
            break;
        }
    }

    private Color parseColor(String rgb) {
        if (rgb == null) {
            return Color.GREEN;
        }
        int index = rgb.indexOf(44);
        int index2 = rgb.lastIndexOf(44);
        if (index > -1 && index2 > -1) {
            int r = this.parseInt(rgb.substring(0, index));
            int g = this.parseInt(rgb.substring(index + 1, index2));
            int b = this.parseInt(rgb.substring(index2 + 1));
            return new Color(r, g, b);
        }
        return Color.GREEN;
    }

    private int parseInt(String sint) {
        try {
            return Integer.parseInt(sint);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

