/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.transcriptionMode.AnnotationCellPlaceholder;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class TranscriptionTableModel
extends DefaultTableModel {
    public static final String NUM_COLUMN_ID = "@No@";
    private String[] columnIdentifiers = new String[]{"@No@"};
    private List<String> nonEditableTiers;
    private boolean autoCreateAnn = true;

    public TranscriptionTableModel() {
        for (int i = 0; i < this.columnIdentifiers.length; ++i) {
            this.addColumn(this.columnIdentifiers[i]);
        }
        this.setColumnIdentifiers(this.columnIdentifiers);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object obj = this.getValueAt(row, column);
        String tierName = this.getTierName(row, column);
        if (tierName != null && this.nonEditableTiers != null && this.nonEditableTiers.contains(tierName)) {
            return false;
        }
        if (obj instanceof AnnotationCellPlaceholder) {
            return ((AnnotationCellPlaceholder)obj).canCreate && this.autoCreateAnn;
        }
        return obj instanceof Annotation;
    }

    public void updateModel(List<String> columnNames) {
        this.columnIdentifiers = new String[columnNames.size() + 1];
        this.columnIdentifiers[0] = NUM_COLUMN_ID;
        for (int i = 0; i < columnNames.size(); ++i) {
            this.columnIdentifiers[i + 1] = columnNames.get(i);
        }
        this.setColumnIdentifiers(this.columnIdentifiers);
    }

    public void updateTypeName(String oldName, String newName) {
        for (int i = 1; i < this.columnIdentifiers.length; ++i) {
            if (!this.columnIdentifiers[i].equals(oldName)) continue;
            this.columnIdentifiers[i] = newName;
            this.setColumnIdentifiers(this.columnIdentifiers);
            return;
        }
    }

    public String[] getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    public void setNonEditableTiers(List<String> nonEditableTiers) {
        this.nonEditableTiers = nonEditableTiers;
    }

    public void setAutoCreateAnnotations(boolean create) {
        this.autoCreateAnn = create;
    }

    public boolean isAnnotationsCreatedAutomatically() {
        return this.autoCreateAnn;
    }

    private String getTierName(int row, int column) {
        String tierName = null;
        Object val = this.getValueAt(row, column);
        if (val instanceof Annotation) {
            AbstractAnnotation ann = (AbstractAnnotation)val;
            tierName = ann.getTier().getName();
        } else if (val instanceof AnnotationCellPlaceholder) {
            return ((AnnotationCellPlaceholder)val).tierName;
        }
        return tierName;
    }
}

